/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.collections.ModdedPackets;
import org.patryk3211.powergrid.collections.ModdedSoundEvents;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.DeferredJunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.electricity.wire.WireItem;
import org.patryk3211.powergrid.equipment.multimeter.MultimeterItem;
import org.patryk3211.powergrid.network.packets.EntityDataS2CPacket;

public abstract class BaseWireEntity
extends class_1297
implements EntityDataS2CPacket.IConsumer {
    protected static final class_2940<Float> TEMPERATURE = class_2945.method_12791(BaseWireEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Byte> OVERHEAT_TICKS = class_2945.method_12791(BaseWireEntity.class, (class_2941)class_2943.field_13319);
    protected IWireEndpoint endpoint1;
    protected IWireEndpoint endpoint2;
    protected byte deferEndpointResolution = 0;
    protected int deferTicks = 0;
    @NotNull
    private WireItem item;
    private int itemCount;
    private int color;
    protected float overheatTemperature = 175.0f;
    private int despawnTime = 0;
    private int dataVersion = 0;
    private float dissipationFactor;
    private float thermalMass;
    protected Float resistanceOverride = null;

    public BaseWireEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public abstract float current();

    protected void method_5693() {
        this.field_6011.method_12784(TEMPERATURE, (Object)Float.valueOf(22.0f));
        this.field_6011.method_12784(OVERHEAT_TICKS, (Object)0);
    }

    private void temperatureUpdate() {
        if (!((Boolean)ModdedConfigs.server().electricity.wireOverheating.get()).booleanValue()) {
            return;
        }
        if (this.method_37908().field_9236 && !(this.method_37908() instanceof PonderLevel)) {
            return;
        }
        float temperature = ((Float)this.field_6011.method_12789(TEMPERATURE)).floatValue();
        float energy = 0.0f;
        float I = this.current();
        energy += I * I * this.getResistance() / 20.0f;
        if (!this.isOverheated()) {
            if ((temperature += (energy -= this.dissipationFactor * (temperature - 22.0f) / 20.0f) / this.thermalMass) > this.overheatTemperature && energy > 0.0f) {
                this.field_6011.method_12778(OVERHEAT_TICKS, (Object)((byte)((Byte)this.field_6011.method_12789(OVERHEAT_TICKS) + 1)));
            } else if (energy <= 0.0f) {
                this.field_6011.method_12778(OVERHEAT_TICKS, (Object)0);
                if (temperature > this.overheatTemperature + 10.0f) {
                    temperature = this.overheatTemperature + 10.0f;
                }
            }
        }
        this.field_6011.method_12778(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public boolean isOverheated() {
        return ((Float)this.field_6011.method_12789(TEMPERATURE)).floatValue() >= this.overheatTemperature && (Byte)this.field_6011.method_12789(OVERHEAT_TICKS) >= 2;
    }

    public float getTemperature() {
        return ((Float)this.field_6011.method_12789(TEMPERATURE)).floatValue();
    }

    public void method_5773() {
        class_1937 world = this.method_37908();
        this.temperatureUpdate();
        this.method_5670();
        if ((this.deferEndpointResolution & 1) != 0 && this.endpoint1 != null && this.endpoint1.isValid(world)) {
            this.endpoint1.assignWireEntity(this);
            this.deferEndpointResolution = (byte)(this.deferEndpointResolution & 0xFFFFFFFE);
            this.makeWire();
        }
        if ((this.deferEndpointResolution & 2) != 0 && this.endpoint2 != null && this.endpoint2.isValid(world)) {
            this.endpoint2.assignWireEntity(this);
            this.deferEndpointResolution = (byte)(this.deferEndpointResolution & 0xFFFFFFFD);
            this.makeWire();
        }
        if (this.isOverheated()) {
            this.dropWire();
            if (!world.field_9236) {
                if (this.despawnTime == 0) {
                    ModdedSoundEvents.WIRE_BURNED.playFrom((class_1297)this);
                }
                if (++this.despawnTime >= 5) {
                    this.method_31472();
                }
            }
        }
        this.field_5953 = false;
    }

    public void setEndpoint1(IWireEndpoint endpoint) {
        assert (endpoint == null || endpoint.canAcceptType(this.getClass())) : "Endpoint doesn't accept this entity type";
        if (this.endpoint1 != endpoint) {
            if (this.endpoint1 != null) {
                this.endpoint1.removeWireEntity(this);
            }
            class_1937 world = this.method_37908();
            if (endpoint != null) {
                if (endpoint.type() == WireEndpointType.DEFERRED_JUNCTION) {
                    endpoint = ((DeferredJunctionWireEndpoint)endpoint).resolve(world);
                }
                if (endpoint != null) {
                    if (endpoint.isValid(world)) {
                        endpoint.assignWireEntity(this);
                    } else {
                        this.deferEndpointResolution = (byte)(this.deferEndpointResolution | 1);
                        this.deferTicks = 0;
                    }
                }
            }
            this.endpoint1 = endpoint;
            this.makeWire();
        }
    }

    public void setEndpoint2(IWireEndpoint endpoint) {
        assert (endpoint == null || endpoint.canAcceptType(this.getClass())) : "Endpoint doesn't accept this entity type";
        if (this.endpoint2 != endpoint) {
            if (this.endpoint2 != null) {
                this.endpoint2.removeWireEntity(this);
            }
            class_1937 world = this.method_37908();
            if (endpoint != null) {
                if (endpoint.type() == WireEndpointType.DEFERRED_JUNCTION) {
                    endpoint = ((DeferredJunctionWireEndpoint)endpoint).resolve(world);
                }
                if (endpoint != null) {
                    if (endpoint.isValid(world)) {
                        endpoint.assignWireEntity(this);
                    } else {
                        this.deferEndpointResolution = (byte)(this.deferEndpointResolution | 2);
                        this.deferTicks = 0;
                    }
                }
            }
            this.endpoint2 = endpoint;
            this.makeWire();
        }
    }

    public void flipEndpoints() {
        IWireEndpoint endpoint = this.endpoint1;
        this.endpoint1 = this.endpoint2;
        this.endpoint2 = endpoint;
        this.deferEndpointResolution = (byte)((this.deferEndpointResolution & 1) << 1 | (this.deferEndpointResolution & 2) >> 1);
        PowerGrid.LOGGER.debug("Wire entity endpoints have been flipped.");
    }

    public IWireEndpoint getEndpoint1() {
        return this.endpoint1;
    }

    public IWireEndpoint getEndpoint2() {
        return this.endpoint2;
    }

    public void endpointRemoved(IWireEndpoint endpoint) {
    }

    private EntityDataS2CPacket createExtraDataPacket() {
        class_2487 tag = new class_2487();
        this.method_5652(tag);
        tag.method_10569("Version", this.dataVersion++);
        return new EntityDataS2CPacket(this, tag);
    }

    public void sendExtraData() {
        ModdedPackets.sendToClientsTracking(this.createExtraDataPacket(), this);
    }

    public class_2596<class_2602> method_18002() {
        EntityDataS2CPacket extra = this.createExtraDataPacket();
        ModdedPackets.sendToClientsTracking(extra, this);
        return super.method_18002();
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
    }

    @Override
    public void onEntityDataPacket(class_2487 data) {
        int version = data.method_10550("Version");
        if (version < this.dataVersion) {
            return;
        }
        this.method_5749(data);
        this.dataVersion = version + 1;
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_10545("Item")) {
            class_2487 itemTag = nbt.method_10562("Item");
            class_1792 readItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(itemTag.method_10558("Id")));
            if (!(readItem instanceof WireItem)) {
                throw new IllegalStateException("WireEntity item must be a WireItem");
            }
            WireItem wireItem = (WireItem)readItem;
            this.setItem(wireItem, itemTag.method_10550("Count"));
            if (wireItem.canBeColored()) {
                this.color = nbt.method_10550("Color");
            }
        } else {
            throw new IllegalStateException("WireEntity must have an item");
        }
        class_2338 lastPos = null;
        if (nbt.method_10545("LastKnownPos")) {
            lastPos = class_2512.method_10691((class_2487)nbt.method_10562("LastKnownPos"));
        }
        IWireEndpoint endpoint1 = null;
        IWireEndpoint endpoint2 = null;
        if (nbt.method_10545("Endpoint1")) {
            endpoint1 = WireEndpointType.deserialize(nbt.method_10562("Endpoint1"));
        }
        if (nbt.method_10545("Endpoint2")) {
            endpoint2 = WireEndpointType.deserialize(nbt.method_10562("Endpoint2"));
        }
        class_2338 currentPos = this.method_24515();
        if (lastPos != null && !lastPos.equals((Object)currentPos)) {
            class_2338 diff = currentPos.method_10059((class_2382)lastPos);
            if (endpoint1 != null) {
                endpoint1 = endpoint1.makeOffset(diff);
            }
            if (endpoint2 != null) {
                endpoint2 = endpoint2.makeOffset(diff);
            }
        }
        this.setEndpoint1(endpoint1);
        this.setEndpoint2(endpoint2);
        this.field_6011.method_12778(TEMPERATURE, (Object)Float.valueOf(nbt.method_10583("Temperature")));
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColor(class_1767 color) {
        float[] rgb = color.method_7787();
        this.color = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
    }

    public void setItem(WireItem item, int count) {
        this.item = item;
        this.itemCount = count;
        int thermalCount = Math.max(this.itemCount, 1);
        this.thermalMass = item.getThermalMass() * (float)thermalCount;
        this.dissipationFactor = item.getDissipationFactor() * (float)thermalCount;
    }

    public float getResistance() {
        if (this.resistanceOverride != null) {
            return this.resistanceOverride.floatValue();
        }
        return this.item.getResistance() * (float)Math.max(this.itemCount, 1);
    }

    @Nullable
    public class_1799 method_31480() {
        return new class_1799((class_1935)this.item, 1);
    }

    public abstract void makeWire();

    public abstract void dropWire();

    public boolean isConnectedTo(class_2338 pos, int terminal) {
        BlockWireEndpoint testPoint = new BlockWireEndpoint(pos, terminal);
        return testPoint.equals(this.endpoint1) || testPoint.equals(this.endpoint2);
    }

    protected void method_5652(class_2487 nbt) {
        if (this.endpoint1 != null) {
            nbt.method_10566("Endpoint1", (class_2520)this.endpoint1.serialize());
        }
        if (this.endpoint2 != null) {
            nbt.method_10566("Endpoint2", (class_2520)this.endpoint2.serialize());
        }
        class_2487 itemTag = new class_2487();
        itemTag.method_10582("Id", class_7923.field_41178.method_10221((Object)this.item).toString());
        itemTag.method_10569("Count", this.itemCount);
        nbt.method_10566("Item", (class_2520)itemTag);
        if (this.item.canBeColored()) {
            nbt.method_10569("Color", this.color);
        }
        nbt.method_10566("LastKnownPos", (class_2520)class_2512.method_10692((class_2338)this.method_24515()));
        nbt.method_10548("Temperature", ((Float)this.field_6011.method_12789(TEMPERATURE)).floatValue());
    }

    public void method_5650(@NotNull class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (reason.method_31486()) {
            this.dropWire();
            if (this.endpoint1 != null) {
                this.endpoint1.removeWireEntity(this);
            }
            if (this.endpoint2 != null) {
                this.endpoint2.removeWireEntity(this);
            }
        }
    }

    public void method_36209() {
        super.method_36209();
        class_1297.class_5529 reason = this.method_35049();
        if (reason.method_31486()) {
            this.dropWire();
            if (this.endpoint1 != null) {
                this.endpoint1.removeWireEntity(this);
            }
            if (this.endpoint2 != null) {
                this.endpoint2.removeWireEntity(this);
            }
        }
    }

    public void method_5768() {
        for (int i = this.itemCount; i > 0; i -= 64) {
            this.method_5775(new class_1799((class_1935)this.item, Math.min(i, 64)));
        }
        this.itemCount = 0;
        super.method_5768();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == ModdedItems.WIRE_CUTTER.get()) {
            ModdedSoundEvents.WIRE_CUT.playAt(this.method_37908(), this.method_19538(), 0.75f, 1.25f, false);
            this.method_5768();
            return class_1269.field_5812;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof MultimeterItem) {
            MultimeterItem multimeter = (MultimeterItem)class_17922;
            return multimeter.useOnWire(player, stack, hand, this);
        }
        class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dye = (class_1769)class_17922;
            if (this.item.canBeColored()) {
                this.setColor(dye.method_7802());
                return class_1269.field_5812;
            }
        }
        return super.method_5688(player, hand);
    }

    public WireItem getWireItem() {
        return this.item;
    }

    public int getWireCount() {
        return this.itemCount;
    }

    public void incrementWireCount(int count) {
        this.itemCount += count;
        if (this.itemCount < 0) {
            this.itemCount = 0;
        }
        int thermalCount = Math.max(this.itemCount, 1);
        this.thermalMass = this.item.getThermalMass() * (float)thermalCount;
        this.dissipationFactor = this.item.getDissipationFactor() * (float)thermalCount;
    }

    public void method_33572(boolean onFire) {
    }

    public boolean method_5643(class_1282 source, float amount) {
        return super.method_5643(source, amount);
    }

    public class_3619 method_5657() {
        return class_3619.field_15975;
    }

    public int getColor() {
        if (this.item.canBeColored()) {
            return this.color;
        }
        return -1;
    }
}

