/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.function.Supplier;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Contract;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntityEndpoint;
import org.patryk3211.powergrid.electricity.wire.CircuitBoardEndpoint;
import org.patryk3211.powergrid.electricity.wire.DeferredJunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.ImaginaryWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.JunctionWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.AutoCordEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.SocketEndpoint;
import org.patryk3211.powergrid.electricity.wire.powercord.SplitCordEndpoint;

public enum WireEndpointType {
    BLOCK(BlockWireEndpoint::new, true),
    JUNCTION(JunctionWireEndpoint::new, true),
    BLOCK_WIRE(BlockWireEntityEndpoint::new, false),
    IMAGINARY(ImaginaryWireEndpoint::new, false),
    DEFERRED_JUNCTION(DeferredJunctionWireEndpoint::new, true),
    CIRCUIT_BOARD(CircuitBoardEndpoint::new),
    SOCKET(SocketEndpoint::new),
    SPLIT_CORD(SplitCordEndpoint::new),
    AUTO_CORD(AutoCordEndpoint::new);

    private final Supplier<IWireEndpoint> factory;
    private final boolean connectable;

    private WireEndpointType(Supplier<IWireEndpoint> factory, boolean connectable) {
        this.factory = factory;
        this.connectable = connectable;
    }

    private WireEndpointType(Supplier<IWireEndpoint> factory) {
        this(factory, false);
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public class_2487 serialize(IWireEndpoint endpoint) {
        class_2487 tag = new class_2487();
        tag.method_10569("Type", this.ordinal());
        endpoint.write(tag);
        return tag;
    }

    @Contract(value="null -> null")
    public static IWireEndpoint deserialize(class_2487 tag) {
        if (tag == null) {
            return null;
        }
        if (!tag.method_10545("Type")) {
            return null;
        }
        WireEndpointType[] all = WireEndpointType.values();
        int index = tag.method_10550("Type");
        if (index >= all.length) {
            return null;
        }
        WireEndpointType type = all[index];
        IWireEndpoint endpoint = type.factory.get();
        endpoint.read(tag);
        return endpoint;
    }
}

