/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.electricity.wire;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.config.WireValues;
import org.patryk3211.powergrid.electricity.base.IElectric;
import org.patryk3211.powergrid.electricity.base.ITerminalPlacement;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntity;
import org.patryk3211.powergrid.electricity.wire.BlockWireEntityEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWire;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.ImaginaryWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.WireEndpointType;
import org.patryk3211.powergrid.utility.BlockTrace;
import org.patryk3211.powergrid.utility.Lang;
import org.patryk3211.powergrid.utility.PlayerUtilities;

public class WireItem
extends class_1792
implements IWire {
    protected class_2960 wireTexture;
    protected float horizontalCoefficient = 1.01f;
    protected float verticalCoefficient = 1.2f;
    protected float wireThickness = 0.0625f;
    protected boolean colored = false;

    public WireItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1269 result;
        if (context.method_8036() != null && context.method_8036().method_5715()) {
            return super.method_7884(context);
        }
        if (context.method_20287() != class_1268.field_5808) {
            return super.method_7884(context);
        }
        IElectric electric = IElectric.getAt(context.method_8045(), context.method_8037());
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        if (electric != null && (result = electric.onWire(blockState, context)) != class_1269.field_5811) {
            return result;
        }
        class_2487 tag = context.method_8041().method_7969();
        if (tag != null) {
            class_1937 world = context.method_8045();
            class_1799 stack = context.method_8041();
            IWireEndpoint endpoint = WireEndpointType.deserialize(tag);
            if (endpoint == null) {
                return class_1269.field_5814;
            }
            class_1271<BlockWireEntity> result2 = WireItem.connect(world, stack, context.method_8036(), endpoint, new ImaginaryWireEndpoint(context.method_17698()));
            if (result2.method_5467().method_23665()) {
                BlockWireEntity entity = (BlockWireEntity)result2.method_5466();
                if (entity != null) {
                    stack.method_7980(new BlockWireEntityEndpoint(entity, true).serialize());
                    class_1657 player = context.method_8036();
                    if (player != null) {
                        player.method_6122(context.method_20287(), stack);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.method_7884(context);
    }

    public static class_1271<BlockWireEntity> connect(class_1937 world, class_1799 stack, class_1657 player, IWireEndpoint endpoint1, IWireEndpoint endpoint2) {
        BlockTrace.TraceResult result;
        if (endpoint1.type() == WireEndpointType.BLOCK_WIRE && endpoint2.type() == WireEndpointType.BLOCK_WIRE) {
            return WireItem.mergeWires(world, stack, player, (BlockWireEntityEndpoint)endpoint1, (BlockWireEntityEndpoint)endpoint2);
        }
        class_243 lastPoint = endpoint1.getExactPosition(world);
        if (endpoint1.type() != WireEndpointType.BLOCK_WIRE) {
            lastPoint = BlockTrace.alignPosition(lastPoint);
        }
        class_243 targetPoint = endpoint2.getExactPosition(world);
        class_2350 continueDir = null;
        if (endpoint1 instanceof BlockWireEntityEndpoint) {
            BlockWireEntityEndpoint bwe = (BlockWireEntityEndpoint)endpoint1;
            BlockWireEntity entity = bwe.getEntity(world);
            if (entity == null) {
                return class_1271.method_22431(null);
            }
            List<BlockWireEntity.Point> segments = entity.segments;
            if (bwe.getEnd()) {
                BlockWireEntity.Point last = segments.get(segments.size() - 1);
                continueDir = last.direction;
            } else {
                BlockWireEntity.Point first = segments.get(0);
                continueDir = first.direction.method_10153();
            }
        }
        ITerminalPlacement terminal = null;
        if (endpoint2 instanceof BlockWireEndpoint) {
            BlockWireEndpoint wireEndpoint = (BlockWireEndpoint)endpoint2;
            terminal = wireEndpoint.getTerminalPlacement(world);
        }
        if ((result = BlockTrace.findPath(world, lastPoint, targetPoint, terminal, continueDir)) != null && result.reachedTarget()) {
            float addedLength = 0.0f;
            for (BlockWireEntity.Point point : result.points()) {
                addedLength += point.length();
            }
            if (endpoint1.type() != WireEndpointType.BLOCK_WIRE) {
                int newItems = (int)Math.ceil(addedLength);
                if (!PlayerUtilities.hasEnoughItems(player, stack, newItems)) {
                    if (player != null) {
                        player.method_7353((class_2561)Lang.translate("message.connection_missing_items", new Object[0]).style(class_124.field_1061).component(), true);
                    }
                    return class_1271.method_22431(null);
                }
                if (!world.field_9236) {
                    BlockWireEntity entity = BlockWireEntity.create(world, endpoint1, stack.method_46651(newItems), result.points());
                    if (endpoint2.type().isConnectable()) {
                        entity.setEndpoint2(endpoint2);
                    }
                    if (player != null) {
                        class_1792 class_17922;
                        class_1799 offItem = player.method_6079();
                        if (((IWire)stack.method_7909()).canBeColored() && (class_17922 = offItem.method_7909()) instanceof class_1769) {
                            class_1769 dye = (class_1769)class_17922;
                            entity.setColor(dye.method_7802());
                        }
                    }
                    if (!((class_3218)world).method_30736((class_1297)entity)) {
                        PowerGrid.LOGGER.error("Failed to spawn new block wire entity.");
                        if (player != null) {
                            player.method_7353((class_2561)Lang.translate("message.connection_failed", new Object[0]).style(class_124.field_1061).component(), true);
                        }
                        return class_1271.method_22431(null);
                    }
                    PlayerUtilities.removeItems(player, stack, newItems);
                    return class_1271.method_22427((Object)entity);
                }
            } else {
                BlockWireEntityEndpoint bwEndpoint = (BlockWireEntityEndpoint)endpoint1;
                BlockWireEntity wire = bwEndpoint.getEntity(world);
                if (wire.getWireItem() != stack.method_7909()) {
                    player.method_7353((class_2561)Lang.translate("message.connection_incorrect_wire_type", new Object[0]).style(class_124.field_1061).component(), true);
                    return class_1271.method_22431(null);
                }
                int newItems = (int)Math.ceil(wire.getTotalLength() + addedLength - (float)wire.getWireCount());
                if (!PlayerUtilities.hasEnoughItems(player, stack, newItems)) {
                    if (player != null) {
                        player.method_7353((class_2561)Lang.translate("message.connection_missing_items", new Object[0]).style(class_124.field_1061).component(), true);
                    }
                    return class_1271.method_22431(null);
                }
                if (!world.field_9236) {
                    if (!bwEndpoint.getEnd()) {
                        PowerGrid.LOGGER.error("Cannot extend wire at start (must be flipped beforehand)");
                        return class_1271.method_22431(null);
                    }
                    if (endpoint2.type().isConnectable()) {
                        wire.setEndpoint2(endpoint2);
                    }
                    wire.extend(result.points(), newItems);
                    PlayerUtilities.removeItems(player, stack, newItems);
                    return class_1271.method_22427((Object)wire);
                }
            }
            return class_1271.method_22427(null);
        }
        return class_1271.method_22431(null);
    }

    public static class_1271<BlockWireEntity> mergeWires(class_1937 world, class_1799 stack, class_1657 player, BlockWireEntityEndpoint endpoint1, BlockWireEntityEndpoint endpoint2) {
        BlockWireEntity sourceEntity;
        BlockWireEntity targetEntity;
        class_2350 continueDir;
        BlockWireEntity entity2;
        if (world.field_9236) {
            throw new IllegalStateException("Wire merging must occur on server");
        }
        class_243 lastPoint = endpoint1.getExactPosition(world);
        class_243 targetPoint = endpoint2.getExactPosition(world);
        BlockWireEntity entity1 = endpoint1.getEntity(world);
        if (entity1 == (entity2 = endpoint2.getEntity(world))) {
            return class_1271.method_22431(null);
        }
        if (entity1.getWireItem() != entity2.getWireItem()) {
            if (player != null) {
                player.method_7353((class_2561)Lang.translate("message.connection_two_wire_types", new Object[0]).style(class_124.field_1061).component(), true);
            }
            return class_1271.method_22431(null);
        }
        if (entity1.getWireItem() != stack.method_7909()) {
            if (player != null) {
                player.method_7353((class_2561)Lang.translate("message.connection_incorrect_wire_type", new Object[0]).style(class_124.field_1061).component(), true);
            }
            return class_1271.method_22431(null);
        }
        List<BlockWireEntity.Point> currentSegments = endpoint1.getEntity((class_1937)world).segments;
        if (endpoint1.getEnd()) {
            BlockWireEntity.Point last = currentSegments.get(currentSegments.size() - 1);
            continueDir = last.direction;
        } else {
            BlockWireEntity.Point first = currentSegments.get(0);
            continueDir = first.direction.method_10153();
        }
        BlockTrace.TraceResult result = BlockTrace.findPath(world, lastPoint, targetPoint, null, continueDir);
        if (result == null || !result.reachedTarget()) {
            return class_1271.method_22431(null);
        }
        float addedLength = 0.0f;
        for (BlockWireEntity.Point point : result.points()) {
            addedLength += point.length();
        }
        int newItems = (int)Math.ceil(entity1.getTotalLength() + entity2.getTotalLength() + addedLength - (float)entity1.getWireCount() - (float)entity2.getWireCount());
        if (!PlayerUtilities.hasEnoughItems(player, stack, newItems)) {
            if (player != null) {
                player.method_7353((class_2561)Lang.translate("message.connection_missing_items", new Object[0]).style(class_124.field_1061).component(), true);
            }
            return class_1271.method_22431(null);
        }
        boolean flipped = false;
        if (endpoint1.getEnd() || !endpoint2.getEnd()) {
            targetEntity = entity1;
            if (!endpoint1.getEnd()) {
                targetEntity = targetEntity.flip();
            }
            sourceEntity = entity2;
            if (endpoint2.getEnd()) {
                flipped = true;
            }
        } else {
            targetEntity = entity2;
            sourceEntity = entity1;
        }
        targetEntity.extend(result.points(), newItems, false);
        if (flipped) {
            ArrayList<BlockWireEntity.Point> segments = new ArrayList<BlockWireEntity.Point>();
            for (BlockWireEntity.Point segment : sourceEntity.segments) {
                segments.add(0, new BlockWireEntity.Point(segment.direction.method_10153(), segment.gridLength));
            }
            targetEntity.setEndpoint2(sourceEntity.getEndpoint1());
            targetEntity.extend(segments, sourceEntity.getWireCount());
        } else {
            targetEntity.setEndpoint2(sourceEntity.getEndpoint2());
            targetEntity.extend(sourceEntity.segments, sourceEntity.getWireCount());
        }
        sourceEntity.method_31472();
        return class_1271.method_22427((Object)targetEntity);
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || stack.method_7985();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (stack.method_7985() && user.method_5715()) {
            stack.method_7980(null);
            if (!world.field_9236) {
                user.method_7353((class_2561)Lang.translate("message.connection_reset", new Object[0]).style(class_124.field_1080).component(), true);
            }
            return class_1271.method_29237((Object)stack, (boolean)true);
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public float getResistance() {
        return WireValues.resistance(this);
    }

    @Override
    public float getMaximumLength() {
        return WireValues.maxLength(this);
    }

    @Override
    public float getDissipationFactor() {
        return WireValues.dissipationFactor(this);
    }

    @Override
    public float getThermalMass() {
        return WireValues.thermalMass(this);
    }

    @Environment(value=EnvType.CLIENT)
    public class_2960 getWireTexture() {
        return this.wireTexture;
    }

    @Environment(value=EnvType.CLIENT)
    public float getHorizontalCoefficient() {
        return this.horizontalCoefficient;
    }

    @Environment(value=EnvType.CLIENT)
    public float getVerticalCoefficient() {
        return this.verticalCoefficient;
    }

    @Environment(value=EnvType.CLIENT)
    public float getWireThickness() {
        return this.wireThickness;
    }

    @Override
    public boolean canBeColored() {
        return this.colored;
    }
}

