/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.equipment.portablebattery;

import com.simibubi.create.AllSoundEvents;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.electricity.base.ElectricBlockEntity;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.SwitchedWire;
import org.patryk3211.powergrid.equipment.portablebattery.BatteryUtils;
import org.patryk3211.powergrid.equipment.portablebattery.PortableBatteryBlock;

public class PortableBatteryBlockEntity
extends ElectricBlockEntity
implements class_1275 {
    private int charge;
    private int maxCharge;
    private int capacityLevel;
    private SwitchedWire wire;
    private class_2561 name;
    private class_2487 vanillaTag = new class_2487();

    public PortableBatteryBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.maxCharge = ((PortableBatteryBlock)state.method_26204()).capacity();
    }

    @Override
    @Nullable
    public ThermalBehaviour specifyThermalBehaviour() {
        return ThermalBehaviour.fromConfig(this);
    }

    public void tick() {
        this.applyPower(this.wire);
        super.tick();
        if (this.wire.getState() && !this.field_11863.field_9236) {
            int prevComparatorLevel = this.getComparatorOutput();
            float fePerTick = Math.abs(this.wire.potentialDifference()) * ModdedConfigs.server().electricity.forgeEnergyPerVolt.getF();
            this.charge = (int)Math.min((float)this.charge + fePerTick, (float)this.maxCharge);
            this.method_5431();
            if (this.getComparatorOutput() != prevComparatorLevel) {
                this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
                this.sendData();
            }
        }
        this.wire.setState(this.charge < this.maxCharge);
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.wire = builder.connectSwitch(this.resistance(), builder.terminalNode(0), builder.terminalNode(1), this.charge < this.maxCharge);
    }

    private void playFilledEffect() {
        AllSoundEvents.CONFIRM.playAt(this.field_11863, (class_2382)this.field_11867, 0.4f, 1.0f, true);
        class_243 baseMotion = new class_243(0.25, 0.1, 0.0);
        class_243 baseVec = this.field_11867.method_46558();
        for (int i = 0; i < 360; i += 10) {
            class_243 m = VecHelper.rotate((class_243)baseMotion, (double)i, (class_2350.class_2351)class_2350.class_2351.field_11052);
            m = m.method_49272(this.field_11863.field_9229, 0.2f);
            class_243 v = baseVec.method_1019(m.method_1029().method_1021(0.25));
            this.field_11863.method_8406((class_2394)SparkParticleData.INSTANCE, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        int prev = this.charge;
        this.charge = tag.method_10550("Charge");
        this.capacityLevel = tag.method_10550("CapacityLevel");
        this.maxCharge = BatteryUtils.getMaxCharge(this.capacityLevel);
        this.name = tag.method_10545("CustomName") ? class_2561.class_2562.method_10877((String)tag.method_10558("CustomName")) : null;
        this.vanillaTag = tag.method_10562("VanillaTag");
        if (prev != 0 && prev != this.charge && this.charge == this.maxCharge && clientPacket) {
            this.playFilledEffect();
        }
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10569("Charge", this.charge);
        tag.method_10569("CapacityLevel", this.capacityLevel);
        if (this.name != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.name));
        }
        tag.method_10566("VanillaTag", (class_2520)this.vanillaTag);
    }

    public void setCapacityEnchantLevel(int level) {
        this.capacityLevel = level;
        this.maxCharge = BatteryUtils.getMaxCharge(level);
    }

    public void setCharge(int charge) {
        this.charge = charge;
        if (!this.field_11863.field_9236) {
            this.sendData();
        }
    }

    public class_2561 method_5477() {
        return this.name;
    }

    public void setName(class_2561 name) {
        this.name = name;
    }

    public void setTags(class_2487 vanillaTag) {
        this.vanillaTag = vanillaTag;
    }

    public class_2487 getVanillaTag() {
        return this.vanillaTag.method_10553();
    }

    public int getCharge() {
        return this.charge;
    }

    public int getComparatorOutput() {
        return (int)((float)this.charge / (float)this.maxCharge * 15.0f);
    }
}

