/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.inductionrotor;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.apache.commons.lang3.mutable.MutableObject;
import org.patryk3211.powergrid.collections.ModdedConfigs;
import org.patryk3211.powergrid.config.ResistanceValues;
import org.patryk3211.powergrid.electricity.GlobalElectricNetworks;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.IElectricEntity;
import org.patryk3211.powergrid.electricity.base.ProxyElectricBehaviour;
import org.patryk3211.powergrid.electricity.base.ThermalBehaviour;
import org.patryk3211.powergrid.electricity.particles.SparkParticleData;
import org.patryk3211.powergrid.electricity.sim.AbstractElectricWire;
import org.patryk3211.powergrid.electricity.sim.node.VoltageSourceCoupling;
import org.patryk3211.powergrid.electricity.sim.special.GeneratorCoupling;
import org.patryk3211.powergrid.electricity.sim.special.TransmissionLinePart;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.IBrushPlacement;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.InductionRotorBlockEntity;
import org.patryk3211.powergrid.kinetics.generator.rotor.RotorBlockEntity;

public class CommutatorBlockEntity
extends RotorBlockEntity
implements IElectricEntity {
    protected ElectricBehaviour electricBehaviour;
    protected ThermalBehaviour thermalBehaviour;
    protected GeneratorCoupling source;
    private float resistance = 0.0f;
    private boolean updateBehaviour = true;
    private final Set<InductionRotorBlockEntity> rotors = new HashSet<InductionRotorBlockEntity>();

    public CommutatorBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public float inertia() {
        return ModdedConfigs.server().kinetics.generatorControls.generatorCommutatorInertia.getF();
    }

    @Override
    public void buildCircuit(IElectricEntity.CircuitBuilder builder) {
        builder.setTerminalCount(2);
        this.source = builder.addInternalNode(GeneratorCoupling.class, builder.terminalNode(0), builder.terminalNode(1), Float.valueOf(this.resistance), this.rotorBehaviour);
    }

    private void assemblyChanged() {
        this.source = null;
        this.updateBehaviour = true;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.rotorBehaviour.setChangeCallback(this::assemblyChanged);
    }

    protected void applyPower(AbstractElectricWire wire) {
        if (this.thermalBehaviour != null) {
            this.thermalBehaviour.applyWirePower(wire);
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.electricBehaviour != null) {
            this.electricBehaviour.remove();
        }
    }

    public VoltageSourceCoupling getAssemblySource() {
        ElectricBehaviour electricBehaviour = this.electricBehaviour;
        if (electricBehaviour instanceof ProxyElectricBehaviour) {
            ProxyElectricBehaviour proxy = (ProxyElectricBehaviour)electricBehaviour;
            Optional<ElectricBehaviour> opt = proxy.getMainBehaviour();
            if (opt.isEmpty()) {
                return null;
            }
            SmartBlockEntity smartBlockEntity = opt.get().blockEntity;
            if (smartBlockEntity instanceof CommutatorBlockEntity) {
                CommutatorBlockEntity commutator = (CommutatorBlockEntity)smartBlockEntity;
                return commutator.source;
            }
            return null;
        }
        return this.source;
    }

    public float getCurrent() {
        return -this.getAssemblySource().getCurrent();
    }

    public float getPower() {
        VoltageSourceCoupling source = this.getAssemblySource();
        return -source.getCurrent() * source.getVoltage();
    }

    public void tick() {
        assert (this.field_11863 != null);
        super.tick();
        if (this.updateBehaviour) {
            this.rotors.clear();
            this.resistance = 0.0f;
            MutableObject proxyTarget = new MutableObject(null);
            this.rotorBehaviour.forEachSegment(segment -> {
                SmartBlockEntity patt0$temp = segment.blockEntity;
                if (patt0$temp instanceof InductionRotorBlockEntity) {
                    InductionRotorBlockEntity rotor = (InductionRotorBlockEntity)patt0$temp;
                    this.resistance += ResistanceValues.get(rotor.method_11010().method_26204());
                    this.rotors.add(rotor);
                } else {
                    SmartBlockEntity patt1$temp = segment.blockEntity;
                    if (patt1$temp instanceof CommutatorBlockEntity) {
                        CommutatorBlockEntity commutator = (CommutatorBlockEntity)patt1$temp;
                        if (commutator.source != null) {
                            proxyTarget.setValue((Object)commutator.field_11867);
                        }
                    }
                }
            });
            Object wires = null;
            ElectricBehaviour oldBehaviour = this.electricBehaviour;
            if (this.electricBehaviour != null) {
                wires = GlobalElectricNetworks.getWorldNetworks(this.field_11863).findConnectedWires(this.electricBehaviour);
                this.electricBehaviour.pause();
            }
            this.electricBehaviour = proxyTarget.getValue() != null ? new ProxyElectricBehaviour(this, () -> ((MutableObject)proxyTarget).getValue()) : new ElectricBehaviour(this);
            if (oldBehaviour != null) {
                this.electricBehaviour.inheritConnections(oldBehaviour);
            }
            this.attachBehaviourLate(this.electricBehaviour);
            this.updateBehaviour = false;
            if (wires != null) {
                wires.forEach(TransmissionLinePart::refreshEndpointNodes);
            }
        }
        float totalField = 0.0f;
        if (this.source != null) {
            for (InductionRotorBlockEntity rotor : this.rotors) {
                totalField += rotor.calculateField();
            }
            this.source.tick(totalField);
        }
        if (this.field_11863.field_9236) {
            float angular = this.rotorBehaviour.getAngularVelocityRadians();
            float current = this.getCurrent();
            class_2248 class_22482 = this.method_11010().method_26204();
            if (!(class_22482 instanceof IBrushPlacement)) {
                return;
            }
            IBrushPlacement brushes = (IBrushPlacement)class_22482;
            class_5819 r = this.field_11863.field_9229;
            for (float chance = Math.min(Math.abs(angular / 32.0f * current / 4.0f), 5.0f); chance > 0.0f; chance -= 1.0f) {
                if (!(r.method_43057() < chance)) continue;
                boolean secondBrush = r.method_43056();
                class_243 pos = this.method_11016().method_46558();
                class_243 brushOffset = brushes.brushOffset(this.method_11010()).method_49272(r, 0.0625f);
                pos = secondBrush ? pos.method_1019(brushOffset) : pos.method_1020(brushOffset);
                int velocityDir = angular < 0.0f ^ secondBrush ? 1 : -1;
                class_243 velocity = brushes.sparkVelocity(this.method_11010(), angular).method_49272(r, 0.0625f);
                this.field_11863.method_8406((class_2394)new SparkParticleData(r.method_39332(1, 3), false, true), pos.field_1352, pos.field_1351, pos.field_1350, velocity.field_1352 * (double)velocityDir, velocity.field_1351 * (double)velocityDir, velocity.field_1350 * (double)velocityDir);
            }
        }
    }
}

