/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.kinetics.generator.winding;

import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingItem;
import org.patryk3211.powergrid.utility.PlacementOverlay;
import org.patryk3211.powergrid.utility.PlayerUtilities;

@Environment(value=EnvType.CLIENT)
public class WindingPreview {
    private static final Random r = new Random();

    @Nullable
    public static class_1799 getUsedWireStack(class_1657 player) {
        class_1799 stack1 = player.method_6047();
        class_1799 stack2 = player.method_6079();
        if (stack1 != null && stack1.method_7909() instanceof WindingItem && stack1.method_7985()) {
            return stack1;
        }
        if (stack2 != null && stack2.method_7909() instanceof WindingItem && stack2.method_7985()) {
            return stack2;
        }
        return null;
    }

    public static void tick() {
        class_746 player = class_310.method_1551().field_1724;
        class_638 world = class_310.method_1551().field_1687;
        if (player == null || world == null) {
            return;
        }
        class_1799 stack = WindingPreview.getUsedWireStack((class_1657)player);
        if (stack == null) {
            return;
        }
        class_2487 tag = stack.method_7969();
        int[] posArray = tag.method_10561("Position");
        if (posArray.length < 3) {
            return;
        }
        class_2338 firstPos = new class_2338(posArray[0], posArray[1], posArray[2]);
        class_2680 firstState = world.method_8320(firstPos);
        if (!ShaftBlock.isShaft((class_2680)firstState)) {
            return;
        }
        class_239 rayTrace = class_310.method_1551().field_1765;
        if (!(rayTrace instanceof class_3965)) {
            if (r.nextInt(50) == 0) {
                world.method_8406((class_2394)new class_2390(new Vector3f(0.3f, 0.9f, 0.5f), 1.0f), (double)((float)firstPos.method_10263() + 0.5f + WindingPreview.randomOffset(0.25f)), (double)((float)firstPos.method_10264() + 0.5f + WindingPreview.randomOffset(0.25f)), (double)((float)firstPos.method_10260() + 0.5f + WindingPreview.randomOffset(0.25f)), 0.0, 0.0, 0.0);
            }
            return;
        }
        class_3965 hit = (class_3965)rayTrace;
        class_2338 selected = hit.method_17777();
        class_2680 selectedState = world.method_8320(selected);
        if (!ShaftBlock.isShaft((class_2680)selectedState)) {
            selected = selected.method_10093(hit.method_17780());
        }
        boolean canConnect = ShaftBlock.isShaft((class_2680)selectedState) && WindingItem.isPlacementAxisAligned(selected, firstPos) && firstState.method_11654((class_2769)class_2741.field_12496) == selectedState.method_11654((class_2769)class_2741.field_12496);
        class_2350.class_2351 placementAxis = WindingItem.getPlacementAxis(selected, firstPos);
        if (placementAxis == firstState.method_11654((class_2769)class_2741.field_12496)) {
            canConnect = false;
        }
        int length = WindingItem.getPlacementDelta(selected, firstPos);
        if (canConnect) {
            if (length > 0) {
                for (i = 1; i < length; ++i) {
                    if (world.method_8320(firstPos.method_30513(placementAxis, i)).method_45474()) continue;
                    canConnect = false;
                    break;
                }
            } else {
                for (i = -1; i > length; --i) {
                    if (world.method_8320(firstPos.method_30513(placementAxis, i)).method_45474()) continue;
                    canConnect = false;
                    break;
                }
            }
        }
        if (!player.method_7337()) {
            class_1792 item = stack.method_7909();
            int count = Math.abs(length) + 1;
            boolean hasItems = PlayerUtilities.hasEnoughItems((class_1657)player, item, count);
            PlacementOverlay.setItemRequirement(item, count, hasItems);
        }
        class_243 start = class_243.method_24954((class_2382)firstPos);
        class_2350 heading = class_2350.method_10169((class_2350.class_2351)placementAxis, (class_2350.class_2352)(length > 0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060));
        for (float f = 0.0f; f < (float)Math.abs(length); f += 0.0625f) {
            class_243 position = start.method_43206(heading, (double)f);
            if (r.nextInt(10) != 0) continue;
            world.method_8406((class_2394)new class_2390(new Vector3f(canConnect ? 0.3f : 0.9f, canConnect ? 0.9f : 0.3f, 0.5f), 1.0f), position.field_1352 + 0.5, position.field_1351 + 0.5, position.field_1350 + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private static float randomOffset(float range) {
        return (r.nextFloat() - 0.5f) * 2.0f * range;
    }
}

