/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.mixin.fabric;

import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.patryk3211.powergrid.circuits.circuitboard.IncompleteCircuitItem;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ArmInteractionPoint.class}, remap=false)
public abstract class ArmInteractionPointMixin {
    @Shadow
    @Nullable
    protected abstract Storage<ItemVariant> getHandler();

    @Shadow
    public abstract class_1937 getLevel();

    @Shadow
    public abstract class_2338 getPos();

    @Unique
    private class_1799 powerGrid$handleDepot(class_1799 stack, TransactionContext ctx) {
        Storage<ItemVariant> handler = this.getHandler();
        if (handler == null) {
            return null;
        }
        try (Transaction inner = ctx.openNested();){
            for (StorageView view : handler) {
                if (view.isResourceBlank() || view.getAmount() == 0L) continue;
                ItemVariant circuit = (ItemVariant)view.getResource();
                if (!circuit.isOf((Object)((class_1792)ModdedItems.INCOMPLETE_CIRCUIT.get()))) continue;
                if (handler.extract((Object)((ItemVariant)view.getResource()), 1L, ctx) == 0L) continue;
                class_1799 newCircuit = IncompleteCircuitItem.insert(circuit.toStack(), stack);
                if (newCircuit != null && handler.insert((Object)ItemVariant.of((class_1799)newCircuit), 1L, ctx) == 1L) {
                    class_1799 result = ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)(stack.method_7947() - 1));
                    inner.commit();
                    class_1799 class_17992 = result;
                    return class_17992;
                }
                inner.abort();
                class_1799 class_17993 = stack;
                return class_17993;
            }
        }
        return null;
    }

    @Unique
    private class_1799 powerGrid$handleBelt(class_1799 stack, TransactionContext ctx) {
        BeltBlockEntity beltBE = BeltHelper.getSegmentBE((class_1936)this.getLevel(), (class_2338)this.getPos());
        if (beltBE == null) {
            return null;
        }
        TransportedItemStackHandlerBehaviour transport = (TransportedItemStackHandlerBehaviour)beltBE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
        if (transport == null) {
            return null;
        }
        MutableBoolean found = new MutableBoolean(false);
        MutableBoolean inserted = new MutableBoolean(false);
        transport.handleCenteredProcessingOnAllItems(0.05f, tis -> {
            if (found.isFalse() && ModdedItems.INCOMPLETE_CIRCUIT.isIn(tis.stack)) {
                found.setTrue();
                class_1799 newCircuit = IncompleteCircuitItem.insert(tis.stack, stack);
                if (newCircuit != null) {
                    inserted.setTrue();
                    TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                        TransportedItemStack result = new TransportedItemStack(newCircuit);
                        result.lockedExternally = newCircuit.method_31574((class_1792)ModdedItems.INCOMPLETE_CIRCUIT.get());
                        transport.handleProcessingOnItem(tis, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(List.of(), (TransportedItemStack)result));
                    });
                }
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        });
        if (found.isFalse()) {
            return null;
        }
        if (inserted.isFalse()) {
            return stack;
        }
        return ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)(stack.method_7947() - 1));
    }

    @Inject(method={"insert"}, at={@At(value="INVOKE", target="Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;insert(Ljava/lang/Object;JLnet/fabricmc/fabric/api/transfer/v1/transaction/TransactionContext;)J")}, cancellable=true)
    private void insertAssembleCircuit(class_1799 stack, TransactionContext ctx, CallbackInfoReturnable<class_1799> cir) {
        class_1799 remainder = null;
        if (this instanceof AllArmInteractionPointTypes.BeltPoint) {
            remainder = this.powerGrid$handleBelt(stack, ctx);
        } else if (this instanceof AllArmInteractionPointTypes.DepotPoint) {
            remainder = this.powerGrid$handleDepot(stack, ctx);
        }
        if (remainder != null) {
            cir.setReturnValue((Object)remainder);
        }
    }
}

