/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import org.ejml.data.DMatrixRMaj;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.electricity.base.ElectricBehaviour;
import org.patryk3211.powergrid.electricity.sim.ElectricalNetwork;
import org.patryk3211.powergrid.electricity.sim.node.INode;
import org.patryk3211.powergrid.electricity.sim.node.OwnedFloatingNode;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.IWireEndpoint;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class SolverStateS2CPacket
implements SimplePacket {
    private final Map<class_2338, double[]> solverValues = new HashMap<class_2338, double[]>();
    public final Set<class_1923> chunks = new HashSet<class_1923>();

    public SolverStateS2CPacket(class_1937 world, ElectricalNetwork network) {
        for (INode node : network.getNodes()) {
            BlockWireEndpoint endpoint;
            ElectricBehaviour behaviour;
            if (!(node instanceof OwnedFloatingNode)) continue;
            OwnedFloatingNode owned = (OwnedFloatingNode)node;
            IWireEndpoint iWireEndpoint = owned.endpoint;
            if (!(iWireEndpoint instanceof BlockWireEndpoint) || (behaviour = (endpoint = (BlockWireEndpoint)iWireEndpoint).getElectricBehaviour(world)) == null || this.solverValues.containsKey(behaviour.getPos())) continue;
            this.chunks.add(new class_1923(behaviour.getPos()));
            List<OwnedFloatingNode> external = behaviour.getExternalNodes();
            List<INode> internal = behaviour.getInternalNodes();
            if (external.isEmpty() || behaviour.getNetwork() != network) continue;
            double[] doubles = new double[external.size() + internal.size()];
            int index = 0;
            for (OwnedFloatingNode eNode : behaviour.getExternalNodes()) {
                doubles[index++] = eNode.getStateValue();
            }
            for (INode iNode : behaviour.getInternalNodes()) {
                doubles[index++] = iNode.getStateValue();
            }
            this.solverValues.put(behaviour.getPos(), doubles);
        }
    }

    public SolverStateS2CPacket(class_2540 buf) {
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            class_2338 pos = buf.method_10811();
            double[] doubles = new double[buf.readInt()];
            for (int j = 0; j < doubles.length; ++j) {
                doubles[j] = buf.readDouble();
            }
            this.solverValues.put(pos, doubles);
        }
    }

    @Override
    public void encode(class_2540 buf) {
        buf.writeInt(this.solverValues.size());
        for (Map.Entry<class_2338, double[]> entry : this.solverValues.entrySet()) {
            buf.method_10807(entry.getKey());
            double[] doubles = entry.getValue();
            buf.writeInt(doubles.length);
            for (double value : doubles) {
                buf.writeDouble(value);
            }
        }
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        context.get().queue(() -> {
            class_1937 world = ClientSideAccess.world();
            for (Map.Entry<class_2338, double[]> entry : this.solverValues.entrySet()) {
                double diff;
                ElectricalNetwork network;
                List<OwnedFloatingNode> external;
                ElectricBehaviour behaviour;
                class_2338 pos = entry.getKey();
                if (!world.method_22340(pos) || (behaviour = (ElectricBehaviour)BlockEntityBehaviour.get((class_1922)world, (class_2338)pos, ElectricBehaviour.TYPE)) == null || (external = behaviour.getExternalNodes()).isEmpty() || (network = behaviour.getNetwork()) == null) continue;
                double[] doubles = entry.getValue();
                int index = 0;
                DMatrixRMaj vector = network.getStateVector();
                if (vector == null) continue;
                for (OwnedFloatingNode eNode : external) {
                    if (vector.getNumRows() <= eNode.getIndex()) continue;
                    diff = doubles[index] - eNode.getStateValue();
                    if (diff > 0.5) {
                        PowerGrid.LOGGER.debug("Solver sync corrected difference of {} at {}", (Object)diff, (Object)pos);
                    }
                    vector.set(eNode.getIndex(), 0, doubles[index++]);
                }
                for (INode iNode : behaviour.getInternalNodes()) {
                    if (vector.getNumRows() <= iNode.getIndex()) continue;
                    diff = doubles[index] - iNode.getStateValue();
                    if (diff > 0.5) {
                        PowerGrid.LOGGER.debug("Solver sync corrected difference of {} at {}", (Object)diff, (Object)pos);
                    }
                    vector.set(iNode.getIndex(), 0, doubles[index++]);
                }
            }
        });
    }
}

