/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlockEntity;
import org.patryk3211.powergrid.circuits.components.properties.ComponentProperty;
import org.patryk3211.powergrid.circuits.components.properties.PropertyEntry;
import org.patryk3211.powergrid.circuits.schematic.PlacedComponent;
import org.patryk3211.powergrid.collections.ModdedBlockEntities;
import org.patryk3211.powergrid.network.SimplePacket;
import org.patryk3211.powergrid.utility.ClientSideAccess;

public class UpdateComponentBiPacket
implements SimplePacket {
    private final class_2338 pos;
    private final int componentId;
    private final class_2960 propertyId;
    private final class_2487 propertyValue;

    public UpdateComponentBiPacket(CircuitBoardBlockEntity be, PlacedComponent component, ComponentProperty<?> property) {
        this.pos = be.method_11016();
        this.componentId = be.getSchematic().getId(component);
        assert (this.componentId >= 0);
        this.propertyId = property.id();
        this.propertyValue = new class_2487();
        component.getEntry(property).write(this.propertyValue);
    }

    public UpdateComponentBiPacket(CircuitBoardBlockEntity be, PlacedComponent component, class_2960 propertyId) {
        this.pos = be.method_11016();
        this.componentId = be.getSchematic().getId(component);
        assert (this.componentId >= 0);
        this.propertyId = propertyId;
        this.propertyValue = new class_2487();
        component.getEntry(propertyId).write(this.propertyValue);
    }

    public UpdateComponentBiPacket(class_2540 buf) {
        this.pos = buf.method_10811();
        this.componentId = buf.readInt();
        this.propertyId = buf.method_10810();
        this.propertyValue = buf.method_10798();
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10807(this.pos);
        buf.writeInt(this.componentId);
        buf.method_10812(this.propertyId);
        buf.method_10794(this.propertyValue);
    }

    public void handle(class_1937 world) {
        Optional be = world.method_35230(this.pos, (class_2591)ModdedBlockEntities.CIRCUIT_BOARD.get());
        be.ifPresent(circuit -> {
            PlacedComponent placed = circuit.getSchematic().components().get(this.componentId);
            PropertyEntry<?> entry = placed.getEntry(this.propertyId);
            entry.read(this.propertyValue);
            placed.stateUpdated();
            if (!world.field_9236) {
                placed.notifyClients(this.propertyId);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient() {
        class_1937 world = ClientSideAccess.world();
        this.handle(world);
    }

    public void handleServer(class_1657 player) {
        class_1937 world = player.method_37908();
        if (!player.method_36971(world, this.pos)) {
            return;
        }
        this.handle(world);
    }

    @Override
    public void handle(Supplier<NetworkManager.PacketContext> context) {
        NetworkManager.PacketContext ctx = context.get();
        ctx.queue(() -> {
            switch (ctx.getEnv()) {
                case CLIENT: {
                    this.handleClient();
                    break;
                }
                case SERVER: {
                    this.handleServer(ctx.getPlayer());
                }
            }
        });
    }
}

