/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.ponder.base;

import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.PonderElement;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.foundation.element.ElementLinkImpl;
import net.createmod.ponder.foundation.instruction.FadeOutOfSceneInstruction;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.patryk3211.powergrid.collections.ModdedItems;
import org.patryk3211.powergrid.electricity.wire.BlockWireEndpoint;
import org.patryk3211.powergrid.electricity.wire.HangingWireEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.CordEntity;
import org.patryk3211.powergrid.electricity.wire.powercord.ICordEndpoint;
import org.patryk3211.powergrid.ponder.base.CreateWireInstruction;
import org.patryk3211.powergrid.ponder.base.ElectricityTickInstruction;
import org.patryk3211.powergrid.ponder.base.InvisibleWireElement;
import org.patryk3211.powergrid.ponder.base.SetSourceInstruction;
import org.patryk3211.powergrid.ponder.base.UnloadElectricityWorldInstruction;
import org.patryk3211.powergrid.ponder.base.VoltageSource;
import org.patryk3211.powergrid.ponder.base.WireElement;

public class ElectricInstructions {
    public static final float DEFAULT_RESISTANCE = 0.005f;
    private final SceneBuilder builder;

    public ElectricInstructions(SceneBuilder builder) {
        this.builder = builder;
    }

    public static ElectricInstructions of(SceneBuilder builder) {
        return new ElectricInstructions(builder);
    }

    public void tickFor(int ticks) {
        this.builder.addInstruction((PonderInstruction)new ElectricityTickInstruction(ticks));
    }

    public ElementLink<WireElement> connect(class_2338 pos1, int terminal1, class_2338 pos2, int terminal2, float resistance) {
        ElementLinkImpl link = new ElementLinkImpl(WireElement.class);
        WireElement element = new WireElement(level -> {
            HangingWireEntity wire = HangingWireEntity.create(level, new BlockWireEndpoint(pos1, terminal1), new BlockWireEndpoint(pos2, terminal2), ModdedItems.WIRE.asStack(), Float.valueOf(resistance));
            wire.updateRenderParams();
            return wire;
        });
        this.builder.addInstruction((PonderInstruction)new CreateWireInstruction(15, class_2350.field_11033, element));
        this.builder.addInstruction(ponder -> ponder.linkElement((PonderElement)element, (ElementLink)link));
        return link;
    }

    public ElementLink<WireElement> connect(class_2338 pos1, int terminal1, class_2338 pos2, int terminal2, class_1767 dye, float resistance) {
        ElementLinkImpl link = new ElementLinkImpl(WireElement.class);
        WireElement element = new WireElement(level -> {
            HangingWireEntity wire = HangingWireEntity.create(level, new BlockWireEndpoint(pos1, terminal1), new BlockWireEndpoint(pos2, terminal2), ModdedItems.INSULATED_COPPER_WIRE.asStack(), Float.valueOf(resistance));
            wire.setColor(dye);
            wire.updateRenderParams();
            return wire;
        });
        this.builder.addInstruction((PonderInstruction)new CreateWireInstruction(15, class_2350.field_11033, element));
        this.builder.addInstruction(ponder -> ponder.linkElement((PonderElement)element, (ElementLink)link));
        return link;
    }

    public ElementLink<WireElement> connectCord(ICordEndpoint endpoint1, ICordEndpoint endpoint2, float resistance) {
        ElementLinkImpl link = new ElementLinkImpl(WireElement.class);
        WireElement element = new WireElement(level -> {
            CordEntity wire = CordEntity.create(level, endpoint1, endpoint2, ModdedItems.CORD.asStack(), Float.valueOf(resistance));
            wire.updateRenderParams();
            return wire;
        });
        this.builder.addInstruction((PonderInstruction)new CreateWireInstruction(15, class_2350.field_11033, element));
        this.builder.addInstruction(ponder -> ponder.linkElement((PonderElement)element, (ElementLink)link));
        return link;
    }

    public ElementLink<WireElement> connect(class_2338 pos1, int terminal1, class_2338 pos2, int terminal2) {
        return this.connect(pos1, terminal1, pos2, terminal2, 0.005f);
    }

    public ElementLink<WireElement> connect(class_2338 pos1, int terminal1, class_2338 pos2, int terminal2, class_1767 dye) {
        return this.connect(pos1, terminal1, pos2, terminal2, dye, 0.005f);
    }

    public ElementLink<WireElement> connectCord(ICordEndpoint endpoint1, ICordEndpoint endpoint2) {
        return this.connectCord(endpoint1, endpoint2, 0.005f);
    }

    public ElementLink<WireElement> connectInvisible(class_2338 pos1, int terminal1, class_2338 pos2, int terminal2, float resistance) {
        ElementLinkImpl link = new ElementLinkImpl(WireElement.class);
        InvisibleWireElement element = new InvisibleWireElement(pos1, terminal1, pos2, terminal2, resistance);
        this.builder.addInstruction((PonderInstruction)new CreateWireInstruction(0, class_2350.field_11033, element));
        this.builder.addInstruction(ponder -> ponder.linkElement((PonderElement)element, (ElementLink)link));
        return link;
    }

    public ElementLink<WireElement> connectInvisible(class_2338 pos1, int terminal1, class_2338 pos2, int terminal2) {
        return this.connectInvisible(pos1, terminal1, pos2, terminal2, 0.005f);
    }

    public ElementLink<VoltageSource> addSource(class_2338 pos, int terminal, float voltage) {
        ElementLinkImpl link = new ElementLinkImpl(VoltageSource.class);
        VoltageSource element = new VoltageSource(new BlockWireEndpoint(pos, terminal), voltage);
        this.builder.addInstruction(scene -> {
            scene.addElement((PonderElement)element);
            scene.linkElement((PonderElement)element, (ElementLink)link);
        });
        return link;
    }

    public void setSource(ElementLink<VoltageSource> source, float value) {
        this.builder.addInstruction(scene -> {
            VoltageSource element = (VoltageSource)scene.resolve(source);
            if (element != null) {
                element.setValue(value);
            }
        });
    }

    public void removeWire(ElementLink<WireElement> wire) {
        this.builder.addInstruction((PonderInstruction)new FadeOutOfSceneInstruction(15, class_2350.field_11036, wire));
    }

    public void setSource(class_2338 sourcePos, float value) {
        this.builder.addInstruction((PonderInstruction)new SetSourceInstruction(sourcePos, value));
    }

    public void unload() {
        this.builder.addInstruction((PonderInstruction)new UnloadElectricityWorldInstruction());
    }
}

