/*
 * Decompiled with CFR 0.152.
 */
package org.patryk3211.powergrid.utility.fabric;

import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import io.github.fabricators_of_create.porting_lib.models.generators.ConfiguredModel;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.MultiPartBlockStateBuilder;
import io.github.fabricators_of_create.porting_lib.models.generators.item.ItemModelBuilder;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.apache.logging.log4j.util.TriConsumer;
import org.patryk3211.powergrid.PowerGrid;
import org.patryk3211.powergrid.base.CustomProperties;
import org.patryk3211.powergrid.circuits.circuitboard.CircuitBoardBlock;
import org.patryk3211.powergrid.circuits.editor.CircuitDesignTableBlock;
import org.patryk3211.powergrid.electricity.basinheater.BasinHeaterBlock;
import org.patryk3211.powergrid.electricity.electricswitch.HvSwitchBlock;
import org.patryk3211.powergrid.electricity.electricswitch.SwitchBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseHolderBlock;
import org.patryk3211.powergrid.electricity.fuse.FuseState;
import org.patryk3211.powergrid.electricity.light.fixture.LightFixtureBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerMediumBlock;
import org.patryk3211.powergrid.electricity.transformer.TransformerSmallBlock;
import org.patryk3211.powergrid.kinetics.generator.housing.GeneratorHousing;
import org.patryk3211.powergrid.kinetics.generator.inductionrotor.VerticalCommutatorBlock;
import org.patryk3211.powergrid.kinetics.generator.rotor.AbstractRotorBlock;
import org.patryk3211.powergrid.kinetics.generator.winding.WindingBlock;

public class DataProviderUtilityImpl {
    public static ModelFile.ExistingModelFile modModel(RegistrateBlockstateProvider prov, String name) {
        return prov.models().getExistingFile(prov.modLoc(name));
    }

    public static ModelFile.UncheckedModelFile unchecked(String name) {
        return new ModelFile.UncheckedModelFile(PowerGrid.asResource(name));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> horizontalBlock(String model) {
        return (ctx, prov) -> prov.horizontalBlock((class_2248)ctx.getEntry(), (ModelFile)DataProviderUtilityImpl.modModel(prov, model));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> horizontalBlock(Function<class_2680, String> model) {
        return (ctx, prov) -> prov.horizontalBlock((class_2248)ctx.getEntry(), state -> DataProviderUtilityImpl.modModel(prov, (String)model.apply((class_2680)state)));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> alternateDirectionalBlock(Function<class_2680, String> modelProvider) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, (String)modelProvider.apply((class_2680)state)));
            switch ((class_2350)state.method_11654((class_2769)class_2741.field_12525)) {
                case field_11035: {
                    builder.rotationY(180);
                    break;
                }
                case field_11034: {
                    builder.rotationY(90);
                    break;
                }
                case field_11039: {
                    builder.rotationY(-90);
                    break;
                }
                case field_11036: {
                    builder.rotationX(-90);
                    break;
                }
                case field_11033: {
                    builder.rotationX(90);
                }
            }
            return builder.build();
        });
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> horizontalAxisBlock(String model) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, model));
            if (state.method_11654((class_2769)class_2741.field_12529) == class_2350.class_2351.field_11048) {
                builder.rotationY(90);
            }
            return builder.build();
        });
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> surfaceSwitch(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            String suffix = (Boolean)state.method_11654((class_2769)SwitchBlock.OPEN) != false ? "_off" : "_on";
            DataProviderUtilityImpl.surfaceFacingTransforms(state, (TriConsumer<Integer, Integer, Boolean>)((TriConsumer)(x, y, vertical) -> {
                String suffix2 = vertical != false ? "_v" : "_h";
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + suffix + suffix2));
                builder.rotationX(x.intValue()).rotationY(y.intValue());
            }));
            return builder.build();
        });
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> surfaceBlock(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            DataProviderUtilityImpl.surfaceFacingTransforms(state, (TriConsumer<Integer, Integer, Boolean>)((TriConsumer)(x, y, vertical) -> {
                String suffix = vertical != false ? "_v" : "_h";
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + suffix));
                builder.rotationX(x.intValue()).rotationY(y.intValue());
            }));
            return builder.build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, LightFixtureBlock>, RegistrateBlockstateProvider> lightFixture(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            Boolean axis_along_first = (Boolean)state.method_11654((class_2769)CustomProperties.ALONG_FIRST_AXIS);
            int x = 0;
            int y = 0;
            boolean vertical = false;
            switch (facing) {
                case field_11036: {
                    vertical = true;
                    break;
                }
                case field_11033: {
                    x = 180;
                    vertical = true;
                    break;
                }
                case field_11034: {
                    y = 180;
                    break;
                }
                case field_11043: {
                    y = 90;
                    break;
                }
                case field_11035: {
                    y = -90;
                }
            }
            if (!axis_along_first.booleanValue() && vertical) {
                y = 90;
            } else if (axis_along_first.booleanValue() && !vertical) {
                x = -90;
            }
            String suffix = vertical ? "_v" : "_h";
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + suffix));
            builder.rotationX(x).rotationY(y);
            return builder.build();
        });
    }

    public static void surfaceFacingTransforms(class_2680 state, TriConsumer<Integer, Integer, Boolean> transformer) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        boolean axis_along_first = false;
        if (state.method_28498((class_2769)CustomProperties.ALONG_FIRST_AXIS)) {
            axis_along_first = (Boolean)state.method_11654((class_2769)CustomProperties.ALONG_FIRST_AXIS);
        } else if (state.method_28498((class_2769)CustomProperties.ROTATION_4)) {
            axis_along_first = (Integer)state.method_11654((class_2769)CustomProperties.ROTATION_4) % 2 == 1;
        }
        int x = 0;
        int y = 0;
        boolean verticalModel = false;
        switch (facing) {
            case field_11036: {
                x = 180;
                verticalModel = true;
                break;
            }
            case field_11033: {
                verticalModel = true;
                break;
            }
            case field_11039: {
                y = 180;
                break;
            }
            case field_11043: {
                y = -90;
                break;
            }
            case field_11035: {
                y = 90;
            }
        }
        if (!axis_along_first) {
            if (verticalModel) {
                y = 90;
            } else {
                x = -90;
            }
        }
        transformer.accept((Object)x, (Object)y, (Object)verticalModel);
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> housing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            int x = 0;
            int y = 0;
            class_2350 facing = (class_2350)state.method_11654(GeneratorHousing.HORIZONTAL_FACING);
            if (facing.method_10166() == class_2350.class_2351.field_11048) {
                y = -90;
            }
            if (facing.method_10171() == class_2350.class_2352.field_11060) {
                x = -90;
            }
            if (((Boolean)state.method_11654((class_2769)GeneratorHousing.UP)).booleanValue()) {
                x = 90 - x;
            }
            return builder.rotationX(x).rotationY(y).build();
        });
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> basinHeater(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Object model = switch ((BlazeBurnerBlock.HeatLevel)state.method_11654(BasinHeaterBlock.HEAT_LEVEL)) {
                default -> throw new IncompatibleClassChangeError();
                case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> baseName;
                case BlazeBurnerBlock.HeatLevel.FADING, BlazeBurnerBlock.HeatLevel.KINDLED -> baseName + "_on";
                case BlazeBurnerBlock.HeatLevel.SEETHING -> baseName + "_seething";
            };
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, (String)model));
            return builder.build();
        });
    }

    public static <T extends AbstractRotorBlock> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> rotorModel(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            int x = 90;
            int y = 0;
            ModelFile.ExistingModelFile model = DataProviderUtilityImpl.modModel(prov, name);
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)model);
            class_2350.class_2351 axis = state.method_28498((class_2769)class_2741.field_12496) ? (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496) : (state.method_28498((class_2769)class_2741.field_12529) ? (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12529) : class_2350.class_2351.field_11051);
            switch (axis) {
                case field_11048: {
                    builder.rotationY(y - 90);
                    break;
                }
                case field_11051: {
                    builder.rotationY(y);
                    break;
                }
                case field_11052: {
                    builder.rotationX(x);
                }
            }
            return builder.build();
        });
    }

    public static <T extends VerticalCommutatorBlock> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> verticalCommutator(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ModelFile.ExistingModelFile model = DataProviderUtilityImpl.modModel(prov, name);
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)model);
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (!((Boolean)state.method_11654((class_2769)class_2741.field_12519)).booleanValue()) {
                builder.rotationX(180);
            }
            builder.rotationY((int)(facing.method_10144() - 180.0f));
            return builder.build();
        });
    }

    public static <T extends HvSwitchBlock> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> hvSwitch(String baseName) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Integer part = (Integer)state.method_11654((class_2769)HvSwitchBlock.PART);
            if (part == 0) {
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + "_body"));
            } else {
                builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, baseName + "_receptacle"));
            }
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            builder.rotationY((int)facing.method_10144());
            return builder.build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, TransformerSmallBlock>, RegistrateBlockstateProvider> transformerSmall() {
        return (ctx, prov) -> ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((class_2248)ctx.getEntry()).part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small")).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new class_2350.class_2351[]{class_2350.class_2351.field_11051}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil1")).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new class_2350.class_2351[]{class_2350.class_2351.field_11051}).condition((class_2769)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{1, 2}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil2")).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new class_2350.class_2351[]{class_2350.class_2351.field_11051}).condition((class_2769)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{2}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small")).rotationY(90).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new class_2350.class_2351[]{class_2350.class_2351.field_11048}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil1")).rotationY(90).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new class_2350.class_2351[]{class_2350.class_2351.field_11048}).condition((class_2769)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{1, 2}).end().part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/transformer/small_coil2")).rotationY(90).addModel()).condition(TransformerSmallBlock.HORIZONTAL_AXIS, (Comparable[])new class_2350.class_2351[]{class_2350.class_2351.field_11048}).condition((class_2769)TransformerSmallBlock.COILS, (Comparable[])new Integer[]{2}).end();
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, TransformerMediumBlock>, RegistrateBlockstateProvider> transformerMedium() {
        return (ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((class_2248)ctx.getEntry());
            DataProviderUtilityImpl.transformerMedium(builder, prov, class_2350.class_2351.field_11051);
            DataProviderUtilityImpl.transformerMedium(builder, prov, class_2350.class_2351.field_11048);
        };
    }

    public static void transformerMedium(MultiPartBlockStateBuilder builder, RegistrateBlockstateProvider prov, class_2350.class_2351 axis) {
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_bottom", axis, 0, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_bottom_1", axis, 1, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_top", axis, 2, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_top_1", axis, 3, false).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil1", axis, 0, true).condition((class_2769)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{1, 2}).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil1", axis, 1, true).condition((class_2769)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{1, 2}).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil2", axis, 2, true).condition((class_2769)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{2}).end();
        DataProviderUtilityImpl.transformerMediumPart(builder, prov, "block/transformer/medium_coil2", axis, 3, true).condition((class_2769)TransformerMediumBlock.COILS, (Comparable[])new Integer[]{2}).end();
    }

    private static MultiPartBlockStateBuilder.PartBuilder transformerMediumPart(MultiPartBlockStateBuilder builder, RegistrateBlockstateProvider prov, String model, class_2350.class_2351 axis, int part, boolean coil) {
        int y = 0;
        if (part % 2 == 1 && coil) {
            y = 180;
        }
        if (axis == class_2350.class_2351.field_11048) {
            y -= 90;
        }
        return ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, model)).rotationY(y).addModel()).condition(TransformerMediumBlock.HORIZONTAL_AXIS, (Comparable[])new class_2350.class_2351[]{axis}).condition((class_2769)TransformerMediumBlock.PART, (Comparable[])new Integer[]{part});
    }

    public static <T extends WindingBlock> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> windingModel() {
        return (ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((class_2248)ctx.getEntry());
            for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
                for (int i = 0; i <= 2; ++i) {
                    DataProviderUtilityImpl.windingModel(axis, i, true, builder, prov);
                    DataProviderUtilityImpl.windingModel(axis, i, false, builder, prov);
                }
            }
        };
    }

    private static void windingModel(class_2350.class_2351 axis, int part, boolean alongFirst, MultiPartBlockStateBuilder builder, RegistrateBlockstateProvider prov) {
        int x = 0;
        int y = 0;
        switch (axis) {
            case field_11048: {
                y = -90;
                break;
            }
            case field_11052: {
                x = 90;
            }
        }
        if (part == 2) {
            if (axis == class_2350.class_2351.field_11052) {
                x += 180;
            } else {
                y += 180;
            }
        }
        ModelFile.ExistingModelFile model = switch (part) {
            case 0, 2 -> {
                Object base;
                Object v0 = base = alongFirst ? "block/winding/end_v" : "block/winding/end";
                if (part == 2 && !alongFirst && axis.method_10179()) {
                    base = (String)base + "_1";
                }
                yield DataProviderUtilityImpl.modModel(prov, (String)base);
            }
            case 1 -> DataProviderUtilityImpl.modModel(prov, alongFirst ? "block/winding/middle_v" : "block/winding/middle");
            default -> throw new IllegalStateException();
        };
        Function<Boolean, ModelFile.ExistingModelFile> caseModel = half -> {
            boolean condition;
            boolean bl = condition = half == false;
            condition = axis == class_2350.class_2351.field_11051 ? (condition ^= alongFirst && part == 2) : (axis == class_2350.class_2351.field_11052 ? (condition ^= !alongFirst && part != 2) : (condition ^= alongFirst && part != 2));
            String halfStr = condition ? "p" : "n";
            return switch (part) {
                case 0, 2 -> DataProviderUtilityImpl.modModel(prov, "block/winding/end" + (alongFirst ? "_v" : "") + "_case_" + halfStr);
                case 1 -> DataProviderUtilityImpl.modModel(prov, "block/winding/middle" + (alongFirst ? "_v" : "") + "_case_" + halfStr);
                default -> throw new IllegalStateException();
            };
        };
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)caseModel.apply(false)).rotationX(x).rotationY(y).addModel()).condition((class_2769)class_2741.field_12496, (Comparable[])new class_2350.class_2351[]{axis}).condition((class_2769)WindingBlock.PART, (Comparable[])new Integer[]{part}).condition((class_2769)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{alongFirst}).condition((class_2769)WindingBlock.CASE_LEFT, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)caseModel.apply(true)).rotationX(x).rotationY(y).addModel()).condition((class_2769)class_2741.field_12496, (Comparable[])new class_2350.class_2351[]{axis}).condition((class_2769)WindingBlock.PART, (Comparable[])new Integer[]{part}).condition((class_2769)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{alongFirst}).condition((class_2769)WindingBlock.CASE_RIGHT, (Comparable[])new Boolean[]{true}).end();
        if (axis == class_2350.class_2351.field_11052 && alongFirst && part == 0) {
            y = 180;
        } else if (axis == class_2350.class_2351.field_11052 && alongFirst && part == 1) {
            y += 180;
        }
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)model).rotationX(x).rotationY(y).addModel()).condition((class_2769)class_2741.field_12496, (Comparable[])new class_2350.class_2351[]{axis}).condition((class_2769)WindingBlock.PART, (Comparable[])new Integer[]{part}).condition((class_2769)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{alongFirst}).end();
    }

    public static void rotateDownFacingModel(ConfiguredModel.Builder<?> builder, class_2350 facing) {
        switch (facing) {
            case field_11036: {
                builder.rotationX(180);
                break;
            }
            case field_11043: {
                builder.rotationX(-90);
                break;
            }
            case field_11035: {
                builder.rotationX(90);
                break;
            }
            case field_11039: {
                builder.rotationX(90).rotationY(90);
                break;
            }
            case field_11034: {
                builder.rotationX(90).rotationY(-90);
            }
        }
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> northFacing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            switch ((class_2350)state.method_11654((class_2769)class_2741.field_12525)) {
                case field_11033: {
                    builder.rotationX(90);
                    break;
                }
                case field_11036: {
                    builder.rotationX(-90);
                    break;
                }
                case field_11035: {
                    builder.rotationY(180);
                    break;
                }
                case field_11034: {
                    builder.rotationY(90);
                    break;
                }
                case field_11039: {
                    builder.rotationY(-90);
                }
            }
            return builder.build();
        });
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> downFacing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            DataProviderUtilityImpl.rotateDownFacingModel(builder, (class_2350)state.method_11654((class_2769)class_2741.field_12525));
            return builder.build();
        });
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> upFacing(String name) {
        return (ctx, prov) -> prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            builder.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, name));
            switch ((class_2350)state.method_11654((class_2769)class_2741.field_12525)) {
                case field_11033: {
                    builder.rotationX(180);
                    break;
                }
                case field_11043: {
                    builder.rotationX(90);
                    break;
                }
                case field_11035: {
                    builder.rotationX(-90);
                    break;
                }
                case field_11034: {
                    builder.rotationX(90).rotationY(90);
                    break;
                }
                case field_11039: {
                    builder.rotationX(90).rotationY(-90);
                }
            }
            return builder.build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, CircuitBoardBlock>, RegistrateBlockstateProvider> circuitBoard() {
        return (ctx, prov) -> prov.simpleBlock((class_2248)ctx.getEntry(), (ModelFile)DataProviderUtilityImpl.unchecked("circuit_board"));
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, CircuitDesignTableBlock>, RegistrateBlockstateProvider> circuitDesignTable() {
        return (ctx, prov) -> prov.simpleBlock((class_2248)ctx.getEntry(), (ModelFile)prov.models().cubeBottomTop(ctx.getName(), prov.modLoc("block/circuit_design_table_side"), prov.mcLoc("block/spruce_planks"), prov.modLoc("block/circuit_design_table_top")));
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, FuseHolderBlock>, RegistrateBlockstateProvider> fuseHolder() {
        return (ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((class_2248)ctx.getEntry());
            for (class_2350 facing : class_2741.field_12525.method_11898()) {
                for (Boolean axis : CustomProperties.ALONG_FIRST_AXIS.method_11898()) {
                    class_2680 state = (class_2680)((class_2680)((FuseHolderBlock)ctx.getEntry()).method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)facing)).method_11657((class_2769)CustomProperties.ALONG_FIRST_AXIS, (Comparable)axis);
                    DataProviderUtilityImpl.surfaceFacingTransforms(state, (TriConsumer<Integer, Integer, Boolean>)((TriConsumer)(x, y, vertical) -> {
                        ConfiguredModel.Builder part = builder.part();
                        if (vertical.booleanValue()) {
                            part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse_holder"));
                        } else {
                            part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse_holder_h"));
                        }
                        part.rotationX(x.intValue()).rotationY(y.intValue());
                        ((MultiPartBlockStateBuilder.PartBuilder)part.addModel()).condition((class_2769)class_2741.field_12525, (Comparable[])new class_2350[]{facing}).condition((class_2769)CustomProperties.ALONG_FIRST_AXIS, (Comparable[])new Boolean[]{axis});
                    }));
                }
                ConfiguredModel.Builder part = builder.part();
                part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse"));
                DataProviderUtilityImpl.rotateDownFacingModel(part, facing);
                ((MultiPartBlockStateBuilder.PartBuilder)part.addModel()).condition((class_2769)class_2741.field_12525, (Comparable[])new class_2350[]{facing}).condition(FuseHolderBlock.STATE, (Comparable[])new FuseState[]{FuseState.CLOSED});
                part = builder.part();
                part.modelFile((ModelFile)DataProviderUtilityImpl.modModel(prov, "block/fuse_blown"));
                DataProviderUtilityImpl.rotateDownFacingModel(part, facing);
                ((MultiPartBlockStateBuilder.PartBuilder)part.addModel()).condition((class_2769)class_2741.field_12525, (Comparable[])new class_2350[]{facing}).condition(FuseHolderBlock.STATE, (Comparable[])new FuseState[]{FuseState.BLOWN});
            }
        };
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> cubeColumn(String side, String end) {
        return (ctx, prov) -> prov.simpleBlock((class_2248)ctx.getEntry(), (ModelFile)prov.models().cubeColumn(ctx.getName(), prov.modLoc(side), prov.modLoc(end)));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> cubeAllWithItem(String name) {
        return (ctx, prov) -> prov.simpleBlockWithItem((class_2248)ctx.getEntry(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc(name)));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> simple(String model) {
        return (ctx, prov) -> prov.simpleBlock((class_2248)ctx.getEntry(), (ModelFile)DataProviderUtilityImpl.modModel(prov, model));
    }

    public static <T extends class_1792> NonNullBiConsumer<DataGenContext<class_1792, T>, RegistrateItemModelProvider> generated() {
        return (ctx, prov) -> prov.generated(ctx.lazy());
    }

    public static <T extends class_1792> NonNullBiConsumer<DataGenContext<class_1792, T>, RegistrateItemModelProvider> gauge(String model, String texture) {
        return (ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.modLoc(model))).texture("2", prov.modLoc(texture));
    }

    public static <T extends class_1792> NonNullBiConsumer<DataGenContext<class_1792, T>, RegistrateItemModelProvider> itemWithParent(String parent) {
        return (ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.modLoc(parent));
    }

    public static <T extends class_1792> NonNullBiConsumer<DataGenContext<class_1792, T>, RegistrateItemModelProvider> barrier() {
        return (ctx, prov) -> prov.withExistingParent(ctx.getName(), prov.mcLoc("item/barrier"));
    }
}

