/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.annotations.DoNotMerge;
import io.github.arcaneplugins.levelledmobs.annotations.DoNotShow;
import io.github.arcaneplugins.levelledmobs.annotations.RuleFieldInfo;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.enums.RuleType;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.AbstractCommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.SuggestionInfo;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.Argument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ArgumentSuggestions;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ListArgumentBuilder;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.StringArgument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.CommandArguments;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.ExecutorType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.MapsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.comparisons.ComparisonsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntries;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntriesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.io.CloseableKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.Sequence;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.SequencesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.misc.EffectiveInfo;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.rules.strategies.PlayerLevellingStrategy;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0002J*\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001f2\b\u0010)\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\u001bH\u0002\u00a8\u0006."}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand;", "", "<init>", "()V", "createInstance", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/CommandAPICommand;", "showAllRules", "", "sender", "Lorg/bukkit/command/CommandSender;", "args", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/executors/CommandArguments;", "getAllRuleNames", "", "", "()[Ljava/lang/String;", "showTempDisabled", "forceRelevel", "resetRules", "difficulty", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand$ResetDifficulty;", "showHyperlink", "message", "url", "showRule", "showEffectiveRules", "getMobBeingLookedAt", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "player", "Lorg/bukkit/entity/Player;", "findNearbyEntities", "", "createParticleEffect", "location", "Lorg/bukkit/Location;", "spawnParticles", "world", "Lorg/bukkit/World;", "showEffectiveValues", "lmEntity", "showOnConsole", "mobHash", "getPlayerLevellingFormatting", "opts", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/PlayerLevellingStrategy;", "ResetDifficulty", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nRulesSubcommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesSubcommand.kt\nio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,726:1\n37#2,2:727\n608#3:729\n608#3:730\n608#3:731\n*S KotlinDebug\n*F\n+ 1 RulesSubcommand.kt\nio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand\n*L\n165#1:727,2\n634#1:729\n647#1:730\n660#1:731\n*E\n"})
public final class RulesSubcommand {
    @NotNull
    public static final RulesSubcommand INSTANCE = new RulesSubcommand();

    private RulesSubcommand() {
    }

    @NotNull
    public final CommandAPICommand createInstance() {
        CommandAPICommand[] commandAPICommandArray = new CommandAPICommand[1];
        Argument[] argumentArray = new Argument[1];
        String[] stringArray = new String[]{"console"};
        argumentArray[0] = new StringArgument("console").includeSuggestions(ArgumentSuggestions.strings(stringArray));
        commandAPICommandArray[0] = ((CommandAPICommand)new CommandAPICommand("show-all").withOptionalArguments(argumentArray)).executes(RulesSubcommand::createInstance$lambda$1, new ExecutorType[0]);
        CommandAPICommand commandAPICommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("rules").withPermission("levelledmobs.command.rules")).withShortDescription("Used to view various rules.")).withFullDescription("Used to view various rules.")).executes(RulesSubcommand::createInstance$lambda$0, new ExecutorType[0])).withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[1];
        argumentArray = new Argument[]{new StringArgument("rulename").replaceSuggestions(ArgumentSuggestions.strings(RulesSubcommand::createInstance$lambda$2))};
        CommandAPICommand commandAPICommand2 = (CommandAPICommand)new CommandAPICommand("show-rule").withArguments(argumentArray);
        argumentArray = new Argument[1];
        stringArray = new String[]{"console"};
        argumentArray[0] = new StringArgument("console").includeSuggestions(ArgumentSuggestions.strings(stringArray));
        commandAPICommandArray[0] = ((CommandAPICommand)commandAPICommand2.withOptionalArguments(argumentArray)).executes(RulesSubcommand::createInstance$lambda$3, new ExecutorType[0]);
        CommandAPICommand commandAPICommand3 = (CommandAPICommand)commandAPICommand.withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[1];
        argumentArray = new Argument[1];
        stringArray = new String[]{"console", "looking-at"};
        argumentArray[0] = new ListArgumentBuilder("values").withList((Collection)CollectionsKt.mutableListOf(stringArray)).withStringMapper().buildGreedy();
        commandAPICommandArray[0] = ((CommandAPICommand)new CommandAPICommand("show-effective").withOptionalArguments(argumentArray)).executes(RulesSubcommand::createInstance$lambda$4, new ExecutorType[0]);
        CommandAPICommand commandAPICommand4 = (CommandAPICommand)commandAPICommand3.withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[]{new CommandAPICommand("help-discord").executes(RulesSubcommand::createInstance$lambda$5, new ExecutorType[0])};
        CommandAPICommand commandAPICommand5 = (CommandAPICommand)commandAPICommand4.withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[]{new CommandAPICommand("help-wiki").executes(RulesSubcommand::createInstance$lambda$6, new ExecutorType[0])};
        CommandAPICommand commandAPICommand6 = (CommandAPICommand)commandAPICommand5.withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[1];
        argumentArray = new Argument[1];
        stringArray = new String[]{"vanilla", "bronze", "silver", "gold", "platinum"};
        argumentArray[0] = new StringArgument("difficulty").includeSuggestions(ArgumentSuggestions.strings(stringArray));
        CommandAPICommand commandAPICommand7 = (CommandAPICommand)new CommandAPICommand("reset").withOptionalArguments(argumentArray);
        argumentArray = new Argument[]{new StringArgument("confirm")};
        commandAPICommandArray[0] = ((CommandAPICommand)commandAPICommand7.withOptionalArguments(argumentArray)).executes(RulesSubcommand::createInstance$lambda$7, new ExecutorType[0]);
        CommandAPICommand commandAPICommand8 = (CommandAPICommand)commandAPICommand6.withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[]{new CommandAPICommand("force-all").executes(RulesSubcommand::createInstance$lambda$8, new ExecutorType[0])};
        CommandAPICommand commandAPICommand9 = (CommandAPICommand)commandAPICommand8.withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[]{new CommandAPICommand("show-temp-disabled").executes(RulesSubcommand::createInstance$lambda$9, new ExecutorType[0])};
        AbstractCommandAPICommand abstractCommandAPICommand = commandAPICommand9.withSubcommands(commandAPICommandArray);
        Intrinsics.checkNotNullExpressionValue(abstractCommandAPICommand, "withSubcommands(...)");
        return (CommandAPICommand)abstractCommandAPICommand;
    }

    private final void showAllRules(CommandSender sender, CommandArguments args) {
        Object object;
        if (sender instanceof Player) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.console-rules");
        }
        boolean showOnConsole = ((object = args.get("console")) instanceof String ? (String)object : null) != null;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        StringBuilder sb = new StringBuilder();
        for (RuleInfo rpi : main.getRulesParsingManager().getRulePresets().values()) {
            String[] stringArray = new String[]{"ruleIsEnabled"};
            sb.append("\n&r--------------------------------- Preset rule ----------------------------------").append(rpi.formatRulesVisually(false, CollectionsKt.mutableListOf(stringArray)));
        }
        StringBuilder stringBuilder = sb.append("\n&r--------------------------------- Default values -------------------------------");
        RuleInfo ruleInfo = main.getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(ruleInfo);
        stringBuilder.append(ruleInfo.formatRulesVisually());
        for (RuleInfo rpi : main.getRulesParsingManager().getCustomRules()) {
            sb.append("\n&r--------------------------------- Custom rule ----------------------------------").append(rpi.formatRulesVisually());
        }
        sb.append("\n&r--------------------------------------------------------------------------------------");
        if (showOnConsole) {
            Log.INSTANCE.inf(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        } else {
            sender.sendMessage(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        }
    }

    private final String[] getAllRuleNames() {
        List allRuleNames = new ArrayList();
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules()) {
            allRuleNames.add(StringsKt.replace$default(ruleInfo.getRuleName$levelledmobs_plugin(), " ", "_", false, 4, null));
        }
        Collection $this$toTypedArray$iv = allRuleNames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final void showTempDisabled(CommandSender sender) {
        LevelledMobs.Companion.getInstance().getRulesManager().showTempDisabledRules(sender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forceRelevel(CommandSender sender) {
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            sender.sendMessage("Sorry this command doesn't work in Folia");
            return;
        }
        int worldCount = 0;
        int entityCount = 0;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        main.reloadLM(sender);
        boolean isUsingPlayerLevelling = main.getRulesManager().isPlayerLevellingEnabled();
        for (World world : Bukkit.getWorlds()) {
            ++worldCount;
            for (Entity entity : world.getEntities()) {
                PersistentDataContainer persistentDataContainer;
                if (!(entity instanceof LivingEntity) || entity instanceof Player) continue;
                boolean doContinue = false;
                Intrinsics.checkNotNullExpressionValue(((LivingEntity)entity).getPersistentDataContainer(), "getPersistentDataContainer(...)");
                synchronized (persistentDataContainer) {
                    boolean bl = false;
                    if (((LivingEntity)entity).getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getWasSummoned(), PersistentDataType.INTEGER)) {
                        doContinue = true;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (doContinue) continue;
                ++entityCount;
                LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
                lmEntity.setReEvaluateLevel(true);
                lmEntity.setRulesForceAll(true);
                lmEntity.setWasPreviouslyLevelled(lmEntity.isLevelled());
                if (isUsingPlayerLevelling) {
                    EntitySpawnListener.Companion.updateMobForPlayerLevelling(lmEntity);
                }
                main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
                lmEntity.free();
            }
        }
        String[] stringArray = new String[]{"%entitycount%", "%worldcount%"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{String.valueOf(entityCount), String.valueOf(worldCount)};
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.rules-reprocessed", stringArray2, stringArray);
    }

    private final void resetRules(CommandSender sender, CommandArguments args) {
        ResetDifficulty difficulty;
        String confirm;
        Object object = args.get("difficulty");
        String difficultyStr = object instanceof String ? (String)object : null;
        Object object2 = args.get("confirm");
        String string = confirm = object2 instanceof String ? (String)object2 : null;
        if (difficultyStr == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.reset");
            return;
        }
        String string2 = difficultyStr;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        switch (string3) {
            case "vanilla": {
                ResetDifficulty resetDifficulty = ResetDifficulty.VANILLA;
                break;
            }
            case "bronze": {
                ResetDifficulty resetDifficulty = ResetDifficulty.BRONZE;
                break;
            }
            case "silver": {
                ResetDifficulty resetDifficulty = ResetDifficulty.SILVER;
                break;
            }
            case "gold": {
                ResetDifficulty resetDifficulty = ResetDifficulty.GOLD;
                break;
            }
            case "platinum": {
                ResetDifficulty resetDifficulty = ResetDifficulty.PLATINUM;
                break;
            }
            default: {
                ResetDifficulty resetDifficulty = difficulty = ResetDifficulty.UNSPECIFIED;
            }
        }
        if (difficulty == ResetDifficulty.UNSPECIFIED) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.invalid-difficulty", "%difficulty%", difficultyStr);
            return;
        }
        if (confirm == null || !StringsKt.equals("confirm", confirm, true)) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.reset-syntax", "%difficulty%", difficultyStr);
            return;
        }
        this.resetRules(sender, difficulty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetRules(@Nullable CommandSender sender, @NotNull ResetDifficulty difficulty) {
        Intrinsics.checkNotNullParameter((Object)difficulty, "difficulty");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        String prefix = main.getConfigUtils().getPrefix();
        if (sender != null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.resetting", "%difficulty%", difficulty.toString());
        }
        String filename = "rules.yml";
        String[] stringArray = new String[]{"    - challenge-silver", ""};
        String[] replaceWhat = stringArray;
        Object object = new String[]{"    #- challenge-silver", ""};
        String[] replaceWith = object;
        switch (WhenMappings.$EnumSwitchMapping$0[difficulty.ordinal()]) {
            case 1: {
                replaceWhat[1] = "#- challenge-vanilla";
                replaceWith[1] = "- challenge-vanilla";
                break;
            }
            case 2: {
                replaceWhat[1] = "#- challenge-bronze";
                replaceWith[1] = "- challenge-bronze";
                break;
            }
            case 3: {
                replaceWhat[1] = "#- challenge-gold";
                replaceWith[1] = "- challenge-gold";
                break;
            }
            case 4: {
                replaceWhat[1] = "#- challenge-platinum";
                replaceWith[1] = "- challenge-platinum";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        try {
            object = main.getResource(filename);
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)object;
                boolean bl = false;
                if (stream == null) {
                    Log.INSTANCE.sev(prefix + " Input stream was null");
                    return;
                }
                byte[] byArray = stream.readAllBytes();
                Intrinsics.checkNotNullExpressionValue(byArray, "readAllBytes(...)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
                Charset charset2 = charset;
                String rulesText = new String(byArray2, charset2);
                if (difficulty != ResetDifficulty.SILVER) {
                    rulesText = StringsKt.replace$default(StringsKt.replace$default(rulesText, replaceWhat[0], replaceWith[0], false, 4, null), replaceWhat[1], replaceWith[1], false, 4, null);
                }
                File rulesFile = new File(main.getDataFolder(), filename);
                File rulesBackupFile = new File(main.getDataFolder(), "rules.yml.backup");
                for (int i = 0; i < 10 && rulesBackupFile.exists(); ++i) {
                    rulesBackupFile = new File(main.getDataFolder(), "rules.yml.backup" + i);
                }
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(rulesFile.toPath(), rulesBackupFile.toPath(), copyOptionArray);
                Path path = Files.writeString(rulesFile.toPath(), (CharSequence)rulesText, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        if (sender != null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.reset-complete");
            main.reloadLM(sender);
        }
    }

    private final void showHyperlink(CommandSender sender, String message, String url) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(url);
            return;
        }
        if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            PaperUtils.INSTANCE.sendHyperlink(sender, message, url);
        } else {
            SpigotUtils.INSTANCE.sendHyperlink(sender, message, url);
        }
    }

    private final void showRule(CommandSender sender, CommandArguments args) {
        Object object = args.get("rulename");
        String ruleName = object instanceof String ? (String)object : null;
        boolean showOnConsole = sender instanceof ConsoleCommandSender;
        Object object2 = args.get("console");
        if ((object2 instanceof String ? (String)object2 : null) != null) {
            showOnConsole = true;
        }
        if (ruleName == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.rule-name-missing");
            return;
        }
        RuleInfo rule = null;
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules()) {
            String checkName = StringsKt.replace$default(ruleInfo.getRuleName$levelledmobs_plugin(), " ", "_", false, 4, null);
            if (!StringsKt.equals(ruleName, checkName, true)) continue;
            rule = ruleInfo;
            break;
        }
        if (rule == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.rule-name-invalid");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.showing-rules", "%rulename%", rule.getRuleName$levelledmobs_plugin()));
        String[] stringArray = new String[]{"id"};
        sb.append(rule.formatRulesVisually(false, CollectionsKt.mutableListOf(stringArray)));
        if (showOnConsole) {
            Log.INSTANCE.inf(sb.toString());
        } else {
            sender.sendMessage(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        }
    }

    private final void showEffectiveRules(CommandSender sender, CommandArguments args) {
        Player player;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            sender.sendMessage("Must be run by a player");
            return;
        }
        Ref.BooleanRef showOnConsole = new Ref.BooleanRef();
        boolean findNearbyEntities = true;
        Object input = args.get("values");
        if (input != null) {
            Set<String> inputValue = CollectionsKt.toMutableSet((ArrayList)input);
            for (String key : inputValue) {
                if (StringsKt.equals("console", key, true)) {
                    showOnConsole.element = true;
                    continue;
                }
                if (!StringsKt.equals("looking-at", key, true)) continue;
                findNearbyEntities = false;
            }
        }
        LivingEntityWrapper livingEntityWrapper = this.getMobBeingLookedAt(player, findNearbyEntities, (CommandSender)player);
        if (livingEntityWrapper == null) {
            return;
        }
        LivingEntityWrapper lmEntity = livingEntityWrapper;
        String entityName = lmEntity.getTypeName();
        if (ExternalCompatibilityManager.Companion.getHasMythicMobsInstalled() && ExternalCompatibilityManager.Companion.isMythicMob(lmEntity)) {
            entityName = ExternalCompatibilityManager.Companion.getMythicMobInternalName(lmEntity);
        }
        String locationStr = lmEntity.getLocation().getBlockX() + ", " + lmEntity.getLocation().getBlockY() + ", " + lmEntity.getLocation().getBlockZ();
        String mobLevel = lmEntity.isLevelled() ? String.valueOf(lmEntity.getGetMobLevel()) : "0";
        String[] stringArray = new String[]{"%mobname%", "%entitytype%", "%location%", "%world%", "%level%"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{entityName, lmEntity.getNameIfBaby(), locationStr, lmEntity.getWorldName(), mobLevel};
        List<String> messages = MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.effective-rules", stringArray2, stringArray);
        StringBuilder sb = new StringBuilder();
        sb.append(StringsKt.replace$default(CollectionsKt.joinToString$default(messages, "\n", null, null, 0, null, null, 62, null), LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix() + " ", "", false, 4, null));
        if (showOnConsole.element) {
            Log.INSTANCE.inf(sb.toString());
        } else {
            sender.sendMessage(sb.toString());
        }
        if (!showOnConsole.element) {
            sb.setLength(0);
        }
        Ref.ObjectRef mobHash = new Ref.ObjectRef();
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING)) {
            mobHash.element = lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING);
        }
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> RulesSubcommand.showEffectiveRules$lambda$0(sender, lmEntity, showOnConsole, mobHash));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.runDelayed(25L);
    }

    @Nullable
    public final LivingEntityWrapper getMobBeingLookedAt(@NotNull Player player, boolean findNearbyEntities, @NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(sender, "sender");
        LivingEntity livingEntity = null;
        LivingEntityWrapper lmEntity = null;
        Location location = player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getEyeLocation(...)");
        Location eye = location;
        SortedMap entities = new TreeMap();
        for (Entity entity : player.getNearbyEntities(10.0, 10.0, 10.0)) {
            Vector toEntity;
            if (!(entity instanceof LivingEntity)) continue;
            if (findNearbyEntities) {
                double distance = ((LivingEntity)entity).getLocation().distanceSquared(player.getLocation());
                ((Map)entities).put(distance, entity);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(((LivingEntity)entity).getEyeLocation().toVector().subtract(eye.toVector()), "subtract(...)");
            double dot = toEntity.normalize().dot(eye.getDirection());
            if (!(dot >= 0.975)) continue;
            livingEntity = (LivingEntity)entity;
            break;
        }
        if (!findNearbyEntities && livingEntity == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.no-entities-visible");
        } else if (findNearbyEntities && entities.isEmpty()) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.no-entities-near");
        } else {
            if (findNearbyEntities) {
                livingEntity = (LivingEntity)entities.get(entities.firstKey());
            }
            LivingEntity livingEntity2 = livingEntity;
            Intrinsics.checkNotNull(livingEntity2);
            Location location2 = livingEntity2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            this.createParticleEffect(location2);
            lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        }
        return lmEntity;
    }

    private final void createParticleEffect(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> RulesSubcommand.createParticleEffect$lambda$0(location, world2));
        scheduler.setLocationForRegionScheduler(location);
        scheduler.run();
    }

    private final void spawnParticles(Location location, World world) {
        try {
            int n = 10;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                world.spawnParticle(Particle.EFFECT, location, 20, 0.0, 0.0, 0.0, 0.1);
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void showEffectiveValues(CommandSender sender, LivingEntityWrapper lmEntity, boolean showOnConsole, String mobHash) {
        Object item;
        void $this$sortedBy$iv;
        Map values = new LinkedHashMap();
        List<RuleInfo> effectiveRules = lmEntity.getApplicableRules();
        StringBuilder sb = new StringBuilder();
        Map effectiveInfosAlreadyProcessed = new LinkedHashMap();
        if (effectiveRules.isEmpty()) {
            if (showOnConsole) {
                Log.INSTANCE.inf(sb + "\n" + StringsKt.replace$default(MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.no-effective-rules"), LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix() + " ", "", false, 4, null));
            } else {
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.no-effective-rules");
            }
            return;
        }
        try {
            int n = ((Collection)effectiveRules).size();
            for (int i = 0; i < n; ++i) {
                Field[] fieldArray;
                RuleInfo pi = effectiveRules.get(i);
                Intrinsics.checkNotNullExpressionValue(pi.getClass().getDeclaredFields(), "getDeclaredFields(...)");
                for (Field f : fieldArray) {
                    Object value;
                    f.trySetAccessible();
                    if (f.isAnnotationPresent(DoNotMerge.class) || f.isAnnotationPresent(DoNotShow.class) || f.get(pi) == null || ((CharSequence)value.toString()).length() == 0) continue;
                    String ruleName = f.getName();
                    Object showValue = null;
                    RuleType ruleInfoType = RuleType.MISC;
                    RuleFieldInfo ruleTypeInfo = f.getAnnotation(RuleFieldInfo.class);
                    if (ruleTypeInfo != null) {
                        ruleInfoType = ruleTypeInfo.ruleType();
                        ruleName = ruleTypeInfo.value();
                    }
                    if (value instanceof Map && ((Map)value).isEmpty() || value instanceof List && ((List)value).isEmpty()) continue;
                    String string = ruleName;
                    Intrinsics.checkNotNull(string);
                    RuleInfo.RuleSortingInfo ruleInfo = new RuleInfo.RuleSortingInfo(ruleInfoType, string);
                    if (value instanceof PlayerLevellingStrategy) {
                        showValue = this.getPlayerLevellingFormatting((PlayerLevellingStrategy)value, lmEntity);
                    } else if (value instanceof EffectiveInfo) {
                        if (effectiveInfosAlreadyProcessed.containsKey(ruleName)) {
                            pi.getRuleSourceNames().put(f.getName(), pi.getRuleName$levelledmobs_plugin());
                            continue;
                        }
                        showValue = ((EffectiveInfo)value).getEffectiveInfo(lmEntity);
                        effectiveInfosAlreadyProcessed.put(pi.getRuleName$levelledmobs_plugin(), ruleInfo);
                    }
                    if (value instanceof Enum && (Intrinsics.areEqual("NONE", ((Enum)value).toString()) || Intrinsics.areEqual("NOT_SPECIFIED", ((Enum)value).toString()))) continue;
                    if (showValue == null) {
                        showValue = "&b" + value + "&r";
                    }
                    showValue = (String)showValue + ", &1source: " + (pi.getRuleSourceNames().containsKey(f.getName()) ? pi.getRuleSourceNames().get(f.getName()) : pi.getRuleName$levelledmobs_plugin());
                    showValue = (String)showValue + "&r";
                    values.put(ruleInfo, showValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mobHash != null) {
            RuleInfo.RuleSortingInfo mobHashInfo = new RuleInfo.RuleSortingInfo(RuleType.MISC, "mob hash");
            values.put(mobHashInfo, mobHash);
        }
        if (!((Collection)lmEntity.getMobExternalTypes()).isEmpty()) {
            RuleInfo.RuleSortingInfo externalMobTypeMisc = new RuleInfo.RuleSortingInfo(RuleType.MISC, "external plugin type");
            values.put(externalMobTypeMisc, lmEntity.getMobExternalTypes().toString());
        }
        boolean hadConditions = false;
        boolean hadApplySettings = false;
        boolean hadStrategies = false;
        boolean hadMisc = false;
        Sequence<Map.Entry> sequence = SequencesKt.filter(MapsKt.asSequence(values), RulesSubcommand::showEffectiveValues$lambda$0);
        boolean $i$f$sortedBy = false;
        Iterator<Object> iterator2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry v = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((RuleInfo.RuleSortingInfo)v.getKey()).getFieldName());
                v = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((RuleInfo.RuleSortingInfo)v.getKey()).getFieldName()));
            }
        }).iterator();
        while (iterator2.hasNext()) {
            item = (Map.Entry)iterator2.next();
            if (!hadConditions) {
                hadConditions = true;
                sb.append("\n&lConditions:&r");
            }
            sb.append("\n   ").append(((RuleInfo.RuleSortingInfo)item.getKey()).getFieldName()).append(": ").append((String)item.getValue());
        }
        item = SequencesKt.filter(MapsKt.asSequence(values), RulesSubcommand::showEffectiveValues$lambda$2);
        $i$f$sortedBy = false;
        iterator2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry v = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((RuleInfo.RuleSortingInfo)v.getKey()).getFieldName());
                v = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((RuleInfo.RuleSortingInfo)v.getKey()).getFieldName()));
            }
        }).iterator();
        while (iterator2.hasNext()) {
            item = (Map.Entry)iterator2.next();
            if (!hadApplySettings) {
                hadApplySettings = true;
                sb.append("\n&lApply Settings&r:");
            }
            sb.append("\n   ").append(((RuleInfo.RuleSortingInfo)item.getKey()).getFieldName()).append(": ").append((String)item.getValue());
        }
        item = SequencesKt.filter(MapsKt.asSequence(values), RulesSubcommand::showEffectiveValues$lambda$4);
        $i$f$sortedBy = false;
        iterator2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry v = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((RuleInfo.RuleSortingInfo)v.getKey()).getFieldName());
                v = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((RuleInfo.RuleSortingInfo)v.getKey()).getFieldName()));
            }
        }).iterator();
        while (iterator2.hasNext()) {
            item = (Map.Entry)iterator2.next();
            if (!hadStrategies) {
                hadStrategies = true;
                sb.append("\n&lStrategies:&r");
            }
            sb.append("\n   ").append(((RuleInfo.RuleSortingInfo)item.getKey()).getFieldName()).append(": ").append((String)item.getValue());
        }
        iterator2 = SequencesKt.filter(MapsKt.asSequence(values), RulesSubcommand::showEffectiveValues$lambda$6).iterator();
        while (iterator2.hasNext()) {
            item = (Map.Entry)iterator2.next();
            if (!hadMisc) {
                hadMisc = true;
                sb.append("\n&lMisc:&r");
            }
            sb.append("\n   ").append(((RuleInfo.RuleSortingInfo)item.getKey()).getFieldName()).append(": ").append((String)item.getValue());
        }
        if (showOnConsole) {
            Log.INSTANCE.inf(sb.toString());
        } else {
            sender.sendMessage(MessageUtils.INSTANCE.colorizeAll(sb.toString()));
        }
    }

    private final String getPlayerLevellingFormatting(PlayerLevellingStrategy opts, LivingEntityWrapper lmEntity) {
        UUID uuid;
        Player player;
        StringBuilder sb = new StringBuilder("value: ");
        String userId = null;
        String plValue = null;
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingId())) {
            userId = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING);
        }
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingValue())) {
            plValue = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getPlayerLevellingValue(), PersistentDataType.STRING);
        }
        if (plValue != null) {
            sb.append(plValue);
        }
        boolean foundName = false;
        if (userId != null && (player = Bukkit.getPlayer((UUID)(uuid = UUID.fromString(userId)))) != null) {
            foundName = true;
            if (plValue != null) {
                sb.append(", ");
            }
            sb.append("plr: ").append(player.getName());
        }
        if (plValue != null || foundName) {
            sb.append(", ");
        }
        sb.append(opts);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final void createInstance$lambda$0(CommandSender sender, CommandArguments commandArguments) {
        Intrinsics.checkNotNull(sender);
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.rules.incomplete-command");
    }

    private static final void createInstance$lambda$1(CommandSender sender, CommandArguments args) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args);
        INSTANCE.showAllRules(sender, args);
    }

    private static final String[] createInstance$lambda$2(SuggestionInfo suggestionInfo) {
        return INSTANCE.getAllRuleNames();
    }

    private static final void createInstance$lambda$3(CommandSender sender, CommandArguments args) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args);
        INSTANCE.showRule(sender, args);
    }

    private static final void createInstance$lambda$4(CommandSender sender, CommandArguments args) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args);
        INSTANCE.showEffectiveRules(sender, args);
    }

    private static final void createInstance$lambda$5(CommandSender sender, CommandArguments commandArguments) {
        String message = MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.discord-invite");
        Intrinsics.checkNotNull(sender);
        INSTANCE.showHyperlink(sender, message, "https://discord.gg/arcaneplugins-752310043214479462");
    }

    private static final void createInstance$lambda$6(CommandSender sender, CommandArguments commandArguments) {
        String message = MessagesHelper.INSTANCE.getMessage("command.levelledmobs.rules.wiki-link");
        Intrinsics.checkNotNull(sender);
        INSTANCE.showHyperlink(sender, message, "https://arcaneplugins.gitbook.io/levelledmobs-the-ultimate-mob-levelling-solution/");
    }

    private static final void createInstance$lambda$7(CommandSender sender, CommandArguments args) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args);
        INSTANCE.resetRules(sender, args);
    }

    private static final void createInstance$lambda$8(CommandSender sender, CommandArguments commandArguments) {
        Intrinsics.checkNotNull(sender);
        INSTANCE.forceRelevel(sender);
    }

    private static final void createInstance$lambda$9(CommandSender sender, CommandArguments commandArguments) {
        Intrinsics.checkNotNull(sender);
        INSTANCE.showTempDisabled(sender);
    }

    private static final void showEffectiveRules$lambda$0(CommandSender $sender, LivingEntityWrapper $lmEntity, Ref.BooleanRef $showOnConsole, Ref.ObjectRef $mobHash) {
        INSTANCE.showEffectiveValues($sender, $lmEntity, $showOnConsole.element, (String)$mobHash.element);
        $lmEntity.free();
        if ($showOnConsole.element) {
            $sender.sendMessage("Effective rules have been printed in the console");
        }
    }

    private static final void createParticleEffect$lambda$0(Location $location, World $world) {
        INSTANCE.spawnParticles($location, $world);
    }

    private static final boolean showEffectiveValues$lambda$0(Map.Entry v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return ((RuleInfo.RuleSortingInfo)v.getKey()).getRuleType() == RuleType.CONDITION;
    }

    private static final boolean showEffectiveValues$lambda$2(Map.Entry v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return ((RuleInfo.RuleSortingInfo)v.getKey()).getRuleType() == RuleType.APPLY_SETTING;
    }

    private static final boolean showEffectiveValues$lambda$4(Map.Entry v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return ((RuleInfo.RuleSortingInfo)v.getKey()).getRuleType() == RuleType.STRATEGY;
    }

    private static final boolean showEffectiveValues$lambda$6(Map.Entry v) {
        Intrinsics.checkNotNullParameter(v, "v");
        return ((RuleInfo.RuleSortingInfo)v.getKey()).getRuleType() != RuleType.CONDITION && ((RuleInfo.RuleSortingInfo)v.getKey()).getRuleType() != RuleType.APPLY_SETTING && ((RuleInfo.RuleSortingInfo)v.getKey()).getRuleType() != RuleType.STRATEGY && ((RuleInfo.RuleSortingInfo)v.getKey()).getRuleType() != RuleType.NO_CATEGORY;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/RulesSubcommand$ResetDifficulty;", "", "<init>", "(Ljava/lang/String;I)V", "VANILLA", "BRONZE", "SILVER", "GOLD", "PLATINUM", "UNSPECIFIED", "levelledmobs-plugin"})
    public static final class ResetDifficulty
    extends Enum<ResetDifficulty> {
        public static final /* enum */ ResetDifficulty VANILLA = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty BRONZE = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty SILVER = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty GOLD = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty PLATINUM = new ResetDifficulty();
        public static final /* enum */ ResetDifficulty UNSPECIFIED = new ResetDifficulty();
        private static final /* synthetic */ ResetDifficulty[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ResetDifficulty[] values() {
            return (ResetDifficulty[])$VALUES.clone();
        }

        public static ResetDifficulty valueOf(String value) {
            return Enum.valueOf(ResetDifficulty.class, value);
        }

        @NotNull
        public static EnumEntries<ResetDifficulty> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resetDifficultyArray = new ResetDifficulty[]{ResetDifficulty.VANILLA, ResetDifficulty.BRONZE, ResetDifficulty.SILVER, ResetDifficulty.GOLD, ResetDifficulty.PLATINUM, ResetDifficulty.UNSPECIFIED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResetDifficulty.values().length];
            try {
                nArray[ResetDifficulty.VANILLA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.BRONZE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.GOLD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.PLATINUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.SILVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDifficulty.UNSPECIFIED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

