/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SummonMobOptions;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.AbstractCommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.SuggestionInfo;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.Argument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ArgumentSuggestions;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.IntegerArgument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ListArgumentBuilder;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.StringArgument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.CommandArguments;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.ExecutorType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin._Assertions;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.SetsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntries;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntriesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.LivingEntityPlaceholder;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.RequestedLevel;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.result.MinAndMaxHolder;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u001f\u001a\u0004\u0018\u00010\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190\r2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u001bH\u0002J2\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u0016H\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006/"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand;", "", "<init>", "()V", "createInstance", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/CommandAPICommand;", "processCmd", "", "sender", "Lorg/bukkit/command/CommandSender;", "args", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/executors/CommandArguments;", "buildTabSuggestions", "", "", "info", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/SuggestionInfo;", "summonMobs", "options", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonMobOptions;", "spawnMobs", "location", "Lorg/bukkit/Location;", "getSpawnLocation", "getBlockCandidates", "Lorg/bukkit/block/Block;", "minDistFromPlayer", "", "maxDistFromPlayer", "target", "Lorg/bukkit/entity/Player;", "checkBlockCandidates", "blockCandidates", "blocksNeeded", "world", "Lorg/bukkit/World;", "getLocationNearPlayer", "player", "useDistFromPlayer", "getRelativeLocation", "xStr", "yStr", "zStr", "addVarianceToLocation", "oldLocation", "getEntityNames", "SummonType", "levelledmobs-plugin"})
public final class SummonSubcommand {
    @NotNull
    public static final SummonSubcommand INSTANCE = new SummonSubcommand();

    private SummonSubcommand() {
    }

    @NotNull
    public final CommandAPICommand createInstance() {
        Argument[] argumentArray = new Argument[]{new IntegerArgument("number").replaceSuggestions(ArgumentSuggestions.strings((Collection<String>)Utils.INSTANCE.getOneToNine()))};
        CommandAPICommand commandAPICommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("summon").withPermission("levelledmobs.command.summon")).withShortDescription("Various commands for summoning mobs.")).withFullDescription("Various commands for summoning mobs.")).executes(SummonSubcommand::createInstance$lambda$0, new ExecutorType[0])).withOptionalArguments(argumentArray);
        argumentArray = new Argument[]{new StringArgument("mobtype").replaceSuggestions(ArgumentSuggestions.strings((Collection<String>)this.getEntityNames()))};
        CommandAPICommand commandAPICommand2 = (CommandAPICommand)commandAPICommand.withOptionalArguments(argumentArray);
        argumentArray = new Argument[]{new IntegerArgument("moblevel").replaceSuggestions(ArgumentSuggestions.strings((Collection<String>)Utils.INSTANCE.getOneToNine()))};
        CommandAPICommand commandAPICommand3 = (CommandAPICommand)commandAPICommand2.withOptionalArguments(argumentArray);
        argumentArray = new Argument[1];
        String[] stringArray = new String[]{"here", "at-player", "at-location"};
        argumentArray[0] = new StringArgument("designator").replaceSuggestions(ArgumentSuggestions.strings(stringArray));
        CommandAPICommand commandAPICommand4 = (CommandAPICommand)commandAPICommand3.withOptionalArguments(argumentArray);
        argumentArray = new Argument[]{new ListArgumentBuilder("values").allowAnyValue(true).allowDuplicates(true).withList(SummonSubcommand::createInstance$lambda$1).withStringMapper().buildGreedy()};
        AbstractCommandAPICommand abstractCommandAPICommand = commandAPICommand4.withOptionalArguments(argumentArray);
        Intrinsics.checkNotNullExpressionValue(abstractCommandAPICommand, "withOptionalArguments(...)");
        return (CommandAPICommand)abstractCommandAPICommand;
    }

    private final void processCmd(CommandSender sender, CommandArguments args) {
        Object object = args.get("number");
        Integer amount = object instanceof Integer ? (Integer)object : null;
        Object object2 = args.get("moblevel");
        Integer mobLevel = object2 instanceof Integer ? (Integer)object2 : null;
        Object object3 = args.get("mobtype");
        String mobType = object3 instanceof String ? (String)object3 : null;
        Object object4 = args.get("designator");
        String string = object4 instanceof String ? (String)object4 : null;
        if (string == null) {
            string = "here";
        }
        String designator = string;
        String values = args.rawArgsMap().get("values");
        if (amount == null || mobLevel == null || mobType == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.usage");
            return;
        }
        EntityType entityType = null;
        try {
            String string2 = mobType;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            entityType = EntityType.valueOf((String)string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.invalid-entity-type", "%entityType%", mobType);
            return;
        }
        RequestedLevel requestedLevel = new RequestedLevel();
        requestedLevel.setLevel(mobLevel);
        CommandSender commandSender = sender;
        Location location = commandSender instanceof Player ? ((Player)sender).getLocation() : (commandSender instanceof BlockCommandSender ? ((BlockCommandSender)sender).getBlock().getLocation() : null);
        String nbtData = null;
        String string4 = values;
        List miscArgs = string4 != null ? Utils.INSTANCE.splitStringWithQuotes(string4) : (List)new ArrayList();
        int n = miscArgs.size();
        for (int i = 0; i < n; ++i) {
            String arg = (String)miscArgs.get(i);
            if (!StringsKt.startsWith$default(arg, "{", false, 2, null) || !StringsKt.endsWith$default(arg, "}", false, 2, null)) continue;
            nbtData = arg;
        }
        String string5 = designator.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
        switch (string5) {
            case "here": {
                if (location == null) {
                    MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.here.usage");
                    return;
                }
                LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location);
                SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                options.setAmount(amount);
                options.setRequestedLevel(requestedLevel);
                options.setSummonType(SummonType.HERE);
                options.setOverride(true);
                options.setNbtData(nbtData);
                this.summonMobs(options);
                lmPlaceHolder.free();
                break;
            }
            case "at-location": {
                String xStr = "";
                String yStr = "";
                String zStr = "";
                World world = null;
                int n2 = miscArgs.size();
                block19: for (int i = 0; i < n2; ++i) {
                    String arg = (String)miscArgs.get(i);
                    if (StringsKt.startsWith$default(arg, "{", false, 2, null)) continue;
                    switch (i) {
                        case 0: {
                            xStr = arg;
                            continue block19;
                        }
                        case 1: {
                            yStr = arg;
                            continue block19;
                        }
                        case 2: {
                            zStr = arg;
                            continue block19;
                        }
                        case 3: {
                            world = Bukkit.getWorld((String)arg);
                            if (world != null) continue block19;
                            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atLocation.invalid-world", "%world%", arg);
                            return;
                        }
                    }
                }
                if (world == null) {
                    MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atLocation.usage-console");
                    return;
                }
                location = this.getRelativeLocation(sender, xStr, yStr, zStr, world);
                if (location == null) {
                    sender.sendMessage("Invalid location");
                    return;
                }
                LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location);
                SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                options.setAmount(amount);
                options.setRequestedLevel(requestedLevel);
                options.setSummonType(SummonType.AT_LOCATION);
                options.setOverride(true);
                options.setNbtData(nbtData);
                this.summonMobs(options);
                lmPlaceHolder.free();
                break;
            }
            case "at-player": {
                boolean didSummon = false;
                int n3 = miscArgs.size();
                for (int i = 0; i < n3; ++i) {
                    String arg = (String)miscArgs.get(i);
                    if (StringsKt.startsWith$default(arg, "{", false, 2, null)) continue;
                    boolean offline = false;
                    World world = null;
                    Player target = Bukkit.getPlayer((String)arg);
                    if (target == null) {
                        offline = true;
                    } else if (sender instanceof Player) {
                        if (!((Player)sender).canSee(target) && !((Player)sender).isOp()) {
                            offline = true;
                        }
                        location = target.getLocation();
                        world = location.getWorld();
                    } else {
                        location = target.getLocation();
                        world = target.getWorld();
                    }
                    if (offline || world == null) {
                        MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", arg);
                        return;
                    }
                    Location location2 = location;
                    Intrinsics.checkNotNull(location2);
                    LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location2);
                    SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                    options.setAmount(amount);
                    options.setRequestedLevel(requestedLevel);
                    options.setSummonType(SummonType.AT_PLAYER);
                    options.setPlayer(target);
                    options.setOverride(true);
                    options.setNbtData(nbtData);
                    this.summonMobs(options);
                    lmPlaceHolder.free();
                    didSummon = true;
                    break;
                }
                if (didSummon) break;
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atPlayer.usage");
                break;
            }
            default: {
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.usage");
            }
        }
    }

    private final List<String> buildTabSuggestions(SuggestionInfo<CommandSender> info) {
        String string = info.currentInput();
        Intrinsics.checkNotNullExpressionValue(string, "currentInput(...)");
        List<String> args = Utils.INSTANCE.splitStringWithQuotes(string);
        String string2 = args.get(5).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        switch (string2) {
            case "here": {
                return new ArrayList();
            }
            case "at-player": {
                List suggestions = new ArrayList();
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (info.sender() instanceof Player) {
                        CommandSender commandSender = info.sender();
                        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
                        Player player = (Player)commandSender;
                        if (!player.canSee(onlinePlayer) && !player.isOp()) continue;
                        String string3 = onlinePlayer.getName();
                        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                        suggestions.add(string3);
                        continue;
                    }
                    String string4 = onlinePlayer.getName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                    suggestions.add(string4);
                }
                return suggestions;
            }
            case "at-location": {
                int suggestions = args.size();
                boolean bl = 6 <= suggestions ? suggestions < 9 : false;
                if (bl) {
                    return Utils.INSTANCE.getOneToNine();
                }
                if (args.size() != 9) break;
                List worlds = new ArrayList();
                for (World world : Bukkit.getWorlds()) {
                    String string5 = world.getName();
                    Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                    worlds.add(string5);
                }
                return worlds;
            }
            default: {
                return new ArrayList();
            }
        }
        return new ArrayList();
    }

    private final void summonMobs(SummonMobOptions options) {
        List<String> messages;
        CommandSender sender = options.getSender();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Player target = options.getPlayer();
        Ref.ObjectRef location = new Ref.ObjectRef();
        location.element = options.getLmPlaceholder().getLocation();
        if (CollectionsKt.contains((Iterable)main.getLevelManager().getForcedBlockedEntityTypes(), options.getLmPlaceholder().getEntityType())) {
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.not-levellable");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages2 = list;
            messages2 = Utils.INSTANCE.replaceAllInList(messages2, "%prefix%", main.getConfigUtils().getPrefix());
            messages2 = Utils.INSTANCE.replaceAllInList(messages2, "%entity%", options.getLmPlaceholder().getTypeName());
            messages2 = Utils.INSTANCE.colorizeAllInList(messages2);
            messages2.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$0(sender, arg_0));
            return;
        }
        if (!sender.isOp() && !options.getOverride() && main.getLevelInterface().getLevellableState(options.getLmPlaceholder()) != LevellableState.ALLOWED) {
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.not-levellable");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages3 = list;
            messages3 = Utils.INSTANCE.replaceAllInList(messages3, "%prefix%", main.getConfigUtils().getPrefix());
            messages3 = Utils.INSTANCE.replaceAllInList(messages3, "%entity%", options.getLmPlaceholder().getTypeName());
            messages3 = Utils.INSTANCE.colorizeAllInList(messages3);
            messages3.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$1(sender, arg_0));
            return;
        }
        if (options.getAmount() < 1) {
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.amount-limited.min");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages4 = list;
            messages4 = Utils.INSTANCE.replaceAllInList(messages4, "%prefix%", main.getConfigUtils().getPrefix());
            messages4 = Utils.INSTANCE.colorizeAllInList(messages4);
            messages4.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$2(sender, arg_0));
        }
        int maxAmount = main.getHelperSettings().getInt("customize-summon-command-limit", 100);
        if (options.getAmount() > maxAmount) {
            options.setAmount(maxAmount);
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.amount-limited.max");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages5 = list;
            messages5 = Utils.INSTANCE.replaceAllInList(messages5, "%prefix%", main.getConfigUtils().getPrefix());
            messages5 = Utils.INSTANCE.replaceAllInList(messages5, "%maxAmount%", String.valueOf(maxAmount));
            messages5 = Utils.INSTANCE.colorizeAllInList(messages5);
            messages5.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$3(sender, arg_0));
        }
        MinAndMaxHolder levels = main.getLevelManager().getMinAndMaxLevels(options.getLmPlaceholder());
        RequestedLevel requestedLevel = options.getRequestedLevel();
        Intrinsics.checkNotNull(requestedLevel);
        if ((float)requestedLevel.getLevelMin() < levels.getMin() && !sender.hasPermission("levelledmobs.command.summon.bypass-level-limit") && !options.getOverride()) {
            RequestedLevel requestedLevel2 = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel2);
            requestedLevel2.setMinAllowedLevel(levels.getMinAsInt());
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.level-limited.min");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            messages = list;
            messages = Utils.INSTANCE.replaceAllInList(messages, "%prefix%", main.getConfigUtils().getPrefix());
            messages = Utils.INSTANCE.replaceAllInList(messages, "%minLevel%", String.valueOf(levels.getMin()));
            messages = Utils.INSTANCE.colorizeAllInList(messages);
            messages.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$4(sender, arg_0));
        }
        RequestedLevel requestedLevel3 = options.getRequestedLevel();
        Intrinsics.checkNotNull(requestedLevel3);
        if ((float)requestedLevel3.getLevelMax() > levels.getMax() && !sender.hasPermission("levelledmobs.command.summon.bypass-level-limit") && !options.getOverride()) {
            RequestedLevel requestedLevel4 = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel4);
            requestedLevel4.setMaxAllowedLevel(levels.getMaxAsInt());
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.level-limited.max");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            messages = list;
            messages = Utils.INSTANCE.replaceAllInList(messages, "%prefix%", main.getConfigUtils().getPrefix());
            messages = Utils.INSTANCE.replaceAllInList(messages, "%maxLevel%", String.valueOf(levels.getMax()));
            messages = Utils.INSTANCE.colorizeAllInList(messages);
            messages.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$5(sender, arg_0));
        }
        if (options.getSummonType() == SummonType.HERE) {
            location.element = this.addVarianceToLocation((Location)location.element);
        }
        if (options.getSummonType() == SummonType.HERE || options.getSummonType() == SummonType.AT_PLAYER) {
            int distFromPlayer = main.getHelperSettings().getInt("summon-command-spawn-distance-from-player", 5);
            if (distFromPlayer > 0 && target != null) {
                Location locationTemp = this.getSpawnLocation((Location)location.element, options);
                if (locationTemp == null) {
                    sender.sendMessage("Unable to find a suitable spawn location");
                    return;
                }
                location.element = locationTemp;
            } else if (target == null && sender instanceof BlockCommandSender) {
                location.element = new Location(((Location)location.element).getWorld(), (double)((Location)location.element).getBlockX(), (double)(((Location)location.element).getBlockY() + 2), (double)((Location)location.element).getBlockZ());
            }
        }
        CompletableFuture future = new CompletableFuture();
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)options.getPlayer(), () -> SummonSubcommand.summonMobs$lambda$6(sender, options, location, future));
        wrapper.setRunDirectlyInBukkit(true);
        wrapper.setRunDirectlyInFolia(sender instanceof Player);
        wrapper.setLocationForRegionScheduler((Location)location.element);
        wrapper.run();
        future.get(100L, TimeUnit.MILLISECONDS);
        boolean printResults = main.getHelperSettings().getBoolean("print-lm-summon-results", true);
        SummonType summonType = options.getSummonType();
        switch (summonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[summonType.ordinal()]) {
            case 1: {
                if (!printResults) break;
                String[] stringArray = new String[]{"%amount%", "%level%", "%entity%"};
                String[] stringArray2 = stringArray;
                stringArray = new String[]{String.valueOf(options.getAmount()), String.valueOf(options.getRequestedLevel()), options.getLmPlaceholder().getTypeName()};
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.here.success", stringArray2, stringArray);
                break;
            }
            case 2: {
                String string;
                if (!printResults) break;
                String[] stringArray = new String[]{"%amount%", "%level%", "%entity%", "%x%", "%y%", "%z%", "%world%"};
                String[] stringArray3 = stringArray;
                stringArray = new String[7];
                stringArray[0] = String.valueOf(options.getAmount());
                stringArray[1] = String.valueOf(options.getRequestedLevel());
                stringArray[2] = options.getLmPlaceholder().getTypeName();
                stringArray[3] = String.valueOf(((Location)location.element).getBlockX());
                stringArray[4] = String.valueOf(((Location)location.element).getBlockY());
                stringArray[5] = String.valueOf(((Location)location.element).getBlockZ());
                if (((Location)location.element).getWorld() == null) {
                    string = "(null)";
                } else {
                    String string2 = ((Location)location.element).getWorld().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                }
                stringArray[6] = string;
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atLocation.success", stringArray3, stringArray);
                break;
            }
            case 3: {
                if (!printResults) break;
                String playerName = main.getVer().isRunningPaper() ? PaperUtils.INSTANCE.getPlayerDisplayName(target) : SpigotUtils.INSTANCE.getPlayerDisplayName(target);
                String[] stringArray = new String[]{"%amount%", "%level%", "%entity%", "%targetUsername%", "%targetDisplayname%"};
                String[] stringArray4 = stringArray;
                stringArray = new String[5];
                stringArray[0] = String.valueOf(options.getAmount());
                stringArray[1] = String.valueOf(options.getRequestedLevel());
                stringArray[2] = options.getLmPlaceholder().getTypeName();
                Object object = target;
                if (object == null || (object = object.getName()) == null) {
                    object = "(null)";
                }
                stringArray[3] = object;
                stringArray[4] = target == null ? "(null)" : playerName;
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atPlayer.success", stringArray4, stringArray);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected SummonType value of " + options.getSummonType() + "!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void spawnMobs(CommandSender sender, SummonMobOptions options, Location location) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        int n = options.getAmount();
        for (int i = 0; i < n; ++i) {
            Entity entity;
            int n2;
            boolean bl;
            int it = i;
            boolean bl2 = false;
            boolean bl3 = bl = location.getWorld() != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            RequestedLevel requestedLevel = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel);
            if (requestedLevel.getHasLevelRange()) {
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                RequestedLevel requestedLevel2 = options.getRequestedLevel();
                Intrinsics.checkNotNull(requestedLevel2);
                int n3 = requestedLevel2.getLevelRangeMin();
                RequestedLevel requestedLevel3 = options.getRequestedLevel();
                Intrinsics.checkNotNull(requestedLevel3);
                n2 = threadLocalRandom.nextInt(n3, requestedLevel3.getLevelRangeMax() + 1);
            } else {
                RequestedLevel requestedLevel4 = options.getRequestedLevel();
                Intrinsics.checkNotNull(requestedLevel4);
                n2 = requestedLevel4.getLevel();
            }
            int useLevel = n2;
            World world = location.getWorld();
            EntityType entityType = options.getLmPlaceholder().getEntityType();
            Intrinsics.checkNotNull(entityType);
            Intrinsics.checkNotNullExpressionValue(world.spawnEntity(location, entityType), "spawnEntity(...)");
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
            lmEntity.setSummonedLevel(useLevel);
            lmEntity.setNewlySpawned(true);
            Object object = LevelManager.Companion.getSummonedOrSpawnEggs_Lock();
            synchronized (object) {
                boolean $i$a$-synchronized-SummonSubcommand$spawnMobs$1$32 = false;
                Object $i$a$-synchronized-SummonSubcommand$spawnMobs$1$32 = main.getLevelManager().getSummonedOrSpawnEggs().put(lmEntity.getLivingEntity(), null);
            }
            Object[] objectArray = (String[])options.getNbtData();
            if (!(objectArray == null || objectArray.length() == 0)) {
                objectArray = new String[1];
                Intrinsics.checkNotNull(options.getNbtData());
                lmEntity.setNbtData(CollectionsKt.mutableListOf(objectArray));
            }
            lmEntity.setSummonedSender(sender);
            PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            object = persistentDataContainer;
            synchronized (object) {
                boolean bl4 = false;
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getWasSummoned(), PersistentDataType.INTEGER, (Object)1);
                Unit unit = Unit.INSTANCE;
            }
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            objectArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.NOT_APPLICABLE};
            main.getLevelInterface().applyLevelToMob(lmEntity, useLevel, true, options.getOverride(), SetsKt.mutableSetOf(objectArray));
            lmEntity.free();
        }
    }

    private final Location getSpawnLocation(Location location, SummonMobOptions options) {
        if (location.getWorld() == null) {
            return null;
        }
        EntityType entityType = options.getLmPlaceholder().getEntityType();
        Intrinsics.checkNotNull(entityType);
        EntityType entityType2 = entityType;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Ref.ObjectRef maxDistFromPlayer = new Ref.ObjectRef();
        maxDistFromPlayer.element = main.getHelperSettings().getInt2("summon-command-spawn-max-distance-from-player", null);
        if (maxDistFromPlayer.element == null) {
            maxDistFromPlayer.element = main.getHelperSettings().getInt2("summon-command-spawn-distance-from-player", null);
        }
        if (maxDistFromPlayer.element == null) {
            maxDistFromPlayer.element = 5;
        }
        int minDistFromPlayer = (int)Math.min((double)main.getHelperSettings().getInt("summon-command-spawn-min-distance-from-player", 3), (double)((Number)maxDistFromPlayer.element).intValue());
        int blocksNeeded = entityType2 == EntityType.ENDERMAN || entityType2 == EntityType.RAVAGER ? 3 : 2;
        CompletableFuture completableFuture = new CompletableFuture();
        Player player = options.getPlayer();
        Intrinsics.checkNotNull(player);
        Player target = player;
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)target, () -> SummonSubcommand.getSpawnLocation$lambda$0(minDistFromPlayer, maxDistFromPlayer, target, location, completableFuture));
        wrapper.setRunDirectlyInBukkit(true);
        if (options.getSender() instanceof Player) {
            wrapper.setRunDirectlyInFolia(true);
        }
        wrapper.run();
        List blockCandidates = (List)completableFuture.get(100L, TimeUnit.MILLISECONDS);
        if (blockCandidates.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNull(blockCandidates);
        Collections.shuffle(blockCandidates);
        CompletableFuture futureCandidate = new CompletableFuture();
        wrapper = new SchedulerWrapper((Entity)target, () -> SummonSubcommand.getSpawnLocation$lambda$1(blockCandidates, blocksNeeded, location, futureCandidate));
        wrapper.setRunDirectlyInBukkit(true);
        if (options.getSender() instanceof Player) {
            wrapper.setRunDirectlyInFolia(true);
        }
        wrapper.run();
        Location foundLocation = (Location)futureCandidate.get(500L, TimeUnit.MILLISECONDS);
        return foundLocation;
    }

    private final List<Block> getBlockCandidates(int minDistFromPlayer, int maxDistFromPlayer, Player target, Location location) {
        List blockCandidates = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            Block block;
            Location tempLocation;
            int y;
            int useDistance = minDistFromPlayer != maxDistFromPlayer ? ThreadLocalRandom.current().nextInt(minDistFromPlayer, maxDistFromPlayer) : maxDistFromPlayer;
            Location startingLocation = this.getLocationNearPlayer(target, location, useDistance);
            Intrinsics.checkNotNullExpressionValue(startingLocation.clone(), "clone(...)");
            boolean foundBlock = false;
            int maxYVariance = (int)Math.max((double)(maxDistFromPlayer - useDistance), 10.0);
            for (y = 0; y < maxYVariance; ++y) {
                Intrinsics.checkNotNullExpressionValue(tempLocation.add(0.0, Math.min((double)y, 1.0), 0.0).getBlock(), "getBlock(...)");
                if (!block.getType().isSolid()) continue;
                blockCandidates.add(block);
                foundBlock = true;
                break;
            }
            if (!foundBlock) {
                Location location2 = startingLocation.clone();
                Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
                tempLocation = location2;
                y = 1;
                if (y <= maxYVariance) {
                    while (true) {
                        Intrinsics.checkNotNullExpressionValue(tempLocation.add(0.0, -1.0, 0.0).getBlock(), "getBlock(...)");
                        if (block.getType().isSolid()) {
                            blockCandidates.add(block);
                            break;
                        }
                        if (y == maxYVariance) break;
                        ++y;
                    }
                }
            }
            if (blockCandidates.size() >= 10) break;
        }
        return blockCandidates;
    }

    private final Location checkBlockCandidates(List<Block> blockCandidates, int blocksNeeded, World world) {
        for (Block block : blockCandidates) {
            boolean notGoodSpot = false;
            int n = blocksNeeded + 1;
            for (int i = 1; i < n; ++i) {
                Block temp;
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(block.getX(), block.getY() + i, block.getZ()), "getBlockAt(...)");
                if (temp.isPassable()) continue;
                notGoodSpot = true;
                break;
            }
            if (notGoodSpot) continue;
            return block.getLocation().add(0.5, (double)(blocksNeeded - 1), 0.5);
        }
        return null;
    }

    private final Location getLocationNearPlayer(Player player, Location location, int useDistFromPlayer) {
        int newX = location.getBlockX();
        int newZ = location.getBlockZ();
        double rotation = (player.getLocation().getYaw() - (float)180) % (float)360;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        double d = rotation;
        if (RangesKt.rangeUntil(0.0, 22.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newZ -= useDistFromPlayer;
        } else if (RangesKt.rangeUntil(22.5, 67.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX += useDistFromPlayer;
            newZ -= useDistFromPlayer;
        } else if (RangesKt.rangeUntil(67.5, 112.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(112.5, 157.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX += useDistFromPlayer;
            newZ += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(157.5, 202.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newZ += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(202.5, 247.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX -= useDistFromPlayer;
            newZ += useDistFromPlayer;
        } else if (RangesKt.rangeUntil(247.5, 292.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX -= useDistFromPlayer;
        } else if (RangesKt.rangeUntil(292.5, 337.5).contains((Double)((Comparable)Double.valueOf(d)))) {
            newX -= useDistFromPlayer;
            newZ -= useDistFromPlayer;
        } else {
            newZ -= useDistFromPlayer;
        }
        return new Location(location.getWorld(), (double)newX, (double)location.getBlockY(), (double)newZ);
    }

    private final Location getRelativeLocation(CommandSender sender, String xStr, String yStr, String zStr, World world) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        boolean xRelative = false;
        boolean yRelative = false;
        boolean zRelative = false;
        if (sender instanceof Player || sender instanceof BlockCommandSender) {
            double addition;
            if (xStr.charAt(0) == '~') {
                double d = x = sender instanceof Player ? ((Player)sender).getLocation().getX() : (double)((BlockCommandSender)sender).getBlock().getX();
                if (xStr.length() > 1) {
                    addition = 0.0;
                    try {
                        String string = xStr.substring(1);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        addition = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    x += addition;
                }
                xRelative = true;
            }
            if (yStr.charAt(0) == '~') {
                double d = y = sender instanceof Player ? ((Player)sender).getLocation().getY() : (double)((BlockCommandSender)sender).getBlock().getY();
                if (yStr.length() > 1) {
                    addition = 0.0;
                    try {
                        String string = yStr.substring(1);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        addition = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    y += addition;
                }
                yRelative = true;
            }
            if (zStr.charAt(0) == '~') {
                double d = z = sender instanceof Player ? ((Player)sender).getLocation().getZ() : (double)((BlockCommandSender)sender).getBlock().getZ();
                if (zStr.length() > 1) {
                    addition = 0.0;
                    try {
                        String string = zStr.substring(1);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        addition = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                    z += addition;
                }
                zRelative = true;
            }
        }
        if (!xRelative) {
            try {
                x = Double.parseDouble(xStr);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (!yRelative) {
            try {
                y = Double.parseDouble(yStr);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (!zRelative) {
            try {
                z = Double.parseDouble(zStr);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return new Location(world, x, y, z);
    }

    private final Location addVarianceToLocation(Location oldLocation) {
        double min = 0.5;
        double max = 2.5;
        Random random1 = new Random();
        Random random2 = new Random();
        int n = 20;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            double x = oldLocation.getX() + min + (max - min) * random1.nextDouble();
            double z = oldLocation.getZ() + min + (max - min) * random2.nextDouble();
            Location newLocation = new Location(oldLocation.getWorld(), x, oldLocation.getY(), z);
            if (!newLocation.getBlock().isPassable() || !newLocation.add(0.0, 1.0, 0.0).getBlock().isPassable()) continue;
            return newLocation;
        }
        return oldLocation;
    }

    private final List<String> getEntityNames() {
        List entityNames = new ArrayList();
        for (EntityType entityType : EntriesMappings.entries$0) {
            String string = entityType.toString();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            entityNames.add(string2);
        }
        return entityNames;
    }

    private static final void createInstance$lambda$0(CommandSender sender, CommandArguments args) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args);
        INSTANCE.processCmd(sender, args);
    }

    private static final Collection createInstance$lambda$1(SuggestionInfo info) {
        Intrinsics.checkNotNull(info);
        return INSTANCE.buildTabSuggestions(info);
    }

    private static final void summonMobs$lambda$0(CommandSender $sender, String s) {
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$1(CommandSender $sender, String s) {
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$2(CommandSender $sender, String s) {
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$3(CommandSender $sender, String s) {
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$4(CommandSender $sender, String s) {
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$5(CommandSender $sender, String s) {
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$6(CommandSender $sender, SummonMobOptions $options, Ref.ObjectRef $location, CompletableFuture $future) {
        INSTANCE.spawnMobs($sender, $options, (Location)$location.element);
        $future.complete(true);
    }

    private static final void getSpawnLocation$lambda$0(int $minDistFromPlayer, Ref.ObjectRef $maxDistFromPlayer, Player $target, Location $location, CompletableFuture $completableFuture) {
        List<Block> blockCandidates = INSTANCE.getBlockCandidates($minDistFromPlayer, ((Number)$maxDistFromPlayer.element).intValue(), $target, $location);
        $completableFuture.complete(blockCandidates);
    }

    private static final void getSpawnLocation$lambda$1(List $blockCandidates, int $blocksNeeded, Location $location, CompletableFuture $futureCandidate) {
        Intrinsics.checkNotNull($blockCandidates);
        World world = $location.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        Location foundLocation = INSTANCE.checkBlockCandidates($blockCandidates, $blocksNeeded, world);
        $futureCandidate.complete(foundLocation);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EntityType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EntityType.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand$SummonType;", "", "<init>", "(Ljava/lang/String;I)V", "HERE", "AT_PLAYER", "AT_LOCATION", "levelledmobs-plugin"})
    public static final class SummonType
    extends Enum<SummonType> {
        public static final /* enum */ SummonType HERE = new SummonType();
        public static final /* enum */ SummonType AT_PLAYER = new SummonType();
        public static final /* enum */ SummonType AT_LOCATION = new SummonType();
        private static final /* synthetic */ SummonType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SummonType[] values() {
            return (SummonType[])$VALUES.clone();
        }

        public static SummonType valueOf(String value) {
            return Enum.valueOf(SummonType.class, value);
        }

        @NotNull
        public static EnumEntries<SummonType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = summonTypeArray = new SummonType[]{SummonType.HERE, SummonType.AT_PLAYER, SummonType.AT_LOCATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SummonType.values().length];
            try {
                nArray[SummonType.HERE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SummonType.AT_LOCATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SummonType.AT_PLAYER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

