/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.customdrops;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropProcessingInfo;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropsHandler;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.TypeIntrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.managers.NotifyManager;
import io.github.arcaneplugins.levelledmobs.result.EvaluationResult;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.stumper66.lm_items.ExternalItemRequest;
import io.github.stumper66.lm_items.LM_Items;
import java.lang.invoke.LambdaMetafactory;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J&\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/LMItemsParser;", "", "<init>", "()V", "pendingItems", "", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropItem;", "", "processPendingItems", "", "parseExternalItemAttributes", "", "materialName", "item", "getExternalItem", "info", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropProcessingInfo;", "evaluateFormula", "name", "value", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "levelledmobs-plugin"})
public final class LMItemsParser {
    @NotNull
    private final Map<CustomDropItem, String> pendingItems = new LinkedHashMap();

    public final void processPendingItems() {
        for (Map.Entry<CustomDropItem, String> item : this.pendingItems.entrySet()) {
            this.parseExternalItemAttributes(item.getValue(), item.getKey());
        }
        this.pendingItems.clear();
    }

    public final boolean parseExternalItemAttributes(@NotNull String materialName, @NotNull CustomDropItem item) {
        Intrinsics.checkNotNullParameter(materialName, "materialName");
        Intrinsics.checkNotNullParameter(item, "item");
        if (!ExternalCompatibilityManager.Companion.getInstance().doesLMIMeetVersionRequirement()) {
            if (ExternalCompatibilityManager.Companion.getHasLMItemsInstalled()) {
                Log.INSTANCE.war("customdrops.yml references external item '" + materialName + "' but LM_Items is an old version");
            } else {
                Log.INSTANCE.war("customdrops.yml references external item '" + materialName + "' but LM_Items is not installed");
            }
            return false;
        }
        if (!MainCompanion.Companion.getInstance().getHasFinishedLoading()) {
            this.pendingItems.put(item, materialName);
            item.setItemStack(new ItemStack(Material.STICK));
            return true;
        }
        int colon = StringsKt.indexOf$default((CharSequence)materialName, ":", 0, false, 6, null);
        item.setExternalPluginName(StringsKt.take(materialName, colon));
        String string = materialName.substring(colon + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        item.setExternalItemId(string);
        LM_Items lmitems = LM_Items.plugin;
        String string2 = item.getExternalPluginName();
        Intrinsics.checkNotNull(string2);
        if (!lmitems.doesSupportPlugin(string2)) {
            Log.INSTANCE.war("customdrops.yml references item from plugin '" + item.getExternalPluginName() + "' but LM_Items does not support that plugin");
            return false;
        }
        item.setExternalItem(true);
        return this.getExternalItem(item, null);
    }

    /*
     * Unable to fully structure code
     */
    public final boolean getExternalItem(@NotNull CustomDropItem item, @Nullable CustomDropProcessingInfo info) {
        block23: {
            block22: {
                block21: {
                    Intrinsics.checkNotNullParameter(item, "item");
                    v0 = item.getExternalPluginName();
                    Intrinsics.checkNotNull(v0);
                    itemsAPI = LM_Items.plugin.getItemAPIForPlugin(v0);
                    if (itemsAPI == null) {
                        Log.INSTANCE.war("Unable to get ItemsAPI from LM_Items for plugin " + item.getExternalPluginName());
                        return false;
                    }
                    main = LevelledMobs.Companion.getInstance();
                    v1 = item.getExternalItemId();
                    Intrinsics.checkNotNull(v1);
                    itemRequest = new ExternalItemRequest(v1);
                    itemRequest.itemType = item.getExternalType();
                    itemRequest.amount = item.getExternalAmount();
                    if (info != null && !((var6_6 = (CharSequence)item.getAmountFormula()) == null || var6_6.length() == 0)) {
                        v2 = item.getAmountFormula();
                        v3 = info.getLmEntity();
                        Intrinsics.checkNotNull(v3);
                        itemRequest.amount = CustomDropsHandler.Companion.evaluateNumberFormula(v2, "amount-formula", v3).getResult();
                    }
                    if (main.getMainCompanion().getExternalCompatibilityManager().doesLMIMeetVersionRequirement2()) {
                        itemRequest.getMultipleItems = Intrinsics.areEqual("-", itemRequest.itemId);
                        itemRequest.minItems = item.getMinItems();
                        itemRequest.maxItems = item.getMaxItems();
                        itemRequest.allowedList = item.getAllowedList();
                        itemRequest.excludedList = item.getExcludedList();
                        itemRequest.isDebugEnabled = main.getDebugManager().isEnabled();
                    }
                    if (item.getExternalExtras() != null) {
                        v4 = item.getExternalExtras();
                        Intrinsics.checkNotNull(v4);
                        itemRequest.extras = new Hashtable<K, V>(v4.size());
                        v5 = item.getExternalExtras();
                        Intrinsics.checkNotNull(v5);
                        var6_6 = v5.keySet().iterator();
                        while (var6_6.hasNext()) {
                            useKey = key = (String)var6_6.next();
                            v6 = item.getExternalExtras();
                            Intrinsics.checkNotNull(v6);
                            value = v6.get(useKey);
                            if (StringsKt.endsWith(useKey, "-formula", true)) {
                                v7 = info;
                                value = this.evaluateFormula(useKey, value, v7 != null ? v7.getLmEntity() : null);
                                useKey = StringsKt.dropLast(useKey, 8);
                            } else if (value instanceof String && StringsKt.contains$default((CharSequence)value, "%", false, 2, null)) {
                                if (info != null) {
                                    v8 = main.getLevelManager();
                                    v9 = (String)value;
                                    v10 = info.getLmEntity();
                                    Intrinsics.checkNotNull(v10);
                                    value = v8.replaceStringPlaceholders(v9, v10, true, info.getMobKiller(), false);
                                } else if (ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
                                    value = ExternalCompatibilityManager.Companion.getPapiPlaceholder(null, (String)value, null);
                                }
                            }
                            v11 = itemRequest.extras;
                            Intrinsics.checkNotNull(v11, "null cannot be cast to non-null type java.util.Hashtable<kotlin.String, kotlin.Any>");
                            ((Map)((Hashtable)v11)).put(useKey, value);
                        }
                    }
                    v12 = itemsAPI.getItem(itemRequest);
                    Intrinsics.checkNotNullExpressionValue(v12, "getItem(...)");
                    result = v12;
                    if (!result.pluginIsInstalled) {
                        Log.INSTANCE.war("custom item references plugin '" + item.getExternalPluginName() + "' but that plugin is not installed");
                        return false;
                    }
                    itemStack = result.itemStack;
                    if (itemStack != null) break block21;
                    if (result.typeIsNotSupported) {
                        if (item.getExternalType() == null) {
                            Log.INSTANCE.war("custom item '" + item.getExternalPluginName() + ":" + item.getExternalItemId() + "' doesn't support type (null)");
                        } else {
                            Log.INSTANCE.war("custom item '" + item.getExternalPluginName() + ":" + item.getExternalItemId() + "' doesn't support type " + item.getExternalType());
                        }
                        return false;
                    }
                    if (item.getExternalType() != null) ** GOTO lbl-1000
                    if (result.itemStacks == null) ** GOTO lbl-1000
                    v13 = result.itemStacks;
                    Intrinsics.checkNotNull(v13);
                    if (v13.isEmpty()) lbl-1000:
                    // 2 sources

                    {
                        v14 = "&4custom item '" + item.getExternalPluginName() + ":" + item.getExternalItemId() + "' returned a null item&r";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v14 = msg = "&4custom item '" + item.getExternalPluginName() + ":" + item.getExternalItemId() + "' (" + item.getExternalType() + ") returned a null item&r";
                    }
                    if (main.getMainCompanion().getHasFinishedLoading()) {
                        DebugManager.Companion.log(DebugType.CUSTOM_DROPS, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getExternalItem$lambda$0(java.lang.String ), ()Ljava/lang/String;)((String)msg));
                    } else {
                        Log.INSTANCE.war(msg);
                    }
                    main.getCustomDropsHandler().getCustomDropsParser().getInvalidExternalItems().add(msg);
                    return false;
                }
                if (!main.getMainCompanion().getExternalCompatibilityManager().doesLMIMeetVersionRequirement2()) break block22;
                if (result.itemStacks == null) ** GOTO lbl-1000
                v15 = result.itemStacks;
                Intrinsics.checkNotNull(v15);
                if (v15.isEmpty() == false) {
                    v16 = result.itemStacks;
                    Intrinsics.checkNotNull(v16, "null cannot be cast to non-null type kotlin.collections.MutableList<org.bukkit.inventory.ItemStack>");
                    item.setItemStacks(TypeIntrinsics.asMutableList(v16));
                } else lbl-1000:
                // 2 sources

                {
                    item.setItemStack(result.itemStack);
                }
                break block23;
            }
            item.setItemStack(itemStack);
        }
        return true;
    }

    private final Object evaluateFormula(String name, Object value, LivingEntityWrapper lmEntity) {
        if (value == null) {
            return null;
        }
        if (lmEntity == null) {
            return 1;
        }
        String formulaPre = value.toString();
        String formula = LevelledMobs.Companion.getInstance().getLevelManager().replaceStringPlaceholdersForFormulas(formulaPre, lmEntity);
        EvaluationResult evalResult = MobDataManager.Companion.evaluateExpression(formula);
        if (evalResult.getHadError()) {
            NotifyManager.INSTANCE.notifyOfError("Error evaluating formula for custom drop extras for '" + name + "' on mob: " + lmEntity.getNameIfBaby() + ", " + evalResult.getError());
            DebugManager.Companion.log(DebugType.CUSTOM_DROPS_FORMULA, lmEntity, () -> LMItemsParser.evaluateFormula$lambda$0(formula, formulaPre, evalResult));
            return null;
        }
        double result = evalResult.getResult();
        DebugManager.Companion.log(DebugType.CUSTOM_DROPS_FORMULA, lmEntity, () -> LMItemsParser.evaluateFormula$lambda$1(formula, formulaPre, result));
        return result;
    }

    private static final String getExternalItem$lambda$0(String $msg) {
        return $msg;
    }

    private static final String evaluateFormula$lambda$0(String $formula, String $formulaPre, EvaluationResult $evalResult) {
        String msg = Intrinsics.areEqual($formula, $formulaPre) ? "   formula: '" + $formula + "'" : "   formulaPre: '" + $formulaPre + "'\n   formula: '" + $formula + "'";
        return "result (error, " + $evalResult.getError() + ")\n" + msg;
    }

    private static final String evaluateFormula$lambda$1(String $formula, String $formulaPre, double $result) {
        String msg = Intrinsics.areEqual($formula, $formulaPre) ? "   formula: '" + $formula + "'" : "   formulaPre: '" + $formulaPre + "'\n   formula: '" + $formula + "'";
        return "result " + $result + "\n" + msg;
    }
}

