/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.libs.commandapi;

import org.bukkit.plugin.Plugin;

public class Schedulers {
    private final boolean isFoliaPresent;

    public Schedulers(boolean isFoliaPresent) {
        this.isFoliaPresent = isFoliaPresent;
    }

    public int scheduleSyncRepeatingTask(Plugin plugin, Runnable runnable2, long delay, long period) {
        if (this.isFoliaPresent) {
            plugin.getServer().getGlobalRegionScheduler().runAtFixedRate(plugin, task -> runnable2.run(), delay <= 0L ? 1L : delay, period);
            return 1;
        }
        return plugin.getServer().getScheduler().runTaskTimer(plugin, runnable2, delay, period).getTaskId();
    }

    public void cancelTask(Plugin plugin, int id) {
        if (this.isFoliaPresent) {
            plugin.getServer().getGlobalRegionScheduler().cancelTasks(plugin);
        } else {
            plugin.getServer().getScheduler().cancelTask(id);
        }
    }

    public void scheduleSync(Plugin plugin, Runnable runnable2) {
        if (this.isFoliaPresent) {
            plugin.getServer().getGlobalRegionScheduler().execute(plugin, runnable2);
        } else {
            plugin.getServer().getScheduler().runTask(plugin, runnable2);
        }
    }

    public void scheduleSyncDelayed(Plugin plugin, Runnable runnable2, long delay) {
        if (this.isFoliaPresent) {
            plugin.getServer().getGlobalRegionScheduler().runDelayed(plugin, task -> runnable2.run(), delay <= 0L ? 1L : delay);
        } else {
            plugin.getServer().getScheduler().runTaskLater(plugin, runnable2, delay);
        }
    }

    public void scheduleAsync(Plugin plugin, Runnable runnable2) {
        if (this.isFoliaPresent) {
            plugin.getServer().getAsyncScheduler().runNow(plugin, task -> runnable2.run());
        } else {
            plugin.getServer().getScheduler().runTaskAsynchronously(plugin, runnable2);
        }
    }
}

