/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.libs.crunch.exceptions;

import io.github.arcaneplugins.levelledmobs.libs.crunch.ExpressionParser;

public class ExpressionCompilationException
extends RuntimeException {
    private final ExpressionParser parser;

    public ExpressionCompilationException(ExpressionParser parser, String message) {
        super(ExpressionCompilationException.generateMessage(parser, message));
        this.parser = parser;
    }

    public ExpressionParser getParser() {
        return this.parser;
    }

    private static String generateMessage(ExpressionParser parser, String message) {
        if (parser == null) {
            return message;
        }
        return message + ":\n" + parser.getInput() + "\n" + ExpressionCompilationException.repeat(' ', parser.getCursor()) + "^";
    }

    private static String repeat(char c, int n) {
        StringBuilder builder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            builder.append(c);
        }
        return builder.toString();
    }
}

