/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropResult;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.functions.Function1;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.NametagTimerChecker;
import io.github.arcaneplugins.levelledmobs.result.AdjacentChunksResult;
import io.github.arcaneplugins.levelledmobs.result.ChunkKillInfo;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityDeathListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "damageMappings", "", "Ljava/util/UUID;", "Lorg/bukkit/entity/Player;", "getDamageMappings", "()Ljava/util/Map;", "lastPriority", "Lorg/bukkit/event/EventPriority;", "settingName", "", "bypassEntity", "", "Lorg/bukkit/entity/EntityType;", "load", "", "onDeath", "event", "Lorg/bukkit/event/entity/EntityDeathEvent;", "hasReachedEntityDeathChunkMax", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "player", "getNumberOfEntityDeathsInAdjacentChunks", "Lio/github/arcaneplugins/levelledmobs/result/AdjacentChunksResult;", "levelledmobs-plugin"})
public final class EntityDeathListener
implements Listener {
    @NotNull
    private final Map<UUID, Player> damageMappings = new LinkedHashMap();
    @Nullable
    private EventPriority lastPriority;
    @NotNull
    private final String settingName;
    @NotNull
    private final List<EntityType> bypassEntity;

    public EntityDeathListener() {
        this.settingName = "entity-death-event";
        EntityType[] entityTypeArray = new EntityType[]{EntityType.ARMOR_STAND, EntityType.ITEM_FRAME, EntityType.ITEM_DISPLAY, EntityType.PAINTING};
        this.bypassEntity = CollectionsKt.mutableListOf(entityTypeArray);
    }

    @NotNull
    public final Map<UUID, Player> getDamageMappings() {
        return this.damageMappings;
    }

    public final void load() {
        EventPriority priority = LevelledMobs.Companion.getInstance().getMainCompanion().getEventPriority(this.settingName, EventPriority.NORMAL);
        if (this.lastPriority != null) {
            if (priority == this.lastPriority) {
                return;
            }
            HandlerList.unregisterAll((Listener)this);
            Log.INSTANCE.inf("Changing event priority for " + this.settingName + " from " + this.lastPriority + " to " + priority);
        }
        Bukkit.getPluginManager().registerEvent(EntityDeathEvent.class, (Listener)this, priority, (arg_0, arg_1) -> EntityDeathListener.load$lambda$0(this, arg_0, arg_1), (Plugin)LevelledMobs.Companion.getInstance(), false);
        this.lastPriority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void onDeath(EntityDeathEvent event) {
        block17: {
            damagingPlayer = null;
            if (this.damageMappings.containsKey(event.getEntity().getUniqueId())) {
                damagingPlayer = this.damageMappings.get(event.getEntity().getUniqueId());
                this.damageMappings.remove(event.getEntity().getUniqueId());
            }
            if (event.getEntity() instanceof Player) {
                return;
            }
            if (this.bypassEntity.contains(event.getEntityType())) {
                return;
            }
            main = LevelledMobs.Companion.getInstance();
            v0 = damagingPlayer;
            if (v0 == null) {
                v0 = event.getEntity().getKiller();
            }
            killer = v0;
            var6_5 = NametagTimerChecker.Companion.getEntityTarget_Lock();
            synchronized (var6_5) {
                $i$a$-synchronized-EntityDeathListener$onDeath$1 = false;
                $i$a$-synchronized-EntityDeathListener$onDeath$1 = main.getNametagTimerChecker().getEntityTargetMap().remove(event.getEntity());
            }
            v1 = event.getEntity();
            Intrinsics.checkNotNullExpressionValue(v1, "getEntity(...)");
            lmEntity = LivingEntityWrapper.Companion.getInstance(v1);
            lmEntity.setAssociatedPlayer(killer);
            damage = lmEntity.getLivingEntity().getLastDamageCause();
            if (damage != null) {
                v2 = damage.getCause();
                Intrinsics.checkNotNullExpressionValue(v2, "getCause(...)");
                lmEntity.setDeathCause(v2);
            }
            if (killer != null && main.getPlaceholderApiIntegration() != null) {
                v3 = main.getPlaceholderApiIntegration();
                Intrinsics.checkNotNull((Object)v3);
                v3.putPlayerOrMobDeath(killer, lmEntity, false);
            }
            doNotMultiplyDrops = new Ref.BooleanRef();
            doNotBoostXp = new Ref.BooleanRef();
            disableXpDrops = new Ref.BooleanRef();
            if (lmEntity.isLevelled() && killer != null && main.getRulesManager().getMaximumDeathInChunkThreshold(lmEntity) > 0) {
                v4 = main.getRulesManager().getRuleUseCustomDropsForMob(lmEntity).getChunkKillOptions();
                Intrinsics.checkNotNull(v4);
                opts = v4;
                v5 = isAnyOptionEnabled = opts.getDisableXpDrops() != false || opts.getDisableVanillaDrops() != false || opts.getDisableItemBoost() != false;
                if (isAnyOptionEnabled && this.hasReachedEntityDeathChunkMax(lmEntity, killer)) {
                    if (opts.getDisableVanillaDrops()) {
                        event.getDrops().clear();
                        disableXpDrops.element = true;
                    }
                    if (opts.getDisableItemBoost()) {
                        doNotMultiplyDrops.element = true;
                    }
                    if (opts.getDisableXpDrops()) {
                        doNotBoostXp.element = true;
                    }
                }
            }
            if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER) || !lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedDropRules(), PersistentDataType.STRING)) break block17;
            lockedDropRules = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedDropRules(), PersistentDataType.STRING);
            if (lockedDropRules != null) {
                isAnyOptionEnabled = new String[]{";"};
                lmEntity.setLockedCustomDrops(CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)lockedDropRules, isAnyOptionEnabled, false, 0, 6, null)));
            }
            if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedDropRulesOverride(), PersistentDataType.INTEGER)) break block17;
            lockedOverride = (Integer)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedDropRulesOverride(), PersistentDataType.INTEGER);
            if (lockedOverride == null) ** GOTO lbl-1000
            var12_16 = 1;
            if (lockedOverride == var12_16) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            lmEntity.setHasLockedDropsOverride(v6);
        }
        scheduler = new SchedulerWrapper((Entity)event.getEntity(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, onDeath$lambda$1(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper io.github.arcaneplugins.levelledmobs.LevelledMobs org.bukkit.event.entity.EntityDeathEvent io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref$BooleanRef io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref$BooleanRef io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref$BooleanRef ), ()V)((LivingEntityWrapper)lmEntity, (LevelledMobs)main, (EntityDeathEvent)event, (Ref.BooleanRef)doNotMultiplyDrops, (Ref.BooleanRef)disableXpDrops, (Ref.BooleanRef)doNotBoostXp));
        lmEntity.getInUseCount().incrementAndGet();
        scheduler.setRunDirectlyInBukkit(true);
        scheduler.run();
    }

    private final boolean hasReachedEntityDeathChunkMax(LivingEntityWrapper lmEntity, Player player) {
        int n;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Chunk chunk = lmEntity.getLocation().getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        long chunkKey = Utils.INSTANCE.getChunkKey(chunk);
        Map<EntityType, ChunkKillInfo> pairList = main.getMainCompanion().getorAddPairForSpecifiedChunk(chunkKey);
        if (pairList.containsKey(lmEntity.getEntityType())) {
            ChunkKillInfo chunkKillInfo = pairList.get(lmEntity.getEntityType());
            Intrinsics.checkNotNull(chunkKillInfo);
            n = chunkKillInfo.getCount();
        } else {
            n = 0;
        }
        int numberOfEntityDeathInChunk = n;
        AdjacentChunksResult adjacentChunksResult = this.getNumberOfEntityDeathsInAdjacentChunks(lmEntity);
        if (adjacentChunksResult != null) {
            numberOfEntityDeathInChunk += adjacentChunksResult.getEntities();
            adjacentChunksResult.getChunkKeys().add(chunkKey);
        }
        lmEntity.setChunkKillcount(numberOfEntityDeathInChunk);
        int maximumDeathInChunkThreshold = main.getRulesManager().getMaximumDeathInChunkThreshold(lmEntity);
        int maxCooldownTime = main.getRulesManager().getMaxChunkCooldownTime(lmEntity);
        if (numberOfEntityDeathInChunk < maximumDeathInChunkThreshold) {
            ChunkKillInfo chunkKillInfo = pairList.computeIfAbsent(lmEntity.getEntityType(), arg_0 -> EntityDeathListener.hasReachedEntityDeathChunkMax$lambda$1(EntityDeathListener::hasReachedEntityDeathChunkMax$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(chunkKillInfo, "computeIfAbsent(...)");
            ChunkKillInfo chunkKillInfo2 = chunkKillInfo;
            chunkKillInfo2.getEntityCounts().put(Instant.now(), maxCooldownTime);
            return false;
        }
        if (main.getHelperSettings().getBoolean("exceed-kill-in-chunk-message", true)) {
            Object object = adjacentChunksResult;
            if (object == null || (object = ((AdjacentChunksResult)object).getChunkKeys()) == null) {
                Long[] longArray = new Long[]{chunkKey};
                object = CollectionsKt.mutableListOf(longArray);
            }
            List<Long> chunkKeys = object;
            MainCompanion mainCompanion = main.getMainCompanion();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (mainCompanion.doesUserHaveCooldown(chunkKeys, uUID)) {
                return true;
            }
            DebugManager.Companion.log(DebugType.CHUNK_KILL_COUNT, lmEntity, () -> EntityDeathListener.hasReachedEntityDeathChunkMax$lambda$2(lmEntity, player, maximumDeathInChunkThreshold));
            String prefix = main.getConfigUtils().getPrefix();
            String msg = main.getMessagesCfg().getString("other.no-drop-in-chunk");
            if (msg != null) {
                player.sendMessage(MessageUtils.INSTANCE.colorizeAll(StringsKt.replace$default(msg, "%prefix%", prefix, false, 4, null)));
            }
            MainCompanion mainCompanion2 = main.getMainCompanion();
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            mainCompanion2.addUserCooldown(chunkKeys, uUID2);
        }
        return true;
    }

    private final AdjacentChunksResult getNumberOfEntityDeathsInAdjacentChunks(LivingEntityWrapper lmEntity) {
        int adjacentChunksToCheck = LevelledMobs.Companion.getInstance().getRulesManager().getAdjacentChunksToCheck(lmEntity);
        if (adjacentChunksToCheck <= 0) {
            return null;
        }
        Chunk chunk = lmEntity.getLocation().getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        Chunk startingChunk = chunk;
        AdjacentChunksResult result = new AdjacentChunksResult();
        for (int x = -adjacentChunksToCheck; x < adjacentChunksToCheck; ++x) {
            for (int z = -adjacentChunksToCheck; z < adjacentChunksToCheck; ++z) {
                Chunk chunk2;
                if (x == 0 && z == 0) continue;
                Intrinsics.checkNotNullExpressionValue(lmEntity.getWorld().getChunkAt(startingChunk.getX() + x, startingChunk.getZ() + z), "getChunkAt(...)");
                if (!chunk2.isLoaded()) continue;
                result.getChunkKeys().add(Utils.INSTANCE.getChunkKey(chunk2));
            }
        }
        List<Map<EntityType, ChunkKillInfo>> pairLists = MainCompanion.Companion.getInstance().getorAddPairForSpecifiedChunks(result.getChunkKeys());
        for (Map<EntityType, ChunkKillInfo> pairList : pairLists) {
            int n;
            int n2 = result.getEntities();
            if (pairList.containsKey(lmEntity.getEntityType())) {
                ChunkKillInfo chunkKillInfo = pairList.get(lmEntity.getEntityType());
                Intrinsics.checkNotNull(chunkKillInfo);
                n = chunkKillInfo.getCount();
            } else {
                n = 0;
            }
            result.setEntities(n2 + n);
        }
        return result;
    }

    private static final void load$lambda$0(EntityDeathListener this$0, Listener listener, Event event) {
        Intrinsics.checkNotNullParameter(listener, "<unused var>");
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof EntityDeathEvent) {
            this$0.onDeath((EntityDeathEvent)event);
        }
    }

    private static final void onDeath$lambda$1(LivingEntityWrapper $lmEntity, LevelledMobs $main, EntityDeathEvent $event, Ref.BooleanRef $doNotMultiplyDrops, Ref.BooleanRef $disableXpDrops, Ref.BooleanRef $doNotBoostXp) {
        if ($lmEntity.isLevelled()) {
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, $lmEntity, null, 2, null);
            LevelManager levelManager = $main.getLevelManager();
            List list = $event.getDrops();
            Intrinsics.checkNotNullExpressionValue(list, "getDrops(...)");
            levelManager.setLevelledItemDrops($lmEntity, list, $doNotMultiplyDrops.element);
            if ($disableXpDrops.element) {
                $event.setDroppedExp(0);
            } else if (!$doNotBoostXp.element && $event.getDroppedExp() > 0) {
                $event.setDroppedExp($main.getLevelManager().getLevelledExpDrops($lmEntity, $event.getDroppedExp()));
            }
        } else if ($lmEntity.getLockedCustomDrops() != null || $main.getRulesManager().getRuleUseCustomDropsForMob($lmEntity).getUseDrops()) {
            List drops = new ArrayList();
            CustomDropResult result = $main.getCustomDropsHandler().getCustomItemDrops($lmEntity, drops, false);
            if (result.getHasOverride()) {
                LevelManager levelManager = $main.getLevelManager();
                List list = $event.getDrops();
                Intrinsics.checkNotNullExpressionValue(list, "getDrops(...)");
                levelManager.removeVanillaDrops($lmEntity, list);
            }
            $event.getDrops().addAll(drops);
        }
        $lmEntity.free();
    }

    private static final ChunkKillInfo hasReachedEntityDeathChunkMax$lambda$0(EntityType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ChunkKillInfo();
    }

    private static final ChunkKillInfo hasReachedEntityDeathChunkMax$lambda$1(Function1 $tmp0, Object p0) {
        return (ChunkKillInfo)$tmp0.invoke(p0);
    }

    private static final String hasReachedEntityDeathChunkMax$lambda$2(LivingEntityWrapper $lmEntity, Player $player, int $maximumDeathInChunkThreshold) {
        return Utils.INSTANCE.displayChunkLocation($lmEntity.getLocation()) + ": player: " + $player.getName() + ", reached chunk kill limit, max: " + $maximumDeathInChunkThreshold;
    }
}

