/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners.paper;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.PlaceholderApiIntegration;
import io.github.arcaneplugins.levelledmobs.nametag.KyoriNametags;
import io.github.arcaneplugins.levelledmobs.nametag.ServerVersionInfo;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/paper/PlayerDeathListener;", "", "<init>", "()V", "shouldCancelEvent", "", "useNewerAdventureArgs", "onPlayerDeathEvent", "event", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "getPlayersKiller", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "updateDeathMessage", "", "nametagResult", "Lio/github/arcaneplugins/levelledmobs/result/NametagResult;", "buildPlayerComponent", "Lnet/kyori/adventure/text/Component;", "player", "Lorg/bukkit/entity/Player;", "levelledmobs-plugin"})
public final class PlayerDeathListener {
    private boolean shouldCancelEvent;
    private boolean useNewerAdventureArgs = true;

    public PlayerDeathListener() {
        ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();
        if (!ver.isRunningPaper() || ver.getMinorVersion() < 20 || ver.getMinorVersion() == 20 && ver.getRevision() < 6) {
            this.useNewerAdventureArgs = false;
        }
    }

    public final boolean onPlayerDeathEvent(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.shouldCancelEvent = false;
        if (event.deathMessage() == null) {
            return true;
        }
        if (!(event.deathMessage() instanceof TranslatableComponent)) {
            return false;
        }
        LivingEntityWrapper lmEntity = this.getPlayersKiller(event);
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (lmEntity == null) {
            if (main.getPlaceholderApiIntegration() != null) {
                PlaceholderApiIntegration placeholderApiIntegration = main.getPlaceholderApiIntegration();
                Intrinsics.checkNotNull((Object)placeholderApiIntegration);
                Player player = event.getEntity();
                Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
                placeholderApiIntegration.putPlayerOrMobDeath(player, null, true);
            }
            if (this.shouldCancelEvent) {
                event.setCancelled(true);
            }
            return true;
        }
        if (main.getPlaceholderApiIntegration() != null) {
            PlaceholderApiIntegration placeholderApiIntegration = main.getPlaceholderApiIntegration();
            Intrinsics.checkNotNull((Object)placeholderApiIntegration);
            Player player = event.getEntity();
            Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
            placeholderApiIntegration.putPlayerOrMobDeath(player, lmEntity, true);
        }
        lmEntity.free();
        if (this.shouldCancelEvent) {
            event.setCancelled(true);
        }
        return true;
    }

    private final LivingEntityWrapper getPlayersKiller(PlayerDeathEvent event) {
        LivingEntity killer;
        block13: {
            block12: {
                EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
                if (entityDamageEvent == null || entityDamageEvent.isCancelled() || !(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
                    return null;
                }
                Entity entity = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
                Intrinsics.checkNotNullExpressionValue(entity, "getDamager(...)");
                Entity damager = entity;
                killer = null;
                if (damager instanceof Projectile) {
                    if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                        killer = (LivingEntity)((Projectile)damager).getShooter();
                    }
                } else if (damager instanceof LivingEntity) {
                    killer = (LivingEntity)damager;
                }
                if (killer == null) break block12;
                String string = killer.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (!(((CharSequence)string).length() == 0) && !(killer instanceof Player)) break block13;
            }
            return null;
        }
        LivingEntityWrapper lmKiller = LivingEntityWrapper.Companion.getInstance(killer);
        if (!lmKiller.isLevelled()) {
            return lmKiller;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        lmKiller.setAssociatedPlayer(player2);
        NametagResult mobNametag = LevelledMobs.Companion.getInstance().getLevelManager().getNametag(lmKiller, true, true);
        if (((CharSequence)mobNametag.getNametagNonNull()).length() == 0) {
            return lmKiller;
        }
        if (mobNametag.isNullOrEmpty() || StringsKt.equals("disabled", mobNametag.getNametagNonNull(), true)) {
            return lmKiller;
        }
        this.updateDeathMessage(event, mobNametag);
        return lmKiller;
    }

    private final void updateDeathMessage(PlayerDeathEvent event, NametagResult nametagResult) {
        ComponentSerializer componentSerializer;
        if (!(event.deathMessage() instanceof TranslatableComponent)) {
            return;
        }
        Component component = event.deathMessage();
        Intrinsics.checkNotNull(component, "null cannot be cast to non-null type net.kyori.adventure.text.TranslatableComponent");
        TranslatableComponent tc = (TranslatableComponent)component;
        String mobKey = null;
        TranslationArgument itemComp = null;
        if (this.useNewerAdventureArgs) {
            for (TranslationArgument c : tc.arguments()) {
                Component component2 = c.asComponent();
                TranslatableComponent tc2 = component2 instanceof TranslatableComponent ? (TranslatableComponent)component2 : null;
                if (tc2 == null) continue;
                if (Intrinsics.areEqual("chat.square_brackets", tc2.key())) {
                    itemComp = (Component)tc2;
                    continue;
                }
                mobKey = tc2.key();
            }
        } else {
            for (TranslationArgument c : tc.args()) {
                if (!(c instanceof TranslatableComponent)) continue;
                if (Intrinsics.areEqual("chat.square_brackets", ((TranslatableComponent)c).key())) {
                    itemComp = c;
                    continue;
                }
                mobKey = ((TranslatableComponent)c).key();
            }
        }
        if (mobKey == null) {
            return;
        }
        String mobName = nametagResult.getNametagNonNull();
        int displayNameIndex = StringsKt.indexOf$default((CharSequence)mobName, "{DisplayName}", 0, false, 6, null);
        if (LevelledMobs.Companion.getInstance().getDefinitions().getUseLegacySerializer()) {
            LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacyAmpersand();
            Intrinsics.checkNotNullExpressionValue(legacyComponentSerializer, "legacyAmpersand(...)");
            componentSerializer = (ComponentSerializer)legacyComponentSerializer;
        } else {
            MiniMessage miniMessage = LevelledMobs.Companion.getInstance().getDefinitions().getMm();
            Intrinsics.checkNotNull(miniMessage);
            componentSerializer = (ComponentSerializer)miniMessage;
        }
        ComponentSerializer cs = componentSerializer;
        Component newCom = null;
        if (nametagResult.getHadCustomDeathMessage()) {
            TextReplacementConfig.Builder builder = TextReplacementConfig.builder().matchLiteral("%player%");
            Player player = event.getEntity();
            Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
            Object object = builder.replacement((ComponentLike)this.buildPlayerComponent(player)).build();
            Intrinsics.checkNotNullExpressionValue(object, "build(...)");
            TextReplacementConfig replacementConfig = (TextReplacementConfig)object;
            Component component3 = cs.deserialize((Object)mobName).replaceText(replacementConfig);
            Intrinsics.checkNotNullExpressionValue(component3, "replaceText(...)");
            newCom = component3;
            if (nametagResult.getHadCustomDeathMessage()) {
                Object object2 = TextReplacementConfig.builder().matchLiteral("{DisplayName}").replacement((ComponentLike)KyoriNametags.INSTANCE.generateDeathMessage(mobKey, nametagResult)).build();
                Intrinsics.checkNotNullExpressionValue(object2, "build(...)");
                TextReplacementConfig displayName = (TextReplacementConfig)object2;
                Component component4 = newCom.replaceText(displayName);
                Intrinsics.checkNotNullExpressionValue(component4, "replaceText(...)");
                newCom = component4;
            }
        } else if (displayNameIndex < 0) {
            String string = tc.key();
            ComponentLike[] displayName = new ComponentLike[2];
            Player player = event.getEntity();
            Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
            displayName[0] = this.buildPlayerComponent(player);
            displayName[1] = cs.deserialize((Object)mobName);
            TranslatableComponent replacementConfig = Component.translatable((String)string, (ComponentLike[])displayName);
            Intrinsics.checkNotNullExpressionValue(replacementConfig, "translatable(...)");
            newCom = (Component)replacementConfig;
        } else {
            TranslatableComponent translatableComponent;
            Component component5;
            Component rightComp;
            Component leftComp;
            if (displayNameIndex > 0) {
                Component component6 = cs.deserialize((Object)StringsKt.take(mobName, displayNameIndex));
                v13 = component6;
                Intrinsics.checkNotNullExpressionValue(component6, "deserialize(...)");
            } else {
                TextComponent textComponent = Component.empty();
                Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
                v13 = leftComp = (Component)textComponent;
            }
            if (mobName.length() > displayNameIndex + 13) {
                String string = mobName.substring(displayNameIndex + 13);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                Component component7 = cs.deserialize((Object)string);
                v17 = component7;
                Intrinsics.checkNotNullExpressionValue(component7, "deserialize(...)");
            } else {
                TextComponent textComponent = Component.empty();
                Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
                v17 = rightComp = (Component)textComponent;
            }
            if (nametagResult.getOverriddenName() == null) {
                TranslatableComponent translatableComponent2 = Component.translatable((String)mobKey);
                Intrinsics.checkNotNullExpressionValue(translatableComponent2, "translatable(...)");
                component5 = (Component)translatableComponent2;
            } else {
                String string = nametagResult.getOverriddenName();
                Intrinsics.checkNotNull(string);
                Component component8 = cs.deserialize((Object)string);
                component5 = component8;
                Intrinsics.checkNotNullExpressionValue(component8, "deserialize(...)");
            }
            Component mobNameComponent = component5;
            if (itemComp == null) {
                String string = tc.key();
                var14_18 = new ComponentLike[2];
                Player player = event.getEntity();
                Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
                var14_18[0] = this.buildPlayerComponent(player);
                var14_18[1] = leftComp.append(mobNameComponent);
                translatableComponent = (TranslatableComponent)Component.translatable((String)string, (ComponentLike[])var14_18).append(rightComp);
            } else {
                String string = tc.key();
                var14_18 = new ComponentLike[3];
                Player player = event.getEntity();
                Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
                var14_18[0] = this.buildPlayerComponent(player);
                var14_18[1] = leftComp.append(mobNameComponent);
                var14_18[2] = itemComp;
                translatableComponent = (TranslatableComponent)Component.translatable((String)string, (ComponentLike[])var14_18).append(rightComp);
            }
            TranslatableComponent translatableComponent3 = translatableComponent;
            Intrinsics.checkNotNull(translatableComponent3);
            newCom = (Component)translatableComponent3;
        }
        event.deathMessage(newCom);
    }

    private final Component buildPlayerComponent(Player player) {
        ClickEvent clickEvent = ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)("/tell " + player.getName() + " "));
        Intrinsics.checkNotNullExpressionValue(clickEvent, "clickEvent(...)");
        ClickEvent clickEvent2 = clickEvent;
        Component component = Component.text((String)player.getName()).clickEvent(clickEvent2);
        Intrinsics.checkNotNullExpressionValue(component, "clickEvent(...)");
        return component;
    }
}

