/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelInterface2;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.LivingEntityInterface;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropResult;
import io.github.arcaneplugins.levelledmobs.customdrops.EquippedItemsInfo;
import io.github.arcaneplugins.levelledmobs.customdrops.GroupLimits;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.enums.AttributeNames;
import io.github.arcaneplugins.levelledmobs.enums.InternalSpawnReason;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.enums.MobCustomNameStatus;
import io.github.arcaneplugins.levelledmobs.enums.MobTamedStatus;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.events.MobPostLevelEvent;
import io.github.arcaneplugins.levelledmobs.events.MobPreLevelEvent;
import io.github.arcaneplugins.levelledmobs.events.SummonedMobPreLevelEvent;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Pair;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.TuplesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin._Assertions;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.MapsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.comparisons.ComparisonsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.math.MathKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.Sequence;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.SequencesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.CharsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.managers.NBTManager;
import io.github.arcaneplugins.levelledmobs.managers.NotifyManager;
import io.github.arcaneplugins.levelledmobs.misc.EvaluationException;
import io.github.arcaneplugins.levelledmobs.misc.ExternalPluginDetection;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.PickedUpEquipment;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.misc.StringReplacer;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.result.AttributePreMod;
import io.github.arcaneplugins.levelledmobs.result.EvaluationResult;
import io.github.arcaneplugins.levelledmobs.result.MinAndMaxHolder;
import io.github.arcaneplugins.levelledmobs.result.MythicMobsMobInfo;
import io.github.arcaneplugins.levelledmobs.result.NBTApplyResult;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.result.PlayerHomeCheckResult;
import io.github.arcaneplugins.levelledmobs.result.PlayerLevelSourceResult;
import io.github.arcaneplugins.levelledmobs.result.PlayerNetherOrWorldSpawnResult;
import io.github.arcaneplugins.levelledmobs.rules.ChunkKillOptions;
import io.github.arcaneplugins.levelledmobs.rules.CustomDropsRuleSet;
import io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes;
import io.github.arcaneplugins.levelledmobs.rules.HealthIndicator;
import io.github.arcaneplugins.levelledmobs.rules.RulesManager;
import io.github.arcaneplugins.levelledmobs.rules.strategies.CustomStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.PlayerLevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.RandomVarianceGenerator;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MiscUtils;
import io.github.arcaneplugins.levelledmobs.util.MythicMobUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerResult;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u0090\u00012\u00020\u0001:\u0002\u0090\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020%H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J \u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002052\u0006\u00109\u001a\u000205H\u0016J\u0018\u0010:\u001a\u0002052\u0006\u0010;\u001a\u00020<2\u0006\u00106\u001a\u000207H\u0002J \u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010!2\u0006\u00106\u001a\u0002072\u0006\u0010@\u001a\u00020%J\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ$\u0010E\u001a\u0002012\u0006\u00106\u001a\u0002072\f\u0010F\u001a\b\u0012\u0004\u0012\u00020G0\u00052\u0006\u0010H\u001a\u00020\u000eJ\u001e\u0010I\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u0010J\u001a\u00020G2\u0006\u0010K\u001a\u00020<J$\u0010L\u001a\b\u0012\u0004\u0012\u00020G0\u00052\u0006\u00106\u001a\u0002072\f\u0010M\u001a\b\u0012\u0004\u0012\u00020G0\u0005H\u0002J\u001c\u0010N\u001a\u0002012\u0006\u00106\u001a\u0002072\f\u0010M\u001a\b\u0012\u0004\u0012\u00020G0\u0005J\u0016\u0010O\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u0010P\u001a\u00020QJ\u0016\u0010R\u001a\u00020S2\u0006\u00106\u001a\u0002072\u0006\u0010T\u001a\u00020\u000eJ\u001e\u0010R\u001a\u00020S2\u0006\u00106\u001a\u0002072\u0006\u0010T\u001a\u00020\u000e2\u0006\u0010U\u001a\u00020\u000eJ(\u0010V\u001a\u00020S2\u0006\u00106\u001a\u0002072\u0006\u0010W\u001a\u00020X2\u0006\u0010U\u001a\u00020\u000e2\b\u0010Y\u001a\u0004\u0018\u00010%J\u0010\u0010Z\u001a\u0002012\u0006\u00106\u001a\u000207H\u0002J\u0018\u0010[\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u0010\\\u001a\u00020XH\u0002J\u0016\u0010]\u001a\u00020%2\u0006\u0010^\u001a\u00020%2\u0006\u00106\u001a\u000207J0\u0010_\u001a\u00020%2\u0006\u0010^\u001a\u00020%2\u0006\u00106\u001a\u0002072\u0006\u0010`\u001a\u00020\u000e2\b\u0010?\u001a\u0004\u0018\u00010!2\u0006\u0010U\u001a\u00020\u000eJ2\u0010_\u001a\u00020%2\u0006\u0010^\u001a\u00020X2\u0006\u00106\u001a\u0002072\u0006\u0010`\u001a\u00020\u000e2\b\u0010?\u001a\u0004\u0018\u00010!2\u0006\u0010U\u001a\u00020\u000eH\u0002J \u0010a\u001a\u0002012\u0006\u0010b\u001a\u00020Q2\u0006\u0010c\u001a\u00020Q2\u0006\u0010^\u001a\u00020XH\u0002J\u000e\u0010d\u001a\u0002012\u0006\u00106\u001a\u000207J\u000e\u0010V\u001a\u0002012\u0006\u00106\u001a\u000207J$\u0010V\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u0010W\u001a\u00020S2\f\u0010e\u001a\b\u0012\u0004\u0012\u00020!0\u0005J\u0006\u0010f\u001a\u000201J\b\u0010g\u001a\u000201H\u0002J\b\u0010h\u001a\u000201H\u0002J\u0006\u0010i\u001a\u000201J\b\u0010j\u001a\u000201H\u0002J2\u0010k\u001a\u0002012\u0006\u0010l\u001a\u00020\"2\u0006\u0010?\u001a\u00020!2\u0018\u0010m\u001a\u0014\u0012\u0004\u0012\u000207\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00050 H\u0002J\u0010\u0010n\u001a\u00020\u000e2\u0006\u00106\u001a\u000207H\u0002J\u001e\u0010o\u001a\u0002012\u0006\u00106\u001a\u0002072\f\u0010e\u001a\b\u0012\u0004\u0012\u00020!0pH\u0002J\u0018\u0010q\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u0010?\u001a\u00020!H\u0002J\u0018\u0010r\u001a\u00020\u000e2\u0006\u00106\u001a\u0002072\u0006\u0010?\u001a\u00020!H\u0002J\u0006\u0010s\u001a\u000201J,\u0010t\u001a\u0002012\u0006\u00106\u001a\u0002072\f\u0010u\u001a\b\u0012\u0004\u0012\u00020v0\u00052\f\u0010w\u001a\b\u0012\u0004\u0012\u00020%0\u0005H\u0002J\u0010\u0010x\u001a\u0002012\u0006\u00106\u001a\u000207H\u0002J\u0018\u0010y\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u0010z\u001a\u000205H\u0002J\u0018\u0010{\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u0010|\u001a\u00020}H\u0002J\u0010\u0010~\u001a\u00020Q2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010\u007f\u001a\u00020Q2\u0006\u00106\u001a\u000207H\u0002J\u0012\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0006\u0010C\u001a\u00020DH\u0016J\u0013\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020\tH\u0016J=\u0010\u0083\u0001\u001a\u0002012\u0006\u00106\u001a\u0002072\u0006\u0010z\u001a\u0002052\u0007\u0010\u0084\u0001\u001a\u00020\u000e2\u0007\u0010\u0085\u0001\u001a\u00020\u000e2\u0010\u0010\u0086\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u0087\u0001\u0018\u00010*H\u0016J(\u0010\u0088\u0001\u001a\u0002012\u0006\u00106\u001a\u0002072\f\u0010w\u001a\b\u0012\u0004\u0012\u00020%0\u00052\u0007\u0010\u0089\u0001\u001a\u00020\u000eH\u0002J\u001f\u0010\u008a\u0001\u001a\u0002012\u0006\u00106\u001a\u0002072\f\u0010w\u001a\b\u0012\u0004\u0012\u00020%0\u0005H\u0002J\u001f\u0010\u008b\u0001\u001a\u0002012\u0006\u00106\u001a\u0002072\f\u0010w\u001a\b\u0012\u0004\u0012\u00020%0\u0005H\u0002J\u0012\u0010\u008c\u0001\u001a\u00020\u000e2\u0007\u0010\u0082\u0001\u001a\u00020\tH\u0016J\u0012\u0010\u008d\u0001\u001a\u0002052\u0007\u0010\u0082\u0001\u001a\u00020\tH\u0016J\u0011\u0010\u008e\u0001\u001a\u0002012\u0006\u00106\u001a\u000207H\u0016J\u0012\u0010\u008e\u0001\u001a\u0002012\u0007\u0010\u0082\u0001\u001a\u00020\tH\u0016J\u0014\u0010\u008f\u0001\u001a\u0004\u0018\u00010%2\u0007\u0010\u0082\u0001\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00050 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006\u0091\u0001"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/LevelManager;", "Lio/github/arcaneplugins/levelledmobs/LevelInterface2;", "<init>", "()V", "vehicleNoMultiplierItems", "", "Lorg/bukkit/Material;", "summonedOrSpawnEggs", "Ljava/util/WeakHashMap;", "Lorg/bukkit/entity/LivingEntity;", "", "getSummonedOrSpawnEggs", "()Ljava/util/WeakHashMap;", "hasMentionedNBTAPIMissing", "", "doCheckMobHash", "getDoCheckMobHash", "()Z", "setDoCheckMobHash", "(Z)V", "lastLEWCacheClearing", "Ljava/time/Instant;", "entitySpawnListener", "Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "getEntitySpawnListener", "()Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "nametagAutoUpdateTask", "Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerResult;", "nametagTimerTask", "asyncRunningCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "entitiesPerPlayer", "", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/entity/Entity;", "entitiesPerPlayerLock", "attributeStringList", "", "Lorg/bukkit/attribute/Attribute;", "strategyPlaceholders", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "forcedBlockedEntityTypes", "", "Lorg/bukkit/entity/EntityType;", "getForcedBlockedEntityTypes", "()Ljava/util/Set;", "setForcedBlockedEntityTypes", "(Ljava/util/Set;)V", "load", "", "mapLegacyEntityTypeName", "name", "generateLevel", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "minLevel", "maxLevel", "constructLevel", "input", "", "getPlayerLevelSourceNumber", "Lio/github/arcaneplugins/levelledmobs/result/PlayerLevelSourceResult;", "player", "variableToUse", "getMinAndMaxLevels", "Lio/github/arcaneplugins/levelledmobs/result/MinAndMaxHolder;", "lmInterface", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "setLevelledItemDrops", "currentDrops", "Lorg/bukkit/inventory/ItemStack;", "disableItemBoost", "multiplyDrop", "currentDrop", "addition", "removePickedUpItems", "drops", "removeVanillaDrops", "getLevelledExpDrops", "xp", "", "getNametag", "Lio/github/arcaneplugins/levelledmobs/result/NametagResult;", "isDeathNametag", "preserveMobName", "updateNametag", "nametag", "Lio/github/arcaneplugins/levelledmobs/misc/StringReplacer;", "customDeathMessage", "checkLockedNametag", "getAttributesCache", "str", "replaceStringPlaceholdersForFormulas", "text", "replaceStringPlaceholders", "usePAPI", "getHealthPercentRemaining", "currentHealth", "maxHealth", "updateNametagWithDelay", "players", "startNametagAutoUpdateTask", "checkLEWCache", "enumerateNearbyEntities", "startNametagTimer", "runNametagCheckASync", "checkEntity", "entity", "entityToPlayer", "checkIfReadyForRelevelling", "checkEntityForPlayerLevelling", "", "checkLevelledEntity", "doesMobNeedRelevelling", "stopNametagAutoUpdateTask", "applyLevelledAttributes", "additions", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "nbtDatas", "applyCreeperBlastRadius", "applyLevelledEquipment", "level", "applyLevelledEquipmentNonAsync", "customDropsRuleSet", "Lio/github/arcaneplugins/levelledmobs/rules/CustomDropsRuleSet;", "getMobAttributeValue", "getMobHealth", "getLevellableState", "Lio/github/arcaneplugins/levelledmobs/enums/LevellableState;", "livingEntity", "applyLevelToMob", "isSummoned", "bypassLimits", "additionalLevelInformation", "Lio/github/arcaneplugins/levelledmobs/result/AdditionalLevelInformation;", "applyLevelToMob2", "doSkipLMNametag", "applyAttribs", "applyNbtData", "isLevelled", "getLevelOfMob", "removeLevel", "getMobNametag", "Companion", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nLevelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevelManager.kt\nio/github/arcaneplugins/levelledmobs/managers/LevelManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,2150:1\n608#2:2151\n*S KotlinDebug\n*F\n+ 1 LevelManager.kt\nio/github/arcaneplugins/levelledmobs/managers/LevelManager\n*L\n1297#1:2151\n*E\n"})
public final class LevelManager
implements LevelInterface2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Material> vehicleNoMultiplierItems = new ArrayList();
    @NotNull
    private final WeakHashMap<LivingEntity, Object> summonedOrSpawnEggs = new WeakHashMap();
    private boolean hasMentionedNBTAPIMissing;
    private boolean doCheckMobHash;
    @Nullable
    private Instant lastLEWCacheClearing;
    @NotNull
    private final EntitySpawnListener entitySpawnListener = new EntitySpawnListener();
    @Nullable
    private SchedulerResult nametagAutoUpdateTask;
    @Nullable
    private SchedulerResult nametagTimerTask;
    @NotNull
    private final AtomicInteger asyncRunningCount = new AtomicInteger();
    @NotNull
    private final Map<Player, List<Entity>> entitiesPerPlayer = new LinkedHashMap();
    @NotNull
    private final Object entitiesPerPlayerLock = new Object();
    @NotNull
    private final Map<String, Attribute> attributeStringList = new LinkedHashMap();
    @NotNull
    private final Map<String, StrategyType> strategyPlaceholders = new LinkedHashMap();
    @NotNull
    private Set<EntityType> forcedBlockedEntityTypes = new LinkedHashSet();
    @NotNull
    private static final Object summonedOrSpawnEggs_Lock = new Object();

    @NotNull
    public final WeakHashMap<LivingEntity, Object> getSummonedOrSpawnEggs() {
        return this.summonedOrSpawnEggs;
    }

    public final boolean getDoCheckMobHash() {
        return this.doCheckMobHash;
    }

    public final void setDoCheckMobHash(boolean bl) {
        this.doCheckMobHash = bl;
    }

    @NotNull
    public final EntitySpawnListener getEntitySpawnListener() {
        return this.entitySpawnListener;
    }

    @NotNull
    public final Set<EntityType> getForcedBlockedEntityTypes() {
        return this.forcedBlockedEntityTypes;
    }

    public final void setForcedBlockedEntityTypes(@NotNull Set<EntityType> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.forcedBlockedEntityTypes = set;
    }

    public final void load() {
        Pair[] pairArray = new Pair[9];
        Attribute attribute = Utils.INSTANCE.getAttribute(AttributeNames.MAX_HEALTH);
        Intrinsics.checkNotNull(attribute);
        pairArray[0] = TuplesKt.to("%max-health%", attribute);
        Attribute attribute2 = Utils.INSTANCE.getAttribute(AttributeNames.MOVEMENT_SPEED);
        Intrinsics.checkNotNull(attribute2);
        pairArray[1] = TuplesKt.to("%movement-speed%", attribute2);
        Attribute attribute3 = Utils.INSTANCE.getAttribute(AttributeNames.ATTACK_DAMAGE);
        Intrinsics.checkNotNull(attribute3);
        pairArray[2] = TuplesKt.to("%attack-damage%", attribute3);
        Attribute attribute4 = Utils.INSTANCE.getAttribute(AttributeNames.FOLLOW_RANGE);
        Intrinsics.checkNotNull(attribute4);
        pairArray[3] = TuplesKt.to("%follow-range%", attribute4);
        Attribute attribute5 = Utils.INSTANCE.getAttribute(AttributeNames.ARMOR);
        Intrinsics.checkNotNull(attribute5);
        pairArray[4] = TuplesKt.to("%armor-bonus%", attribute5);
        Attribute attribute6 = Utils.INSTANCE.getAttribute(AttributeNames.ARMOR_TOUGHNESS);
        Intrinsics.checkNotNull(attribute6);
        pairArray[5] = TuplesKt.to("%armor-toughness%", attribute6);
        Attribute attribute7 = Utils.INSTANCE.getAttribute(AttributeNames.ATTACK_KNOCKBACK);
        Intrinsics.checkNotNull(attribute7);
        pairArray[6] = TuplesKt.to("%attack-knockback%", attribute7);
        Attribute attribute8 = Utils.INSTANCE.getAttribute(AttributeNames.KNOCKBACK_RESISTANCE);
        Intrinsics.checkNotNull(attribute8);
        pairArray[7] = TuplesKt.to("%knockback-resistance%", attribute8);
        Attribute attribute9 = Utils.INSTANCE.getAttribute(AttributeNames.SPAWN_REINFORCEMENTS);
        Intrinsics.checkNotNull(attribute9);
        pairArray[8] = TuplesKt.to("%zombie-spawn-reinforcements%", attribute9);
        this.attributeStringList.putAll(MapsKt.mutableMapOf(pairArray));
        pairArray = new Pair[]{TuplesKt.to("%random%", StrategyType.RANDOM), TuplesKt.to("%weighted-random%", StrategyType.WEIGHTED_RANDOM), TuplesKt.to("%random-variance-mod%", StrategyType.RANDOM_VARIANCE), TuplesKt.to("%custom-strategy%", StrategyType.CUSTOM), TuplesKt.to("%distance-from-origin%", StrategyType.SPAWN_DISTANCE), TuplesKt.to("%y-coordinate%", StrategyType.Y_COORDINATE), TuplesKt.to("%player-variable-mod%", StrategyType.PLAYER_VARIABLE)};
        this.strategyPlaceholders.putAll(MapsKt.mutableMapOf(pairArray));
        pairArray = new Material[]{Material.SADDLE, Material.LEATHER_HORSE_ARMOR, Material.IRON_HORSE_ARMOR, Material.GOLDEN_HORSE_ARMOR, Material.DIAMOND_HORSE_ARMOR};
        this.vehicleNoMultiplierItems.addAll((Collection<Material>)CollectionsKt.mutableListOf(pairArray));
        pairArray = new EntityType[]{EntityType.AREA_EFFECT_CLOUD, EntityType.ARMOR_STAND, EntityType.ARROW, EntityType.DRAGON_FIREBALL, EntityType.EGG, this.mapLegacyEntityTypeName("ENDER_CRYSTAL"), EntityType.ENDER_PEARL, this.mapLegacyEntityTypeName("ENDER_SIGNAL"), EntityType.EXPERIENCE_ORB, EntityType.FALLING_BLOCK, EntityType.FIREBALL, this.mapLegacyEntityTypeName("FIREWORK"), this.mapLegacyEntityTypeName("FISHING_HOOK"), EntityType.ITEM_FRAME, this.mapLegacyEntityTypeName("LEASH_HITCH"), this.mapLegacyEntityTypeName("LIGHTNING"), EntityType.LLAMA_SPIT, EntityType.MINECART, this.mapLegacyEntityTypeName("MINECART_CHEST"), this.mapLegacyEntityTypeName("MINECART_COMMAND"), this.mapLegacyEntityTypeName("MINECART_FURNACE"), this.mapLegacyEntityTypeName("MINECART_HOPPER"), this.mapLegacyEntityTypeName("MINECART_MOB_SPAWNER"), this.mapLegacyEntityTypeName("MINECART_TNT"), EntityType.PAINTING, this.mapLegacyEntityTypeName("PRIMED_TNT"), EntityType.SMALL_FIREBALL, EntityType.SNOWBALL, EntityType.SPECTRAL_ARROW, this.mapLegacyEntityTypeName("SPLASH_POTION"), this.mapLegacyEntityTypeName("THROWN_EXP_BOTTLE"), EntityType.TRIDENT, EntityType.UNKNOWN, EntityType.WITHER_SKULL, EntityType.SHULKER_BULLET, EntityType.PLAYER};
        this.forcedBlockedEntityTypes.addAll((Collection<EntityType>)CollectionsKt.mutableListOf(pairArray));
    }

    private final EntityType mapLegacyEntityTypeName(String name) {
        EntityType entityType;
        block51: {
            block49: {
                if (LevelledMobs.Companion.getInstance().getVer().getMinorVersion() < 21) break block49;
                switch (name) {
                    case "ENDER_CRYSTAL": {
                        entityType = EntityType.END_CRYSTAL;
                        break;
                    }
                    case "ENDER_SIGNAL": {
                        entityType = EntityType.EYE_OF_ENDER;
                        break;
                    }
                    case "FIREWORK": {
                        entityType = EntityType.FIREWORK_ROCKET;
                        break;
                    }
                    case "FISHING_HOOK": {
                        entityType = EntityType.FISHING_BOBBER;
                        break;
                    }
                    case "LEASH_HITCH": {
                        entityType = EntityType.LEASH_KNOT;
                        break;
                    }
                    case "LIGHTNING": {
                        entityType = EntityType.LIGHTNING_BOLT;
                        break;
                    }
                    case "MINECART_CHEST": {
                        entityType = EntityType.CHEST_MINECART;
                        break;
                    }
                    case "MINECART_COMMAND": {
                        entityType = EntityType.COMMAND_BLOCK_MINECART;
                        break;
                    }
                    case "MINECART_FURNACE": {
                        entityType = EntityType.FURNACE_MINECART;
                        break;
                    }
                    case "MINECART_HOPPER": {
                        entityType = EntityType.HOPPER_MINECART;
                        break;
                    }
                    case "MINECART_MOB_SPAWNER": {
                        entityType = EntityType.SPAWNER_MINECART;
                        break;
                    }
                    case "MINECART_TNT": {
                        entityType = EntityType.TNT_MINECART;
                        break;
                    }
                    case "PRIMED_TNT": {
                        entityType = EntityType.TNT;
                        break;
                    }
                    case "SPLASH_POTION": {
                        entityType = EntityType.SPLASH_POTION;
                        break;
                    }
                    case "THROWN_EXP_BOTTLE": {
                        entityType = EntityType.EXPERIENCE_BOTTLE;
                        break;
                    }
                    default: {
                        entityType = EntityType.UNKNOWN;
                        break;
                    }
                }
                break block51;
            }
            entityType = EntityType.valueOf((String)name);
        }
        return entityType;
    }

    @Override
    public int generateLevel(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        return this.generateLevel(lmEntity, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generateLevel(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int useMinLevel = minLevel;
        int useMaxLevel = maxLevel;
        if (useMinLevel == -1 || useMaxLevel == -1) {
            MinAndMaxHolder levels = this.getMinAndMaxLevels(lmEntity);
            if (useMinLevel == -1) {
                useMinLevel = levels.getMinAsInt();
            }
            if (useMaxLevel == -1) {
                useMaxLevel = levels.getMaxAsInt();
            }
        }
        List<LevellingStrategy> levellingStrategies = LevelledMobs.Companion.getInstance().getRulesManager().getRuleLevellingStrategies(lmEntity);
        List<CustomStrategy> customStrategies = LevelledMobs.Companion.getInstance().getRulesManager().getRuleCustomStrategies(lmEntity);
        float numberResult = 0.0f;
        UUID debugId = DebugManager.Companion.startLongDebugMessage();
        try {
            float result;
            LevellingStrategy strategy;
            int count;
            Iterator iterator2 = ((Iterable)levellingStrategies).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                count = n++;
                strategy = (LevellingStrategy)iterator2.next();
                result = strategy.generateNumber(lmEntity, useMinLevel, useMaxLevel);
                lmEntity.getStrategyResults().put(strategy.getStrategyType(), Float.valueOf(result));
                DebugManager.Companion.logLongMessage(debugId, () -> LevelManager.generateLevel$lambda$0(count, strategy, result));
                numberResult += result;
            }
            iterator2 = ((Iterable)customStrategies).iterator();
            n = 0;
            while (iterator2.hasNext()) {
                count = n++;
                strategy = (CustomStrategy)iterator2.next();
                result = ((CustomStrategy)strategy).generateNumber(lmEntity, useMinLevel, useMaxLevel);
                lmEntity.getCustomStrategyResults().put(((CustomStrategy)strategy).getPlaceholderName(), Float.valueOf(result));
                DebugManager.Companion.logLongMessage(debugId, () -> LevelManager.generateLevel$lambda$1(count, (CustomStrategy)strategy, result));
                numberResult += result;
            }
        }
        finally {
            DebugManager.Companion.endLongMessage(debugId, DebugType.STRATEGY_RESULT, lmEntity);
        }
        if (useMinLevel == useMaxLevel) {
            return useMinLevel;
        }
        int generatedLevel = RangesKt.coerceAtLeast(RangesKt.coerceAtMost(this.constructLevel(numberResult, lmEntity), useMaxLevel), useMinLevel);
        return generatedLevel;
    }

    private final int constructLevel(float input, LivingEntityWrapper lmEntity) {
        String string = LevelledMobs.Companion.getInstance().getRulesManager().getRuleConstructLevel(lmEntity);
        if (string == null) {
            return MathKt.roundToInt(input);
        }
        String formulaPre = string;
        String formula = this.replaceStringPlaceholdersForFormulas(formulaPre, lmEntity);
        EvaluationResult evalResult = MobDataManager.Companion.evaluateExpression(formula);
        if (evalResult.getHadError()) {
            NotifyManager.INSTANCE.notifyOfError("Error evaluating formula for construct-level on mob: " + lmEntity.getNameIfBaby() + ", " + evalResult.getError());
            DebugManager.Companion.log(DebugType.CONSTRUCT_LEVEL, lmEntity, () -> LevelManager.constructLevel$lambda$0(formula, formulaPre, evalResult));
            throw new EvaluationException();
        }
        int result = (int)Math.floor(evalResult.getResult());
        DebugManager.Companion.log(DebugType.CONSTRUCT_LEVEL, lmEntity, () -> LevelManager.constructLevel$lambda$1(formula, formulaPre, result));
        return result;
    }

    @NotNull
    public final PlayerLevelSourceResult getPlayerLevelSourceNumber(@Nullable Player player, @NotNull LivingEntityWrapper lmEntity, @NotNull String variableToUse) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(variableToUse, "variableToUse");
        if (player == null) {
            return new PlayerLevelSourceResult(1.0f);
        }
        float origLevelSource = 0.0f;
        String homeNameUsed = "spawn";
        if (StringsKt.equals("%level%", variableToUse, true)) {
            origLevelSource = player.getLevel();
        } else if (StringsKt.equals("%exp%", variableToUse, true)) {
            origLevelSource = player.getExp();
        } else if (StringsKt.equals("%exp-to-level%", variableToUse, true)) {
            origLevelSource = player.getExpToLevel();
        } else if (StringsKt.equals("%total-exp%", variableToUse, true)) {
            origLevelSource = player.getTotalExperience();
        } else if (StringsKt.equals("%world-time-ticks%", variableToUse, true)) {
            origLevelSource = player.getWorld().getTime();
        } else if (StringsKt.equals("%home-distance%", variableToUse, true) || StringsKt.equals("%home-distance-with-bed%", variableToUse, true)) {
            Location useLocation2;
            boolean allowBed = StringsKt.equals("%home-distance-with-bed%", variableToUse, true);
            PlayerNetherOrWorldSpawnResult netherOrWorldSpawnResult = null;
            PlayerHomeCheckResult result = ExternalCompatibilityManager.Companion.getPlayerHomeLocation(player, allowBed);
            if (result.getHomeNameUsed() != null) {
                String string = result.getHomeNameUsed();
                Intrinsics.checkNotNull(string);
                homeNameUsed = string;
            }
            if ((useLocation2 = result.getLocation()) == null || !Intrinsics.areEqual(useLocation2.getWorld(), player.getWorld())) {
                netherOrWorldSpawnResult = Utils.INSTANCE.getPortalOrWorldSpawn(player);
                useLocation2 = netherOrWorldSpawnResult.getLocation();
                String string = netherOrWorldSpawnResult.isWorldPortalLocation() ? "world-portal" : (homeNameUsed = netherOrWorldSpawnResult.isNetherPortalLocation() ? "nether-portal" : "spawn");
            }
            if (result.getResultMessage() != null) {
                DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> LevelManager.getPlayerLevelSourceNumber$lambda$0(result));
            }
            Location location = useLocation2;
            Intrinsics.checkNotNull(location);
            origLevelSource = (float)location.distance(player.getLocation());
        } else if (StringsKt.equals("%bed-distance%", variableToUse, true)) {
            Location useLocation = player.getRespawnLocation();
            homeNameUsed = "bed";
            if (useLocation == null || useLocation.getWorld() != player.getWorld()) {
                PlayerNetherOrWorldSpawnResult result = Utils.INSTANCE.getPortalOrWorldSpawn(player);
                useLocation = result.getLocation();
                homeNameUsed = result.isWorldPortalLocation() ? "world-portal" : (result.isNetherPortalLocation() ? "nether-portal" : "spawn");
            }
            Location location = useLocation;
            Intrinsics.checkNotNull(location);
            origLevelSource = (float)location.distance(player.getLocation());
        } else {
            Location l;
            boolean usePlayerLevel = false;
            String papiResult = null;
            if (ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
                papiResult = ExternalCompatibilityManager.Companion.getPapiPlaceholder(player, variableToUse, lmEntity.getInvalidPlaceholderReplacement());
                if (((CharSequence)papiResult).length() == 0) {
                    Location location = player.getLocation();
                    Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                    l = location;
                    DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> LevelManager.getPlayerLevelSourceNumber$lambda$1(variableToUse, player, l));
                    usePlayerLevel = true;
                }
            } else {
                Log.INSTANCE.war("PlaceHolderAPI is not installed, unable to get variable " + variableToUse);
                usePlayerLevel = true;
            }
            if (usePlayerLevel) {
                origLevelSource = player.getLevel();
            } else {
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                l = location;
                CharSequence useLocation2 = papiResult;
                if (useLocation2 == null || useLocation2.length() == 0) {
                    origLevelSource = player.getLevel();
                    DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> LevelManager.getPlayerLevelSourceNumber$lambda$2(variableToUse, player, l));
                } else if (Utils.INSTANCE.isDouble(papiResult)) {
                    float useLocation2;
                    try {
                        useLocation2 = Float.parseFloat(papiResult);
                    }
                    catch (Exception exception) {
                        useLocation2 = player.getLevel();
                    }
                    origLevelSource = useLocation2;
                } else {
                    PlayerLevelSourceResult result = new PlayerLevelSourceResult(papiResult);
                    result.setHomeNameUsed(homeNameUsed);
                    return result;
                }
            }
        }
        PlayerLevelSourceResult sourceResult = new PlayerLevelSourceResult(origLevelSource);
        Integer maxRandomVariance = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMaxRandomVariance(lmEntity);
        if (maxRandomVariance != null) {
            sourceResult.setRandomVarianceResult(Float.valueOf(ThreadLocalRandom.current().nextInt(0, maxRandomVariance + 1)));
            if (ThreadLocalRandom.current().nextBoolean()) {
                Float f = sourceResult.getRandomVarianceResult();
                Intrinsics.checkNotNull(f);
                sourceResult.setRandomVarianceResult(Float.valueOf(f.floatValue() * (float)-1));
            }
        }
        sourceResult.setHomeNameUsed(homeNameUsed);
        return sourceResult;
    }

    @NotNull
    public final MinAndMaxHolder getMinAndMaxLevels(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        int minLevel = main.getRulesManager().getRuleMobMinLevel(lmInterface);
        int maxLevel = main.getRulesManager().getRuleMobMaxLevel(lmInterface);
        maxLevel = RangesKt.coerceAtLeast(maxLevel, 0);
        minLevel = RangesKt.coerceAtMost(minLevel, maxLevel);
        return new MinAndMaxHolder(minLevel, maxLevel);
    }

    public final void setLevelledItemDrops(@NotNull LivingEntityWrapper lmEntity, @NotNull List<ItemStack> currentDrops, boolean disableItemBoost) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(currentDrops, "currentDrops");
        int vanillaDrops = currentDrops.size();
        List customDrops = new ArrayList();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        boolean doNotMultiplyDrops = disableItemBoost || main.getRulesManager().getRuleCheckIfNoDropMultiplierEntitiy(lmEntity);
        boolean hasOverride = false;
        if (lmEntity.getLockedCustomDrops() != null || main.getRulesManager().getRuleUseCustomDropsForMob(lmEntity).getUseDrops()) {
            CustomDropResult dropResult = main.getCustomDropsHandler().getCustomItemDrops(lmEntity, customDrops, false);
            MythicMobsMobInfo mmInfo = MythicMobUtils.INSTANCE.getMythicMobInfo(lmEntity);
            if (mmInfo != null && mmInfo.getPreventOtherDrops()) {
                hasOverride = true;
            }
            if (dropResult.getHasOverride()) {
                hasOverride = true;
            }
            if (hasOverride) {
                this.removeVanillaDrops(lmEntity, currentDrops);
            }
        }
        int additionUsed = 0;
        if (!doNotMultiplyDrops && !((Collection)currentDrops).isEmpty()) {
            float additionValue = main.getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CUSTOM_ITEM_DROP, 2.0f).getMultiplierAmount();
            if (additionValue == Float.MIN_VALUE) {
                DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, LevelManager::setLevelledItemDrops$lambda$0);
                this.removeVanillaDrops(lmEntity, currentDrops);
                return;
            }
            additionUsed = MathKt.roundToInt(additionValue);
            List itemsToNotMultiply = new ArrayList();
            if (lmEntity.getLivingEntity().getEquipment() != null) {
                itemsToNotMultiply.addAll((Collection)this.removePickedUpItems(lmEntity, currentDrops));
            }
            for (ItemStack currentDrop : currentDrops) {
                boolean skipItem = false;
                Iterator iterator2 = itemsToNotMultiply.iterator();
                while (iterator2.hasNext()) {
                    ItemStack itemToSkip = (ItemStack)iterator2.next();
                    if (!itemToSkip.isSimilar(currentDrop)) continue;
                    skipItem = true;
                    iterator2.remove();
                }
                if (skipItem) continue;
                this.multiplyDrop(lmEntity, currentDrop, additionValue);
            }
        }
        if (!((Collection)customDrops).isEmpty()) {
            currentDrops.addAll(customDrops);
        }
        String nameWithOverride = hasOverride ? " (override), " : "";
        int additionUsedFinal = additionUsed;
        DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, () -> LevelManager.setLevelledItemDrops$lambda$1(nameWithOverride, vanillaDrops, currentDrops, additionUsedFinal));
    }

    public final void multiplyDrop(@NotNull LivingEntityWrapper lmEntity, @NotNull ItemStack currentDrop, float addition) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(currentDrop, "currentDrop");
        MobDataManager mobDataManager = LevelledMobs.Companion.getInstance().getMobDataManager();
        Material material = currentDrop.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        if (mobDataManager.isLevelledDropManaged(material)) {
            DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, LevelManager::multiplyDrop$lambda$0);
            return;
        }
        int oldAmount = currentDrop.getAmount();
        int useAmount = RangesKt.coerceAtMost(MathKt.roundToInt((float)currentDrop.getAmount() + (float)currentDrop.getAmount() * addition), currentDrop.getMaxStackSize());
        currentDrop.setAmount(useAmount);
        DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, () -> LevelManager.multiplyDrop$lambda$1(currentDrop, oldAmount, addition));
    }

    private final List<ItemStack> removePickedUpItems(LivingEntityWrapper lmEntity, List<ItemStack> drops) {
        List removedItems = new ArrayList();
        List<ItemStack> pickedUpItems = new PickedUpEquipment(lmEntity).getMobPickedUpItems();
        if (pickedUpItems.isEmpty()) {
            return removedItems;
        }
        ListIterator<ItemStack> iteratorPickedUpItems = pickedUpItems.listIterator();
        block0: while (iteratorPickedUpItems.hasNext()) {
            ItemStack foundItem = iteratorPickedUpItems.next();
            for (ItemStack mobItem : drops) {
                if (!mobItem.isSimilar(foundItem)) continue;
                iteratorPickedUpItems.remove();
                removedItems.add(mobItem);
                continue block0;
            }
        }
        return removedItems;
    }

    /*
     * Unable to fully structure code
     */
    public final void removeVanillaDrops(@NotNull LivingEntityWrapper lmEntity, @NotNull List<ItemStack> drops) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(drops, "drops");
        hadSaddle = false;
        itemsToKeep = new ArrayList<E>();
        if (!(lmEntity.getLivingEntity() instanceof ChestedHorse)) ** GOTO lbl-1000
        v0 = lmEntity.getLivingEntity();
        Intrinsics.checkNotNull(v0, "null cannot be cast to non-null type org.bukkit.entity.ChestedHorse");
        if (((ChestedHorse)v0).isCarryingChest()) {
            v1 = lmEntity.getLivingEntity();
            Intrinsics.checkNotNull(v1, "null cannot be cast to non-null type org.bukkit.entity.ChestedHorse");
            v2 = ((ChestedHorse)v1).getInventory();
            Intrinsics.checkNotNullExpressionValue(v2, "getInventory(...)");
            inv = v2;
            itemsToKeep.add(new ItemStack(Material.CHEST));
            v3 = inv.getContents();
            Intrinsics.checkNotNullExpressionValue(v3, "getContents(...)");
            for (ItemStack item : v3) {
                if (item == null) continue;
                itemsToKeep.add(item);
            }
        } else if (lmEntity.getLivingEntity() instanceof Vehicle) {
            for (ItemStack itemStack : drops) {
                if (itemStack.getType() != Material.SADDLE) continue;
                hadSaddle = true;
                break;
            }
        }
        if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            pickedUpItems = new PickedUpEquipment(lmEntity).getMobPickedUpItems();
            itemsToKeep.addAll((Collection)pickedUpItems);
        }
        drops.clear();
        drops.addAll(itemsToKeep);
        if (hadSaddle) {
            drops.add(new ItemStack(Material.SADDLE));
        }
    }

    public final int getLevelledExpDrops(@NotNull LivingEntityWrapper lmEntity, double xp) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (lmEntity.isLevelled()) {
            float dropAddition = LevelledMobs.Companion.getInstance().getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CUSTOM_XP_DROP, 3.0f).getMultiplierAmount();
            double newXp = 0.0;
            if (dropAddition == Float.MIN_VALUE) {
                DebugManager.Companion.log(DebugType.SET_LEVELLED_XP_DROPS, lmEntity, () -> LevelManager.getLevelledExpDrops$lambda$0(xp));
                return 0;
            }
            if (dropAddition > -1.0f) {
                newXp = MathKt.roundToInt(xp + xp * (double)dropAddition);
            }
            int newXpFinal = (int)newXp;
            DebugManager.Companion.log(DebugType.SET_LEVELLED_XP_DROPS, lmEntity, () -> LevelManager.getLevelledExpDrops$lambda$1(xp, newXpFinal));
            return (int)newXp;
        }
        return (int)xp;
    }

    @NotNull
    public final NametagResult getNametag(@NotNull LivingEntityWrapper lmEntity, boolean isDeathNametag) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        return this.getNametag(lmEntity, isDeathNametag, false);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final NametagResult getNametag(@NotNull LivingEntityWrapper lmEntity, boolean isDeathNametag, boolean preserveMobName) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
                usePreserveMobName = preserveMobName;
                nametag = null;
                customDeathMessage = null;
                main = LevelledMobs.Companion.getInstance();
                if (!isDeathNametag) break block6;
                nametag = new StringReplacer(main.getRulesManager().getRuleNametagCreatureDeath(lmEntity));
                break block7;
            }
            this.checkLockedNametag(lmEntity);
            if (lmEntity.getLockedNametag() == null) ** GOTO lbl-1000
            v0 = lmEntity.getLockedNametag();
            Intrinsics.checkNotNull(v0);
            if (((CharSequence)v0).length() == 0) lbl-1000:
            // 2 sources

            {
                v1 = main.getRulesManager().getRuleNametag(lmEntity);
            } else {
                v2 = lmEntity.getLockedNametag();
                v1 = v2;
                Intrinsics.checkNotNull(v2);
            }
            nametagText = v1;
            nametag = new StringReplacer(nametagText);
        }
        if (StringsKt.equals("disabled", nametag.getText(), true) || StringsKt.equals("none", nametag.getText(), true)) {
            return new NametagResult(null);
        }
        if (isDeathNametag && !((var9_10 = (CharSequence)(deathMessage = main.getRulesManager().getDeathMessage(lmEntity))) == null || var9_10.length() == 0)) {
            nametag = new StringReplacer(StringsKt.replace$default(deathMessage, "%death_nametag%", nametag.getText(), false, 4, null));
            v3 = player = lmEntity.getAssociatedPlayer();
            nametag.replace("%player%", (String)(v3 != null ? v3.getName() + "&r" : ""));
            nametag.setText(this.replaceStringPlaceholders(nametag.getText(), lmEntity, true, player, false));
            usePreserveMobName = true;
            v4 = customDeathMessage = nametag.contains("{DisplayName}") != false ? main.getRulesManager().getRuleNametagCreatureDeath(lmEntity) : nametag.getText();
        }
        if (nametag.isEmpty()) {
            useCustomNameForNametags = main.getHelperSettings().getBoolean("use-customname-for-mob-nametags");
            return useCustomNameForNametags != false ? new NametagResult(lmEntity.getTypeName()) : new NametagResult(lmEntity.getLivingEntity().getCustomName());
        }
        if (!lmEntity.isLevelled()) {
            nametag.setText("");
        }
        return this.updateNametag(lmEntity, nametag, usePreserveMobName, customDeathMessage);
    }

    @NotNull
    public final NametagResult updateNametag(@NotNull LivingEntityWrapper lmEntity, @NotNull StringReplacer nametag, boolean preserveMobName, @Nullable String customDeathMessage) {
        HealthIndicator indicator;
        String string;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(nametag, "nametag");
        if (nametag.isEmpty()) {
            NametagResult result = new NametagResult(nametag.getText());
            result.setCustomDeathMessage(customDeathMessage);
            return result;
        }
        this.checkLockedNametag(lmEntity);
        if (lmEntity.getLockedOverrideName() == null) {
            string = LevelledMobs.Companion.getInstance().getRulesManager().getRuleEntityOverriddenName(lmEntity, false);
        } else {
            String string2 = lmEntity.getLockedOverrideName();
            string = string2;
            Intrinsics.checkNotNull(string2);
        }
        String overridenName = string;
        this.replaceStringPlaceholders(nametag, lmEntity, false, null, preserveMobName);
        Object indicatorStr = "";
        String colorOnly = "";
        if ((StringsKt.contains$default((CharSequence)nametag.getText(), "%health-indicator%", false, 2, null) || StringsKt.contains$default((CharSequence)nametag.getText(), "%health-indicator-color%", false, 2, null)) && (indicator = LevelledMobs.Companion.getInstance().getRulesManager().getRuleNametagIndicator(lmEntity)) != null) {
            HealthIndicator.HealthIndicatorResult result = indicator.formatHealthIndicator(lmEntity);
            indicatorStr = result.getFormattedString() + "&r";
            colorOnly = result.getColorOnly();
        }
        nametag.replace("%health-indicator%", (String)indicatorStr);
        nametag.replace("%health-indicator-color%", colorOnly);
        if (StringsKt.contains$default((CharSequence)nametag.getText(), "%", false, 2, null) && ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
            nametag.setText(ExternalCompatibilityManager.Companion.getPapiPlaceholder(lmEntity.getAssociatedPlayer(), nametag.getText(), lmEntity.getInvalidPlaceholderReplacement()));
        }
        NametagResult result = new NametagResult(nametag.getText());
        result.setOverriddenName(overridenName);
        result.setCustomDeathMessage(customDeathMessage);
        result.setKillerMob(lmEntity.getLivingEntity());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLockedNametag(LivingEntityWrapper lmEntity) {
        PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            block9: {
                block7: {
                    block8: {
                        boolean bl = false;
                        Integer doLockSettings = null;
                        if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER)) break block7;
                        doLockSettings = (Integer)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER);
                        if (doLockSettings == null) break block8;
                        int n = 1;
                        if (doLockSettings == n) break block9;
                    }
                    return;
                }
                return;
            }
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedNametag(), PersistentDataType.STRING)) {
                lmEntity.setLockedNametag((String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedNametag(), PersistentDataType.STRING));
            }
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedNameOverride(), PersistentDataType.STRING)) {
                lmEntity.setLockedOverrideName((String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedNameOverride(), PersistentDataType.STRING));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void getAttributesCache(LivingEntityWrapper lmEntity, StringReplacer str) {
        if (lmEntity.getAttributeValuesCache() != null) {
            return;
        }
        List whichOnes = new ArrayList();
        for (Map.Entry<String, Attribute> placeholder : this.attributeStringList.entrySet()) {
            if (!StringsKt.contains$default((CharSequence)str.getText(), placeholder.getKey(), false, 2, null)) continue;
            whichOnes.add(placeholder.getValue());
        }
        MobDataManager.Companion.getInstance().getAllAttributeValues(lmEntity, whichOnes);
    }

    @NotNull
    public final String replaceStringPlaceholdersForFormulas(@NotNull String text, @NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        StringReplacer str = new StringReplacer(text);
        if (StringsKt.contains((CharSequence)str.getText(), "%level-ratio%", true)) {
            Integer n = lmEntity.getMobLevel();
            int mobLevel = n != null ? n.intValue() : lmEntity.getGetMobLevel();
            float f = RulesManager.Companion.getInstance().getRuleMobMaxLevel(lmEntity);
            float minLevel = RulesManager.Companion.getInstance().getRuleMobMinLevel(lmEntity);
            if (mobLevel == 0 || f == 0.0f) {
                str.replace("%level-ratio%", "0");
                DebugManager.Companion.log(DebugType.LEVEL_RATIO, lmEntity, LevelManager::replaceStringPlaceholdersForFormulas$lambda$0);
            } else {
                float newValue = 0.0f;
                float part1 = (float)mobLevel - minLevel;
                float part2 = f - minLevel;
                newValue = part2 == 0.0f ? 1.0f : (part1 == 0.0f ? 0.0f : RangesKt.coerceAtLeast(part1 / part2, 0.0f));
                str.replace("%level-ratio%", String.valueOf(newValue));
                DebugManager.Companion.log(DebugType.LEVEL_RATIO, lmEntity, () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$1(mobLevel, minLevel, f, newValue));
            }
        }
        str.replaceIfExists("%ranged-attack-damage%", () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$2(lmEntity));
        for (Map.Entry<String, StrategyType> entry : this.strategyPlaceholders.entrySet()) {
            str.replaceIfExists(entry.getKey(), () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$3(lmEntity, entry));
        }
        for (String string : RulesManager.Companion.getInstance().getAllCustomStrategyPlaceholders()) {
            str.replaceIfExists(string, () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$4(lmEntity, string));
        }
        this.getAttributesCache(lmEntity, str);
        str.replaceIfExists("%distance-from-spawn%", () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$5(lmEntity));
        str.replace("%hotspots-mod%", "0");
        str.replace("%barricades-mod%", "0");
        str.replaceIfExists("%creeper-blast-damage%", () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$6(lmEntity));
        for (Map.Entry entry : this.attributeStringList.entrySet()) {
            str.replaceIfExists((String)entry.getKey(), () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$7(lmEntity, entry));
        }
        str.replaceIfExists("%item-drop%", LevelManager::replaceStringPlaceholdersForFormulas$lambda$8);
        str.replaceIfExists("%xp-drop%", LevelManager::replaceStringPlaceholdersForFormulas$lambda$9);
        if (!StringsKt.contains$default((CharSequence)str.getText(), "%", false, 2, null)) {
            return str.getText();
        }
        return this.replaceStringPlaceholders(str, lmEntity, true, lmEntity.getAssociatedPlayer(), true);
    }

    @NotNull
    public final String replaceStringPlaceholders(@NotNull String text, @NotNull LivingEntityWrapper lmEntity, boolean usePAPI, @Nullable Player player, boolean preserveMobName) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        return this.replaceStringPlaceholders(new StringReplacer(text), lmEntity, usePAPI, player, preserveMobName);
    }

    private final String replaceStringPlaceholders(StringReplacer text, LivingEntityWrapper lmEntity, boolean usePAPI, Player player, boolean preserveMobName) {
        RulesManager rm;
        String tieredPlaceholder;
        Object playerName;
        Object object;
        Object playerId;
        double maxHealth = this.getMobAttributeValue(lmEntity);
        double entityHealth = this.getMobHealth(lmEntity);
        int entityHealthRounded = entityHealth < 1.0 && entityHealth > 0.0 ? 1 : (int)Utils.INSTANCE.round(entityHealth);
        String roundedMaxHealth = String.valueOf(Utils.INSTANCE.round(maxHealth));
        String roundedMaxHealthInt = String.valueOf((int)Utils.INSTANCE.round(maxHealth));
        double percentHealthTemp = MathKt.roundToInt(entityHealth / maxHealth * 100.0);
        int percentHealth = percentHealthTemp < 1.0 ? 1 : (int)percentHealthTemp;
        Object object2 = player;
        if (object2 == null || (object2 = object2.getUniqueId()) == null || (object2 = ((UUID)object2).toString()) == null) {
            object2 = playerId = "";
        }
        if ((object = player) == null || (object = object.getName()) == null) {
            object = playerName = "";
        }
        if ((tieredPlaceholder = (rm = LevelledMobs.Companion.getInstance().getRulesManager()).getRuleTieredPlaceholder(lmEntity)) == null) {
            tieredPlaceholder = "";
        }
        text.replaceIfExists("%displayname%", () -> LevelManager.replaceStringPlaceholders$lambda$0(lmEntity, rm, preserveMobName));
        text.replace("%mob-lvl%", lmEntity.getGetMobLevel());
        text.replace("%entity-name%", Utils.INSTANCE.capitalize(StringsKt.replace$default(lmEntity.getTypeName(), "_", " ", false, 4, null)));
        text.replace("%entity-name-raw%", lmEntity.getTypeName());
        text.replace("%entity-health%", Utils.INSTANCE.round(entityHealth));
        text.replace("%entity-health-rounded%", entityHealthRounded);
        text.replaceIfExists("%entity-health-rounded-up%", () -> LevelManager.replaceStringPlaceholders$lambda$1(entityHealth));
        text.replace("%entity-max-health%", roundedMaxHealth);
        text.replace("%entity-max-health-rounded%", roundedMaxHealthInt);
        text.replaceIfExists("%entity-max-health-rounded-up%", () -> LevelManager.replaceStringPlaceholders$lambda$2(maxHealth));
        this.getHealthPercentRemaining(entityHealth, maxHealth, text);
        text.replaceIfExists("%base-health%", () -> LevelManager.replaceStringPlaceholders$lambda$3(lmEntity));
        text.replace("%heart-symbol%", "\u2764");
        text.replace("%tiered%", tieredPlaceholder);
        text.replace("%wg-region%", lmEntity.getWgRegionName());
        text.replace("%world%", lmEntity.getWorldName());
        text.replaceIfExists("%location%", () -> LevelManager.replaceStringPlaceholders$lambda$4(lmEntity));
        text.replaceIfExists("%min-level%", () -> LevelManager.replaceStringPlaceholders$lambda$5(rm, lmEntity));
        text.replaceIfExists("%max-level%", () -> LevelManager.replaceStringPlaceholders$lambda$6(rm, lmEntity));
        text.replace("%health%-percent%", percentHealth);
        text.replace("%x%", lmEntity.getLivingEntity().getLocation().getBlockX());
        text.replace("%y%", lmEntity.getLivingEntity().getLocation().getBlockY());
        text.replace("%z%", lmEntity.getLivingEntity().getLocation().getBlockZ());
        text.replace("%player-uuid%", (String)playerId);
        text.replace("%player%", (String)playerName);
        if (text.contains("%rand_")) {
            RandomVarianceGenerator.INSTANCE.generateVariance(lmEntity, text);
        }
        for (Map.Entry<String, ExternalPluginDetection> placeholder : ExternalCompatibilityManager.Companion.getInstance().getExternalPluginPlaceholders().entrySet()) {
            text.replaceIfExists(placeholder.getKey(), () -> LevelManager.replaceStringPlaceholders$lambda$7(placeholder, lmEntity));
        }
        if (usePAPI && text.contains("%") && ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
            text.setText(ExternalCompatibilityManager.Companion.getPapiPlaceholder(player, text.getText(), lmEntity.getInvalidPlaceholderReplacement()));
        }
        return text.getText();
    }

    private final void getHealthPercentRemaining(double currentHealth, double maxHealth, StringReplacer text) {
        int start = StringsKt.indexOf$default((CharSequence)text.getText(), "%entity-max-health-percent", 0, false, 6, null);
        if (start < 0) {
            return;
        }
        int end = StringsKt.indexOf$default((CharSequence)text.getText(), "%", start + 25, false, 4, null);
        if (end < 0) {
            return;
        }
        float percentHealth = (float)currentHealth / (float)maxHealth * 100.0f;
        String string = text.getText().substring(start, end);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String fullText = string;
        String string2 = fullText.substring(fullText.length() - 2);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String optional = string2;
        int digits = 2;
        if (optional.charAt(0) == '-' && Character.isDigit(optional.charAt(1))) {
            digits = CharsKt.digitToInt(optional.charAt(1));
        }
        text.setText(StringsKt.replace$default(text.getText(), fullText, digits == 0 ? String.valueOf(MathKt.roundToInt(percentHealth)) : String.valueOf(Utils.INSTANCE.round(percentHealth, digits)), false, 4, null));
    }

    public final void updateNametagWithDelay(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> LevelManager.updateNametagWithDelay$lambda$0(this, lmEntity));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.runDelayed(1L);
    }

    public final void updateNametag(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        NametagResult nametag = this.getNametag(lmEntity, false, true);
        List list = lmEntity.getLivingEntity().getWorld().getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        QueueItem queueItem = new QueueItem(lmEntity, nametag, list);
        LevelledMobs.Companion.getInstance().getNametagQueueManager().addToQueue(queueItem);
    }

    public final void updateNametag(@NotNull LivingEntityWrapper lmEntity, @NotNull NametagResult nametag, @NotNull List<Player> players) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(nametag, "nametag");
        Intrinsics.checkNotNullParameter(players, "players");
        LevelledMobs.Companion.getInstance().getNametagQueueManager().addToQueue(new QueueItem(lmEntity, nametag, players));
    }

    public final void startNametagAutoUpdateTask() {
        Log.INSTANCE.inf("&fTasks: &7Starting async nametag auto update task...");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        long period = main.getHelperSettings().getInt("async-task-update-period", 6);
        this.doCheckMobHash = main.getHelperSettings().getBoolean("check-mob-hash", true);
        Runnable runnable2 = () -> LevelManager.startNametagAutoUpdateTask$lambda$0(this);
        if (main.getVer().isRunningFolia()) {
            Consumer<ScheduledTask> task = arg_0 -> LevelManager.startNametagAutoUpdateTask$lambda$1(runnable2, arg_0);
            this.nametagTimerTask = new SchedulerResult(Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)main, task, 0L, period, TimeUnit.SECONDS));
        } else {
            this.nametagTimerTask = new SchedulerResult(Bukkit.getScheduler().runTaskTimer((Plugin)main, runnable2, 0L, (long)20 * period));
        }
    }

    private final void checkLEWCache() {
        if (this.lastLEWCacheClearing == null) {
            this.lastLEWCacheClearing = Instant.now();
            return;
        }
        Instant instant = this.lastLEWCacheClearing;
        Intrinsics.checkNotNull(instant);
        long duration = instant.until(Instant.now(), ChronoUnit.MILLIS);
        Long l = LevelledMobs.Companion.getInstance().getHelperSettings().getIntTimeUnitMS("lew-cache-clear-period", 180000L);
        Intrinsics.checkNotNull(l);
        long configDuration = l;
        if (duration >= configDuration) {
            DebugManager.Companion.log(DebugType.DEVELOPER_LEW_CACHE, () -> LevelManager.checkLEWCache$lambda$0(configDuration));
            this.lastLEWCacheClearing = Instant.now();
            LivingEntityWrapper.Companion.clearCache();
        }
    }

    private final void enumerateNearbyEntities() {
        this.entitiesPerPlayer.clear();
        this.asyncRunningCount.set(0);
        Ref.DoubleRef checkDistance = new Ref.DoubleRef();
        checkDistance.element = this.entitySpawnListener.getMobCheckDistance();
        for (Player player : Bukkit.getOnlinePlayers()) {
            List entities;
            if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
                this.asyncRunningCount.getAndIncrement();
                SchedulerWrapper scheduler = new SchedulerWrapper((Entity)player, () -> LevelManager.enumerateNearbyEntities$lambda$0(checkDistance, player, this));
                scheduler.run();
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(player.getNearbyEntities(checkDistance.element, checkDistance.element, checkDistance.element), "getNearbyEntities(...)");
            this.entitiesPerPlayer.put(player, entities);
            this.runNametagCheckASync();
        }
    }

    public final void startNametagTimer() {
        SchedulerWrapper scheduler = new SchedulerWrapper(LevelManager::startNametagTimer$lambda$0);
        scheduler.runTaskTimerAsynchronously(0L, 1000L);
    }

    private final void runNametagCheckASync() {
        ConcurrentHashMap entityToPlayer = new ConcurrentHashMap();
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            for (Player entry : this.entitiesPerPlayer.keySet()) {
                List<Entity> list = this.entitiesPerPlayer.get(entry);
                Intrinsics.checkNotNull(list);
                var4_8 = list.iterator();
                while (var4_8.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue(var4_8.next(), "next(...)");
                    Consumer<ScheduledTask> task = arg_0 -> LevelManager.runNametagCheckASync$lambda$0(this, entity, entry, entityToPlayer, arg_0);
                    entity.getScheduler().run((Plugin)LevelledMobs.Companion.getInstance(), task, null);
                }
            }
        } else {
            for (Player player : this.entitiesPerPlayer.keySet()) {
                List<Entity> list = this.entitiesPerPlayer.get(player);
                Intrinsics.checkNotNull(list);
                var4_8 = list.iterator();
                while (var4_8.hasNext()) {
                    Intrinsics.checkNotNullExpressionValue(var4_8.next(), "next(...)");
                    this.checkEntity(entity, player, entityToPlayer);
                }
            }
        }
        for (Map.Entry entry : ((Map)entityToPlayer).entrySet()) {
            LivingEntityWrapper lmEntity = (LivingEntityWrapper)entry.getKey();
            List value = (List)entry.getValue();
            if (entityToPlayer.containsKey(lmEntity)) {
                this.checkEntityForPlayerLevelling(lmEntity, value);
            }
            lmEntity.free();
        }
        this.entitiesPerPlayer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkEntity(Entity entity, Player player, Map<LivingEntityWrapper, List<Player>> entityToPlayer) {
        if (!entity.isValid()) {
            return;
        }
        if (!(entity instanceof LivingEntity) || entity instanceof Player || !((LivingEntity)entity).isValid()) {
            return;
        }
        if (((LivingEntity)entity).getTicksLived() < 30) {
            return;
        }
        boolean wrapperHasReference = false;
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
        lmEntity.setAssociatedPlayer(player);
        if (this.doCheckMobHash && Utils.INSTANCE.checkIfMobHashChanged(lmEntity)) {
            lmEntity.setReEvaluateLevel(true);
            lmEntity.setRulesForceAll(true);
            lmEntity.setWasPreviouslyLevelled(lmEntity.isLevelled());
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (lmEntity.isLevelled()) {
            boolean skipLevelling;
            InternalSpawnReason internalSpawnReason = lmEntity.getSpawnReason().getInternalSpawnReason(lmEntity);
            boolean bl = skipLevelling = internalSpawnReason == InternalSpawnReason.LM_SPAWNER || internalSpawnReason == InternalSpawnReason.LM_SUMMON;
            if (main.getRulesManager().isPlayerLevellingEnabled() && !lmEntity.isRulesForceAll() && !this.checkIfReadyForRelevelling(lmEntity)) {
                skipLevelling = true;
            }
            if (main.getRulesManager().isPlayerLevellingEnabled() && !skipLevelling) {
                List<Player> list;
                boolean hasKey = entityToPlayer.containsKey(lmEntity);
                if (hasKey) {
                    List<Player> list2 = entityToPlayer.get(lmEntity);
                    Intrinsics.checkNotNull(list2);
                    list = list2;
                } else {
                    list = new ArrayList();
                }
                List<Player> players = list;
                players.add(player);
                if (!hasKey) {
                    entityToPlayer.put(lmEntity, players);
                }
                wrapperHasReference = true;
            }
            if (!lmEntity.isPopulated()) {
                return;
            }
            List<NametagVisibilityEnum> nametagVisibilityEnums = lmEntity.getNametagVisibilityEnum();
            long nametagVisibleTime = lmEntity.getNametagCooldownTime();
            if (nametagVisibleTime > 0L && nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.TARGETED) && lmEntity.getLivingEntity().hasLineOfSight((Entity)player)) {
                if (lmEntity.getPlayersNeedingNametagCooldownUpdate() == null) {
                    lmEntity.setPlayersNeedingNametagCooldownUpdate(new HashSet());
                }
                Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                set.add(player);
            }
            this.checkLevelledEntity(lmEntity, player);
        } else {
            boolean wasBabyMob = false;
            PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
            synchronized (persistentDataContainer2) {
                boolean bl = false;
                wasBabyMob = lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getWasBabyMobKey(), PersistentDataType.INTEGER);
                Unit unit = Unit.INSTANCE;
            }
            if (lmEntity.isPopulated()) {
                LevellableState levellableState = main.getLevelInterface().getLevellableState(lmEntity);
                if (!lmEntity.isBabyMob() && wasBabyMob && levellableState == LevellableState.ALLOWED) {
                    DebugManager.Companion.log(DebugType.ENTITY_MISC, lmEntity, () -> LevelManager.checkEntity$lambda$1(lmEntity));
                    main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
                } else if (levellableState == LevellableState.ALLOWED) {
                    main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
                }
            }
        }
        if (!wrapperHasReference) {
            lmEntity.free();
        }
    }

    private final boolean checkIfReadyForRelevelling(LivingEntityWrapper lmEntity) {
        PlayerLevellingStrategy opts;
        PlayerLevellingStrategy playerLevellingStrategy = opts = LevelledMobs.Companion.getInstance().getRulesManager().getRulePlayerLevellingOptions(lmEntity);
        if ((playerLevellingStrategy != null ? playerLevellingStrategy.getPreserveEntityTime() : null) == null) {
            return true;
        }
        if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLastDamageTime(), PersistentDataType.LONG)) {
            return true;
        }
        Long l = (Long)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLastDamageTime(), PersistentDataType.LONG);
        if (l == null) {
            return true;
        }
        long lastLevelledTime = l;
        Instant levelledTime = Instant.ofEpochMilli(lastLevelledTime);
        Intrinsics.checkNotNull(levelledTime);
        long l2 = Utils.INSTANCE.getMillisecondsFromInstant(levelledTime);
        Long l3 = opts.getPreserveEntityTime();
        Intrinsics.checkNotNull(l3);
        return l2 > l3;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEntityForPlayerLevelling(LivingEntityWrapper lmEntity, List<? extends Player> players) {
        void $this$sortedBy$iv;
        LivingEntity mob = lmEntity.getLivingEntity();
        Sequence<Pair> sequence = SequencesKt.map(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)players), arg_0 -> LevelManager.checkEntityForPlayerLevelling$lambda$0(mob, arg_0)), LevelManager::checkEntityForPlayerLevelling$lambda$1), arg_0 -> LevelManager.checkEntityForPlayerLevelling$lambda$2(mob, arg_0));
        boolean $i$f$sortedBy = false;
        Sequence<Player> sortedPlayersSequence = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
            }
        }), LevelManager::checkEntityForPlayerLevelling$lambda$4);
        if (MainCompanion.Companion.getInstance().getExcludePlayersInCreative()) {
            sortedPlayersSequence = SequencesKt.filter(sortedPlayersSequence, LevelManager::checkEntityForPlayerLevelling$lambda$5);
        }
        List<Player> sortedPlayers = SequencesKt.toMutableList(sortedPlayersSequence);
        Player closestPlayer = null;
        for (Player player : sortedPlayers) {
            if (ExternalCompatibilityManager.Companion.isMobOfCitizens((LivingEntity)player)) continue;
            closestPlayer = player;
            break;
        }
        if (closestPlayer == null) {
            return;
        }
        Instant logonTime = MainCompanion.Companion.getInstance().getRecentlyJoinedPlayerLogonTime(closestPlayer);
        if (logonTime != null) {
            if (Utils.INSTANCE.getMillisecondsFromInstant(logonTime) < 5000L) {
                return;
            }
            MainCompanion.Companion.getInstance().removeRecentlyJoinedPlayer(closestPlayer);
        }
        if (this.doesMobNeedRelevelling(lmEntity, closestPlayer)) {
            lmEntity.setPendingPlayerIdToSet(closestPlayer.getUniqueId().toString());
            lmEntity.setAssociatedPlayer(closestPlayer);
            lmEntity.setReEvaluateLevel(true);
            LevelledMobs.Companion.getInstance().getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
        }
    }

    private final void checkLevelledEntity(LivingEntityWrapper lmEntity, Player player) {
        if (!lmEntity.getLivingEntity().isValid()) {
            return;
        }
        double maxDistance = Math.pow(128.0, 2.0);
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (lmEntity.isRulesForceAll()) {
            main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
        } else if (lmEntity.getLivingEntity().getCustomName() != null && main.getRulesManager().getRuleMobCustomNameStatus(lmEntity) == MobCustomNameStatus.NOT_NAMETAGGED) {
            main.getLevelInterface().removeLevel(lmEntity);
        } else if (lmEntity.isMobTamed() && main.getRulesManager().getRuleMobTamedStatus(lmEntity) == MobTamedStatus.NOT_TAMED) {
            main.getLevelInterface().removeLevel(lmEntity);
        } else if (lmEntity.getLivingEntity().isValid() && location2.getWorld() != null && Intrinsics.areEqual(location2.getWorld(), lmEntity.getWorld()) && lmEntity.getLocation().distanceSquared(location2) <= maxDistance) {
            NametagResult nametag = main.getLevelManager().getNametag(lmEntity, false, true);
            Player[] playerArray = new Player[]{player};
            main.getNametagQueueManager().addToQueue(new QueueItem(lmEntity, nametag, CollectionsKt.mutableListOf(playerArray)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doesMobNeedRelevelling(LivingEntityWrapper lmEntity, Player player) {
        Instant lastCheck;
        Duration duration;
        LivingEntity mob = lmEntity.getLivingEntity();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (lmEntity.getSpawnReason().getInternalSpawnReason(lmEntity) == InternalSpawnReason.LM_SUMMON) {
            return false;
        }
        if (main.getPlayerLevellingMinRelevelTime() > 0L && main.getPlayerLevellingEntities().containsKey(mob) && (duration = Duration.between(lastCheck = main.getPlayerLevellingEntities().get(mob), Instant.now())).toMillis() < main.getPlayerLevellingMinRelevelTime()) {
            return false;
        }
        Object playerId = null;
        if (main.getPlayerLevellingMinRelevelTime() > 0L) {
            ((Map)main.getPlayerLevellingEntities()).put(mob, Instant.now());
        }
        PersistentDataContainer persistentDataContainer = mob.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            block13: {
                boolean bl = false;
                if (mob.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING)) break block13;
                boolean bl2 = true;
                return bl2;
            }
            playerId = mob.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING);
            Unit unit = Unit.INSTANCE;
        }
        if (playerId == null && main.getPlayerLevellingMinRelevelTime() <= 0L) {
            return true;
        }
        if (playerId == null || !Intrinsics.areEqual(player.getUniqueId().toString(), playerId)) {
            return true;
        }
        PlayerLevellingStrategy opts = main.getRulesManager().getRulePlayerLevellingOptions(lmEntity);
        if (Intrinsics.areEqual(player.getUniqueId().toString(), playerId) && opts != null && opts.getGetRecheckPlayers()) {
            String string;
            String string2 = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getPlayerLevellingSourceNumber(), PersistentDataType.STRING);
            if (string2 == null) {
                return true;
            }
            String previousResult = string2;
            CharSequence charSequence = opts.getVariable();
            if (charSequence == null || charSequence.length() == 0) {
                string = "%level%";
            } else {
                String string3 = opts.getVariable();
                string = string3;
                Intrinsics.checkNotNull(string3);
            }
            String variableToUse = string;
            PlayerLevelSourceResult result = this.getPlayerLevelSourceNumber(player, lmEntity, variableToUse);
            String sourceNumberStr = result.isNumericResult() ? String.valueOf(result.getNumericResult()) : result.getStringResult();
            return !Intrinsics.areEqual(previousResult, sourceNumberStr);
        }
        return !Intrinsics.areEqual(player.getUniqueId().toString(), playerId);
    }

    public final void stopNametagAutoUpdateTask() {
        LevelledMobs.Companion.getInstance().getNametagQueueManager().stop();
        if (!LevelledMobs.Companion.getInstance().getNametagQueueManager().getHasNametagSupport()) {
            return;
        }
        if (this.nametagAutoUpdateTask != null) {
            SchedulerResult schedulerResult = this.nametagAutoUpdateTask;
            Intrinsics.checkNotNull(schedulerResult);
            if (!schedulerResult.isCancelled()) {
                Log.INSTANCE.inf("&fTasks: &7Stopping async nametag auto update task...");
                SchedulerResult schedulerResult2 = this.nametagAutoUpdateTask;
                Intrinsics.checkNotNull(schedulerResult2);
                schedulerResult2.cancelTask();
            }
        }
        if (this.nametagTimerTask != null) {
            SchedulerResult schedulerResult = this.nametagTimerTask;
            Intrinsics.checkNotNull(schedulerResult);
            if (!schedulerResult.isCancelled()) {
                SchedulerResult schedulerResult3 = this.nametagTimerTask;
                Intrinsics.checkNotNull(schedulerResult3);
                schedulerResult3.cancelTask();
            }
        }
    }

    private final void applyLevelledAttributes(LivingEntityWrapper lmEntity, List<Addition> additions, List<String> nbtDatas) {
        if (!lmEntity.isLevelled()) {
            return;
        }
        List modInfo = new ArrayList();
        Map<Attribute, AttributeInstance> map = lmEntity.getAttributeValuesCache();
        if (map == null || map.isEmpty()) {
            MobDataManager.getAllAttributeValues$default(MobDataManager.Companion.getInstance(), lmEntity, null, 2, null);
        }
        for (Addition addition : additions) {
            AttributePreMod result;
            Attribute attribute;
            if ((attribute = (switch (WhenMappings.$EnumSwitchMapping$0[addition.ordinal()]) {
                case 1 -> Utils.INSTANCE.getAttribute(AttributeNames.MAX_HEALTH);
                case 2 -> Utils.INSTANCE.getAttribute(AttributeNames.ATTACK_DAMAGE);
                case 3 -> Utils.INSTANCE.getAttribute(AttributeNames.MOVEMENT_SPEED);
                case 4 -> Utils.INSTANCE.getAttribute(AttributeNames.JUMP_STRENGTH);
                case 5 -> Utils.INSTANCE.getAttribute(AttributeNames.ARMOR);
                case 6 -> Utils.INSTANCE.getAttribute(AttributeNames.ARMOR_TOUGHNESS);
                case 7 -> Utils.INSTANCE.getAttribute(AttributeNames.KNOCKBACK_RESISTANCE);
                case 8 -> Utils.INSTANCE.getAttribute(AttributeNames.FLYING_SPEED);
                case 9 -> Utils.INSTANCE.getAttribute(AttributeNames.ATTACK_KNOCKBACK);
                case 10 -> Utils.INSTANCE.getAttribute(AttributeNames.FOLLOW_RANGE);
                case 11 -> {
                    if (lmEntity.getSpawnReason().getMinecraftSpawnReason(lmEntity) == CreatureSpawnEvent.SpawnReason.REINFORCEMENTS) {
                        yield null;
                    }
                    yield Utils.INSTANCE.getAttribute(AttributeNames.SPAWN_REINFORCEMENTS);
                }
                default -> throw new IllegalStateException("Addition must be an Attribute, if so, it has not been considered in this method");
            })) == null || (result = MobDataManager.Companion.getInstance().prepareSetAttributes(lmEntity, attribute, addition)) == null) continue;
            modInfo.add(result);
        }
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> LevelManager.applyLevelledAttributes$lambda$0(lmEntity, modInfo, this, nbtDatas));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.setRunDirectlyInFolia(true);
        scheduler.run();
    }

    private final void applyCreeperBlastRadius(LivingEntityWrapper lmEntity) {
        LivingEntity livingEntity = lmEntity.getLivingEntity();
        Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Creeper");
        Creeper creeper = (Creeper)livingEntity;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        FineTuningAttributes tuning = main.getRulesManager().getFineTuningAttributes(lmEntity);
        if (tuning == null) {
            if (creeper.getExplosionRadius() != 3) {
                creeper.setExplosionRadius(3);
            }
            DebugManager.Companion.log(DebugType.CREEPER_BLAST_RADIUS, lmEntity, LevelManager::applyCreeperBlastRadius$lambda$0);
            return;
        }
        int maxRadius = main.getRulesManager().getRuleCreeperMaxBlastRadius(lmEntity);
        float damage = main.getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CREEPER_BLAST_DAMAGE, 3.0f).getMultiplierAmount();
        if (damage == 0.0f) {
            return;
        }
        int blastRadius = 3 + (int)Math.floor(damage);
        int blastRadiusFinal = blastRadius = RangesKt.coerceAtMost(RangesKt.coerceAtLeast(blastRadius, 0), maxRadius);
        DebugManager.Companion.log(DebugType.CREEPER_BLAST_RADIUS, lmEntity, () -> LevelManager.applyCreeperBlastRadius$lambda$1(damage, maxRadius, blastRadiusFinal));
        creeper.setExplosionRadius(blastRadius);
    }

    private final void applyLevelledEquipment(LivingEntityWrapper lmEntity, int level) {
        if (!lmEntity.isLevelled()) {
            return;
        }
        if (level < 1) {
            return;
        }
        CustomDropsRuleSet customDropsRuleSet = LevelledMobs.Companion.getInstance().getRulesManager().getRuleUseCustomDropsForMob(lmEntity);
        if (!customDropsRuleSet.getUseDrops()) {
            return;
        }
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            this.applyLevelledEquipmentNonAsync(lmEntity, customDropsRuleSet);
            return;
        }
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> LevelManager.applyLevelledEquipment$lambda$0(this, lmEntity, customDropsRuleSet));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.setEntity((Entity)lmEntity.getLivingEntity());
        scheduler.run();
    }

    private final void applyLevelledEquipmentNonAsync(LivingEntityWrapper lmEntity, CustomDropsRuleSet customDropsRuleSet) {
        MythicMobsMobInfo mmInfo = MythicMobUtils.INSTANCE.getMythicMobInfo(lmEntity);
        if (mmInfo != null && mmInfo.getPreventRandomEquipment()) {
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        List items = new ArrayList();
        CustomDropResult dropResult = main.getCustomDropsHandler().getCustomItemDrops(lmEntity, items, true);
        if (items.isEmpty()) {
            return;
        }
        EntityEquipment entityEquipment = lmEntity.getLivingEntity().getEquipment();
        if (entityEquipment == null) {
            return;
        }
        EntityEquipment equipment = entityEquipment;
        if (lmEntity.getLockEntitySettings() && !((Collection)customDropsRuleSet.getUseDropTableIds()).isEmpty()) {
            String customDrops = CollectionsKt.joinToString$default(customDropsRuleSet.getUseDropTableIds(), ";", null, null, 0, null, null, 62, null);
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLockedDropRules(), PersistentDataType.STRING, (Object)customDrops);
            ChunkKillOptions chunkKillOptions = customDropsRuleSet.getChunkKillOptions();
            Intrinsics.checkNotNull(chunkKillOptions);
            if (chunkKillOptions.getDisableVanillaDrops()) {
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLockedDropRulesOverride(), PersistentDataType.INTEGER, (Object)1);
            }
        }
        boolean hadMainItem = false;
        boolean hadPlayerHead = false;
        EquippedItemsInfo equippedItemsInfo = new EquippedItemsInfo();
        Map equippedCountPerGroup = new LinkedHashMap();
        int equippedSoFar = 0;
        Collections.shuffle(dropResult.getStackToItem());
        for (Map.Entry<ItemStack, CustomDropItem> entry : dropResult.getStackToItem()) {
            Material material;
            boolean hasEquipLimits;
            ItemStack itemStack = entry.getKey();
            CustomDropItem item = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(itemStack.getType(), "getType(...)");
            GroupLimits groupLimits = main.getCustomDropsHandler().getGroupLimits(item);
            boolean bl = hasEquipLimits = item.getHasGroupId() && groupLimits != null && groupLimits.getHasCapEquipped();
            if (hasEquipLimits) {
                if (equippedCountPerGroup.containsKey(item.getGroupId())) {
                    Object v = equippedCountPerGroup.get(item.getGroupId());
                    Intrinsics.checkNotNull(v);
                    equippedSoFar = ((Number)v).intValue();
                }
                if (groupLimits.hasReachedCapEquipped(equippedSoFar)) {
                    DebugManager.Companion.log(DebugType.GROUP_LIMITS, lmEntity, () -> LevelManager.applyLevelledEquipmentNonAsync$lambda$0(groupLimits, material, item));
                    continue;
                }
            }
            if (EnchantmentTarget.ARMOR_FEET.includes(material)) {
                equipment.setBoots(itemStack, true);
                equipment.setBootsDropChance(0.0f);
                equippedItemsInfo.setBoots(item.getItemStack());
            } else if (EnchantmentTarget.ARMOR_LEGS.includes(material)) {
                equipment.setLeggings(itemStack, true);
                equipment.setLeggingsDropChance(0.0f);
                equippedItemsInfo.setLeggings(item.getItemStack());
            } else if (EnchantmentTarget.ARMOR_TORSO.includes(material)) {
                equipment.setChestplate(itemStack, true);
                equipment.setChestplateDropChance(0.0f);
                equippedItemsInfo.setChestplate(item.getItemStack());
            } else if (EnchantmentTarget.ARMOR_HEAD.includes(material) || StringsKt.endsWith$default(material.name(), "_HEAD", false, 2, null) || item.getEquipOnHelmet() && !hadPlayerHead) {
                equipment.setHelmet(itemStack, true);
                equipment.setHelmetDropChance(0.0f);
                equippedItemsInfo.setHelmet(item.getItemStack());
                if (material == Material.PLAYER_HEAD) {
                    hadPlayerHead = true;
                }
            } else if (!hadMainItem) {
                equipment.setItemInMainHand(itemStack);
                equipment.setItemInMainHandDropChance(0.0f);
                equippedItemsInfo.setMainHand(item.getItemStack());
                hadMainItem = true;
            } else if (item.getEquipOffhand()) {
                equipment.setItemInOffHand(itemStack);
                equipment.setItemInOffHandDropChance(0.0f);
                equippedItemsInfo.setOffhand(item.getItemStack());
            }
            ++equippedSoFar;
            if (!hasEquipLimits) continue;
            equippedCountPerGroup.put(item.getGroupId(), equippedSoFar);
        }
        equippedItemsInfo.saveEquipment(lmEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final double getMobAttributeValue(LivingEntityWrapper lmEntity) {
        double result = 0.0;
        Object object = LevelledMobs.Companion.getInstance().getAttributeSyncObject();
        synchronized (object) {
            boolean bl = false;
            LivingEntity livingEntity = lmEntity.getLivingEntity();
            Attribute attribute = Utils.INSTANCE.getAttribute(AttributeNames.MAX_HEALTH);
            Intrinsics.checkNotNull(attribute);
            AttributeInstance attrib = livingEntity.getAttribute(attribute);
            if (attrib != null) {
                result = attrib.getValue();
            }
            Unit unit = Unit.INSTANCE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final double getMobHealth(LivingEntityWrapper lmEntity) {
        double result = 0.0;
        Object object = LevelledMobs.Companion.getInstance().getAttributeSyncObject();
        synchronized (object) {
            boolean bl = false;
            result = lmEntity.getLivingEntity().getHealth();
            Unit unit = Unit.INSTANCE;
        }
        return result;
    }

    @Override
    @NotNull
    public LevellableState getLevellableState(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (CollectionsKt.contains((Iterable)this.forcedBlockedEntityTypes, lmInterface.getEntityType())) {
            return LevellableState.DENIED_FORCE_BLOCKED_ENTITY_TYPE;
        }
        if (lmInterface.getApplicableRules().isEmpty()) {
            return LevellableState.DENIED_NO_APPLICABLE_RULES;
        }
        if (!main.getRulesManager().getRuleIsMobAllowedInEntityOverride(lmInterface)) {
            return LevellableState.DENIED_CONFIGURATION_BLOCKED_ENTITY_TYPE;
        }
        if (main.getRulesManager().getRuleMobMaxLevel(lmInterface) < 1) {
            return LevellableState.DENIED_LEVEL_0;
        }
        if (!(lmInterface instanceof LivingEntityWrapper)) {
            return LevellableState.ALLOWED;
        }
        if (((LivingEntityWrapper)lmInterface).isMobOfExternalType()) {
            ((LivingEntityWrapper)lmInterface).invalidateCache();
            if (!main.getRulesManager().getRuleIsMobAllowedInEntityOverride(lmInterface)) {
                return LevellableState.DENIED_CONFIGURATION_BLOCKED_ENTITY_TYPE;
            }
        }
        if (((LivingEntityWrapper)lmInterface).getLivingEntity().getCustomName() != null && main.getRulesManager().getRuleMobCustomNameStatus((LivingEntityWrapper)lmInterface) == MobCustomNameStatus.NOT_NAMETAGGED) {
            return LevellableState.DENIED_CONFIGURATION_CONDITION_NAMETAGGED;
        }
        return LevellableState.ALLOWED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LevellableState getLevellableState(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        try {
            LevellableState levellableState = this.getLevellableState(lmEntity);
            return levellableState;
        }
        finally {
            lmEntity.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void applyLevelToMob(@NotNull LivingEntityWrapper lmEntity, int level, boolean isSummoned, boolean bypassLimits, @Nullable Set<AdditionalLevelInformation> additionalLevelInformation) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        main = LevelledMobs.Companion.getInstance();
        if (!main.getVer().isRunningFolia() && Bukkit.isPrimaryThread()) {
            scheduler = new SchedulerWrapper((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, applyLevelToMob$lambda$0(io.github.arcaneplugins.levelledmobs.managers.LevelManager io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper int boolean boolean java.util.Set ), ()V)((LevelManager)this, (LivingEntityWrapper)lmEntity, (int)level, (boolean)isSummoned, (boolean)bypassLimits, additionalLevelInformation));
            lmEntity.getInUseCount().getAndIncrement();
            scheduler.run();
            return;
        }
        useLevel = 0;
        useLevel = level;
        if (useLevel <= 0) {
            useLevel = this.generateLevel(lmEntity);
        }
        lmEntity.setMobPrelevel(useLevel);
        v0 = var8_9 = bypassLimits != false || isSummoned != false || this.getLevellableState(lmEntity) == LevellableState.ALLOWED;
        if (_Assertions.ENABLED && !var8_9) {
            var9_10 = "Assertion failed";
            throw new AssertionError((Object)var9_10);
        }
        skipLMNametag = false;
        if (lmEntity.getLivingEntity().isInsideVehicle() && main.getRulesManager().getRulePassengerMatchLevel(lmEntity) && lmEntity.getLivingEntity().getVehicle() instanceof LivingEntity) {
            v1 = lmEntity.getLivingEntity().getVehicle();
            Intrinsics.checkNotNull(v1, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            vehicle = LivingEntityWrapper.Companion.getInstance((LivingEntity)v1);
            if (vehicle.isLevelled()) {
                useLevel = vehicle.getGetMobLevel();
                lmEntity.setMobPrelevel(useLevel);
            }
            vehicle.free();
        }
        if (isSummoned) {
            lmEntity.getSpawnReason().setInternalSpawnReason(lmEntity, InternalSpawnReason.LM_SUMMON, true);
            summonedMobPreLevelEvent = new SummonedMobPreLevelEvent(lmEntity.getLivingEntity(), useLevel);
            Bukkit.getPluginManager().callEvent((Event)summonedMobPreLevelEvent);
            if (summonedMobPreLevelEvent.isCancelled()) {
                return;
            }
        } else {
            mobPreLevelEvent = new MobPreLevelEvent(lmEntity.getLivingEntity(), useLevel, MobPreLevelEvent.LevelCause.NORMAL, additionalLevelInformation);
            Bukkit.getPluginManager().callEvent((Event)mobPreLevelEvent);
            if (mobPreLevelEvent.isCancelled()) {
                return;
            }
            useLevel = mobPreLevelEvent.getLevel();
            lmEntity.setMobPrelevel(useLevel);
            if (!mobPreLevelEvent.getShowLMNametag()) {
                skipLMNametag = true;
                lmEntity.setShouldShowLMNametag(false);
            }
        }
        hasNoLevelKey = false;
        if (!isSummoned) {
            v2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(v2, "getPersistentDataContainer(...)");
            var11_13 = v2;
            synchronized (var11_13) {
                $i$a$-synchronized-LevelManager$applyLevelToMob$1 = false;
                hasNoLevelKey = lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getNoLevelKey(), PersistentDataType.STRING);
                $i$a$-synchronized-LevelManager$applyLevelToMob$1 = Unit.INSTANCE;
            }
        }
        if (hasNoLevelKey) {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, applyLevelToMob$lambda$2(), ()Ljava/lang/String;)());
            return;
        }
        v3 = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(v3, "getPersistentDataContainer(...)");
        var11_13 = v3;
        synchronized (var11_13) {
            $i$a$-synchronized-LevelManager$applyLevelToMob$3 = false;
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER, (Object)useLevel);
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING, (Object)main.getRulesManager().getCurrentRulesHash());
            $i$a$-synchronized-LevelManager$applyLevelToMob$3 = Unit.INSTANCE;
        }
        lmEntity.invalidateCache();
        if (lmEntity.getNbtData() == null) ** GOTO lbl-1000
        v4 = lmEntity.getNbtData();
        Intrinsics.checkNotNull(v4);
        if (((Collection)v4).isEmpty() == false) {
            v5 = lmEntity.getNbtData();
        } else lbl-1000:
        // 2 sources

        {
            v5 = main.getRulesManager().getRuleNbtData(lmEntity);
        }
        v6 = nbtDatas = v5;
        Intrinsics.checkNotNull(v6);
        if (((Collection)v6).isEmpty() == false && !ExternalCompatibilityManager.Companion.getHasNbtApiInstalled()) {
            v7 = msg = isSummoned != false ? "NBT Data was supplied but the required plugin NBTAPI is not installed!" : "NBT Data has been specified in customdrops.yml but the required plugin NBTAPI is not installed!";
            if (!this.hasMentionedNBTAPIMissing) {
                Log.INSTANCE.war(msg);
                this.hasMentionedNBTAPIMissing = true;
            }
            nbtDatas.clear();
        }
        lmEntity.setLockEntitySettings(main.getRulesManager().getRuleDoLockEntity(lmEntity));
        if (lmEntity.getLockEntitySettings() && lmEntity.isNewlySpawned()) {
            lmEntity.setLockedNametag(main.getRulesManager().getRuleNametag(lmEntity));
            lmEntity.setLockedOverrideName(main.getRulesManager().getRuleEntityOverriddenName(lmEntity, true));
        }
        doSkipLMNametag = skipLMNametag;
        try {
            this.applyLevelToMob2(lmEntity, nbtDatas, doSkipLMNametag);
            levelCause = isSummoned != false ? MobPostLevelEvent.LevelCause.SUMMONED : MobPostLevelEvent.LevelCause.NORMAL;
            Bukkit.getPluginManager().callEvent((Event)new MobPostLevelEvent(lmEntity, levelCause, additionalLevelInformation));
            sb = new StringBuilder().append("world: ").append(lmEntity.getWorldName()).append(", level: ").append(useLevel);
            if (isSummoned) {
                sb.append(" (summoned)");
            }
            if (bypassLimits) {
                sb.append(" (limit bypass)");
            }
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, true, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((StringBuilder)sb));
        }
        catch (TimeoutException <unused var>) {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, applyLevelToMob$lambda$4(), ()Ljava/lang/String;)());
        }
    }

    private final void applyLevelToMob2(LivingEntityWrapper lmEntity, List<String> nbtDatas, boolean doSkipLMNametag) {
        this.applyAttribs(lmEntity, nbtDatas);
        if (!doSkipLMNametag) {
            LevelledMobs.Companion.getInstance().getLevelManager().updateNametagWithDelay(lmEntity);
        }
        LevelledMobs.Companion.getInstance().getLevelManager().applyLevelledEquipment(lmEntity, lmEntity.getGetMobLevel());
    }

    private final void applyAttribs(LivingEntityWrapper lmEntity, List<String> nbtDatas) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Addition[] additionArray = new Addition[]{Addition.ATTRIBUTE_ATTACK_DAMAGE, Addition.ATTRIBUTE_MAX_HEALTH, Addition.ATTRIBUTE_MOVEMENT_SPEED, Addition.ATTRIBUTE_ARMOR_BONUS, Addition.ATTRIBUTE_ARMOR_TOUGHNESS, Addition.ATTRIBUTE_ATTACK_KNOCKBACK, Addition.ATTRIBUTE_FLYING_SPEED, Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE, Addition.ATTRIBUTE_FOLLOW_RANGE};
        List<Addition> attribs = CollectionsKt.mutableListOf(additionArray);
        if (lmEntity.getLivingEntity() instanceof Zombie) {
            attribs.add(Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS);
        } else if (main.getVer().getUseNewHorseJumpAttrib() && lmEntity.getLivingEntity() instanceof Horse) {
            attribs.add(Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH);
        }
        main.getLevelManager().applyLevelledAttributes(lmEntity, attribs, nbtDatas);
    }

    private final void applyNbtData(LivingEntityWrapper lmEntity, List<String> nbtDatas) {
        if (nbtDatas.isEmpty()) {
            return;
        }
        boolean hadSuccess = false;
        List allResults = new ArrayList();
        for (String nbtData : nbtDatas) {
            NBTApplyResult result = NBTManager.INSTANCE.applyNBTDataMob(lmEntity, nbtData);
            if (result.getHadException()) {
                if (lmEntity.getSummonedSender() == null) {
                    Log.INSTANCE.war("Error applying NBT data '" + nbtData + "' to " + lmEntity.getNameIfBaby() + ". Exception message: " + result.getExceptionMessage());
                    continue;
                }
                CommandSender commandSender = lmEntity.getSummonedSender();
                Intrinsics.checkNotNull(commandSender);
                commandSender.sendMessage("Error applying NBT data to " + lmEntity.getNameIfBaby() + ". Exception message: " + result.getExceptionMessage());
                continue;
            }
            hadSuccess = true;
            allResults.add(result);
        }
        if (hadSuccess) {
            DebugManager.Companion.log(DebugType.NBT_APPLICATION, lmEntity, true, () -> LevelManager.applyNbtData$lambda$0(allResults));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLevelled(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        boolean hadError = false;
        boolean succeeded = false;
        boolean isLevelled = false;
        for (int i = 0; i < 2; ++i) {
            try {
                PersistentDataContainer persistentDataContainer = livingEntity.getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
                PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
                synchronized (persistentDataContainer2) {
                    boolean bl = false;
                    isLevelled = livingEntity.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER);
                    Unit unit = Unit.INSTANCE;
                }
                succeeded = true;
                break;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                hadError = true;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
        }
        if (hadError) {
            if (succeeded) {
                Log.INSTANCE.war("Got ConcurrentModificationException in LevelManager checking entity isLevelled, succeeded on retry");
            } else {
                Log.INSTANCE.war("Got ConcurrentModificationException (2x) in LevelManager checking entity isLevelled");
            }
        }
        return isLevelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLevelOfMob(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        PersistentDataContainer persistentDataContainer = livingEntity.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            block4: {
                boolean bl = false;
                if (livingEntity.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER)) break block4;
                int n = -1;
                return n;
            }
            Object object = livingEntity.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER);
            Intrinsics.checkNotNull(object);
            int n = ((Number)object).intValue();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLevel(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        boolean bl = lmEntity.isLevelled();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        Object object = persistentDataContainer;
        synchronized (object) {
            boolean $i$a$-synchronized-LevelManager$removeLevel$32 = false;
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER)) {
                lmEntity.getPdc().remove(NamespacedKeys.INSTANCE.getLevelKey());
            }
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getOverridenEntityNameKey(), PersistentDataType.STRING)) {
                lmEntity.getPdc().remove(NamespacedKeys.INSTANCE.getOverridenEntityNameKey());
            }
            Unit $i$a$-synchronized-LevelManager$removeLevel$32 = Unit.INSTANCE;
        }
        object = main.getAttributeSyncObject();
        synchronized (object) {
            boolean bl2 = false;
            for (AttributeNames attributeName : AttributeNames.getEntries()) {
                AttributeInstance attInst;
                Attribute attribute;
                if (Utils.INSTANCE.getAttribute(attributeName) == null || lmEntity.getLivingEntity().getAttribute(attribute) == null) continue;
                Enumeration existingMods = Collections.enumeration(attInst.getModifiers());
                while (existingMods.hasMoreElements()) {
                    AttributeModifier existingMod = (AttributeModifier)existingMods.nextElement();
                    if (main.getMobDataManager().getVanillaMultiplierNames().containsKey(existingMod.getName())) continue;
                    attInst.removeModifier(existingMod);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (lmEntity.getLivingEntity() instanceof Creeper) {
            LivingEntity livingEntity = lmEntity.getLivingEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Creeper");
            ((Creeper)livingEntity).setExplosionRadius(3);
        }
        lmEntity.invalidateCache();
        main.getLevelManager().updateNametag(lmEntity);
    }

    @Override
    public void removeLevel(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        this.removeLevel(lmEntity);
        lmEntity.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getMobNametag(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        try {
            String string = this.getNametag(lmEntity, false).getNametag();
            return string;
        }
        finally {
            lmEntity.free();
        }
    }

    private static final String generateLevel$lambda$0(int $count, LevellingStrategy $strategy, float $result) {
        return $count > 0 ? ", " + $strategy.getStrategyType() + ": " + $result : $strategy.getStrategyType() + ": " + $result;
    }

    private static final String generateLevel$lambda$1(int $count, CustomStrategy $strategy, float $result) {
        return $count > 0 ? ", " + $strategy.getPlaceholderName() + ": " + $result : $strategy.getPlaceholderName() + ": " + $result;
    }

    private static final String constructLevel$lambda$0(String $formula, String $formulaPre, EvaluationResult $evalResult) {
        String msg = Intrinsics.areEqual($formula, $formulaPre) ? "   formula: '" + $formula + "'" : "   formulaPre: '" + $formulaPre + "'\n   formula: '" + $formula + "'";
        return "result (error, " + $evalResult.getError() + ")\n" + msg;
    }

    private static final String constructLevel$lambda$1(String $formula, String $formulaPre, int $result) {
        String msg = Intrinsics.areEqual($formula, $formulaPre) ? "   formula: '" + $formula + "'" : "   formulaPre: '" + $formulaPre + "'\n   formula: '" + $formula + "'";
        return "result " + $result + "\n" + msg;
    }

    private static final String getPlayerLevelSourceNumber$lambda$0(PlayerHomeCheckResult $result) {
        return $result.getResultMessage();
    }

    private static final String getPlayerLevelSourceNumber$lambda$1(String $variableToUse, Player $player, Location $l) {
        return "Got blank result for '" + $variableToUse + "' from PAPI. Player " + $player.getName() + " at " + $l.getBlockX() + "," + $l.getBlockY() + "," + $l.getBlockZ() + " in " + $player.getWorld().getName();
    }

    private static final String getPlayerLevelSourceNumber$lambda$2(String $variableToUse, Player $player, Location $l) {
        return "Got blank result for '" + $variableToUse + "' from PAPI. Player " + $player.getName() + " at " + $l.getBlockX() + "," + $l.getBlockY() + "," + $l.getBlockZ() + " in " + $player.getWorld().getName();
    }

    private static final String setLevelledItemDrops$lambda$0() {
        return "removing any drops present";
    }

    private static final String setLevelledItemDrops$lambda$1(String $nameWithOverride, int $vanillaDrops, List $currentDrops, int $additionUsedFinal) {
        return $nameWithOverride + ", vanilla drops: &b" + $vanillaDrops + "&7, all drops: &b" + $currentDrops.size() + "&7, addition: &b" + $additionUsedFinal + "&7.";
    }

    private static final String multiplyDrop$lambda$0() {
        return "&7Item was unmanaged.";
    }

    private static final String multiplyDrop$lambda$1(ItemStack $currentDrop, int $oldAmount, float $addition) {
        return "&7Drop: &b" + $currentDrop.getType() + "&7, old amount: &b" + $oldAmount + "&7, addition value: &b" + $addition + "&7, new amount: &b" + $currentDrop.getAmount() + "&7.";
    }

    private static final String getLevelledExpDrops$lambda$0(double $xp) {
        return "xp-vanilla: &b" + $xp + "&7, new-xp: &b0&7";
    }

    private static final String getLevelledExpDrops$lambda$1(double $xp, int $newXpFinal) {
        return "xp-vanilla: &b" + $xp + "&7, new-xp: &b" + $newXpFinal + "&7";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$0() {
        return "mob-lvl was 0 or maxlevel was 0";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$1(int $mobLevel, float $minLevel, float $maxLevel, float $newValue) {
        return "'(" + (float)$mobLevel + " - " + $minLevel + ") / (" + $maxLevel + " - " + $minLevel + ")', result: " + $newValue;
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$2(LivingEntityWrapper $lmEntity) {
        return $lmEntity.getRangedDamage() != null ? String.valueOf($lmEntity.getRangedDamage()) : "0";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$3(LivingEntityWrapper $lmEntity, Map.Entry $placeholder) {
        return String.valueOf(((Number)$lmEntity.getStrategyResults().getOrDefault($placeholder.getValue(), Float.valueOf(0.0f))).floatValue());
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$4(LivingEntityWrapper $lmEntity, String $placeholder) {
        return String.valueOf(((Number)$lmEntity.getCustomStrategyResults().getOrDefault($placeholder, Float.valueOf(0.0f))).floatValue());
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$5(LivingEntityWrapper $lmEntity) {
        return String.valueOf($lmEntity.getDistanceFromSpawn());
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$6(LivingEntityWrapper $lmEntity) {
        LivingEntity livingEntity = $lmEntity.getLivingEntity();
        Creeper creeper = livingEntity instanceof Creeper ? (Creeper)livingEntity : null;
        Object object = creeper;
        if (object == null || (object = String.valueOf(object.getExplosionRadius())) == null) {
            object = "0";
        }
        return object;
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$7(LivingEntityWrapper $lmEntity, Map.Entry $placeholder) {
        AttributeInstance attributeInstance = $lmEntity.getAttributeValuesCache();
        return String.valueOf(attributeInstance != null && (attributeInstance = attributeInstance.get($placeholder.getValue())) != null ? Double.valueOf(attributeInstance.getBaseValue()) : null);
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$8() {
        return "1";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$9() {
        return "1";
    }

    private static final String replaceStringPlaceholders$lambda$0(LivingEntityWrapper $lmEntity, RulesManager $rm, boolean $preserveMobName) {
        String overridenName = $lmEntity.getLockedOverrideName() == null ? $rm.getRuleEntityOverriddenName($lmEntity, false) : $lmEntity.getLockedOverrideName();
        CharSequence charSequence = overridenName;
        if (!(charSequence == null || charSequence.length() == 0) && $lmEntity.getLivingEntity().getCustomName() == null) {
            return overridenName;
        }
        if ($lmEntity.getLivingEntity().getCustomName() != null) {
            return LevelledMobs.Companion.getInstance().getVer().isRunningPaper() ? "{CustomName}" : $lmEntity.getLivingEntity().getCustomName();
        }
        return $preserveMobName ? "{DisplayName}" : Utils.INSTANCE.capitalize(StringsKt.replace$default($lmEntity.getTypeName(), "_", " ", false, 4, null));
    }

    private static final String replaceStringPlaceholders$lambda$1(double $entityHealth) {
        return String.valueOf((int)Math.ceil($entityHealth));
    }

    private static final String replaceStringPlaceholders$lambda$2(double $maxHealth) {
        return String.valueOf((int)Math.ceil($maxHealth));
    }

    private static final String replaceStringPlaceholders$lambda$3(LivingEntityWrapper $lmEntity) {
        Double baseHealth;
        LivingEntity livingEntity = $lmEntity.getLivingEntity();
        Attribute attribute = Utils.INSTANCE.getAttribute(AttributeNames.MAX_HEALTH);
        Intrinsics.checkNotNull(attribute);
        AttributeInstance attributeInstance = livingEntity.getAttribute(attribute);
        Double d = baseHealth = attributeInstance != null ? Double.valueOf(attributeInstance.getBaseValue()) : null;
        if (d != null) {
            return String.valueOf(d);
        }
        return "0";
    }

    private static final String replaceStringPlaceholders$lambda$4(LivingEntityWrapper $lmEntity) {
        return $lmEntity.getLivingEntity().getLocation().getBlockX() + " " + $lmEntity.getLivingEntity().getLocation().getBlockY() + " " + $lmEntity.getLivingEntity().getLocation().getBlockZ();
    }

    private static final String replaceStringPlaceholders$lambda$5(RulesManager $rm, LivingEntityWrapper $lmEntity) {
        return String.valueOf($rm.getRuleMobMinLevel($lmEntity));
    }

    private static final String replaceStringPlaceholders$lambda$6(RulesManager $rm, LivingEntityWrapper $lmEntity) {
        return String.valueOf($rm.getRuleMobMaxLevel($lmEntity));
    }

    private static final String replaceStringPlaceholders$lambda$7(Map.Entry $placeholder, LivingEntityWrapper $lmEntity) {
        return ((ExternalPluginDetection)$placeholder.getValue()).getPlaceholder($lmEntity);
    }

    private static final void updateNametagWithDelay$lambda$0(LevelManager this$0, LivingEntityWrapper $lmEntity) {
        this$0.updateNametag($lmEntity);
        $lmEntity.free();
    }

    private static final void startNametagAutoUpdateTask$lambda$0(LevelManager this$0) {
        this$0.checkLEWCache();
        this$0.enumerateNearbyEntities();
    }

    private static final void startNametagAutoUpdateTask$lambda$1(Runnable $runnable, ScheduledTask scheduledTask) {
        $runnable.run();
    }

    private static final String checkLEWCache$lambda$0(long $configDuration) {
        return "Reached " + $configDuration + " ms, clearing LEW cache, " + LivingEntityWrapper.Companion.getLEWDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void enumerateNearbyEntities$lambda$0(Ref.DoubleRef $checkDistance, Player $player, LevelManager this$0) {
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        $checkDistance.element = MiscUtils.INSTANCE.retrieveLoadedChunkRadius(location, $checkDistance.element);
        List list = $player.getNearbyEntities($checkDistance.element, $checkDistance.element, $checkDistance.element);
        Intrinsics.checkNotNullExpressionValue(list, "getNearbyEntities(...)");
        List entities = list;
        Object object = this$0.entitiesPerPlayerLock;
        synchronized (object) {
            boolean bl = false;
            Map<Player, List<Entity>> map = this$0.entitiesPerPlayer;
            Intrinsics.checkNotNull($player);
            List<Entity> list2 = map.put($player, entities);
        }
        this$0.asyncRunningCount.getAndDecrement();
        if (this$0.asyncRunningCount.get() == 0) {
            this$0.runNametagCheckASync();
        }
    }

    private static final void startNametagTimer$lambda$0() {
        LevelledMobs.Companion.getInstance().getNametagTimerChecker().checkNametags();
    }

    private static final void runNametagCheckASync$lambda$0(LevelManager this$0, Entity $entity, Player $player, ConcurrentHashMap $entityToPlayer, ScheduledTask scheduledTask) {
        this$0.checkEntity($entity, $player, $entityToPlayer);
    }

    private static final String checkEntity$lambda$1(LivingEntityWrapper $lmEntity) {
        return "&b" + $lmEntity.getTypeName() + " &7was a baby and is now an adult, applying levelling rules";
    }

    private static final boolean checkEntityForPlayerLevelling$lambda$0(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return Intrinsics.areEqual(p.getWorld(), $mob.getWorld());
    }

    private static final boolean checkEntityForPlayerLevelling$lambda$1(Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return p.getGameMode() != GameMode.SPECTATOR;
    }

    private static final Pair checkEntityForPlayerLevelling$lambda$2(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return new Pair<Double, Player>($mob.getLocation().distanceSquared(p.getLocation()), p);
    }

    private static final Player checkEntityForPlayerLevelling$lambda$4(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Player)it.getSecond();
    }

    private static final boolean checkEntityForPlayerLevelling$lambda$5(Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return p.getGameMode() != GameMode.CREATIVE;
    }

    private static final void applyLevelledAttributes$lambda$0(LivingEntityWrapper $lmEntity, List $modInfo, LevelManager this$0, List $nbtDatas) {
        MobDataManager.Companion.getInstance().setAttributeMods($lmEntity, $modInfo);
        if ($lmEntity.getLockEntitySettings()) {
            $lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER, (Object)1);
            if ($lmEntity.getLockedNametag() != null) {
                PersistentDataContainer persistentDataContainer = $lmEntity.getPdc();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getLockedNametag();
                String string = $lmEntity.getLockedNametag();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
            if ($lmEntity.getLockedOverrideName() != null) {
                PersistentDataContainer persistentDataContainer = $lmEntity.getPdc();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getLockedNameOverride();
                String string = $lmEntity.getLockedOverrideName();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
        }
        this$0.applyNbtData($lmEntity, $nbtDatas);
        if ($lmEntity.getLivingEntity() instanceof Creeper) {
            $lmEntity.getMain().getLevelManager().applyCreeperBlastRadius($lmEntity);
        }
        $lmEntity.free();
    }

    private static final String applyCreeperBlastRadius$lambda$0() {
        return "mulp: null, result: 3";
    }

    private static final String applyCreeperBlastRadius$lambda$1(float $damage, int $maxRadius, int $blastRadiusFinal) {
        return "mulp: " + Utils.INSTANCE.round($damage, 3) + ", max: " + $maxRadius + ", result: " + $blastRadiusFinal;
    }

    private static final void applyLevelledEquipment$lambda$0(LevelManager this$0, LivingEntityWrapper $lmEntity, CustomDropsRuleSet $customDropsRuleSet) {
        this$0.applyLevelledEquipmentNonAsync($lmEntity, $customDropsRuleSet);
        $lmEntity.free();
    }

    private static final String applyLevelledEquipmentNonAsync$lambda$0(GroupLimits $groupLimits, Material $material, CustomDropItem $item) {
        return "Reached equip limit of " + $groupLimits.getCapEquipped() + ", item: " + $material + ", group: " + $item.getGroupId();
    }

    private static final void applyLevelToMob$lambda$0(LevelManager this$0, LivingEntityWrapper $lmEntity, int $level, boolean $isSummoned, boolean $bypassLimits, Set $additionalLevelInformation) {
        this$0.applyLevelToMob($lmEntity, $level, $isSummoned, $bypassLimits, $additionalLevelInformation);
        $lmEntity.free();
    }

    private static final String applyLevelToMob$lambda$2() {
        return "&7 had &bnoLevelKey&7 attached";
    }

    private static final String applyLevelToMob$lambda$4() {
        return "Timed out applying level to mob";
    }

    private static final String applyNbtData$lambda$0(List $allResults) {
        return "Applied NBT data, " + MiscUtils.INSTANCE.getNBTDebugMessage($allResults);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/LevelManager$Companion;", "", "<init>", "()V", "summonedOrSpawnEggs_Lock", "getSummonedOrSpawnEggs_Lock", "()Ljava/lang/Object;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getSummonedOrSpawnEggs_Lock() {
            return summonedOrSpawnEggs_Lock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Addition.values().length];
            try {
                nArray[Addition.ATTRIBUTE_MAX_HEALTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ATTACK_DAMAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_MOVEMENT_SPEED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ARMOR_BONUS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ARMOR_TOUGHNESS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_FLYING_SPEED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ATTACK_KNOCKBACK.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_FOLLOW_RANGE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

