/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.misc.EvaluationException;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\u0006\u0010!\u001a\u00020\u000eJ\u0006\u0010\"\u001a\u00020\u001fJ\b\u0010#\u001a\u00020\u001fH\u0002J\u0006\u0010$\u001a\u00020\u001fJ\u0006\u0010%\u001a\u00020\u001fJ\u000e\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\tJ\b\u0010(\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/MobsQueueManager;", "", "<init>", "()V", "isRunning", "", "doThread", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lio/github/arcaneplugins/levelledmobs/misc/QueueItem;", "processingList", "", "Ljava/util/UUID;", "maxThreads", "", "ignoreMobsWithNoPlayerContext", "getIgnoreMobsWithNoPlayerContext", "()Z", "setIgnoreMobsWithNoPlayerContext", "(Z)V", "queueTasks", "", "Lorg/bukkit/scheduler/BukkitTask;", "getQueueTasks", "()Ljava/util/Map;", "setQueueTasks", "(Ljava/util/Map;)V", "threadsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "queueLock", "start", "", "startAThread", "getNumberQueued", "clearQueue", "doneWithThread", "stop", "taskChecker", "addToQueue", "item", "mainThread", "processItem", "levelledmobs-plugin"})
public final class MobsQueueManager {
    private boolean isRunning;
    private boolean doThread;
    @NotNull
    private final LinkedBlockingQueue<QueueItem> queue = new LinkedBlockingQueue();
    @NotNull
    private final List<UUID> processingList = new ArrayList();
    private final int maxThreads;
    private boolean ignoreMobsWithNoPlayerContext;
    @NotNull
    private Map<Integer, BukkitTask> queueTasks = new LinkedHashMap();
    @NotNull
    private final AtomicInteger threadsCount = new AtomicInteger();
    @NotNull
    private final Object queueLock = new Object();

    public MobsQueueManager() {
        this.maxThreads = 3;
    }

    public final boolean getIgnoreMobsWithNoPlayerContext() {
        return this.ignoreMobsWithNoPlayerContext;
    }

    public final void setIgnoreMobsWithNoPlayerContext(boolean bl) {
        this.ignoreMobsWithNoPlayerContext = bl;
    }

    @NotNull
    public final Map<Integer, BukkitTask> getQueueTasks() {
        return this.queueTasks;
    }

    public final void setQueueTasks(@NotNull Map<Integer, BukkitTask> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.queueTasks = map;
    }

    public final void start() {
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            return;
        }
        if (this.isRunning) {
            return;
        }
        this.doThread = true;
        this.isRunning = true;
        this.queueTasks.clear();
        if (!LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            int n = this.maxThreads;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                this.startAThread();
            }
        }
    }

    private final void startAThread() {
        Runnable bgThread = () -> MobsQueueManager.startAThread$lambda$0(this);
        this.threadsCount.getAndIncrement();
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskAsynchronously((Plugin)LevelledMobs.Companion.getInstance(), bgThread);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskAsynchronously(...)");
        BukkitTask task = bukkitTask;
        this.queueTasks.put(task.getTaskId(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumberQueued() {
        int size = 0;
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            size = this.queue.size();
            Unit unit = Unit.INSTANCE;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            this.queue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void doneWithThread() {
        this.threadsCount.getAndDecrement();
        if (this.threadsCount.get() == 0) {
            this.isRunning = false;
            Log.INSTANCE.inf("Mob processing queue Manager has exited");
        }
    }

    public final void stop() {
        this.doThread = false;
    }

    public final void taskChecker() {
        int queueSize = this.getNumberQueued();
        boolean stopAll = queueSize >= 1000;
        int threadsNeeded = 0;
        Iterator<Map.Entry<Integer, BukkitTask>> enumerator = this.queueTasks.entrySet().iterator();
        while (enumerator.hasNext()) {
            Map.Entry<Integer, BukkitTask> taskEntry = enumerator.next();
            int taskId = ((Number)taskEntry.getKey()).intValue();
            BukkitTask task = taskEntry.getValue();
            if (!stopAll && (!task.isCancelled() || Bukkit.getScheduler().isCurrentlyRunning(taskId))) continue;
            String status = task.isCancelled() ? "cancelled" : (!stopAll ? "not running" : "queue size was " + queueSize);
            Log.INSTANCE.war("Restarting Nametag Queue Manager task, status was " + status);
            task.cancel();
            enumerator.remove();
            this.threadsCount.getAndDecrement();
            ++threadsNeeded;
        }
        if (threadsNeeded == 0) {
            return;
        }
        int n = 0;
        while (n < threadsNeeded) {
            int it = n++;
            boolean bl = false;
            this.startAThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToQueue(@NotNull QueueItem item) {
        Intrinsics.checkNotNullParameter(item, "item");
        item.getLmEntity().getInUseCount().getAndIncrement();
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            this.processItem(item);
            item.getLmEntity().free();
        } else {
            boolean offeredItem = false;
            Object object = this.queueLock;
            synchronized (object) {
                boolean bl = false;
                if (!this.processingList.contains(item.getEntityId())) {
                    this.queue.offer(item);
                    offeredItem = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            if (!offeredItem) {
                item.getLmEntity().free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mainThread() {
        while (this.doThread) {
            QueueItem item = null;
            Object object = this.queueLock;
            synchronized (object) {
                boolean $i$a$-synchronized-MobsQueueManager$mainThread$32 = false;
                item = this.queue.poll();
                if (item != null) {
                    this.processingList.add(item.getEntityId());
                }
                Unit $i$a$-synchronized-MobsQueueManager$mainThread$32 = Unit.INSTANCE;
            }
            if (item == null) {
                Thread.sleep(2L);
                continue;
            }
            try {
                this.processItem(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                object = this.queueLock;
                synchronized (object) {
                    boolean bl = false;
                    boolean bl2 = this.processingList.remove(item.getEntityId());
                }
                item.getLmEntity().free();
            }
        }
        this.doneWithThread();
    }

    private final void processItem(QueueItem item) {
        if (!item.getLmEntity().isPopulated()) {
            return;
        }
        if (this.ignoreMobsWithNoPlayerContext && item.getLmEntity().getAssociatedPlayer() == null) {
            DebugManager.Companion.log(DebugType.PLAYER_CONTEXT, item.getLmEntity(), () -> MobsQueueManager.processItem$lambda$0(item));
            return;
        }
        try {
            LevelledMobs.Companion.getInstance().getLevelManager().getEntitySpawnListener().processMob(item.getLmEntity(), item.getEvent());
        }
        catch (EvaluationException evaluationException) {
        }
        catch (TimeoutException timeoutException) {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, item.getLmEntity(), false, MobsQueueManager::processItem$lambda$1);
        }
    }

    private static final void startAThread$lambda$0(MobsQueueManager this$0) {
        try {
            this$0.mainThread();
        }
        catch (InterruptedException interruptedException) {
            this$0.isRunning = false;
        }
        this$0.doneWithThread();
    }

    private static final String processItem$lambda$0(QueueItem $item) {
        String locationStr = $item.getLmEntity().getLocation().getBlockX() + ", " + $item.getLmEntity().getLocation().getBlockY() + ", " + $item.getLmEntity().getLocation().getBlockZ() + " in " + $item.getLmEntity().getLocation().getWorld().getName();
        return "ignoring mob " + $item.getLmEntity().getNameIfBaby() + " due to no player context at " + locationStr;
    }

    private static final String processItem$lambda$1() {
        return "Timed out applying level to mob";
    }
}

