/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.misc.NametagTimerChecker;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.nametag.NametagSender;
import io.github.arcaneplugins.levelledmobs.nametag.NametagSenderHandler;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.util.LibsDisguisesUtils;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0006\u0010%\u001a\u00020!J\u0006\u0010&\u001a\u00020!J\u0006\u0010'\u001a\u00020!J\u000e\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001aJ\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020!H\u0002J\u0010\u0010-\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001aH\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010)\u001a\u00020\u001aH\u0002J&\u0010/\u001a\u00020!2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J\u0010\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u000206H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\f\u00a8\u00069"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/NametagQueueManager;", "", "<init>", "()V", "isRunning", "", "doThread", "nametagSender", "Lio/github/arcaneplugins/levelledmobs/nametag/NametagSender;", "hasLibsDisguisesInstalled", "disableNametagJava", "getDisableNametagJava", "()Z", "setDisableNametagJava", "(Z)V", "disableNametagBedrock", "getDisableNametagBedrock", "setDisableNametagBedrock", "queueTask", "Lorg/bukkit/scheduler/BukkitTask;", "getQueueTask", "()Lorg/bukkit/scheduler/BukkitTask;", "setQueueTask", "(Lorg/bukkit/scheduler/BukkitTask;)V", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lio/github/arcaneplugins/levelledmobs/misc/QueueItem;", "nametagSenderHandler", "Lio/github/arcaneplugins/levelledmobs/nametag/NametagSenderHandler;", "getNametagSenderHandler", "()Lio/github/arcaneplugins/levelledmobs/nametag/NametagSenderHandler;", "queueLock", "load", "", "onLoadOrReload", "hasNametagSupport", "getHasNametagSupport", "start", "stop", "taskChecker", "addToQueue", "item", "getNumberQueued", "", "mainThread", "preProcessItem", "processItem", "updateNametag", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "nametag", "Lio/github/arcaneplugins/levelledmobs/result/NametagResult;", "players", "", "Lorg/bukkit/entity/Player;", "isBedrock", "player", "levelledmobs-plugin"})
public final class NametagQueueManager {
    private boolean isRunning;
    private boolean doThread;
    @Nullable
    private NametagSender nametagSender;
    private boolean hasLibsDisguisesInstalled;
    private boolean disableNametagJava;
    private boolean disableNametagBedrock;
    @Nullable
    private BukkitTask queueTask;
    @NotNull
    private final LinkedBlockingQueue<QueueItem> queue = new LinkedBlockingQueue();
    @NotNull
    private final NametagSenderHandler nametagSenderHandler = new NametagSenderHandler();
    @NotNull
    private final Object queueLock = new Object();

    public final boolean getDisableNametagJava() {
        return this.disableNametagJava;
    }

    public final void setDisableNametagJava(boolean bl) {
        this.disableNametagJava = bl;
    }

    public final boolean getDisableNametagBedrock() {
        return this.disableNametagBedrock;
    }

    public final void setDisableNametagBedrock(boolean bl) {
        this.disableNametagBedrock = bl;
    }

    @Nullable
    public final BukkitTask getQueueTask() {
        return this.queueTask;
    }

    public final void setQueueTask(@Nullable BukkitTask bukkitTask) {
        this.queueTask = bukkitTask;
    }

    @NotNull
    public final NametagSenderHandler getNametagSenderHandler() {
        return this.nametagSenderHandler;
    }

    public final void load() {
        this.hasLibsDisguisesInstalled = ExternalCompatibilityManager.Companion.getHasLibsDisguisesInstalled();
        this.nametagSender = this.nametagSenderHandler.getCurrentUtil();
        this.onLoadOrReload();
    }

    public final void onLoadOrReload() {
        this.disableNametagJava = LevelledMobs.Companion.getInstance().getHelperSettings().getBoolean("disable-nametag-java", false);
        this.disableNametagBedrock = LevelledMobs.Companion.getInstance().getHelperSettings().getBoolean("disable-nametag-bedrock", false);
    }

    public final boolean getHasNametagSupport() {
        return this.nametagSender != null;
    }

    public final void start() {
        this.doThread = true;
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            return;
        }
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> NametagQueueManager.start$lambda$0(this));
        scheduler.run();
        this.queueTask = scheduler.getBukkitTask();
    }

    public final void stop() {
        this.doThread = false;
    }

    public final void taskChecker() {
        BukkitTask bukkitTask = this.queueTask;
        if (bukkitTask == null) {
            return;
        }
        BukkitTask qt = bukkitTask;
        int queueSize = this.getNumberQueued();
        if (queueSize < 1000 && !qt.isCancelled() || Bukkit.getScheduler().isCurrentlyRunning(qt.getTaskId())) {
            return;
        }
        String status = qt.isCancelled() ? "cancelled" : (queueSize < 1000 ? "not running" : "queue size was " + queueSize);
        Log.INSTANCE.war("Restarting Nametag Queue Manager task, status was " + status);
        qt.cancel();
        this.isRunning = false;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToQueue(@NotNull QueueItem item) {
        Intrinsics.checkNotNullParameter(item, "item");
        if (!this.doThread) {
            return;
        }
        if (!item.getLmEntity().getShouldShowLMNametag()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        if (item.getLmEntity().getNametagVisibilityEnum().contains((Object)NametagVisibilityEnum.DISABLED)) {
            return;
        }
        item.getLmEntity().getInUseCount().getAndIncrement();
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            this.preProcessItem(item);
        } else {
            Object object = this.queueLock;
            synchronized (object) {
                boolean bl = false;
                Boolean bl2 = this.queue.offer(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumberQueued() {
        int size = 0;
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            size = this.queue.size();
            Unit unit = Unit.INSTANCE;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mainThread() {
        while (this.doThread) {
            Ref.ObjectRef item = new Ref.ObjectRef();
            Object object = this.queueLock;
            synchronized (object) {
                boolean bl = false;
                item.element = this.queue.poll();
                Unit unit = Unit.INSTANCE;
            }
            if (item.element == null) {
                Thread.sleep(2L);
                continue;
            }
            SchedulerWrapper scheduler = new SchedulerWrapper((Entity)((QueueItem)item.element).getLmEntity().getLivingEntity(), () -> NametagQueueManager.mainThread$lambda$1(this, item));
            scheduler.setRunDirectlyInBukkit(true);
            scheduler.setEntity((Entity)((QueueItem)item.element).getLmEntity().getLivingEntity());
            ((QueueItem)item.element).getLmEntity().getInUseCount().getAndIncrement();
            scheduler.run();
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void preProcessItem(QueueItem item) {
        if (!item.getLmEntity().isPopulated()) {
            item.getLmEntity().free();
            return;
        }
        String lastEntityType = null;
        try {
            lastEntityType = item.getLmEntity().getNameIfBaby();
            this.processItem(item);
        }
        catch (Exception ex) {
            String string = lastEntityType;
            if (string == null) {
                string = "Unknown Entity";
            }
            String entityName = string;
            Log.INSTANCE.sev("Unable to process nametag update for '" + entityName + "'. ");
            ex.printStackTrace();
        }
        finally {
            item.getLmEntity().free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processItem(QueueItem item) {
        Object object;
        if (this.nametagSender == null) {
            return;
        }
        long nametagTimerResetTime = item.getLmEntity().getNametagCooldownTime();
        if (nametagTimerResetTime > 0L) {
            NametagResult nametagResult = item.getNametag();
            Intrinsics.checkNotNull(nametagResult);
            if (!nametagResult.isNullOrEmpty()) {
                Object object2 = NametagTimerChecker.Companion.getNametagTimer_Lock();
                synchronized (object2) {
                    boolean bl = false;
                    Map<Player, WeakHashMap<LivingEntity, Instant>> nametagCooldownQueue = LevelledMobs.Companion.getInstance().getNametagTimerChecker().getNametagCooldownQueue();
                    if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() != null) {
                        Set<Player> set = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                        Intrinsics.checkNotNull(set);
                        for (Player player : set) {
                            if (!nametagCooldownQueue.containsKey(player)) continue;
                            WeakHashMap<LivingEntity, Instant> weakHashMap = nametagCooldownQueue.get(player);
                            if (weakHashMap != null) {
                                ((Map)weakHashMap).put(item.getLmEntity().getLivingEntity(), Instant.now());
                            }
                            ((Map)LevelledMobs.Companion.getInstance().getNametagTimerChecker().getCooldownTimes()).put(item.getLmEntity().getLivingEntity(), item.getLmEntity().getNametagCooldownTime());
                        }
                        for (Map.Entry<Player, WeakHashMap<LivingEntity, Instant>> entry : nametagCooldownQueue.entrySet()) {
                            Player player = entry.getKey();
                            WeakHashMap<LivingEntity, Instant> value = entry.getValue();
                            Set<Player> set2 = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                            Intrinsics.checkNotNull(set2);
                            if (set2.contains(player) || !value.containsKey(item.getLmEntity().getLivingEntity())) continue;
                            Set<Player> set3 = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                            Intrinsics.checkNotNull(set3);
                            set3.add(player);
                        }
                    } else {
                        for (Map.Entry<Player, WeakHashMap<LivingEntity, Instant>> entry : nametagCooldownQueue.entrySet()) {
                            Player key = entry.getKey();
                            WeakHashMap<LivingEntity, Instant> value = entry.getValue();
                            if (!value.containsKey(item.getLmEntity().getLivingEntity())) continue;
                            if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() == null) {
                                item.getLmEntity().setPlayersNeedingNametagCooldownUpdate(new HashSet());
                            }
                            Set<Player> set = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                            Intrinsics.checkNotNull(set);
                            set.add(key);
                        }
                    }
                    object = Unit.INSTANCE;
                }
            }
        }
        if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() != null) {
            item.getLmEntity().setPlayersNeedingNametagCooldownUpdate(null);
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        object = NametagTimerChecker.Companion.getEntityTarget_Lock();
        synchronized (object) {
            boolean bl = false;
            if (main.getNametagTimerChecker().getEntityTargetMap().containsKey(item.getLmEntity().getLivingEntity())) {
                if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() == null) {
                    item.getLmEntity().setPlayersNeedingNametagCooldownUpdate(new LinkedHashSet());
                }
                Set<Player> set = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                Player player = main.getNametagTimerChecker().getEntityTargetMap().get(item.getLmEntity().getLivingEntity());
                Intrinsics.checkNotNull(player);
                set.add(player);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (!item.getLmEntity().isPopulated()) {
            return;
        }
        if (main.getHelperSettings().getBoolean("assert-entity-validity-with-nametag-packets") && !item.getLmEntity().getLivingEntity().isValid()) {
            return;
        }
        LivingEntityWrapper livingEntityWrapper = item.getLmEntity();
        NametagResult nametagResult = item.getNametag();
        Intrinsics.checkNotNull(nametagResult);
        List<Player> list = item.getPlayers();
        Intrinsics.checkNotNull(list);
        this.updateNametag(livingEntityWrapper, nametagResult, list);
    }

    private final void updateNametag(LivingEntityWrapper lmEntity, NametagResult nametag, List<Player> players) {
        int loopCount = lmEntity.getPlayersNeedingNametagCooldownUpdate() == null ? 1 : 2;
        for (int i = 0; i < loopCount; ++i) {
            boolean doAlwaysVisible;
            List<NametagVisibilityEnum> nametagVisibilityEnum = lmEntity.getNametagVisibilityEnum();
            boolean bl = doAlwaysVisible = i == 1 || !nametag.isNullOrEmpty() && lmEntity.getLivingEntity().isCustomNameVisible() || nametagVisibilityEnum.contains((Object)NametagVisibilityEnum.ALWAYS_ON);
            if (i == 0) {
                for (Player player : players) {
                    if (lmEntity.getPlayersNeedingNametagCooldownUpdate() != null) {
                        Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                        Intrinsics.checkNotNull(set);
                        if (set.contains(player)) continue;
                    }
                    if (this.disableNametagBedrock && this.isBedrock(player)) {
                        return;
                    }
                    if (this.disableNametagJava && !this.isBedrock(player)) {
                        return;
                    }
                    NametagSender nametagSender = this.nametagSender;
                    Intrinsics.checkNotNull(nametagSender);
                    nametagSender.sendNametag(lmEntity.getLivingEntity(), nametag, player, doAlwaysVisible);
                }
            } else {
                Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                for (Player player : set) {
                    if (this.disableNametagBedrock && this.isBedrock(player)) {
                        return;
                    }
                    if (this.disableNametagJava && !this.isBedrock(player)) {
                        return;
                    }
                    NametagSender nametagSender = this.nametagSender;
                    Intrinsics.checkNotNull(nametagSender);
                    nametagSender.sendNametag(lmEntity.getLivingEntity(), nametag, player, true);
                }
            }
            if (!this.hasLibsDisguisesInstalled || !LibsDisguisesUtils.INSTANCE.isMobUsingLibsDisguises(lmEntity)) continue;
            String useNametag = null;
            if (nametag.getNametag() != null) {
                String string = StringsKt.replace$default(nametag.getNametagNonNull(), "{DisplayName}", Utils.INSTANCE.capitalize(StringsKt.replace$default(lmEntity.getTypeName(), "_", " ", false, 4, null)), false, 4, null);
                String string2 = lmEntity.getLivingEntity().getCustomName();
                if (string2 == null) {
                    string2 = "";
                }
                useNametag = MessageUtils.INSTANCE.colorizeAll(StringsKt.replace$default(string, "{CustomName}", string2, false, 4, null));
            }
            LibsDisguisesUtils.INSTANCE.updateLibsDisguiseNametag(lmEntity, useNametag);
        }
    }

    private final boolean isBedrock(Player player) {
        return player.getUniqueId().getMostSignificantBits() == 0L;
    }

    private static final void start$lambda$0(NametagQueueManager this$0) {
        boolean hadError;
        block4: {
            hadError = false;
            try {
                this$0.mainThread();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) break block4;
                hadError = true;
                e.printStackTrace();
            }
        }
        if (hadError) {
            Log.INSTANCE.sev("Nametag update queue Manager has exited with error");
        } else {
            Log.INSTANCE.inf("Nametag update queue Manager has exited");
        }
        this$0.isRunning = false;
    }

    private static final void mainThread$lambda$1(NametagQueueManager this$0, Ref.ObjectRef $item) {
        this$0.preProcessItem((QueueItem)$item.element);
        ((QueueItem)$item.element).getLmEntity().free();
    }
}

