/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.MatchResult;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.Regex;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.misc.StringReplacer;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000f\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002,-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00150\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u001e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0016\u0010'\u001a\u00020\u00052\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070(H\u0002J\"\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020+0*2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070(H\u0002\u00a8\u0006."}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/FileMigrator;", "", "<init>", "()V", "getFieldDepth", "", "line", "", "getKeyFromList", "list", "", "currentKey", "copyCustomDrops", "", "from", "Ljava/io/File;", "to", "fileVersion", "doSectionsContainSameLines", "", "section1", "Lio/github/arcaneplugins/levelledmobs/misc/FileMigrator$KeySectionInfo;", "section2", "buildKeySections", "", "contents", "extractSectionNumber", "input", "copyYmlValues", "oldVersion", "countPeriods", "text", "getPadding", "space", "isEntitySameSubkey", "key1", "key2", "getEndingKey", "getParentKey", "getFirstNonCommentLine", "", "getMapFromConfig", "Ljava/util/SortedMap;", "Lio/github/arcaneplugins/levelledmobs/misc/FileMigrator$FieldInfo;", "FieldInfo", "KeySectionInfo", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nFileMigrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileMigrator.kt\nio/github/arcaneplugins/levelledmobs/misc/FileMigrator\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,659:1\n106#2:660\n78#2,22:661\n106#2:683\n78#2,29:684\n106#2:713\n78#2,22:714\n106#2:736\n78#2,22:737\n106#2:759\n78#2,22:760\n106#2:782\n78#2,29:783\n106#2:812\n78#2,22:813\n106#2:835\n78#2,22:836\n106#2:858\n78#2,22:859\n106#2:881\n78#2,22:882\n106#2:904\n78#2,22:905\n106#2:927\n78#2,22:928\n106#2:950\n78#2,29:951\n*S KotlinDebug\n*F\n+ 1 FileMigrator.kt\nio/github/arcaneplugins/levelledmobs/misc/FileMigrator\n*L\n170#1:660\n170#1:661,22\n272#1:683\n272#1:684,29\n280#1:713\n280#1:714,22\n366#1:736\n366#1:737,22\n456#1:759\n456#1:760,22\n458#1:782\n458#1:783,29\n482#1:812\n482#1:813,22\n572#1:835\n572#1:836,22\n591#1:858\n591#1:859,22\n600#1:881\n600#1:882,22\n609#1:904\n609#1:905,22\n640#1:927\n640#1:928,22\n647#1:950\n647#1:951,29\n*E\n"})
public final class FileMigrator {
    @NotNull
    public static final FileMigrator INSTANCE = new FileMigrator();

    private FileMigrator() {
    }

    private final int getFieldDepth(String line) {
        char element;
        int whiteSpace = 0;
        int n = line.length();
        for (int i = 0; i < n && (element = line.charAt(i)) == ' '; ++i) {
            ++whiteSpace;
        }
        return whiteSpace == 0 ? 0 : whiteSpace / 2;
    }

    private final String getKeyFromList(List<String> list, String currentKey) {
        if (list.isEmpty()) {
            return currentKey;
        }
        Object result = CollectionsKt.joinToString$default(list, ".", null, null, 0, null, null, 62, null);
        if (currentKey != null) {
            result = (String)result + "." + currentKey;
        }
        return result;
    }

    public final void copyCustomDrops(@NotNull File from, @NotNull File to, int fileVersion) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        try {
            String string = Files.readString(from.toPath(), StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(string, "readString(...)");
            StringReplacer content = new StringReplacer(string);
            content.replace("overall_chance:", "overall-chance:");
            content.replace("overall_permission:", "overall-permission:");
            MatchResult foundFileVersion = Regex.find$default(new Regex("file-version:.*?\\d+"), content.getText(), 0, 2, null);
            if (foundFileVersion != null) {
                content.replace(foundFileVersion.getValue(), "file-version: 12");
            }
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING};
            Files.writeString(to.toPath(), (CharSequence)content.getText(), StandardCharsets.UTF_8, openOptionArray);
            Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Migrated &b" + to.getName() + "&7 successfully.");
        }
        catch (IOException e) {
            Log.INSTANCE.sev("&fFile Loader: &8(Migration) &7Failed to migrate &b" + to.getName() + "&7! Stack trace:");
            e.printStackTrace();
        }
    }

    private final boolean doSectionsContainSameLines(KeySectionInfo section1, KeySectionInfo section2) {
        if (section1.getLines().size() != section2.getLines().size()) {
            return false;
        }
        int n = ((Collection)section1.getLines()).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual(section1.getLines().get(i), section2.getLines().get(i))) continue;
            return false;
        }
        return true;
    }

    private final Map<String, KeySectionInfo> buildKeySections(List<String> contents) {
        Map sections = new LinkedHashMap();
        KeySectionInfo keySection = null;
        String keyName = null;
        int sectionNumber = 0;
        int sectionStartingLine = 0;
        boolean foundNonComment = false;
        int n = ((Collection)contents).size();
        for (int i = 0; i < n; ++i) {
            String line;
            String origline = contents.get(i);
            int depth = this.getFieldDepth(origline);
            String $this$trim$iv = StringsKt.replace$default(origline, "\t", "", false, 4, null);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default(line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), "# ||  Section", false, 2, null)) {
                int foundSectionNumber = this.extractSectionNumber(line);
                if (foundSectionNumber > 0) {
                    sectionNumber = foundSectionNumber;
                }
                sectionStartingLine = 0;
            }
            if (sectionStartingLine == 0 && sectionNumber > 0 && StringsKt.startsWith$default(line, "# ||||", false, 2, null)) {
                sectionStartingLine = i + 2;
                foundNonComment = false;
            }
            if (StringsKt.startsWith$default(line, "#", false, 2, null) || ((CharSequence)line).length() == 0) continue;
            if (!foundNonComment) {
                if (sectionStartingLine > 0) {
                    sectionStartingLine = i;
                }
                foundNonComment = true;
            }
            if (depth == 0) {
                if (keySection != null) {
                    String string = keyName;
                    Intrinsics.checkNotNull(string);
                    sections.put(string, keySection);
                }
                keySection = new KeySectionInfo();
                keySection.setLineNumber(i);
                keySection.setSectionNumber(sectionNumber);
                keySection.setSectionStartingLine(sectionStartingLine);
                keyName = line;
                continue;
            }
            Object object = keySection;
            if (object == null || (object = ((KeySectionInfo)object).getLines()) == null) continue;
            object.add(origline);
        }
        if (keySection != null) {
            String string = keyName;
            Intrinsics.checkNotNull(string);
            sections.put(string, keySection);
        }
        return sections;
    }

    private final int extractSectionNumber(String input) {
        Pattern p = Pattern.compile("# \\|\\|\\s{2}Section (\\d{2})");
        Matcher m = p.matcher(input);
        if (m.find() && m.groupCount() == 1) {
            String string;
            String temp = m.group(1);
            if (temp.length() > 1 && temp.charAt(0) == '0') {
                string = temp;
                Intrinsics.checkNotNull(string);
                int n = 1;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                temp = string2;
            }
            if (Utils.INSTANCE.isInteger(temp)) {
                string = temp;
                Intrinsics.checkNotNull(string);
                return Integer.parseInt(string);
            }
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void copyYmlValues(@NotNull File from, @NotNull File to, int oldVersion) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        String regexPattern = "^[^':]*:.*";
        boolean isSettings = StringsKt.equals(to.getName(), "settings.yml", true);
        boolean isCustomDrops = StringsKt.equals(to.getName(), "customdrops.yml", true);
        boolean isMessages = StringsKt.equals(to.getName(), "messages.yml", true);
        boolean showMessages = !isMessages;
        List processedKeys = new ArrayList();
        String useCustomDrops = "use-custom-item-drops-for-mobs";
        String[] stringArray = new String[]{"kill-skip-conditions.nametagged", "kill-skip-conditions.tamed", "kill-skip-conditions.leashed", "kill-skip-conditions.convertingZombieVillager"};
        List<String> settingsToRemove = CollectionsKt.mutableListOf(stringArray);
        try {
            int valuesMatched;
            int valuesUpdated;
            int keysMatched;
            List<String> newConfigLines;
            block73: {
                int firstNonCommentLine;
                List<String> oldConfigLines;
                block70: {
                    oldConfigLines = Files.readAllLines(from.toPath(), StandardCharsets.UTF_8);
                    newConfigLines = Files.readAllLines(to.toPath(), StandardCharsets.UTF_8);
                    Intrinsics.checkNotNull(oldConfigLines);
                    SortedMap<String, FieldInfo> oldConfigMap = this.getMapFromConfig(oldConfigLines);
                    Intrinsics.checkNotNull(newConfigLines);
                    SortedMap<String, FieldInfo> newConfigMap = this.getMapFromConfig(newConfigLines);
                    List currentKey = new ArrayList();
                    keysMatched = 0;
                    valuesUpdated = 0;
                    valuesMatched = 0;
                    if (isCustomDrops) break block70;
                    int currentLine = 0;
                    while (currentLine < newConfigLines.size()) {
                        boolean match$iv$iv;
                        char it;
                        int index$iv$iv;
                        boolean startFound$iv$iv;
                        int endIndex$iv$iv;
                        int startIndex$iv$iv;
                        int $i$f$trim;
                        CharSequence $this$trim$iv$iv;
                        boolean $i$f$trim2;
                        CharSequence $this$trim$iv;
                        int depth;
                        String line;
                        block72: {
                            block71: {
                                String string = line = newConfigLines.get(currentLine);
                                Intrinsics.checkNotNull(string);
                                depth = this.getFieldDepth(string);
                                string = line;
                                Intrinsics.checkNotNull(string);
                                $this$trim$iv = string;
                                $i$f$trim2 = false;
                                $this$trim$iv$iv = $this$trim$iv;
                                $i$f$trim = 0;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                if (StringsKt.startsWith$default(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), "#", false, 2, null)) break block71;
                                $this$trim$iv = line;
                                Intrinsics.checkNotNull($this$trim$iv);
                                $i$f$trim2 = false;
                                $this$trim$iv$iv = $this$trim$iv;
                                $i$f$trim = 0;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                                    boolean bl = false;
                                    boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block72;
                            }
                            ++currentLine;
                            continue;
                        }
                        $this$trim$iv = line;
                        Intrinsics.checkNotNull($this$trim$iv);
                        $this$trim$iv = $this$trim$iv;
                        if (new Regex(regexPattern).matches($this$trim$iv)) {
                            String key;
                            String $i$f$trim3 = line;
                            Intrinsics.checkNotNull($i$f$trim3);
                            int firstColon = StringsKt.indexOf$default((CharSequence)$i$f$trim3, ':', 0, false, 6, null);
                            boolean hasValues = line.length() > firstColon + 1;
                            String $i$f$trim4 = line;
                            Intrinsics.checkNotNull($i$f$trim4);
                            String $this$trim$iv2 = StringsKt.replace$default(StringsKt.take($i$f$trim4, firstColon), "\t", "", false, 4, null);
                            boolean $i$f$trim5 = false;
                            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
                            boolean $i$f$trim6 = false;
                            int startIndex$iv$iv2 = 0;
                            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                            boolean startFound$iv$iv2 = false;
                            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                                boolean match$iv$iv2;
                                int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                                char it2 = $this$trim$iv$iv2.charAt(index$iv$iv2);
                                boolean bl = false;
                                boolean bl4 = match$iv$iv2 = Intrinsics.compare(it2, 32) <= 0;
                                if (!startFound$iv$iv2) {
                                    if (!match$iv$iv2) {
                                        startFound$iv$iv2 = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv2;
                                    continue;
                                }
                                if (!match$iv$iv2) break;
                                --endIndex$iv$iv2;
                            }
                            String keyOnly = key = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                            String oldKey = key;
                            if (isSettings && oldVersion < 32 && StringsKt.equals(key, "async-task-update-period", true)) {
                                oldKey = "nametag-auto-update-task-period";
                            }
                            if (depth == 0) {
                                currentKey.clear();
                            } else if (currentKey.size() > depth) {
                                while (currentKey.size() > depth) {
                                    currentKey.remove(currentKey.size() - 1);
                                }
                                String string = this.getKeyFromList(currentKey, key);
                                Intrinsics.checkNotNull(string);
                                key = string;
                            } else {
                                String string = this.getKeyFromList(currentKey, key);
                                Intrinsics.checkNotNull(string);
                                key = string;
                            }
                            if (!hasValues) {
                                currentKey.add(keyOnly);
                                if (oldConfigMap.containsKey(oldKey) && newConfigMap.containsKey(key)) {
                                    FieldInfo fiOld = (FieldInfo)oldConfigMap.get(oldKey);
                                    FieldInfo fiNew = (FieldInfo)newConfigMap.get(key);
                                    String padding = this.getPadding((depth + 1) * 2);
                                    FieldInfo fieldInfo = fiOld;
                                    Intrinsics.checkNotNull(fieldInfo);
                                    if (fieldInfo.isList()) {
                                        List<String> list = fiOld.getValueList();
                                        Intrinsics.checkNotNull(list);
                                        for (String oldValue : list) {
                                            FieldInfo fieldInfo2 = fiNew;
                                            Intrinsics.checkNotNull(fieldInfo2);
                                            if (fieldInfo2.isList()) {
                                                List<String> list2 = fiNew.getValueList();
                                                Intrinsics.checkNotNull(list2);
                                                if (list2.contains(oldValue)) continue;
                                            }
                                            String newline = padding + "- " + oldValue;
                                            newConfigLines.add(currentLine + 1, newline);
                                            if (!showMessages) continue;
                                            Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Added array value: &b" + oldValue);
                                        }
                                    } else {
                                        int numOfPeriods = this.countPeriods(key);
                                        Iterator<Map.Entry<String, FieldInfo>> oldValue = oldConfigMap.entrySet().iterator();
                                        while (oldValue.hasNext()) {
                                            Map.Entry<String, FieldInfo> entry;
                                            String enumeratedKey;
                                            Intrinsics.checkNotNullExpressionValue(oldValue.next(), "next(...)");
                                            String string = enumeratedKey = entry.getKey();
                                            Intrinsics.checkNotNull(string);
                                            int numofperiodsEnumerated = this.countPeriods(string);
                                            if (!StringsKt.startsWith$default(enumeratedKey, key, false, 2, null) || numofperiodsEnumerated != numOfPeriods + 1 || newConfigMap.containsKey(enumeratedKey)) continue;
                                            FieldInfo fi = entry.getValue();
                                            if (isSettings && settingsToRemove.contains(enumeratedKey)) {
                                                ++currentLine;
                                                continue;
                                            }
                                            FieldInfo fieldInfo3 = fi;
                                            Intrinsics.checkNotNull(fieldInfo3);
                                            if (fieldInfo3.isList() || fi.getSimpleValue() == null) continue;
                                            String newline = padding + this.getEndingKey(enumeratedKey) + ": " + fi.getSimpleValue();
                                            newConfigLines.add(currentLine + 1, newline);
                                            if (showMessages) {
                                                Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Adding key: &b" + enumeratedKey + "&7, value: &r" + fi.getSimpleValue() + "&7.");
                                            }
                                            processedKeys.add(key);
                                        }
                                    }
                                }
                            } else if (oldConfigMap.containsKey(oldKey)) {
                                FieldInfo fi;
                                void $this$trim$iv3;
                                ++keysMatched;
                                String fiNew = line;
                                Intrinsics.checkNotNull(fiNew);
                                int padding = firstColon + 1;
                                String string = fiNew.substring(padding);
                                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                                fiNew = string;
                                boolean $i$f$trim7 = false;
                                CharSequence $this$trim$iv$iv3 = (CharSequence)$this$trim$iv3;
                                boolean $i$f$trim82 = false;
                                int startIndex$iv$iv3 = 0;
                                int endIndex$iv$iv3 = $this$trim$iv$iv3.length() - 1;
                                boolean startFound$iv$iv3 = false;
                                while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                                    boolean match$iv$iv3;
                                    int index$iv$iv3 = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                                    char it3 = $this$trim$iv$iv3.charAt(index$iv$iv3);
                                    boolean bl = false;
                                    boolean bl5 = match$iv$iv3 = Intrinsics.compare(it3, 32) <= 0;
                                    if (!startFound$iv$iv3) {
                                        if (!match$iv$iv3) {
                                            startFound$iv$iv3 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv3;
                                        continue;
                                    }
                                    if (!match$iv$iv3) break;
                                    --endIndex$iv$iv3;
                                }
                                String value = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString();
                                FieldInfo fieldInfo = fi = (FieldInfo)oldConfigMap.get(oldKey);
                                Intrinsics.checkNotNull(fieldInfo);
                                String migratedValue = fieldInfo.getSimpleValue();
                                $this$trim$iv$iv3 = key;
                                Locale locale = Locale.getDefault();
                                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                                String string2 = ((String)$this$trim$iv$iv3).toLowerCase(locale);
                                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                                if (StringsKt.startsWith$default(string2, "file-version", false, 2, null)) {
                                    ++currentLine;
                                    continue;
                                }
                                if (isSettings && StringsKt.equals(key, "creature-nametag", true) && oldVersion > 20 && oldVersion < 26 && Intrinsics.areEqual(migratedValue, "'&8[&7Level %level%&8 | &f%displayname%&8 | &c%health%&8/&c%max_health% %heart_symbol%&8]'")) {
                                    ++currentLine;
                                    continue;
                                }
                                if (isSettings && oldVersion < 28 && StringsKt.equals(key, useCustomDrops, true) && oldConfigMap.containsKey(useCustomDrops)) {
                                    Object v = oldConfigMap.get(useCustomDrops);
                                    Intrinsics.checkNotNull(v);
                                    if (StringsKt.equals(((FieldInfo)v).getSimpleValue(), "true", true)) {
                                        if (showMessages) {
                                            Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Current key: &b" + key + "&7, resetting to: &rfalse&7.");
                                        }
                                        Object v2 = newConfigMap.get(useCustomDrops);
                                        Intrinsics.checkNotNull(v2);
                                        ((FieldInfo)v2).setSimpleValue("false");
                                        ++valuesUpdated;
                                        ++currentLine;
                                        continue;
                                    }
                                }
                                String parentKey = this.getParentKey(key);
                                if (fi.getHasValue() && parentKey != null && !processedKeys.contains(parentKey)) {
                                    Iterator<Map.Entry<String, FieldInfo>> $i$f$trim82 = oldConfigMap.entrySet().iterator();
                                    while ($i$f$trim82.hasNext()) {
                                        FieldInfo fiOld;
                                        Map.Entry<String, FieldInfo> entry;
                                        String oldValue;
                                        Intrinsics.checkNotNullExpressionValue($i$f$trim82.next(), "next(...)");
                                        String string3 = oldValue = entry.getKey();
                                        Intrinsics.checkNotNull(string3);
                                        if (!StringsKt.startsWith$default(string3, parentKey, false, 2, null) || newConfigMap.containsKey(oldValue) || !this.isEntitySameSubkey(parentKey, oldValue)) continue;
                                        FieldInfo fieldInfo4 = fiOld = entry.getValue();
                                        Intrinsics.checkNotNull(fieldInfo4);
                                        if (fieldInfo4.isList()) continue;
                                        String padding2 = this.getPadding(depth * 2);
                                        String newline = padding2 + this.getEndingKey(oldValue) + ": " + fiOld.getSimpleValue();
                                        newConfigLines.add(currentLine + 1, newline);
                                        if (!showMessages) continue;
                                        Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Adding key: &b" + oldValue + "&7, value: &r" + fiOld.getSimpleValue() + "&7.");
                                    }
                                    processedKeys.add(parentKey);
                                }
                                if (!Intrinsics.areEqual(value, migratedValue)) {
                                    if (migratedValue != null) {
                                        ++valuesUpdated;
                                        if (showMessages) {
                                            Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Current key: &b" + key + "&7, replacing: &r" + value + "&7, with: &r" + migratedValue + "&7.");
                                        }
                                        String $i$f$trim82 = line;
                                        Intrinsics.checkNotNull($i$f$trim82);
                                        line = StringsKt.replace$default($i$f$trim82, value, migratedValue, false, 4, null);
                                        newConfigLines.set(currentLine, line);
                                    }
                                    v20 = Unit.INSTANCE;
                                } else {
                                    v20 = valuesMatched++;
                                }
                            }
                        } else {
                            String firstColon = line;
                            Intrinsics.checkNotNull(firstColon);
                            $this$trim$iv = firstColon;
                            $i$f$trim2 = false;
                            $this$trim$iv$iv = $this$trim$iv;
                            $i$f$trim = 0;
                            startIndex$iv$iv = 0;
                            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it = $this$trim$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                boolean bl6 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if (StringsKt.startsWith$default(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), "-", false, 2, null)) {
                                boolean match$iv$iv4;
                                char it4;
                                int index$iv$iv4;
                                String key = this.getKeyFromList(currentKey, null);
                                $this$trim$iv$iv = line;
                                Intrinsics.checkNotNull($this$trim$iv$iv);
                                CharSequence $this$trim$iv4 = $this$trim$iv$iv;
                                $i$f$trim = 0;
                                CharSequence $this$trim$iv$iv4 = $this$trim$iv4;
                                boolean $i$f$trim9 = false;
                                int startIndex$iv$iv4 = 0;
                                int endIndex$iv$iv4 = $this$trim$iv$iv4.length() - 1;
                                boolean startFound$iv$iv4 = false;
                                while (startIndex$iv$iv4 <= endIndex$iv$iv4) {
                                    index$iv$iv4 = !startFound$iv$iv4 ? startIndex$iv$iv4 : endIndex$iv$iv4;
                                    it4 = $this$trim$iv$iv4.charAt(index$iv$iv4);
                                    boolean bl = false;
                                    boolean bl7 = match$iv$iv4 = Intrinsics.compare(it4, 32) <= 0;
                                    if (!startFound$iv$iv4) {
                                        if (!match$iv$iv4) {
                                            startFound$iv$iv4 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv4;
                                        continue;
                                    }
                                    if (!match$iv$iv4) break;
                                    --endIndex$iv$iv4;
                                }
                                $this$trim$iv4 = ((Object)$this$trim$iv$iv4.subSequence(startIndex$iv$iv4, endIndex$iv$iv4 + 1)).toString();
                                $i$f$trim = 1;
                                String string = ((String)$this$trim$iv4).substring($i$f$trim);
                                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                                $this$trim$iv4 = string;
                                $i$f$trim = 0;
                                $this$trim$iv$iv4 = $this$trim$iv4;
                                $i$f$trim9 = false;
                                startIndex$iv$iv4 = 0;
                                endIndex$iv$iv4 = $this$trim$iv$iv4.length() - 1;
                                startFound$iv$iv4 = false;
                                while (startIndex$iv$iv4 <= endIndex$iv$iv4) {
                                    index$iv$iv4 = !startFound$iv$iv4 ? startIndex$iv$iv4 : endIndex$iv$iv4;
                                    it4 = $this$trim$iv$iv4.charAt(index$iv$iv4);
                                    boolean bl = false;
                                    boolean bl8 = match$iv$iv4 = Intrinsics.compare(it4, 32) <= 0;
                                    if (!startFound$iv$iv4) {
                                        if (!match$iv$iv4) {
                                            startFound$iv$iv4 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv4;
                                        continue;
                                    }
                                    if (!match$iv$iv4) break;
                                    --endIndex$iv$iv4;
                                }
                                String value = ((Object)$this$trim$iv$iv4.subSequence(startIndex$iv$iv4, endIndex$iv$iv4 + 1)).toString();
                                if (oldConfigMap.containsKey(key)) {
                                    Object v = oldConfigMap.get(key);
                                    Intrinsics.checkNotNull(v);
                                    if (((FieldInfo)v).isList()) {
                                        Object v3 = oldConfigMap.get(key);
                                        Intrinsics.checkNotNull(v3);
                                        List<String> list = ((FieldInfo)v3).getValueList();
                                        Intrinsics.checkNotNull(list);
                                        if (!list.contains(value)) {
                                            newConfigLines.remove(currentLine);
                                            --currentLine;
                                            if (showMessages) {
                                                Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Current key: &b" + key + "&7, removing value: &r" + value + "&7.");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++currentLine;
                    }
                    break block73;
                }
                int startAt = 0;
                int depth = ((Collection)newConfigLines).size();
                for (int i = 0; i < depth; ++i) {
                    String line;
                    String string = newConfigLines.get(i);
                    Intrinsics.checkNotNullExpressionValue(string, "get(...)");
                    String $this$trim$iv = string;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim10 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl9 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    $this$trim$iv = line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                    String string4 = $this$trim$iv.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                    if (!StringsKt.startsWith$default(string4, "file-version", false, 2, null)) continue;
                    startAt = i + 1;
                    break;
                }
                while (newConfigLines.size() > startAt + 1) {
                    newConfigLines.remove(newConfigLines.size() - 1);
                }
                int n = oldConfigLines.size();
                for (int i = firstNonCommentLine = this.getFirstNonCommentLine(oldConfigLines); i < n; ++i) {
                    boolean bl;
                    String string = oldConfigLines.get(i);
                    Intrinsics.checkNotNullExpressionValue(string, "get(...)");
                    CharSequence charSequence = string;
                    Regex regex = new Regex("\\s+$");
                    String string5 = "";
                    Object temp = regex.replace(charSequence, string5);
                    if (StringsKt.endsWith$default((String)temp, "nomultiplier:", false, 2, null) || StringsKt.endsWith$default((String)temp, "nospawner:", false, 2, null)) {
                        temp = (String)temp + " true";
                        bl = newConfigLines.add((String)temp);
                        continue;
                    }
                    bl = newConfigLines.add(oldConfigLines.get(i));
                }
            }
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING};
            Files.write(to.toPath(), (Iterable<? extends CharSequence>)newConfigLines, StandardCharsets.UTF_8, openOptionArray);
            Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Migrated &b" + to.getName() + "&7 successfully.");
            Log.INSTANCE.inf("&fFile Loader: &8(Migration) &7Keys matched: &b" + keysMatched + "&7, values matched: &b" + valuesMatched + "&7, values updated: &b" + valuesUpdated + "&7.");
        }
        catch (Exception e) {
            Log.INSTANCE.sev("&fFile Loader: &8(Migration) &7Failed to migrate &b" + to.getName() + "&7! Stack trace:");
            e.printStackTrace();
        }
    }

    private final int countPeriods(String text) {
        int count = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char element = text.charAt(i);
            if (element != '.') continue;
            ++count;
        }
        return count;
    }

    private final String getPadding(int space) {
        return StringsKt.repeat(" ", space);
    }

    private final boolean isEntitySameSubkey(String key1, String key2) {
        int lastPeriod = StringsKt.lastIndexOf$default((CharSequence)key2, '.', 0, false, 6, null);
        String checkKey = lastPeriod > 0 ? StringsKt.take(key2, lastPeriod) : key2;
        return StringsKt.equals(key1, checkKey, true);
    }

    private final String getEndingKey(String input) {
        int lastPeriod = StringsKt.lastIndexOf$default((CharSequence)input, '.', 0, false, 6, null);
        if (lastPeriod < 0) {
            return input;
        }
        String string = input.substring(lastPeriod + 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }

    private final String getParentKey(String input) {
        int lastPeriod = StringsKt.lastIndexOf$default((CharSequence)input, '.', 0, false, 6, null);
        if (lastPeriod < 0) {
            return null;
        }
        return StringsKt.take(input, lastPeriod);
    }

    private final int getFirstNonCommentLine(List<String> input) {
        int n = ((Collection)input).size();
        for (int lineNum = 0; lineNum < n; ++lineNum) {
            String line;
            String $this$trim$iv = StringsKt.replace$default(input.get(lineNum), "\t", "", false, 4, null);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default(line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), "#", false, 2, null) || ((CharSequence)line).length() == 0) continue;
            return lineNum;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final SortedMap<String, FieldInfo> getMapFromConfig(List<String> input) {
        SortedMap configMap = new TreeMap();
        List currentKey = new ArrayList();
        String regexPattern = "^[^':]*:.*";
        block0: for (String line : input) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String useLine;
            int depth = this.getFieldDepth(line);
            CharSequence $this$trim$iv = StringsKt.replace$default(line, "\t", "", false, 4, null);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            int $i$f$trim2 = 0;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv2;
                int index$iv$iv2 = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it2 = $this$trim$iv$iv.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl2 = match$iv$iv2 = Intrinsics.compare(it2, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv2) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv2) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default(useLine = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), "#", false, 2, null) || ((CharSequence)useLine).length() == 0) continue;
            $this$trim$iv = useLine;
            if (new Regex(regexPattern).matches($this$trim$iv)) {
                boolean match$iv$iv3;
                char it3;
                int index$iv$iv3;
                boolean startFound$iv$iv2;
                int endIndex$iv$iv2;
                int startIndex$iv$iv2;
                boolean $i$f$trim3;
                void $this$trim$iv2;
                String key;
                String origKey;
                int firstColon = StringsKt.indexOf$default((CharSequence)useLine, ':', 0, false, 6, null);
                boolean hasValues = useLine.length() > firstColon + 1;
                String $this$trim$iv3 = StringsKt.replace$default(StringsKt.take(useLine, firstColon), "\t", "", false, 4, null);
                boolean $i$f$trim4 = false;
                CharSequence $this$trim$iv$iv2 = $this$trim$iv3;
                boolean $i$f$trim5 = false;
                int startIndex$iv$iv3 = 0;
                int endIndex$iv$iv3 = $this$trim$iv$iv2.length() - 1;
                boolean startFound$iv$iv3 = false;
                while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                    boolean match$iv$iv4;
                    int index$iv$iv4 = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                    char it4 = $this$trim$iv$iv2.charAt(index$iv$iv4);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv4 = Intrinsics.compare(it4, 32) <= 0;
                    if (!startFound$iv$iv3) {
                        if (!match$iv$iv4) {
                            startFound$iv$iv3 = true;
                            continue;
                        }
                        ++startIndex$iv$iv3;
                        continue;
                    }
                    if (!match$iv$iv4) break;
                    --endIndex$iv$iv3;
                }
                String string = origKey = (key = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString());
                Intrinsics.checkNotNull(string);
                if (StringsKt.startsWith$default(string, "-", false, 2, null)) {
                    if (currentKey.size() > depth) {
                        while (currentKey.size() > depth) {
                            currentKey.remove(currentKey.size() - 1);
                        }
                    }
                    String string2 = origKey.substring(1);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    $this$trim$iv$iv2 = string2;
                    $i$f$trim5 = false;
                    CharSequence $this$trim$iv$iv3 = (CharSequence)$this$trim$iv2;
                    $i$f$trim3 = false;
                    startIndex$iv$iv2 = 0;
                    endIndex$iv$iv2 = $this$trim$iv$iv3.length() - 1;
                    startFound$iv$iv2 = false;
                    while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                        index$iv$iv3 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                        it3 = $this$trim$iv$iv3.charAt(index$iv$iv3);
                        boolean bl = false;
                        boolean bl4 = match$iv$iv3 = Intrinsics.compare(it3, 32) <= 0;
                        if (!startFound$iv$iv2) {
                            if (!match$iv$iv3) {
                                startFound$iv$iv2 = true;
                                continue;
                            }
                            ++startIndex$iv$iv2;
                            continue;
                        }
                        if (!match$iv$iv3) break;
                        --endIndex$iv$iv2;
                    }
                    String temp = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                    Object tempKey = null;
                    for (int i = 0; i < 100; ++i) {
                        tempKey = temp + "[" + i + "]";
                        String checkKey = this.getKeyFromList(currentKey, (String)tempKey);
                        if (configMap.containsKey(checkKey)) continue;
                        currentKey.add(tempKey);
                        ((Map)configMap).put(checkKey, null);
                        continue block0;
                    }
                    continue;
                }
                if (depth == 0) {
                    currentKey.clear();
                } else {
                    if (currentKey.size() > depth) {
                        while (currentKey.size() > depth) {
                            currentKey.remove(currentKey.size() - 1);
                        }
                    }
                    key = this.getKeyFromList(currentKey, key);
                }
                if (!hasValues) {
                    currentKey.add(origKey);
                    if (configMap.containsKey(key)) continue;
                    ((Map)configMap).put(key, new FieldInfo(null, depth));
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(useLine.substring(firstColon + 1), "substring(...)");
                $i$f$trim5 = false;
                CharSequence $this$trim$iv$iv4 = (CharSequence)$this$trim$iv2;
                $i$f$trim3 = false;
                startIndex$iv$iv2 = 0;
                endIndex$iv$iv2 = $this$trim$iv$iv4.length() - 1;
                startFound$iv$iv2 = false;
                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                    index$iv$iv3 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                    it3 = $this$trim$iv$iv4.charAt(index$iv$iv3);
                    boolean bl = false;
                    boolean bl5 = match$iv$iv3 = Intrinsics.compare(it3, 32) <= 0;
                    if (!startFound$iv$iv2) {
                        if (!match$iv$iv3) {
                            startFound$iv$iv2 = true;
                            continue;
                        }
                        ++startIndex$iv$iv2;
                        continue;
                    }
                    if (!match$iv$iv3) break;
                    --endIndex$iv$iv2;
                }
                String value = ((Object)$this$trim$iv$iv4.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                FieldInfo fi = new FieldInfo(value, depth);
                fi.setHasValue(true);
                ((Map)configMap).put(key, fi);
                continue;
            }
            if (!StringsKt.startsWith$default(useLine, "-", false, 2, null)) continue;
            String key = this.getKeyFromList(currentKey, null);
            String $this$trim$iv4 = useLine;
            $i$f$trim2 = 0;
            CharSequence $this$trim$iv$iv5 = $this$trim$iv4;
            boolean $i$f$trim6 = false;
            int startIndex$iv$iv4 = 0;
            int endIndex$iv$iv4 = $this$trim$iv$iv5.length() - 1;
            boolean startFound$iv$iv4 = false;
            while (startIndex$iv$iv4 <= endIndex$iv$iv4) {
                index$iv$iv = !startFound$iv$iv4 ? startIndex$iv$iv4 : endIndex$iv$iv4;
                it = $this$trim$iv$iv5.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl6 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv4) {
                    if (!match$iv$iv) {
                        startFound$iv$iv4 = true;
                        continue;
                    }
                    ++startIndex$iv$iv4;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv4;
            }
            $this$trim$iv4 = ((Object)$this$trim$iv$iv5.subSequence(startIndex$iv$iv4, endIndex$iv$iv4 + 1)).toString();
            $i$f$trim2 = 1;
            String string = $this$trim$iv4.substring($i$f$trim2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            $this$trim$iv4 = string;
            $i$f$trim2 = 0;
            $this$trim$iv$iv5 = $this$trim$iv4;
            $i$f$trim6 = false;
            startIndex$iv$iv4 = 0;
            endIndex$iv$iv4 = $this$trim$iv$iv5.length() - 1;
            startFound$iv$iv4 = false;
            while (startIndex$iv$iv4 <= endIndex$iv$iv4) {
                index$iv$iv = !startFound$iv$iv4 ? startIndex$iv$iv4 : endIndex$iv$iv4;
                it = $this$trim$iv$iv5.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl7 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv4) {
                    if (!match$iv$iv) {
                        startFound$iv$iv4 = true;
                        continue;
                    }
                    ++startIndex$iv$iv4;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv4;
            }
            String value = ((Object)$this$trim$iv$iv5.subSequence(startIndex$iv$iv4, endIndex$iv$iv4 + 1)).toString();
            if (configMap.containsKey(key)) {
                FieldInfo fi;
                FieldInfo fieldInfo = fi = (FieldInfo)configMap.get(key);
                Intrinsics.checkNotNull(fieldInfo);
                fieldInfo.addListValue(value);
                continue;
            }
            ((Map)configMap).put(key, new FieldInfo(value, depth, true));
        }
        return configMap;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\b\u0010 \u001a\u00020\u0003H\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006!"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/FileMigrator$FieldInfo;", "", "value", "", "depth", "", "<init>", "(Ljava/lang/String;I)V", "isListValue", "", "(Ljava/lang/String;IZ)V", "simpleValue", "getSimpleValue", "()Ljava/lang/String;", "setSimpleValue", "(Ljava/lang/String;)V", "valueList", "", "getValueList", "()Ljava/util/List;", "setValueList", "(Ljava/util/List;)V", "getDepth", "()I", "hasValue", "getHasValue", "()Z", "setHasValue", "(Z)V", "isList", "addListValue", "", "toString", "levelledmobs-plugin"})
    private static final class FieldInfo {
        @Nullable
        private String simpleValue;
        @Nullable
        private List<String> valueList;
        private final int depth;
        private boolean hasValue;

        @Nullable
        public final String getSimpleValue() {
            return this.simpleValue;
        }

        public final void setSimpleValue(@Nullable String string) {
            this.simpleValue = string;
        }

        @Nullable
        public final List<String> getValueList() {
            return this.valueList;
        }

        public final void setValueList(@Nullable List<String> list) {
            this.valueList = list;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final boolean getHasValue() {
            return this.hasValue;
        }

        public final void setHasValue(boolean bl) {
            this.hasValue = bl;
        }

        public FieldInfo(@Nullable String value, int depth) {
            this.simpleValue = value;
            this.depth = depth;
        }

        public FieldInfo(@Nullable String value, int depth, boolean isListValue) {
            if (isListValue) {
                this.addListValue(value);
            } else {
                this.simpleValue = value;
            }
            this.depth = depth;
        }

        public final boolean isList() {
            return this.valueList != null;
        }

        public final void addListValue(@Nullable String value) {
            if (this.valueList == null) {
                this.valueList = new ArrayList();
            }
            List<String> list = this.valueList;
            Intrinsics.checkNotNull(list);
            list.add(value);
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String toString() {
            String string;
            if (this.isList()) {
                String string2;
                if (this.valueList != null) {
                    List<String> list = this.valueList;
                    Intrinsics.checkNotNull(list);
                    if (!list.isEmpty()) {
                        List<String> list2 = this.valueList;
                        Intrinsics.checkNotNull(list2);
                        string2 = CollectionsKt.joinToString$default(list2, ",", null, null, 0, null, null, 62, null);
                        return string2;
                    }
                }
                string2 = super.toString();
                return string2;
            }
            if (this.simpleValue == null) {
                string = super.toString();
                return string;
            }
            String string3 = this.simpleValue;
            string = string3;
            Intrinsics.checkNotNull(string3);
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\tR\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/FileMigrator$KeySectionInfo;", "", "<init>", "()V", "lineNumber", "", "getLineNumber", "()I", "setLineNumber", "(I)V", "lines", "", "", "getLines", "()Ljava/util/List;", "sectionNumber", "getSectionNumber", "setSectionNumber", "sectionStartingLine", "getSectionStartingLine", "setSectionStartingLine", "levelledmobs-plugin"})
    private static final class KeySectionInfo {
        private int lineNumber;
        @NotNull
        private final List<String> lines = new ArrayList();
        private int sectionNumber;
        private int sectionStartingLine;

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final void setLineNumber(int n) {
            this.lineNumber = n;
        }

        @NotNull
        public final List<String> getLines() {
            return this.lines;
        }

        public final int getSectionNumber() {
            return this.sectionNumber;
        }

        public final void setSectionNumber(int n) {
            this.sectionNumber = n;
        }

        public final int getSectionStartingLine() {
            return this.sectionStartingLine;
        }

        public final void setSectionStartingLine(int n) {
            this.sectionStartingLine = n;
        }
    }
}

