/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.misc.PlayerQueueItem;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010&\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0016J0\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00062\u001e\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u001cH\u0002JF\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 2\u0006\u0010\u001a\u001a\u00020\u00062\u001e\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u001cH\u0002J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/NametagTimerChecker;", "", "<init>", "()V", "nametagCooldownQueue", "", "Lorg/bukkit/entity/Player;", "Ljava/util/WeakHashMap;", "Lorg/bukkit/entity/LivingEntity;", "Ljava/time/Instant;", "getNametagCooldownQueue", "()Ljava/util/Map;", "cooldownTimes", "", "getCooldownTimes", "()Ljava/util/WeakHashMap;", "entityTargetMap", "getEntityTargetMap", "playersQueue", "Ljava/util/Queue;", "Lio/github/arcaneplugins/levelledmobs/misc/PlayerQueueItem;", "addPlayerToQueue", "", "item", "checkNametags", "processCooldownQueue", "player", "coolDown", "", "processCoolDownEntity", "livingEntity", "entitiesToRemove", "", "updateNametag", "Companion", "levelledmobs-plugin"})
public final class NametagTimerChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Player, WeakHashMap<LivingEntity, Instant>> nametagCooldownQueue = new LinkedHashMap();
    @NotNull
    private final WeakHashMap<LivingEntity, Long> cooldownTimes = new WeakHashMap();
    @NotNull
    private final WeakHashMap<LivingEntity, Player> entityTargetMap = new WeakHashMap();
    @NotNull
    private final Queue<PlayerQueueItem> playersQueue = new LinkedList();
    @NotNull
    private static final Object nametagTimer_Lock = new Object();
    @NotNull
    private static final Object entityTarget_Lock = new Object();
    @NotNull
    private static final Object playerQueue_Lock = new Object();

    @NotNull
    public final Map<Player, WeakHashMap<LivingEntity, Instant>> getNametagCooldownQueue() {
        return this.nametagCooldownQueue;
    }

    @NotNull
    public final WeakHashMap<LivingEntity, Long> getCooldownTimes() {
        return this.cooldownTimes;
    }

    @NotNull
    public final WeakHashMap<LivingEntity, Player> getEntityTargetMap() {
        return this.entityTargetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPlayerToQueue(@NotNull PlayerQueueItem item) {
        Intrinsics.checkNotNullParameter(item, "item");
        Object object = playerQueue_Lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.playersQueue.offer(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkNametags() {
        Object object = nametagTimer_Lock;
        synchronized (object) {
            boolean bl = false;
            Object object2 = playerQueue_Lock;
            synchronized (object2) {
                boolean $i$a$-synchronized-NametagTimerChecker$checkNametags$1$22 = false;
                while (!this.playersQueue.isEmpty()) {
                    PlayerQueueItem item;
                    if (this.playersQueue.poll() == null) continue;
                    if (item.isPlayerJoin()) {
                        this.nametagCooldownQueue.put(item.getPlayer(), new WeakHashMap());
                        continue;
                    }
                    this.nametagCooldownQueue.remove(item.getPlayer());
                }
                Unit $i$a$-synchronized-NametagTimerChecker$checkNametags$1$22 = Unit.INSTANCE;
            }
            if (this.nametagCooldownQueue.isEmpty()) {
                return;
            }
            for (Map.Entry<Player, WeakHashMap<LivingEntity, Instant>> coolDown : this.nametagCooldownQueue.entrySet()) {
                Player player = coolDown.getKey();
                this.processCooldownQueue(player, coolDown);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void processCooldownQueue(Player player, Map.Entry<? extends Player, ? extends WeakHashMap<LivingEntity, Instant>> coolDown) {
        List entitiesToRemove = new ArrayList();
        boolean isRunningFolia = LevelledMobs.Companion.getInstance().getVer().isRunningFolia();
        for (LivingEntity livingEntity : coolDown.getValue().keySet()) {
            if (isRunningFolia) {
                livingEntity.getScheduler().run((Plugin)LevelledMobs.Companion.getInstance(), arg_0 -> NametagTimerChecker.processCooldownQueue$lambda$0(this, livingEntity, entitiesToRemove, player, coolDown, arg_0), null);
                continue;
            }
            Intrinsics.checkNotNull(livingEntity);
            this.processCoolDownEntity(livingEntity, entitiesToRemove, player, coolDown);
        }
        for (LivingEntity livingEntity : entitiesToRemove) {
            coolDown.getValue().remove(livingEntity);
            SchedulerWrapper wrapper = new SchedulerWrapper((Entity)livingEntity, () -> NametagTimerChecker.processCooldownQueue$lambda$1(this, livingEntity, player));
            wrapper.setRunDirectlyInBukkit(true);
            wrapper.run();
        }
        entitiesToRemove.clear();
    }

    private final void processCoolDownEntity(LivingEntity livingEntity, List<LivingEntity> entitiesToRemove, Player player, Map.Entry<? extends Player, ? extends WeakHashMap<LivingEntity, Instant>> coolDown) {
        if (!livingEntity.isValid()) {
            return;
        }
        Instant startInclusive = coolDown.getValue().get(livingEntity);
        if (startInclusive == null) {
            entitiesToRemove.add(livingEntity);
            return;
        }
        if (!Intrinsics.areEqual(player.getWorld().getName(), livingEntity.getWorld().getName())) {
            entitiesToRemove.add(livingEntity);
            return;
        }
        Duration timeDuration = Duration.between(startInclusive, Instant.now());
        Long l = this.cooldownTimes.get(livingEntity);
        Intrinsics.checkNotNull(l);
        long cooldownTime = ((Number)l).longValue();
        if (timeDuration.toMillis() >= cooldownTime) {
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
            boolean usesLoS = lmEntity.getNametagVisibilityEnum().contains((Object)NametagVisibilityEnum.TARGETED);
            if (usesLoS && livingEntity.hasLineOfSight((Entity)player)) {
                ((Map)coolDown.getValue()).put(livingEntity, Instant.now());
            } else {
                entitiesToRemove.add(livingEntity);
            }
            lmEntity.free();
        }
    }

    private final void updateNametag(LivingEntity livingEntity, Player player) {
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        NametagResult nametag = lmEntity.getMain().getLevelManager().getNametag(lmEntity, false, true);
        Player[] playerArray = new Player[]{player};
        lmEntity.getMain().getLevelManager().updateNametag(lmEntity, nametag, CollectionsKt.mutableListOf(playerArray));
        lmEntity.free();
    }

    private static final void processCooldownQueue$lambda$0(NametagTimerChecker this$0, LivingEntity $livingEntity, List $entitiesToRemove, Player $player, Map.Entry $coolDown, ScheduledTask it) {
        Intrinsics.checkNotNull($livingEntity);
        this$0.processCoolDownEntity($livingEntity, $entitiesToRemove, $player, $coolDown);
    }

    private static final void processCooldownQueue$lambda$1(NametagTimerChecker this$0, LivingEntity $livingEntity, Player $player) {
        this$0.updateNametag($livingEntity, $player);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/NametagTimerChecker$Companion;", "", "<init>", "()V", "nametagTimer_Lock", "getNametagTimer_Lock", "()Ljava/lang/Object;", "entityTarget_Lock", "getEntityTarget_Lock", "playerQueue_Lock", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getNametagTimer_Lock() {
            return nametagTimer_Lock;
        }

        @NotNull
        public final Object getEntityTarget_Lock() {
            return entityTarget_Lock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

