/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Contract;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.CharsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.Regex;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0019\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/PickedUpEquipment;", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "<init>", "(Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;)V", "getLmEntity", "()Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "ee", "Lorg/bukkit/inventory/EntityEquipment;", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "itemsNamespace", "Lorg/bukkit/NamespacedKey;", "slotMappings", "", "", "", "checkEquipment", "", "getMobPickedUpItems", "", "storeItemInPDC", "slotNumber", "getNewKeyString", "parseExistingKey", "pdcKey", "getItemEquippedSlot", "Companion", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nPickedUpEquipment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PickedUpEquipment.kt\nio/github/arcaneplugins/levelledmobs/misc/PickedUpEquipment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,170:1\n739#2,9:171\n37#3,2:180\n*S KotlinDebug\n*F\n+ 1 PickedUpEquipment.kt\nio/github/arcaneplugins/levelledmobs/misc/PickedUpEquipment\n*L\n94#1:171,9\n94#1:180,2\n*E\n"})
public final class PickedUpEquipment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LivingEntityWrapper lmEntity;
    @Nullable
    private EntityEquipment ee;
    @Nullable
    private ItemStack itemStack;
    @NotNull
    private final NamespacedKey itemsNamespace;
    @NotNull
    private final Map<Integer, String> slotMappings;

    public PickedUpEquipment(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        this.lmEntity = lmEntity;
        this.itemsNamespace = NamespacedKeys.INSTANCE.getPickedUpItems();
        this.slotMappings = new LinkedHashMap();
    }

    @NotNull
    public final LivingEntityWrapper getLmEntity() {
        return this.lmEntity;
    }

    public final void checkEquipment(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (itemStack.getType() == Material.AIR) {
            return;
        }
        if (this.lmEntity.getLivingEntity().getEquipment() == null) {
            return;
        }
        this.itemStack = itemStack;
        this.ee = this.lmEntity.getLivingEntity().getEquipment();
        int slotNumber = this.getItemEquippedSlot();
        if (slotNumber >= 0) {
            this.storeItemInPDC(slotNumber);
        }
    }

    @NotNull
    public final List<ItemStack> getMobPickedUpItems() {
        List results = new ArrayList();
        if (!this.lmEntity.getPdc().has(this.itemsNamespace, PersistentDataType.STRING)) {
            return results;
        }
        this.parseExistingKey((String)this.lmEntity.getPdc().get(this.itemsNamespace, PersistentDataType.STRING));
        if (this.slotMappings.isEmpty()) {
            return results;
        }
        for (String itemsHex : this.slotMappings.values()) {
            if (itemsHex.length() % 2 != 0) {
                Log.INSTANCE.inf("Unable to deserialize picked up item, invalid length: " + itemsHex.length());
                continue;
            }
            byte[] bytes = PickedUpEquipment.Companion.hexToByte(itemsHex);
            try {
                ItemStack itemStack = ItemStack.deserializeBytes((byte[])bytes);
                Intrinsics.checkNotNullExpressionValue(itemStack, "deserializeBytes(...)");
                results.add(itemStack);
            }
            catch (Exception e) {
                Log.INSTANCE.inf("Unable to deserialize itemstack: " + e.getMessage());
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void storeItemInPDC(int slotNumber) {
        PersistentDataContainer persistentDataContainer = this.lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            boolean bl = false;
            if (this.lmEntity.getPdc().has(this.itemsNamespace, PersistentDataType.STRING)) {
                this.parseExistingKey((String)this.lmEntity.getPdc().get(this.itemsNamespace, PersistentDataType.STRING));
            }
            Map<Integer, String> map = this.slotMappings;
            Integer n = slotNumber;
            ItemStack itemStack = this.itemStack;
            Intrinsics.checkNotNull(itemStack);
            byte[] byArray = itemStack.serializeAsBytes();
            Intrinsics.checkNotNullExpressionValue(byArray, "serializeAsBytes(...)");
            String string = PickedUpEquipment.Companion.bytesToHex(byArray);
            map.put(n, string);
            String hexString = this.getNewKeyString();
            if (hexString != null) {
                this.lmEntity.getPdc().set(this.itemsNamespace, PersistentDataType.STRING, (Object)hexString);
            } else {
                this.lmEntity.getPdc().remove(this.itemsNamespace);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String getNewKeyString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Integer> iterator2 = this.slotMappings.keySet().iterator();
        while (iterator2.hasNext()) {
            int slotNumber = ((Number)iterator2.next()).intValue();
            String hex = this.slotMappings.get(slotNumber);
            if (((CharSequence)sb).length() > 0) {
                sb.append(";");
            }
            sb.append(slotNumber).append(":").append(hex);
        }
        return ((CharSequence)sb).length() == 0 ? null : sb.toString();
    }

    private final void parseExistingKey(String pdcKey) {
        List list;
        this.slotMappings.clear();
        String[] stringArray = (String[])pdcKey;
        if (stringArray == null || stringArray.length() == 0) {
            return;
        }
        CharSequence charSequence = pdcKey;
        Regex regex = new Regex(";");
        int n = 0;
        List<String> $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (String key : thisCollection$iv.toArray(new String[0])) {
            if (key.length() < 3 || key.length() % 2 != 0) continue;
            int slotNumber = Character.getNumericValue(key.charAt(0));
            boolean bl = 0 <= slotNumber ? slotNumber < 7 : false;
            if (!bl) continue;
            Integer n2 = slotNumber;
            String string = key.substring(2);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            this.slotMappings.put(n2, string);
        }
    }

    private final int getItemEquippedSlot() {
        ItemStack itemStack = this.itemStack;
        Intrinsics.checkNotNull(itemStack);
        ItemStack itmStk = itemStack;
        EntityEquipment entityEquipment = this.ee;
        Intrinsics.checkNotNull(entityEquipment);
        EntityEquipment eeNN = entityEquipment;
        if (itmStk.isSimilar(eeNN.getItemInMainHand())) {
            return 0;
        }
        if (itmStk.isSimilar(eeNN.getItemInOffHand())) {
            return 1;
        }
        if (eeNN.getHelmet() != null && itmStk.isSimilar(eeNN.getHelmet())) {
            return 2;
        }
        if (eeNN.getChestplate() != null && itmStk.isSimilar(eeNN.getChestplate())) {
            return 3;
        }
        if (eeNN.getLeggings() != null && itmStk.isSimilar(eeNN.getLeggings())) {
            return 4;
        }
        if (eeNN.getBoots() != null && itmStk.isSimilar(eeNN.getBoots())) {
            return 5;
        }
        if (itmStk.isSimilar(eeNN.getItemInMainHand())) {
            return 6;
        }
        return -1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/PickedUpEquipment$Companion;", "", "<init>", "()V", "bytesToHex", "", "bytes", "", "hexToByte", "hexString", "toDigit", "", "hexChar", "", "levelledmobs-plugin"})
    @SourceDebugExtension(value={"SMAP\nPickedUpEquipment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PickedUpEquipment.kt\nio/github/arcaneplugins/levelledmobs/misc/PickedUpEquipment$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Contract(value="_ -> new")
        private final String bytesToHex(byte[] bytes) {
            char[] hexDigits = new char[bytes.length * 2];
            int currentIndex = 0;
            for (byte num : bytes) {
                hexDigits[currentIndex] = Character.forDigit(num >> 4 & 0xF, 16);
                hexDigits[++currentIndex] = Character.forDigit(num & 0xF, 16);
                ++currentIndex;
            }
            return new String(hexDigits);
        }

        private final byte[] hexToByte(String hexString) {
            byte[] result = new byte[hexString.length() / 2];
            int currentIndex = 0;
            for (int i = 0; i < hexString.length(); i += 2) {
                int firstDigit = this.toDigit(hexString.charAt(i));
                int secondDigit = this.toDigit(hexString.charAt(i + 1));
                result[currentIndex++] = (byte)((firstDigit << 4) + secondDigit);
            }
            return result;
        }

        private final int toDigit(char hexChar) {
            Integer n = CharsKt.digitToIntOrNull(hexChar, 16);
            int digit = n != null ? n : -1;
            if (!(digit != -1)) {
                boolean bl = false;
                String string = "Invalid Hexadecimal Character: " + hexChar;
                throw new IllegalArgumentException(string.toString());
            }
            return digit;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

