/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import java.util.function.Supplier;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0010\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\rJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0011J\u0018\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/StringReplacer;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "replaceIfExists", "", "target", "operation", "Ljava/util/function/Supplier;", "replace", "replaceWith", "", "", "isEmpty", "", "()Z", "contains", "s", "", "toString", "levelledmobs-plugin"})
public final class StringReplacer {
    @NotNull
    private String text;

    public StringReplacer(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.text = text;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.text = string;
    }

    public final void replaceIfExists(@NotNull String target, @Nullable Supplier<String> operation) {
        String newText;
        Intrinsics.checkNotNullParameter(target, "target");
        Supplier<String> supplier = operation;
        String string = newText = supplier != null ? supplier.get() : null;
        if (StringsKt.contains$default((CharSequence)this.text, target, false, 2, null)) {
            this.replace(target, newText);
        }
    }

    public final void replace(@NotNull String replace, double replaceWith) {
        Intrinsics.checkNotNullParameter(replace, "replace");
        this.replace(replace, String.valueOf(replaceWith));
    }

    public final void replace(@NotNull String replace, int replaceWith) {
        Intrinsics.checkNotNullParameter(replace, "replace");
        this.replace(replace, String.valueOf(replaceWith));
    }

    @NotNull
    public final StringReplacer replace(@NotNull String replace, @Nullable String replaceWith) {
        Intrinsics.checkNotNullParameter(replace, "replace");
        String string = replaceWith;
        if (string == null) {
            string = "";
        }
        String replaceWithText = string;
        this.text = StringsKt.replace$default(this.text, replace, replaceWithText, false, 4, null);
        return this;
    }

    public final boolean isEmpty() {
        return ((CharSequence)this.text).length() == 0;
    }

    public final boolean contains(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter(s, "s");
        return StringsKt.contains$default((CharSequence)this.text, s, false, 2, null);
    }

    @NotNull
    public String toString() {
        return this.text;
    }
}

