/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.nametag;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.nametag.ComponentUtils;
import io.github.arcaneplugins.levelledmobs.nametag.Definitions;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.lang.reflect.Method;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.LivingEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/github/arcaneplugins/levelledmobs/nametag/KyoriNametags;", "", "<init>", "()V", "def", "Lio/github/arcaneplugins/levelledmobs/nametag/Definitions;", "generateComponent", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "nametagResult", "Lio/github/arcaneplugins/levelledmobs/result/NametagResult;", "generateDeathMessage", "Lnet/kyori/adventure/text/Component;", "mobKey", "", "levelledmobs-plugin"})
public final class KyoriNametags {
    @NotNull
    public static final KyoriNametags INSTANCE = new KyoriNametags();
    @NotNull
    private static final Definitions def = LevelledMobs.Companion.getInstance().getDefinitions();

    private KyoriNametags() {
    }

    @NotNull
    public final Object generateComponent(@NotNull LivingEntity livingEntity, @NotNull NametagResult nametagResult) {
        Component component;
        Component mobNameComponent;
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        Intrinsics.checkNotNullParameter(nametagResult, "nametagResult");
        String nametag = nametagResult.getNametagNonNull();
        String string = livingEntity.getType().translationKey();
        Intrinsics.checkNotNullExpressionValue(string, "translationKey(...)");
        String mobKey = string;
        if (nametagResult.getOverriddenName() == null) {
            if (def.getUseTranslationComponents()) {
                var6_5 = Component.translatable((String)mobKey);
                Intrinsics.checkNotNull(var6_5);
                v1 = (Component)var6_5;
            } else {
                var6_5 = Component.text((String)livingEntity.getName());
                Intrinsics.checkNotNull(var6_5);
                v1 = (Component)var6_5;
            }
        } else {
            LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacyAmpersand();
            String string2 = nametagResult.getOverriddenName();
            Intrinsics.checkNotNull(string2);
            var6_5 = legacyComponentSerializer.deserialize(string2);
            Intrinsics.checkNotNull(var6_5);
            v1 = mobNameComponent = (Component)var6_5;
        }
        if (def.getUseLegacySerializer()) {
            component = LegacyComponentSerializer.legacyAmpersand().deserialize(nametag).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{DisplayName}").replacement((ComponentLike)mobNameComponent).build());
        } else {
            MiniMessage miniMessage = def.getMm();
            Intrinsics.checkNotNull(miniMessage);
            component = miniMessage.deserialize((Object)nametag).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{DisplayName}").replacement((ComponentLike)mobNameComponent).build());
        }
        Component component2 = component;
        Intrinsics.checkNotNull(component2);
        Component result = component2;
        Component component3 = result.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{CustomName}").replacement((ComponentLike)livingEntity.name()).build());
        Intrinsics.checkNotNullExpressionValue(component3, "replaceText(...)");
        result = component3;
        try {
            Method method = def.getMethodAsVanilla();
            Intrinsics.checkNotNull(method);
            Object[] objectArray = new Object[]{result};
            Object object = method.invoke(def.getClazzPaperAdventure(), objectArray);
            Intrinsics.checkNotNullExpressionValue(object, "invoke(...)");
            return object;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ComponentUtils.INSTANCE.getEmptyComponent();
        }
    }

    @NotNull
    public final Component generateDeathMessage(@NotNull String mobKey, @NotNull NametagResult nametagResult) {
        Component component;
        Component mobNameComponent;
        Intrinsics.checkNotNullParameter(mobKey, "mobKey");
        Intrinsics.checkNotNullParameter(nametagResult, "nametagResult");
        LivingEntity livingEntity = nametagResult.getKillerMob();
        Intrinsics.checkNotNull(livingEntity);
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        LevelManager levelManager = LevelledMobs.Companion.getInstance().getLevelManager();
        String string = nametagResult.getCustomDeathMessage();
        Intrinsics.checkNotNull(string);
        String nametag = levelManager.replaceStringPlaceholders(string, lmEntity, false, null, true);
        lmEntity.free();
        if (nametagResult.getOverriddenName() == null) {
            var6_5 = Component.translatable((String)mobKey);
            Intrinsics.checkNotNull(var6_5);
            v3 = (Component)var6_5;
        } else {
            LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacyAmpersand();
            String string2 = nametagResult.getOverriddenName();
            Intrinsics.checkNotNull(string2);
            var6_5 = legacyComponentSerializer.deserialize(string2);
            Intrinsics.checkNotNull(var6_5);
            v3 = mobNameComponent = (Component)var6_5;
        }
        if (def.getUseLegacySerializer()) {
            component = LegacyComponentSerializer.legacyAmpersand().deserialize(nametag).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{DisplayName}").replacement((ComponentLike)mobNameComponent).build());
        } else {
            MiniMessage miniMessage = def.getMm();
            Intrinsics.checkNotNull(miniMessage);
            component = miniMessage.deserialize((Object)nametag).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{DisplayName}").replacement((ComponentLike)mobNameComponent).build());
        }
        Component component2 = component;
        Intrinsics.checkNotNull(component2);
        Component result = component2;
        return result;
    }
}

