/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.misc.EffectiveInfo;
import io.github.arcaneplugins.levelledmobs.rules.LMMultiplier;
import io.github.arcaneplugins.levelledmobs.rules.MergableRule;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002ABB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010(\u001a\u00020\u0019J\u0012\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u00107\u001a\u0004\u0018\u00010\t2\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:J\u0018\u0010;\u001a\u0004\u0018\u00010\t2\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020:J\b\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010?\u001a\u00020\u000fH\u0016J\u0012\u0010@\u001a\u00020\u000f2\b\u00109\u001a\u0004\u0018\u00010:H\u0002R(\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR4\u0010\u000e\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR(\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000b\"\u0004\b\u0014\u0010\rR4\u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\rR\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001a\u0010$\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001b\"\u0004\b&\u0010\u001dR\u001e\u0010'\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010,\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010.\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u001b\"\u0004\b0\u0010\u001dR\u0011\u00101\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001bR\u0014\u00105\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001b\u00a8\u0006C"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes;", "Lio/github/arcaneplugins/levelledmobs/rules/MergableRule;", "", "Lio/github/arcaneplugins/levelledmobs/misc/EffectiveInfo;", "<init>", "()V", "multipliers", "", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Multiplier;", "getMultipliers", "()Ljava/util/Map;", "setMultipliers", "(Ljava/util/Map;)V", "mobSpecificMultipliers", "", "getMobSpecificMultipliers", "setMobSpecificMultipliers", "baseAttributeModifiers", "getBaseAttributeModifiers", "setBaseAttributeModifiers", "mobSpecificBaseModifiers", "getMobSpecificBaseModifiers", "setMobSpecificBaseModifiers", "doNotMergeAllMultipliers", "", "getDoNotMergeAllMultipliers", "()Z", "setDoNotMergeAllMultipliers", "(Z)V", "doNotMergeMobSpecificMultipliers", "getDoNotMergeMobSpecificMultipliers", "setDoNotMergeMobSpecificMultipliers", "doNotMergeAllBaseMods", "getDoNotMergeAllBaseMods", "setDoNotMergeAllBaseMods", "doNotMergeMobSpecificBaseMods", "getDoNotMergeMobSpecificBaseMods", "setDoNotMergeMobSpecificBaseMods", "useStacked", "getUseStacked", "()Ljava/lang/Boolean;", "setUseStacked", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "value", "doNotMerge", "getDoNotMerge", "setDoNotMerge", "isEmpty", "merge", "", "mergableRule", "doMerge", "getDoMerge", "getMultiplier", "addition", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "getBaseModifier", "cloneItem", "", "getEffectiveInfo", "toString", "formatToString", "Companion", "Multiplier", "levelledmobs-plugin"})
public final class FineTuningAttributes
implements MergableRule,
Cloneable,
EffectiveInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<Addition, Multiplier> multipliers;
    @Nullable
    private Map<String, Map<Addition, Multiplier>> mobSpecificMultipliers;
    @Nullable
    private Map<Addition, Multiplier> baseAttributeModifiers;
    @Nullable
    private Map<String, Map<Addition, Multiplier>> mobSpecificBaseModifiers;
    private boolean doNotMergeAllMultipliers;
    private boolean doNotMergeMobSpecificMultipliers;
    private boolean doNotMergeAllBaseMods;
    private boolean doNotMergeMobSpecificBaseMods;
    @Nullable
    private Boolean useStacked;
    @NotNull
    private static final Object lockObject = new Object();

    @Nullable
    public final Map<Addition, Multiplier> getMultipliers() {
        return this.multipliers;
    }

    public final void setMultipliers(@Nullable Map<Addition, Multiplier> map) {
        this.multipliers = map;
    }

    @Nullable
    public final Map<String, Map<Addition, Multiplier>> getMobSpecificMultipliers() {
        return this.mobSpecificMultipliers;
    }

    public final void setMobSpecificMultipliers(@Nullable Map<String, Map<Addition, Multiplier>> map) {
        this.mobSpecificMultipliers = map;
    }

    @Nullable
    public final Map<Addition, Multiplier> getBaseAttributeModifiers() {
        return this.baseAttributeModifiers;
    }

    public final void setBaseAttributeModifiers(@Nullable Map<Addition, Multiplier> map) {
        this.baseAttributeModifiers = map;
    }

    @Nullable
    public final Map<String, Map<Addition, Multiplier>> getMobSpecificBaseModifiers() {
        return this.mobSpecificBaseModifiers;
    }

    public final void setMobSpecificBaseModifiers(@Nullable Map<String, Map<Addition, Multiplier>> map) {
        this.mobSpecificBaseModifiers = map;
    }

    public final boolean getDoNotMergeAllMultipliers() {
        return this.doNotMergeAllMultipliers;
    }

    public final void setDoNotMergeAllMultipliers(boolean bl) {
        this.doNotMergeAllMultipliers = bl;
    }

    public final boolean getDoNotMergeMobSpecificMultipliers() {
        return this.doNotMergeMobSpecificMultipliers;
    }

    public final void setDoNotMergeMobSpecificMultipliers(boolean bl) {
        this.doNotMergeMobSpecificMultipliers = bl;
    }

    public final boolean getDoNotMergeAllBaseMods() {
        return this.doNotMergeAllBaseMods;
    }

    public final void setDoNotMergeAllBaseMods(boolean bl) {
        this.doNotMergeAllBaseMods = bl;
    }

    public final boolean getDoNotMergeMobSpecificBaseMods() {
        return this.doNotMergeMobSpecificBaseMods;
    }

    public final void setDoNotMergeMobSpecificBaseMods(boolean bl) {
        this.doNotMergeMobSpecificBaseMods = bl;
    }

    @Nullable
    public final Boolean getUseStacked() {
        return this.useStacked;
    }

    public final void setUseStacked(@Nullable Boolean bl) {
        this.useStacked = bl;
    }

    public final boolean getDoNotMerge() {
        return this.doNotMergeAllMultipliers && this.doNotMergeMobSpecificMultipliers && this.doNotMergeAllBaseMods && this.doNotMergeMobSpecificBaseMods;
    }

    public final void setDoNotMerge(boolean value) {
        this.doNotMergeAllMultipliers = value;
        this.doNotMergeMobSpecificMultipliers = value;
        this.doNotMergeAllBaseMods = value;
        this.doNotMergeMobSpecificBaseMods = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getUseStacked() {
        if (this.useStacked == null) return false;
        Boolean bl = this.useStacked;
        Intrinsics.checkNotNull(bl);
        if (bl == false) return false;
        return true;
    }

    public final boolean isEmpty() {
        Map<Object, Object> map = this.multipliers;
        return (map == null || map.isEmpty()) && ((map = this.baseAttributeModifiers) == null || map.isEmpty()) && ((map = this.mobSpecificMultipliers) == null || map.isEmpty()) && ((map = this.mobSpecificBaseModifiers) == null || map.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(@Nullable MergableRule mergableRule) {
        if (!(mergableRule instanceof FineTuningAttributes)) {
            return;
        }
        Object object = lockObject;
        synchronized (object) {
            boolean bl = false;
            FineTuningAttributes.Companion.copyMultipliers((FineTuningAttributes)mergableRule, this, false);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public boolean getDoMerge() {
        return !this.getDoNotMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Multiplier getMultiplier(@NotNull Addition addition, @NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter((Object)addition, "addition");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Object object = lockObject;
        synchronized (object) {
            Multiplier multiplier;
            block6: {
                Multiplier result;
                boolean bl = false;
                if (this.mobSpecificMultipliers == null) break block6;
                Map<String, Map<Addition, Multiplier>> map = this.mobSpecificMultipliers;
                Intrinsics.checkNotNull(map);
                Map<Addition, Multiplier> map2 = map.get(lmEntity.getNameIfBaby());
                Multiplier multiplier2 = result = map2 != null ? map2.get((Object)addition) : null;
                if (result == null) break block6;
                Multiplier multiplier3 = result;
                return multiplier3;
            }
            if (this.multipliers == null) {
                multiplier = null;
            } else {
                Map<Addition, Multiplier> map = this.multipliers;
                Intrinsics.checkNotNull(map);
                multiplier = map.get((Object)addition);
            }
            Multiplier multiplier4 = multiplier;
            return multiplier4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Multiplier getBaseModifier(@NotNull Addition addition, @NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter((Object)addition, "addition");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Object object = lockObject;
        synchronized (object) {
            Multiplier multiplier;
            block6: {
                Multiplier result;
                boolean bl = false;
                if (this.mobSpecificBaseModifiers == null) break block6;
                Map<String, Map<Addition, Multiplier>> map = this.mobSpecificBaseModifiers;
                Intrinsics.checkNotNull(map);
                Map<Addition, Multiplier> map2 = map.get(lmEntity.getNameIfBaby());
                Multiplier multiplier2 = result = map2 != null ? map2.get((Object)addition) : null;
                if (result == null) break block6;
                Multiplier multiplier3 = result;
                return multiplier3;
            }
            if (this.baseAttributeModifiers == null) {
                multiplier = null;
            } else {
                Map<Addition, Multiplier> map = this.baseAttributeModifiers;
                Intrinsics.checkNotNull(map);
                multiplier = map.get((Object)addition);
            }
            Multiplier multiplier4 = multiplier;
            return multiplier4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object cloneItem() {
        FineTuningAttributes copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes");
            copy = (FineTuningAttributes)object;
            if (this.multipliers != null) {
                copy.multipliers = new LinkedHashMap();
            }
            if (this.mobSpecificMultipliers != null) {
                copy.mobSpecificMultipliers = new LinkedHashMap();
            }
            if (this.baseAttributeModifiers != null) {
                copy.baseAttributeModifiers = new LinkedHashMap();
            }
            if (this.mobSpecificBaseModifiers != null) {
                copy.mobSpecificBaseModifiers = new LinkedHashMap();
            }
            Object object2 = lockObject;
            synchronized (object2) {
                boolean bl = false;
                FineTuningAttributes.Companion.copyMultipliers(this, copy, true);
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FineTuningAttributes fineTuningAttributes = copy;
        Intrinsics.checkNotNull(fineTuningAttributes);
        return fineTuningAttributes;
    }

    @Override
    @NotNull
    public String getEffectiveInfo(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        FineTuningAttributes fineTunning = LevelledMobs.Companion.getInstance().getRulesManager().getFineTuningAttributes(lmEntity);
        Object object = fineTunning;
        if (object == null || (object = ((FineTuningAttributes)object).formatToString(lmEntity)) == null) {
            object = this.formatToString(lmEntity);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String toString() {
        Object object = lockObject;
        synchronized (object) {
            boolean bl = false;
            String string = this.formatToString(null);
            return string;
        }
    }

    private final String formatToString(LivingEntityWrapper lmEntity) {
        Map<String, Map<Addition, Multiplier>> map;
        Map<Object, Object> skipMultipliers2;
        Map<String, Map<Addition, Multiplier>> map2;
        if (this.isEmpty()) {
            return "No items";
        }
        StringBuilder sb = new StringBuilder();
        if (this.getUseStacked()) {
            sb.append("(all stk) ");
        }
        boolean hadItems = false;
        Map<Addition, Multiplier> map3 = this.multipliers;
        if (!(map3 == null || map3.isEmpty())) {
            boolean skipMultipliers2 = false;
            if (lmEntity != null && !((map2 = this.mobSpecificMultipliers) == null || map2.isEmpty())) {
                Map<String, Map<Addition, Multiplier>> map4 = this.mobSpecificMultipliers;
                Intrinsics.checkNotNull(map4);
                if (map4.containsKey(lmEntity.getNameIfBaby())) {
                    skipMultipliers2 = true;
                }
            }
            if (!skipMultipliers2) {
                hadItems = true;
                FineTuningAttributes.Companion.formatMultipliers(this.multipliers, sb, null, false, null);
            }
        }
        if (!((skipMultipliers2 = this.mobSpecificMultipliers) == null || skipMultipliers2.isEmpty()) && FineTuningAttributes.Companion.formatMobSpecific(this.mobSpecificMultipliers, sb, "mob specific", hadItems, lmEntity)) {
            hadItems = true;
        }
        if (!((skipMultipliers2 = this.baseAttributeModifiers) == null || skipMultipliers2.isEmpty())) {
            boolean skipBaseMods = false;
            if (lmEntity != null && !((map2 = this.mobSpecificBaseModifiers) == null || map2.isEmpty())) {
                Map<String, Map<Addition, Multiplier>> map5 = this.mobSpecificBaseModifiers;
                Intrinsics.checkNotNull(map5);
                if (map5.containsKey(lmEntity.getNameIfBaby())) {
                    skipBaseMods = true;
                }
            }
            if (!skipBaseMods) {
                FineTuningAttributes.Companion.formatMultipliers(this.baseAttributeModifiers, sb, "base mods", hadItems, null);
                hadItems = true;
            }
        }
        if (!((map = this.mobSpecificBaseModifiers) == null || map.isEmpty())) {
            FineTuningAttributes.Companion.formatMobSpecific(this.mobSpecificBaseModifiers, sb, "mob specific base mods", hadItems, lmEntity);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J(\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u0012H\u0002J@\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u00120\u00122\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u00120\u0012H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JF\u0010\u001b\u001a\u00020\u00162\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00122\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\b\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\bH\u0002JR\u0010#\u001a\u00020\u001a2 \u0010\u001c\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u0012\u0018\u00010\u00122\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001f2\b\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Companion;", "", "<init>", "()V", "lockObject", "getLockObject", "()Ljava/lang/Object;", "getShortName", "", "addition", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "getAdditionFromLMMultiplier", "lmMultiplier", "Lio/github/arcaneplugins/levelledmobs/rules/LMMultiplier;", "duplicateMultiplier", "Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Multiplier;", "multiplier", "dulicateMap1", "", "source", "dulicateMap2", "copyMultipliers", "", "Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes;", "dest", "copyAll", "", "formatMultipliers", "items", "sb", "Ljava/lang/StringBuilder;", "Lio/github/arcaneplugins/levelledmobs/libs/kotlin/text/StringBuilder;", "header", "useCarriageReturn", "mobName", "formatMobSpecific", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getLockObject() {
            return lockObject;
        }

        @NotNull
        public final String getShortName(@NotNull Addition addition) {
            Intrinsics.checkNotNullParameter((Object)addition, "addition");
            return switch (WhenMappings.$EnumSwitchMapping$0[addition.ordinal()]) {
                case 1 -> "attkDmg";
                case 2 -> "creeperDmg";
                case 3 -> "maxHlth";
                case 4 -> "moveSpd";
                case 5 -> "rangdAtkDmg";
                case 6 -> "itemDrp";
                case 7 -> "armrBns";
                case 8 -> "armrTuf";
                case 9 -> "attkKnbk";
                case 10 -> "flySpd";
                case 11 -> "knbkRst";
                case 12 -> "horseJump";
                case 13 -> "zmbRnfrce";
                case 14 -> "flwRng";
                case 15 -> "xpDrp";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final Addition getAdditionFromLMMultiplier(@NotNull LMMultiplier lmMultiplier) {
            Intrinsics.checkNotNullParameter((Object)lmMultiplier, "lmMultiplier");
            return switch (WhenMappings.$EnumSwitchMapping$1[lmMultiplier.ordinal()]) {
                case 1 -> Addition.ATTRIBUTE_ATTACK_DAMAGE;
                case 2 -> Addition.CREEPER_BLAST_DAMAGE;
                case 3 -> Addition.ATTRIBUTE_MAX_HEALTH;
                case 4 -> Addition.ATTRIBUTE_MOVEMENT_SPEED;
                case 5 -> Addition.CUSTOM_RANGED_ATTACK_DAMAGE;
                case 6 -> Addition.CUSTOM_ITEM_DROP;
                case 7 -> Addition.ATTRIBUTE_ARMOR_BONUS;
                case 8 -> Addition.ATTRIBUTE_ARMOR_TOUGHNESS;
                case 9 -> Addition.ATTRIBUTE_ATTACK_KNOCKBACK;
                case 10 -> Addition.ATTRIBUTE_FLYING_SPEED;
                case 11 -> Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE;
                case 12 -> Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH;
                case 13 -> Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS;
                case 14 -> Addition.ATTRIBUTE_FOLLOW_RANGE;
                case 15 -> Addition.CUSTOM_XP_DROP;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final Multiplier duplicateMultiplier(Multiplier multiplier) {
            return new Multiplier(multiplier.addition(), multiplier.useStacked(), multiplier.value(), multiplier.formula(), multiplier.isAddition(), multiplier.isBaseModifier());
        }

        private final Map<Addition, Multiplier> dulicateMap1(Map<Addition, Multiplier> source) {
            Map copy = new LinkedHashMap();
            for (Map.Entry<Addition, Multiplier> item : source.entrySet()) {
                Addition sourceAddition = item.getKey();
                Multiplier sourceMultiplier = item.getValue();
                copy.put(sourceAddition, this.duplicateMultiplier(sourceMultiplier));
            }
            return copy;
        }

        private final Map<String, Map<Addition, Multiplier>> dulicateMap2(Map<String, Map<Addition, Multiplier>> source) {
            Map copy = new LinkedHashMap();
            for (Map.Entry<String, Map<Addition, Multiplier>> item : source.entrySet()) {
                String sourceMob = item.getKey();
                Map<Addition, Multiplier> sourceValues = item.getValue();
                Map copiedMap = new LinkedHashMap();
                for (Map.Entry<Addition, Multiplier> item2 : sourceValues.entrySet()) {
                    copiedMap.put(item2.getKey(), this.duplicateMultiplier(item2.getValue()));
                }
                copy.put(sourceMob, copiedMap);
            }
            return copy;
        }

        private final void copyMultipliers(FineTuningAttributes source, FineTuningAttributes dest, boolean copyAll) {
            Map<Object, Object> map;
            if (source.getDoNotMergeAllMultipliers() && !copyAll) {
                Map<Addition, Multiplier> map2 = dest.getMultipliers();
                if (map2 != null) {
                    map2.clear();
                }
            }
            if (source.getDoNotMergeAllBaseMods() && !copyAll) {
                Map<Addition, Multiplier> map3 = dest.getBaseAttributeModifiers();
                if (map3 != null) {
                    map3.clear();
                }
            }
            if (source.getDoNotMergeMobSpecificMultipliers() && !copyAll) {
                Map<String, Map<Addition, Multiplier>> map4 = dest.getMobSpecificMultipliers();
                if (map4 != null) {
                    map4.clear();
                }
            }
            if (source.getDoNotMergeMobSpecificBaseMods() && !copyAll) {
                Map<String, Map<Addition, Multiplier>> map5 = dest.getMobSpecificBaseModifiers();
                if (map5 != null) {
                    map5.clear();
                }
            }
            if (!((map = source.getMultipliers()) == null || map.isEmpty())) {
                if (dest.getMultipliers() == null) {
                    dest.setMultipliers(new LinkedHashMap());
                }
                Map<Addition, Multiplier> map6 = dest.getMultipliers();
                Intrinsics.checkNotNull(map6);
                Map<Addition, Multiplier> map7 = source.getMultipliers();
                Intrinsics.checkNotNull(map7);
                map6.putAll(map7);
            }
            if (!((map = source.getMobSpecificMultipliers()) == null || map.isEmpty())) {
                if (dest.getMobSpecificMultipliers() == null) {
                    dest.setMobSpecificMultipliers(new LinkedHashMap());
                }
                Map<String, Map<Addition, Multiplier>> map8 = dest.getMobSpecificMultipliers();
                Intrinsics.checkNotNull(map8);
                Map<String, Map<Addition, Multiplier>> map9 = source.getMobSpecificMultipliers();
                Intrinsics.checkNotNull(map9);
                map8.putAll(map9);
            }
            if (!((map = source.getBaseAttributeModifiers()) == null || map.isEmpty())) {
                if (dest.getBaseAttributeModifiers() == null) {
                    dest.setBaseAttributeModifiers(new LinkedHashMap());
                }
                Map<Addition, Multiplier> map10 = dest.getBaseAttributeModifiers();
                Intrinsics.checkNotNull(map10);
                Map<Addition, Multiplier> map11 = source.getBaseAttributeModifiers();
                Intrinsics.checkNotNull(map11);
                map10.putAll(map11);
            }
            if (!((map = source.getMobSpecificBaseModifiers()) == null || map.isEmpty())) {
                if (dest.getMobSpecificBaseModifiers() == null) {
                    dest.setMobSpecificBaseModifiers(new LinkedHashMap());
                }
                Map<String, Map<Addition, Multiplier>> map12 = dest.getMobSpecificBaseModifiers();
                Intrinsics.checkNotNull(map12);
                Map<String, Map<Addition, Multiplier>> map13 = source.getMobSpecificBaseModifiers();
                Intrinsics.checkNotNull(map13);
                map12.putAll(map13);
            }
        }

        private final void formatMultipliers(Map<Addition, Multiplier> items, StringBuilder sb, String header, boolean useCarriageReturn, String mobName) {
            if (items == null) {
                return;
            }
            if (useCarriageReturn) {
                sb.append("\n     ");
            }
            StringBuilder stringBuilder = header != null ? (mobName != null ? sb.append("&r&l" + header + ": (" + mobName + ")&r ") : sb.append("&r&l" + header + ":&r ")) : sb.append("&r");
            boolean isFirst = true;
            for (Multiplier multiplier : items.values()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(this.getShortName(multiplier.addition()));
                if (multiplier.value() != null) {
                    sb.append(": ").append(multiplier.value().floatValue());
                }
                if (multiplier.hasFormula()) {
                    sb.append(multiplier.formula());
                    continue;
                }
                if (!multiplier.useStacked()) continue;
                sb.append(" (stk)");
            }
        }

        private final boolean formatMobSpecific(Map<String, Map<Addition, Multiplier>> items, StringBuilder sb, String header, boolean useCarriageReturn, LivingEntityWrapper lmEntity) {
            if (items == null) {
                return false;
            }
            if (lmEntity != null) {
                Map<Addition, Multiplier> map = items.get(lmEntity.getNameIfBaby());
                if (map == null) {
                    return false;
                }
                Map<Addition, Multiplier> mobSpecificItems = map;
                this.formatMultipliers(mobSpecificItems, sb, header, useCarriageReturn, lmEntity.getNameIfBaby());
                return true;
            }
            boolean isFirst = true;
            if (useCarriageReturn) {
                sb.append("\n     ");
            }
            StringBuilder stringBuilder = header != null ? sb.append("&r&l" + header + "&r: ") : sb.append("&r");
            for (Map.Entry<String, Map<Addition, Multiplier>> mobName : items.entrySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                boolean isFirstValues = true;
                sb.append("&b" + mobName.getKey() + ":&r ");
                for (Map.Entry<Addition, Multiplier> mobValues : mobName.getValue().entrySet()) {
                    if (isFirstValues) {
                        isFirstValues = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(mobValues.getValue());
                }
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Addition.values().length];
                try {
                    nArray[Addition.ATTRIBUTE_ATTACK_DAMAGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CREEPER_BLAST_DAMAGE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_MAX_HEALTH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_MOVEMENT_SPEED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CUSTOM_RANGED_ATTACK_DAMAGE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CUSTOM_ITEM_DROP.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ARMOR_BONUS.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ARMOR_TOUGHNESS.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ATTACK_KNOCKBACK.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_FLYING_SPEED.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_FOLLOW_RANGE.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CUSTOM_XP_DROP.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[LMMultiplier.values().length];
                try {
                    nArray[LMMultiplier.ATTACK_DAMAGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.CREEPER_BLAST_DAMAGE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.MAX_HEALTH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.MOVEMENT_SPEED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.RANGED_ATTACK_DAMAGE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.ITEM_DROP.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.ARMOR_BONUS.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.ARMOR_TOUGHNESS.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.ATTACK_KNOCKBACK.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.FLYING_SPEED.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.KNOCKBACK_RESISTANCE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.HORSE_JUMP_STRENGTH.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.ZOMBIE_SPAWN_REINFORCEMENTS.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.FOLLOW_RANGE.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LMMultiplier.XP_DROP.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0016\u001a\u00020\tH\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003JN\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0006\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Multiplier;", "Ljava/lang/Record;", "addition", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "useStacked", "", "value", "", "formula", "", "isAddition", "isBaseModifier", "<init>", "(Lio/github/arcaneplugins/levelledmobs/enums/Addition;ZLjava/lang/Float;Ljava/lang/String;ZZ)V", "()Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "()Z", "()Ljava/lang/Float;", "Ljava/lang/Float;", "()Ljava/lang/String;", "hasFormula", "useValue", "()F", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lio/github/arcaneplugins/levelledmobs/enums/Addition;ZLjava/lang/Float;Ljava/lang/String;ZZ)Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Multiplier;", "equals", "other", "", "hashCode", "", "levelledmobs-plugin"})
    public static final class Multiplier
    extends Record {
        @NotNull
        private final Addition addition;
        private final boolean useStacked;
        @Nullable
        private final Float value;
        @Nullable
        private final String formula;
        private final boolean isAddition;
        private final boolean isBaseModifier;

        public Multiplier(@NotNull Addition addition, boolean useStacked, @Nullable Float value, @Nullable String formula, boolean isAddition, boolean isBaseModifier) {
            Intrinsics.checkNotNullParameter((Object)addition, "addition");
            this.addition = addition;
            this.useStacked = useStacked;
            this.value = value;
            this.formula = formula;
            this.isAddition = isAddition;
            this.isBaseModifier = isBaseModifier;
        }

        @NotNull
        public final Addition addition() {
            return this.addition;
        }

        public final boolean useStacked() {
            return this.useStacked;
        }

        @Nullable
        public final Float value() {
            return this.value;
        }

        @Nullable
        public final String formula() {
            return this.formula;
        }

        public final boolean isAddition() {
            return this.isAddition;
        }

        public final boolean isBaseModifier() {
            return this.isBaseModifier;
        }

        public final boolean hasFormula() {
            CharSequence charSequence = this.formula;
            return !(charSequence == null || charSequence.length() == 0);
        }

        public final float useValue() {
            Float f = this.value;
            return f != null ? f.floatValue() : 0.0f;
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Companion.getShortName(this.addition));
            if (this.hasFormula()) {
                sb.append(" formula: '");
                sb.append(this.formula).append("'");
                if (this.isAddition && !this.isBaseModifier) {
                    sb.append(" (add)");
                } else if (!this.isBaseModifier) {
                    sb.append(" (multiply)");
                }
            } else if (this.value != null) {
                StringBuilder stringBuilder = this.useStacked ? sb.append(" (stkd): ") : sb.append(": ");
                sb.append(this.value.floatValue());
            } else if (this.useStacked) {
                sb.append(" (stkd)");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        @NotNull
        public final Addition component1() {
            return this.addition;
        }

        public final boolean component2() {
            return this.useStacked;
        }

        @Nullable
        public final Float component3() {
            return this.value;
        }

        @Nullable
        public final String component4() {
            return this.formula;
        }

        public final boolean component5() {
            return this.isAddition;
        }

        public final boolean component6() {
            return this.isBaseModifier;
        }

        @NotNull
        public final Multiplier copy(@NotNull Addition addition, boolean useStacked, @Nullable Float value, @Nullable String formula, boolean isAddition, boolean isBaseModifier) {
            Intrinsics.checkNotNullParameter((Object)addition, "addition");
            return new Multiplier(addition, useStacked, value, formula, isAddition, isBaseModifier);
        }

        public static /* synthetic */ Multiplier copy$default(Multiplier multiplier, Addition addition, boolean bl, Float f, String string, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                addition = multiplier.addition;
            }
            if ((n & 2) != 0) {
                bl = multiplier.useStacked;
            }
            if ((n & 4) != 0) {
                f = multiplier.value;
            }
            if ((n & 8) != 0) {
                string = multiplier.formula;
            }
            if ((n & 0x10) != 0) {
                bl2 = multiplier.isAddition;
            }
            if ((n & 0x20) != 0) {
                bl3 = multiplier.isBaseModifier;
            }
            return multiplier.copy(addition, bl, f, string, bl2, bl3);
        }

        @Override
        public int hashCode() {
            int result = this.addition.hashCode();
            result = result * 31 + Boolean.hashCode(this.useStacked);
            result = result * 31 + (this.value == null ? 0 : ((Object)this.value).hashCode());
            result = result * 31 + (this.formula == null ? 0 : this.formula.hashCode());
            result = result * 31 + Boolean.hashCode(this.isAddition);
            result = result * 31 + Boolean.hashCode(this.isBaseModifier);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Multiplier)) {
                return false;
            }
            Multiplier multiplier = (Multiplier)other;
            if (this.addition != multiplier.addition) {
                return false;
            }
            if (this.useStacked != multiplier.useStacked) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.value, (Object)multiplier.value)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.formula, multiplier.formula)) {
                return false;
            }
            if (this.isAddition != multiplier.isAddition) {
                return false;
            }
            return this.isBaseModifier == multiplier.isBaseModifier;
        }
    }
}

