/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Ref;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.misc.StringReplacer;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/RandomVarianceGenerator;", "", "<init>", "()V", "generateVariance", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "input", "Lio/github/arcaneplugins/levelledmobs/misc/StringReplacer;", "generateVariance2", "", "numberText", "levelledmobs-plugin"})
public final class RandomVarianceGenerator {
    @NotNull
    public static final RandomVarianceGenerator INSTANCE = new RandomVarianceGenerator();

    private RandomVarianceGenerator() {
    }

    public final void generateVariance(@NotNull LivingEntityWrapper lmEntity, @NotNull StringReplacer input) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(input, "input");
        Ref.ObjectRef text = new Ref.ObjectRef();
        text.element = input.getText();
        int count = 0;
        boolean foundRand = false;
        do {
            String randText;
            ++count;
            int start = StringsKt.indexOf$default((CharSequence)text.element, "%rand_", 0, false, 6, null);
            if (start < 0) break;
            int end = StringsKt.indexOf((CharSequence)text.element, "%", start + 1, true);
            if (end <= 0) {
                DebugManager.Companion.log(DebugType.RANDOM_NUMBER, lmEntity, () -> RandomVarianceGenerator.generateVariance$lambda$0(text));
                return;
            }
            Intrinsics.checkNotNullExpressionValue(((String)text.element).substring(start, end + 1), "substring(...)");
            String result = this.generateVariance2(lmEntity, randText);
            text.element = StringsKt.replace$default((String)text.element, randText, result, false, 4, null);
            foundRand = true;
        } while (count <= 100);
        if (foundRand) {
            input.setText((String)text.element);
        }
    }

    private final String generateVariance2(LivingEntityWrapper lmEntity, String numberText) {
        Ref.IntRef useMin = new Ref.IntRef();
        Ref.IntRef useMax = new Ref.IntRef();
        useMax.element = 1;
        String string = numberText.substring(1, numberText.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        String part = string;
        String[] stringArray = new String[]{"_"};
        List split = StringsKt.split$default((CharSequence)part, stringArray, false, 0, 6, null);
        if (split.size() == 3) {
            if (((CharSequence)split.get(2)).length() > 0) {
                useMax.element = Integer.parseInt((String)split.get(2));
                useMin.element = Integer.parseInt((String)split.get(1));
            } else if (((CharSequence)split.get(1)).length() > 0) {
                useMax.element = Integer.parseInt((String)split.get(1));
            }
        } else if (split.size() == 2) {
            useMax.element = Integer.parseInt((String)split.get(1));
        }
        useMin.element = RangesKt.coerceAtMost(useMin.element, useMax.element);
        useMax.element = RangesKt.coerceAtLeast(useMax.element, useMin.element) + 1;
        int result = ThreadLocalRandom.current().nextInt(useMin.element, useMax.element);
        DebugManager.Companion.log(DebugType.RANDOM_NUMBER, lmEntity, () -> RandomVarianceGenerator.generateVariance2$lambda$0(useMin, useMax, result));
        return String.valueOf(result);
    }

    private static final String generateVariance$lambda$0(Ref.ObjectRef $text) {
        return "Invalid input: " + $text.element;
    }

    private static final String generateVariance2$lambda$0(Ref.IntRef $useMin, Ref.IntRef $useMax, int $result) {
        return "min " + $useMin.element + ", max: " + ($useMax.element - 1) + ", result: " + $result;
    }
}

