/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import org.bukkit.entity.Entity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/LibsDisguisesUtils;", "", "<init>", "()V", "hasLibsDisguises", "", "isMobUsingLibsDisguises", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "updateLibsDisguiseNametag", "", "nametag", "", "levelledmobs-plugin"})
public final class LibsDisguisesUtils {
    @NotNull
    public static final LibsDisguisesUtils INSTANCE = new LibsDisguisesUtils();
    private static boolean hasLibsDisguises = ExternalCompatibilityManager.Companion.getHasLibsDisguisesInstalled();

    private LibsDisguisesUtils() {
    }

    public final boolean isMobUsingLibsDisguises(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (!hasLibsDisguises) {
            return false;
        }
        Disguise disguise = null;
        if (lmEntity.getLibsDisguiseCache() != null) {
            disguise = (Disguise)lmEntity.getLibsDisguiseCache();
        } else {
            disguise = DisguiseAPI.getDisguise((Entity)((Entity)lmEntity.getLivingEntity()));
            lmEntity.setLibsDisguiseCache(disguise);
        }
        return disguise != null && disguise.isDisguiseInUse();
    }

    public final void updateLibsDisguiseNametag(@NotNull LivingEntityWrapper lmEntity, @Nullable String nametag) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (!this.isMobUsingLibsDisguises(lmEntity)) {
            return;
        }
        Object object = lmEntity.getLibsDisguiseCache();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type me.libraryaddict.disguise.disguisetypes.Disguise");
        Disguise disguise = (Disguise)object;
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> LibsDisguisesUtils.updateLibsDisguiseNametag$lambda$0(disguise, nametag, lmEntity));
        lmEntity.getInUseCount().getAndIncrement();
        wrapper.run();
    }

    private static final void updateLibsDisguiseNametag$lambda$0(Disguise $disguise, String $nametag, LivingEntityWrapper $lmEntity) {
        $disguise.getWatcher().setCustomName($nametag);
        $lmEntity.free();
    }
}

