/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.MapsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.PropertyReference0Impl;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.TypeIntrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.reflect.KProperty0;
import io.github.arcaneplugins.levelledmobs.nametag.Definitions;
import io.github.arcaneplugins.levelledmobs.nametag.ServerVersionInfo;
import io.github.arcaneplugins.levelledmobs.result.NBTApplyResult;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a8\u0006\u0013"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/MiscUtils;", "", "<init>", "()V", "retrieveLoadedChunkRadius", "", "location", "Lorg/bukkit/Location;", "expect", "getNBTDump", "", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "getPDCKeys", "", "getNBTDebugMessage", "results", "", "Lio/github/arcaneplugins/levelledmobs/result/NBTApplyResult;", "levelledmobs-plugin"})
public final class MiscUtils {
    @NotNull
    public static final MiscUtils INSTANCE = new MiscUtils();

    private MiscUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double retrieveLoadedChunkRadius(@NotNull Location location, double expect) {
        int currentRadius;
        Intrinsics.checkNotNullParameter(location, "location");
        World world = location.getWorld();
        int centerX = (int)(location.getX() / (double)16);
        int centerZ = (int)(location.getZ() / (double)16);
        int maxChunkRadius = 0;
        while (!((double)((currentRadius = maxChunkRadius + 1) * 16) > expect)) {
            int dx = -currentRadius;
            if (dx <= currentRadius) {
                while (true) {
                    if (!world.isChunkLoaded(centerX + dx, centerZ - currentRadius)) {
                        return RangesKt.coerceAtMost((double)maxChunkRadius * 16.0, expect);
                    }
                    if (!world.isChunkLoaded(centerX + dx, centerZ + currentRadius)) {
                        return RangesKt.coerceAtMost((double)maxChunkRadius * 16.0, expect);
                    }
                    if (dx == currentRadius) break;
                    ++dx;
                }
            }
            for (int dz = -currentRadius + 1; dz < currentRadius; ++dz) {
                if (!world.isChunkLoaded(centerX - currentRadius, centerZ + dz)) {
                    return RangesKt.coerceAtMost((double)maxChunkRadius * 16.0, expect);
                }
                if (world.isChunkLoaded(centerX + currentRadius, centerZ + dz)) continue;
                return RangesKt.coerceAtMost((double)maxChunkRadius * 16.0, expect);
            }
            maxChunkRadius = currentRadius;
        }
        return RangesKt.coerceAtMost((double)maxChunkRadius * 16.0, expect);
    }

    @NotNull
    public final String getNBTDump(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        Definitions def = LevelledMobs.Companion.getInstance().getDefinitions();
        ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();
        boolean useNewMethod = ver.getMinecraftVersion() >= 1.21 && ver.getMinorVersion() >= 6 || ver.getMinecraftVersion() >= 1.22;
        try {
            Method method = def.getMethodGetHandle();
            Intrinsics.checkNotNull(method);
            Object internalLivingEntity = method.invoke((Object)livingEntity, new Object[0]);
            if (useNewMethod) {
                Field field = def.getFieldDISCARDING();
                Intrinsics.checkNotNull(field);
                Object problemReporter = field.get(null);
                Method method2 = def.getMethodWithoutContext();
                Intrinsics.checkNotNull(method2);
                Object[] objectArray = new Object[]{problemReporter};
                Object tagValueOutput = method2.invoke(def.getClazzTagValueOutput(), objectArray);
                Method method3 = def.getMethodSaveWithoutId();
                Intrinsics.checkNotNull(method3);
                objectArray = new Object[]{tagValueOutput};
                method3.invoke(internalLivingEntity, objectArray);
                Method method4 = def.getMethodBuildResult();
                Intrinsics.checkNotNull(method4);
                return method4.invoke(tagValueOutput, new Object[0]).toString();
            }
            Class<?> clazz = def.getClazzCompoundTag();
            Intrinsics.checkNotNull(clazz);
            Object compoundTag = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method method5 = def.getMethodSaveWithoutId();
            Intrinsics.checkNotNull(method5);
            Object[] objectArray = new Object[]{compoundTag};
            method5.invoke(internalLivingEntity, objectArray);
            return compoundTag.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @NotNull
    public final Map<String, String> getPDCKeys(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        Definitions def = LevelledMobs.Companion.getInstance().getDefinitions();
        Map results = new LinkedHashMap();
        try {
            Method method = def.getMethodGetHandle();
            Intrinsics.checkNotNull(method);
            Object internalLivingEntity = method.invoke((Object)livingEntity, new Object[0]);
            Class<?> compoundTagClazz = Class.forName("net.minecraft.nbt.NBTTagCompound");
            Object compoundTag = compoundTagClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> clazz = def.getClazzEntity();
            Intrinsics.checkNotNull(clazz);
            Object[] objectArray = new Class[]{compoundTagClazz};
            Method saveWithoutId = clazz.getDeclaredMethod("f", (Class<?>[])objectArray);
            objectArray = new Object[]{compoundTag};
            saveWithoutId.invoke(internalLivingEntity, objectArray);
            ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();
            String methodName = ver.getMajorVersion() >= 21 ? "tags" : "x";
            Field tagsField = compoundTagClazz.getDeclaredField(methodName);
            tagsField.trySetAccessible();
            Object object = tagsField.get(compoundTag);
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            Map tagsMap = TypeIntrinsics.asMutableMap(object);
            Object v = tagsMap.get("BukkitValues");
            if (v == null) {
                return results;
            }
            Object bukkitValues = v;
            Object object2 = tagsField.get(bukkitValues);
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            Map bukkitValuesMap = TypeIntrinsics.asMutableMap(object2);
            for (Map.Entry nbtBase : bukkitValuesMap.entrySet()) {
                String valueType;
                methodName = ver.getMajorVersion() >= 21 ? "getType" : "c";
                Method getTypeMethod2 = ((Class)((KProperty0)new PropertyReference0Impl(nbtBase.getValue()){

                    public Object get() {
                        return this.receiver.getClass();
                    }
                }).get()).getMethod(methodName, new Class[0]);
                Object type = getTypeMethod2.invoke(nbtBase.getValue(), new Object[0]);
                methodName = ver.getMajorVersion() >= 21 ? "getName" : "a";
                Method getNameMethod = type.getClass().getDeclaredMethod(methodName, new Class[0]);
                getNameMethod.trySetAccessible();
                Intrinsics.checkNotNullExpressionValue(getNameMethod.invoke(type, new Object[0]).toString().toLowerCase(Locale.ROOT), "toLowerCase(...)");
                if (Intrinsics.areEqual("byte[]", valueType)) {
                    Method methodSize = nbtBase.getValue().getClass().getDeclaredMethod("size", new Class[0]);
                    Object byteSize = methodSize.invoke(nbtBase.getValue(), new Object[0]);
                    results.put(nbtBase.getKey(), "type: &b" + valueType + "&r, size: &b" + byteSize + "&r");
                    continue;
                }
                results.put(nbtBase.getKey(), "type: &b" + valueType + "&r, value: &b" + nbtBase.getValue() + "&r");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return MapsKt.toSortedMap(results);
    }

    @NotNull
    public final String getNBTDebugMessage(@NotNull List<NBTApplyResult> results) {
        String string;
        int i;
        int n;
        Intrinsics.checkNotNullParameter(results, "results");
        StringBuilder sb = new StringBuilder();
        for (NBTApplyResult result : results) {
            if (result.getObjectsAdded() == null) continue;
            List<String> list = result.getObjectsAdded();
            Intrinsics.checkNotNull(list);
            n = list.size();
            for (i = 0; i < n; ++i) {
                StringBuilder stringBuilder = i > 0 ? sb.append(", ") : sb.append("added: ");
                List<String> list2 = result.getObjectsAdded();
                Intrinsics.checkNotNull(list2);
                sb.append(list2.get(i));
            }
        }
        for (NBTApplyResult result : results) {
            if (result.getObjectsUpdated() == null) continue;
            List<String> list = result.getObjectsUpdated();
            Intrinsics.checkNotNull(list);
            n = list.size();
            for (i = 0; i < n; ++i) {
                if (i > 0 || ((CharSequence)sb).length() > 0) {
                    sb.append(", ");
                }
                if (i == 0) {
                    sb.append("updated: ");
                }
                List<String> list3 = result.getObjectsUpdated();
                Intrinsics.checkNotNull(list3);
                sb.append(list3.get(i));
            }
        }
        for (NBTApplyResult result : results) {
            if (result.getObjectsRemoved() == null) continue;
            List<String> list = result.getObjectsRemoved();
            Intrinsics.checkNotNull(list);
            n = list.size();
            for (i = 0; i < n; ++i) {
                if (i > 0 || ((CharSequence)sb).length() > 0) {
                    sb.append(", ");
                }
                if (i == 0) {
                    sb.append("removed: ");
                }
                List<String> list4 = result.getObjectsRemoved();
                Intrinsics.checkNotNull(list4);
                sb.append(list4.get(i));
            }
        }
        if (((CharSequence)sb).length() == 0) {
            string = "";
        } else {
            String string2 = sb.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        }
        return string;
    }
}

