/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.util.Paper117Utils;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a8\u0006\u0015"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/PaperUtils;", "", "<init>", "()V", "sendHyperlink", "", "sender", "Lorg/bukkit/command/CommandSender;", "message", "", "url", "updateItemMetaLore", "meta", "Lorg/bukkit/inventory/meta/ItemMeta;", "lore", "", "updateItemDisplayName", "displayName", "getPlayerDisplayName", "player", "Lorg/bukkit/entity/Player;", "levelledmobs-plugin"})
public final class PaperUtils {
    @NotNull
    public static final PaperUtils INSTANCE = new PaperUtils();

    private PaperUtils() {
    }

    public final void sendHyperlink(@NotNull CommandSender sender, @NotNull String message, @NotNull String url) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(url, "url");
        Component component = ((TextComponent)Component.text().content(message).build()).clickEvent(ClickEvent.openUrl((String)url));
        Intrinsics.checkNotNullExpressionValue(component, "clickEvent(...)");
        Component newCom = component;
        sender.sendMessage(newCom);
    }

    public final void updateItemMetaLore(@NotNull ItemMeta meta, @Nullable List<String> lore) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        if (lore == null) {
            return;
        }
        List newLore = new ArrayList();
        for (String loreLine : lore) {
            BuildableComponent buildableComponent = ((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).append((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(loreLine))).build();
            Intrinsics.checkNotNullExpressionValue(buildableComponent, "build(...)");
            newLore.add(buildableComponent);
        }
        meta.lore(newLore);
    }

    public final void updateItemDisplayName(@NotNull ItemMeta meta, @Nullable String displayName) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        if (displayName == null) {
            return;
        }
        meta.displayName((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().decoration(TextDecoration.ITALIC, false)).append((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(displayName))).build());
    }

    @NotNull
    public final String getPlayerDisplayName(@Nullable Player player) {
        String string;
        if (player == null) {
            return "";
        }
        Component component = player.displayName();
        Intrinsics.checkNotNullExpressionValue(component, "displayName(...)");
        Component comp = component;
        if (comp instanceof TextComponent) {
            if (LevelledMobs.Companion.getInstance().getVer().getMinecraftVersion() >= 1.17) {
                string = Paper117Utils.INSTANCE.serializeTextComponent((TextComponent)comp);
            } else {
                String string2 = LegacyComponentSerializer.legacySection().serialize(comp);
                Intrinsics.checkNotNull(string2);
                string = string2;
            }
        } else {
            string = comp.toString();
        }
        return string;
    }
}

