/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.AttributeNames;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Contract;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Pair;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.comparisons.ComparisonsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.math.MathKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.Sequence;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.SequencesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.Regex;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.nametag.ServerVersionInfo;
import io.github.arcaneplugins.levelledmobs.result.PlayerNetherOrWorldSpawnResult;
import io.github.arcaneplugins.levelledmobs.rules.MinAndMax;
import io.github.arcaneplugins.levelledmobs.rules.RulesManager;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eJ,\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eJ$\u0010$\u001a\u00020\u001a2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001aJ\u001c\u0010*\u001a\u00020\u001a2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020+0&2\u0006\u0010,\u001a\u00020\nJ$\u0010-\u001a\u00020\u001a2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&2\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200J\u001c\u00101\u001a\u00020\u001a2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u00102\u001a\u00020\u000eJ\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u0002042\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020@J5\u0010A\u001a\u000e\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u0002HD0B\"\u0004\b\u0000\u0010C\"\u0004\b\u0001\u0010D2\u0006\u0010E\u001a\u0002HC2\u0006\u0010F\u001a\u0002HDH\u0007\u00a2\u0006\u0002\u0010GJ\u0016\u0010H\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020\u000eJ\u000e\u0010K\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\u000eJ\u0010\u0010L\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020@H\u0002J\u000e\u0010M\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(J3\u0010N\u001a\u0004\u0018\u0001042\b\u0010I\u001a\u0004\u0018\u00010\u000e2\b\u0010O\u001a\u0004\u0018\u0001042\u0006\u0010P\u001a\u00020\u001a2\b\u0010Q\u001a\u0004\u0018\u00010R\u00a2\u0006\u0002\u0010SJ1\u0010T\u001a\b\u0012\u0004\u0012\u00020:0\u00102\f\u0010U\u001a\b\u0012\u0004\u0012\u00020:0\u00102\u0006\u0010V\u001a\u00020W2\b\u0010X\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010YJ\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010[\u001a\u00020\u000eJ\u0010\u0010\\\u001a\u0004\u0018\u00010]2\u0006\u0010^\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006_"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/Utils;", "", "<init>", "()V", "timeUnitPattern", "Ljava/util/regex/Pattern;", "round", "", "value", "digits", "", "getBiome", "Lorg/bukkit/block/Biome;", "name", "", "getAllAttributes", "", "Lorg/bukkit/attribute/Attribute;", "getAttribute", "attributeName", "Lio/github/arcaneplugins/levelledmobs/enums/AttributeNames;", "replaceEx", "message", "replaceWhat", "replaceTo", "isInteger", "", "str", "isDouble", "oneToNine", "getOneToNine", "()Ljava/util/List;", "replaceAllInList", "oldList", "colorizeAllInList", "capitalize", "isLivingEntityInModalList", "list", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "checkBabyMobs", "isIntegerInModalList", "Lio/github/arcaneplugins/levelledmobs/rules/MinAndMax;", "checkNum", "isBiomeInModalList", "biome", "rulesManager", "Lio/github/arcaneplugins/levelledmobs/rules/RulesManager;", "isDamageCauseInModalList", "cause", "getMillisecondsFromInstant", "", "instant", "Ljava/time/Instant;", "getPortalOrWorldSpawn", "Lio/github/arcaneplugins/levelledmobs/result/PlayerNetherOrWorldSpawnResult;", "player", "Lorg/bukkit/entity/Player;", "getChunkKey", "chunk", "Lorg/bukkit/Chunk;", "displayChunkLocation", "location", "Lorg/bukkit/Location;", "getPair", "", "T", "U", "first", "second", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;", "matchWildcardString", "input", "match", "removeColorCodes", "showLocation", "checkIfMobHashChanged", "parseTimeUnit", "defaultTime", "useMS", "sender", "Lorg/bukkit/command/CommandSender;", "(Ljava/lang/String;Ljava/lang/Long;ZLorg/bukkit/command/CommandSender;)Ljava/lang/Long;", "filterPlayersList", "entities", "mob", "Lorg/bukkit/entity/LivingEntity;", "maxDistance", "(Ljava/util/List;Lorg/bukkit/entity/LivingEntity;Ljava/lang/Double;)Ljava/util/List;", "splitStringWithQuotes", "myString", "getEnchantment", "Lorg/bukkit/enchantments/Enchantment;", "enchantName", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nio/github/arcaneplugins/levelledmobs/util/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,654:1\n1#2:655\n739#3,9:656\n739#3,9:667\n739#3,9:678\n37#4,2:665\n37#4,2:676\n37#4,2:687\n608#5:689\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nio/github/arcaneplugins/levelledmobs/util/Utils\n*L\n245#1:656,9\n424#1:667,9\n531#1:678,9\n246#1:665,2\n424#1:676,2\n531#1:687,2\n605#1:689\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final Pattern timeUnitPattern;
    @NotNull
    private static final List<String> oneToNine;

    private Utils() {
    }

    public final double round(double value) {
        return (double)MathKt.roundToInt(value * (double)100) / 100.0;
    }

    public final double round(double value, int digits) {
        double scale = Math.pow(10.0, digits);
        return (double)MathKt.roundToInt(value * scale) / scale;
    }

    @Nullable
    public final Biome getBiome(@NotNull String name) {
        NamespacedKey key;
        Intrinsics.checkNotNullParameter(name, "name");
        ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();
        if (StringsKt.contains$default((CharSequence)name, ":", false, 2, null)) {
            var4_3 = name;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string = var4_3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            v2 = NamespacedKey.fromString((String)string);
        } else {
            var4_3 = name;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string = var4_3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            v2 = key = NamespacedKey.minecraft((String)string);
        }
        if (key == null) {
            return null;
        }
        if (ver.isRunningPaper() && ver.getMinorVersion() >= 21) {
            Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME);
            Intrinsics.checkNotNullExpressionValue(registry, "getRegistry(...)");
            Registry registry2 = registry;
            return (Biome)registry2.get(key);
        }
        return (Biome)Registry.BIOME.get(key);
    }

    @NotNull
    public final List<Attribute> getAllAttributes() {
        List attributes = new ArrayList();
        for (AttributeNames attributeName : AttributeNames.getEntries()) {
            Attribute attribute;
            if (this.getAttribute(attributeName) == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    @Nullable
    public final Attribute getAttribute(@NotNull AttributeNames attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, "attributeName");
        if (LevelledMobs.Companion.getInstance().getVer().getUseOldEnums()) {
            return switch (WhenMappings.$EnumSwitchMapping$0[attributeName.ordinal()]) {
                case 1 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.max_health"));
                case 2 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.attack_damage"));
                case 3 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.movement_speed"));
                case 4 -> {
                    if (LevelledMobs.Companion.getInstance().getVer().getUseNewHorseJumpAttrib()) {
                        yield (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.jump_strength"));
                    }
                    yield (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"horse.jump_strength"));
                }
                case 5 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.armor"));
                case 6 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.armor_toughness"));
                case 7 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.knockback_resistance"));
                case 8 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.flying_speed"));
                case 9 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.attack_knockback"));
                case 10 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.follow_range"));
                case 11 -> (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"zombie.spawn_reinforcements"));
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[attributeName.ordinal()]) {
            case 1 -> Attribute.MAX_HEALTH;
            case 2 -> Attribute.ATTACK_DAMAGE;
            case 3 -> Attribute.MOVEMENT_SPEED;
            case 4 -> Attribute.JUMP_STRENGTH;
            case 5 -> Attribute.ARMOR;
            case 6 -> Attribute.ARMOR_TOUGHNESS;
            case 7 -> Attribute.KNOCKBACK_RESISTANCE;
            case 8 -> Attribute.FLYING_SPEED;
            case 9 -> Attribute.ATTACK_KNOCKBACK;
            case 10 -> Attribute.FOLLOW_RANGE;
            case 11 -> Attribute.SPAWN_REINFORCEMENTS;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String replaceEx(@NotNull String message, @NotNull String replaceWhat, @NotNull String replaceTo) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        Intrinsics.checkNotNullParameter(replaceTo, "replaceTo");
        int count = 0;
        int position0 = 0;
        int position1 = 0;
        String string = message;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        String upperString = string2;
        String string3 = replaceWhat;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
        String string4 = string3.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
        String upperPattern = string4;
        int inc = message.length() / replaceWhat.length() * (replaceTo.length() - replaceWhat.length());
        char[] chars = new char[(int)((double)message.length() + Math.max(0.0, (double)inc))];
        while (true) {
            int n2;
            int it = n2 = StringsKt.indexOf$default((CharSequence)upperString, upperPattern, position0, false, 4, null);
            boolean bl = false;
            position1 = it;
            if (n2 == -1) break;
            n = position1;
            for (i = position0; i < n; ++i) {
                chars[count++] = message.charAt(i);
            }
            n = replaceTo.length();
            for (i = 0; i < n; ++i) {
                char element = replaceTo.charAt(i);
                chars[count++] = element;
            }
            position0 = position1 + replaceWhat.length();
        }
        if (position0 == 0) {
            return message;
        }
        n = message.length();
        for (i = position0; i < n; ++i) {
            chars[count++] = message.charAt(i);
        }
        return new String(chars, 0, count);
    }

    public final boolean isInteger(@Nullable String str) {
        CharSequence charSequence = str;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public final boolean isDouble(@Nullable String str) {
        CharSequence charSequence = str;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @NotNull
    public final List<String> getOneToNine() {
        return oneToNine;
    }

    @NotNull
    public final List<String> replaceAllInList(@NotNull List<String> oldList, @NotNull String replaceWhat, @Nullable String replaceTo) {
        Intrinsics.checkNotNullParameter(oldList, "oldList");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        String string = replaceTo;
        if (string == null) {
            string = "";
        }
        String useReplaceTo = string;
        List newList = new ArrayList();
        for (String string2 : oldList) {
            newList.add(StringsKt.replace$default(string2, replaceWhat, useReplaceTo, false, 4, null));
        }
        return newList;
    }

    @NotNull
    public final List<String> colorizeAllInList(@NotNull List<String> oldList) {
        Intrinsics.checkNotNullParameter(oldList, "oldList");
        List newList = new ArrayList();
        for (String string : oldList) {
            newList.add(MessageUtils.INSTANCE.colorizeAll(string));
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String capitalize(@NotNull String str) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(str, "str");
        StringBuilder builder = new StringBuilder();
        Object object = str;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        object = string;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] words = thisCollection$iv.toArray(new String[0]);
        int n2 = words.length;
        for (int i = 0; i < n2; ++i) {
            String word = words[i];
            if (((CharSequence)word).length() == 0) continue;
            String string2 = String.valueOf(word.charAt(0));
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
            String string3 = string2.toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            builder.append(string3);
            if (word.length() > 1) {
                String string4 = word.substring(1);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                builder.append(string4);
            }
            if (i >= words.length - 1) continue;
            builder.append(" ");
        }
        String string5 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
        return string5;
    }

    public final boolean isLivingEntityInModalList(@NotNull CachedModalList<String> list, @NotNull LivingEntityWrapper lmEntity, boolean checkBabyMobs) {
        Intrinsics.checkNotNullParameter(list, "list");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        String checkName = checkBabyMobs ? lmEntity.getNameIfBaby() : lmEntity.getTypeName();
        for (String group : lmEntity.getApplicableGroups()) {
            if (!list.getExcludedGroups().contains(group)) continue;
            return false;
        }
        if (list.getExcludedList().contains(lmEntity.getTypeName()) || list.getExcludedList().contains(lmEntity.getNameIfBaby()) || lmEntity.isBabyMob() && list.getExcludedList().contains("baby_")) {
            return false;
        }
        for (String group : lmEntity.getApplicableGroups()) {
            if (!list.getIncludedGroups().contains(group)) continue;
            return true;
        }
        return list.isBlacklist() || list.getIncludedList().contains(checkName) || lmEntity.isBabyMob() && list.getIncludedList().contains("baby_");
    }

    public final boolean isIntegerInModalList(@NotNull CachedModalList<MinAndMax> list, int checkNum) {
        Intrinsics.checkNotNullParameter(list, "list");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        for (MinAndMax exclude : list.getExcludedList()) {
            if (!((float)checkNum >= exclude.getMin()) || !((float)checkNum <= exclude.getMax())) continue;
            return false;
        }
        if (list.isBlacklist()) {
            return true;
        }
        for (MinAndMax include : list.getIncludedList()) {
            if (!((float)checkNum >= include.getMin()) || !((float)checkNum <= include.getMax())) continue;
            return true;
        }
        return false;
    }

    public final boolean isBiomeInModalList(@NotNull CachedModalList<Biome> list, @NotNull Biome biome, @NotNull RulesManager rulesManager) {
        Intrinsics.checkNotNullParameter(list, "list");
        Intrinsics.checkNotNullParameter(biome, "biome");
        Intrinsics.checkNotNullParameter(rulesManager, "rulesManager");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        for (String group : list.getExcludedGroups()) {
            if (!rulesManager.getBiomeGroupMappings().containsKey(group)) continue;
            Set<String> set = rulesManager.getBiomeGroupMappings().get(group);
            Intrinsics.checkNotNull(set);
            if (!set.contains(biome.toString())) continue;
            return false;
        }
        if (list.getExcludedList().contains(biome)) {
            return false;
        }
        for (String group : list.getIncludedGroups()) {
            if (!rulesManager.getBiomeGroupMappings().containsKey(group)) continue;
            Set<String> set = rulesManager.getBiomeGroupMappings().get(group);
            Intrinsics.checkNotNull(set);
            if (!set.contains(biome.toString())) continue;
            return true;
        }
        return list.isBlacklist() || list.getIncludedList().contains(biome);
    }

    public final boolean isDamageCauseInModalList(@NotNull CachedModalList<String> list, @NotNull String cause) {
        Intrinsics.checkNotNullParameter(list, "list");
        Intrinsics.checkNotNullParameter(cause, "cause");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        if (list.getExcludedList().contains(cause)) {
            return false;
        }
        return list.isBlacklist() || list.getIncludedList().contains(cause);
    }

    public final long getMillisecondsFromInstant(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "instant");
        return Duration.between(instant, Instant.now()).toMillis();
    }

    @NotNull
    public final PlayerNetherOrWorldSpawnResult getPortalOrWorldSpawn(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Location location = null;
        boolean isNetherPortalCoord = false;
        boolean isWorldPortalCoord = false;
        if (player.getWorld().getEnvironment() == World.Environment.NETHER) {
            location = MainCompanion.Companion.getInstance().getPlayerNetherPortalLocation(player);
            isNetherPortalCoord = true;
        } else if (player.getWorld().getEnvironment() == World.Environment.NORMAL) {
            location = MainCompanion.Companion.getInstance().getPlayerWorldPortalLocation(player);
            isWorldPortalCoord = true;
        }
        if (location == null) {
            location = player.getWorld().getSpawnLocation();
            isNetherPortalCoord = false;
            isWorldPortalCoord = false;
        }
        return new PlayerNetherOrWorldSpawnResult(location, isNetherPortalCoord, isWorldPortalCoord);
    }

    public final long getChunkKey(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            return chunk.getChunkKey();
        }
        int x = chunk.getX() >> 4;
        int z = chunk.getZ() >> 4;
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    @NotNull
    public final String displayChunkLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return location.getChunk().getX() + "," + location.getChunk().getZ();
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public final <T, U> Map.Entry<T, U> getPair(T first, U second) {
        return new AbstractMap.SimpleEntry<T, U>(first, second);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matchWildcardString(@NotNull String input, @NotNull String match) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(match, "match");
        if (!StringsKt.contains$default((CharSequence)match, "*", false, 2, null)) {
            return StringsKt.equals(input, match, true);
        }
        Object object = match;
        Regex regex = new Regex("\\*");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray22 = false;
        String thisCollection$iv = $this$toTypedArray$iv;
        String[] chopped = thisCollection$iv.toArray(new String[0]);
        if (chopped.length > 3) {
            Log.INSTANCE.war("Invalid wildcard pattern: " + match);
            return StringsKt.equals(input, match, true);
        }
        String $i$f$toTypedArray22 = input;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string = $i$f$toTypedArray22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String inputL = string;
        thisCollection$iv = match;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
        String string2 = thisCollection$iv.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String matchL = string2;
        String useSearch = null;
        if (StringsKt.startsWith$default(matchL, "*", false, 2, null) && StringsKt.endsWith$default(matchL, "*", false, 2, null)) {
            String string3 = matchL.substring(1, matchL.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            useSearch = string3;
            return StringsKt.contains$default((CharSequence)inputL, useSearch, false, 2, null);
        }
        if (StringsKt.startsWith$default(matchL, "*", false, 2, null)) {
            String string4 = matchL.substring(1);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            useSearch = string4;
            return StringsKt.endsWith$default(inputL, useSearch, false, 2, null);
        }
        useSearch = StringsKt.dropLast(matchL, 1);
        return StringsKt.startsWith$default(inputL, useSearch, false, 2, null);
    }

    @NotNull
    public final String removeColorCodes(@NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        String formatted = StringsKt.replace$default(input, "\u00a7", "&", false, 4, null);
        if (StringsKt.contains$default((CharSequence)input, "&", false, 2, null)) {
            CharSequence charSequence = input;
            Regex regex = new Regex("&.");
            String string = "";
            formatted = regex.replace(charSequence, string);
        }
        return formatted;
    }

    private final String showLocation(Location location) {
        return location.getWorld().getName() + " at " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    public final boolean checkIfMobHashChanged(@NotNull LivingEntityWrapper lmEntity) {
        boolean hashChanged;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING)) {
            return true;
        }
        boolean hadHash = false;
        String mobHash = null;
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING)) {
            mobHash = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING);
            hadHash = true;
        }
        boolean bl = hashChanged = !Intrinsics.areEqual(main.getRulesManager().getCurrentRulesHash(), mobHash);
        if (hashChanged) {
            if (hadHash) {
                DebugManager.Companion.log(DebugType.MOB_HASH, lmEntity, false, () -> Utils.checkIfMobHashChanged$lambda$0(lmEntity));
            } else {
                DebugManager.Companion.log(DebugType.MOB_HASH, lmEntity, false, () -> Utils.checkIfMobHashChanged$lambda$1(lmEntity));
            }
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING, (Object)main.getRulesManager().getCurrentRulesHash());
        } else {
            DebugManager.Companion.log(DebugType.MOB_HASH, lmEntity, true, () -> Utils.checkIfMobHashChanged$lambda$2(lmEntity));
        }
        return hashChanged;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long parseTimeUnit(@Nullable String input, @Nullable Long defaultTime, boolean useMS, @Nullable CommandSender sender) {
        String[] split;
        String unit;
        String string;
        Object numberPart;
        if (input == null) {
            return defaultTime;
        }
        if (Intrinsics.areEqual("0", input)) {
            return 0L;
        }
        Matcher match = timeUnitPattern.matcher(input);
        if (!match.matches() || match.groupCount() != 2) {
            CommandSender commandSender = sender;
            if (commandSender != null) {
                commandSender.sendMessage("Invalid time: " + input);
            } else {
                Log.INSTANCE.war("Invalid time: " + input);
            }
            return defaultTime;
        }
        long time = 0L;
        double remainder = 0.0;
        Object object = numberPart = match.group(1) != null ? match.group(1) : match.group(2);
        if (match.group(1) != null) {
            String string2 = match.group(2);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            string = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string.toLowerCase(locale);
            v5 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        } else {
            v5 = unit = "";
        }
        if (this.isInteger(input)) {
            numberPart = input;
            unit = "";
        }
        string = numberPart;
        Intrinsics.checkNotNull(string);
        if (StringsKt.contains$default((CharSequence)string, ".", false, 2, null)) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object2 = numberPart;
            Intrinsics.checkNotNull(object2);
            object2 = (CharSequence)object2;
            Regex regex = new Regex("\\.");
            int n = 0;
            object2 = regex.split((CharSequence)object2, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            split = thisCollection$iv.toArray(new String[0]);
            try {
                remainder = 1.0 - Double.parseDouble("0." + split[1]);
                numberPart = split[0];
            }
            catch (Exception exception) {
                CommandSender commandSender = sender;
                if (commandSender != null) {
                    commandSender.sendMessage("Invalid time: " + input);
                } else {
                    Log.INSTANCE.war("Invalid time: " + input);
                }
                return defaultTime;
            }
        }
        try {
            split = numberPart;
            Intrinsics.checkNotNull(split);
            time = Long.parseLong((String)split);
        }
        catch (Exception exception) {
            CommandSender commandSender = sender;
            if (commandSender != null) {
                commandSender.sendMessage("Invalid time: " + input);
            } else {
                Log.INSTANCE.war("Invalid time: " + input);
            }
            return defaultTime;
        }
        Duration duration = null;
        switch (unit) {
            case "milliseconds": 
            case "ms": 
            case "millisecond": {
                duration = Duration.ofMillis(time);
                break;
            }
            case "second": 
            case "seconds": 
            case "s": {
                duration = Duration.ofSeconds(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusMillis((long)(1000.0 * remainder));
                break;
            }
            case "minutes": 
            case "m": 
            case "minute": {
                duration = Duration.ofMinutes(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusMillis((long)(60000.0 * remainder));
                break;
            }
            case "hours": 
            case "h": 
            case "hour": {
                duration = Duration.ofHours(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusMillis((long)(3600000.0 * remainder));
                break;
            }
            case "d": 
            case "days": 
            case "day": {
                duration = Duration.ofDays(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusSeconds((long)(86400.0 * remainder));
                break;
            }
            case "": {
                duration = useMS ? Duration.ofMillis(time) : Duration.ofSeconds(time);
                break;
            }
            default: {
                CommandSender commandSender = sender;
                if (commandSender != null) {
                    commandSender.sendMessage("Invalid time unit specified: " + input + " (" + unit + ")");
                    break;
                }
                Log.INSTANCE.war("Invalid time unit specified: " + input + " (" + unit + ")");
            }
        }
        if (duration != null) {
            return useMS ? Long.valueOf(duration.toMillis()) : Long.valueOf(duration.getSeconds());
        }
        return defaultTime;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Player> filterPlayersList(@NotNull List<Player> entities, @NotNull LivingEntity mob, @Nullable Double maxDistance) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(entities, "entities");
        Intrinsics.checkNotNullParameter(mob, "mob");
        Sequence<Pair> sequence = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)entities), arg_0 -> Utils.filterPlayersList$lambda$0(mob, arg_0)), Utils::filterPlayersList$lambda$1), arg_0 -> Utils.filterPlayersList$lambda$2(mob, arg_0)), arg_0 -> Utils.filterPlayersList$lambda$3(maxDistance, arg_0));
        boolean $i$f$sortedBy = false;
        Sequence<Player> temp = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
            }
        }), Utils::filterPlayersList$lambda$5);
        if (MainCompanion.Companion.getInstance().getExcludePlayersInCreative()) {
            temp = SequencesKt.filter(temp, Utils::filterPlayersList$lambda$6);
        }
        return SequencesKt.toMutableList(temp);
    }

    @NotNull
    public final List<String> splitStringWithQuotes(@NotNull String myString) {
        Intrinsics.checkNotNullParameter(myString, "myString");
        List results = new ArrayList();
        Pattern pattern = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");
        Matcher match = pattern.matcher(myString);
        while (match.find()) {
            String temp;
            String string = temp = match.group(0);
            Intrinsics.checkNotNull(string);
            if (StringsKt.startsWith$default(string, "\"", false, 2, null)) {
                string = temp;
                Intrinsics.checkNotNull(string);
                if (StringsKt.endsWith$default(string, "\"", false, 2, null)) {
                    string = temp;
                    Intrinsics.checkNotNull(string);
                    int n = 1;
                    int n2 = temp.length() - 1;
                    String string2 = string.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    temp = string2;
                }
            }
            string = temp;
            Intrinsics.checkNotNull(string);
            results.add(string);
        }
        return results;
    }

    @Nullable
    public final Enchantment getEnchantment(@NotNull String enchantName) {
        Intrinsics.checkNotNullParameter(enchantName, "enchantName");
        Enchantment enchantment = null;
        ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();
        if (ver.isRunningPaper() && ver.getMinorVersion() >= 21) {
            Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
            Intrinsics.checkNotNullExpressionValue(registry, "getRegistry(...)");
            Registry registry2 = registry;
            String string = enchantName;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            enchantment = (Enchantment)registry2.get(NamespacedKey.minecraft((String)string2));
        } else {
            String string = enchantName;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)string3));
        }
        return enchantment;
    }

    private static final String checkIfMobHashChanged$lambda$0(LivingEntityWrapper $lmEntity) {
        return "Invalid hash, location: " + INSTANCE.showLocation($lmEntity.getLocation());
    }

    private static final String checkIfMobHashChanged$lambda$1(LivingEntityWrapper $lmEntity) {
        return "Hash missing, location: " + INSTANCE.showLocation($lmEntity.getLocation());
    }

    private static final String checkIfMobHashChanged$lambda$2(LivingEntityWrapper $lmEntity) {
        return "Hash missing, location: " + INSTANCE.showLocation($lmEntity.getLocation());
    }

    private static final boolean filterPlayersList$lambda$0(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return Intrinsics.areEqual(p.getWorld(), $mob.getWorld());
    }

    private static final boolean filterPlayersList$lambda$1(Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return p.getGameMode() != GameMode.SPECTATOR;
    }

    private static final Pair filterPlayersList$lambda$2(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return new Pair<Double, Player>($mob.getLocation().distanceSquared(p.getLocation()), p);
    }

    private static final boolean filterPlayersList$lambda$3(Double $maxDistance, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $maxDistance != null && ((Number)it.getFirst()).doubleValue() <= $maxDistance;
    }

    private static final Player filterPlayersList$lambda$5(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Player)it.getSecond();
    }

    private static final boolean filterPlayersList$lambda$6(Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return ((Player)e).getGameMode() != GameMode.CREATIVE;
    }

    static {
        Pattern pattern = Pattern.compile("(\\d+\\.?\\d+|\\d+)?(\\w+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        timeUnitPattern = pattern;
        String[] stringArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        oneToNine = CollectionsKt.mutableListOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AttributeNames.values().length];
            try {
                nArray[AttributeNames.MAX_HEALTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.ATTACK_DAMAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.MOVEMENT_SPEED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.JUMP_STRENGTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.ARMOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.ARMOR_TOUGHNESS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.KNOCKBACK_RESISTANCE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.FLYING_SPEED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.ATTACK_KNOCKBACK.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.FOLLOW_RANGE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AttributeNames.SPAWN_REINFORCEMENTS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

