/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.wrappers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerResult;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u001b\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-J\u000e\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020-R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\bR\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u00101\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001e\u00a8\u00063"}, d2={"Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerWrapper;", "", "runnable", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/Runnable;)V", "entity", "Lorg/bukkit/entity/Entity;", "(Lorg/bukkit/entity/Entity;)V", "(Lorg/bukkit/entity/Entity;Ljava/lang/Runnable;)V", "getRunnable", "()Ljava/lang/Runnable;", "setRunnable", "getEntity", "()Lorg/bukkit/entity/Entity;", "setEntity", "value", "Lorg/bukkit/scheduler/BukkitTask;", "bukkitTask", "getBukkitTask", "()Lorg/bukkit/scheduler/BukkitTask;", "locationForRegionScheduler", "Lorg/bukkit/Location;", "getLocationForRegionScheduler", "()Lorg/bukkit/Location;", "setLocationForRegionScheduler", "(Lorg/bukkit/Location;)V", "runDirectlyInFolia", "", "getRunDirectlyInFolia", "()Z", "setRunDirectlyInFolia", "(Z)V", "runDirectlyInBukkit", "getRunDirectlyInBukkit", "setRunDirectlyInBukkit", "main", "Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "getMain", "()Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "run", "", "runTaskTimerAsynchronously", "Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerResult;", "initialDelayMS", "", "repeatPeriodMS", "runDelayed", "delayInTicks", "willRunDirectly", "getWillRunDirectly", "levelledmobs-plugin"})
public final class SchedulerWrapper {
    @Nullable
    private Runnable runnable;
    @Nullable
    private Entity entity;
    @Nullable
    private BukkitTask bukkitTask;
    @Nullable
    private Location locationForRegionScheduler;
    private boolean runDirectlyInFolia;
    private boolean runDirectlyInBukkit;
    @NotNull
    private final LevelledMobs main;

    @Nullable
    public final Runnable getRunnable() {
        return this.runnable;
    }

    public final void setRunnable(@Nullable Runnable runnable2) {
        this.runnable = runnable2;
    }

    @Nullable
    public final Entity getEntity() {
        return this.entity;
    }

    public final void setEntity(@Nullable Entity entity) {
        this.entity = entity;
    }

    @Nullable
    public final BukkitTask getBukkitTask() {
        return this.bukkitTask;
    }

    public SchedulerWrapper(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter(runnable2, "runnable");
        this.main = LevelledMobs.Companion.getInstance();
        this.runnable = runnable2;
    }

    public SchedulerWrapper(@Nullable Entity entity) {
        this.main = LevelledMobs.Companion.getInstance();
        this.entity = entity;
    }

    public SchedulerWrapper(@Nullable Entity entity, @NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter(runnable2, "runnable");
        this.main = LevelledMobs.Companion.getInstance();
        this.entity = entity;
        this.runnable = runnable2;
    }

    @Nullable
    public final Location getLocationForRegionScheduler() {
        return this.locationForRegionScheduler;
    }

    public final void setLocationForRegionScheduler(@Nullable Location location) {
        this.locationForRegionScheduler = location;
    }

    public final boolean getRunDirectlyInFolia() {
        return this.runDirectlyInFolia;
    }

    public final void setRunDirectlyInFolia(boolean bl) {
        this.runDirectlyInFolia = bl;
    }

    public final boolean getRunDirectlyInBukkit() {
        return this.runDirectlyInBukkit;
    }

    public final void setRunDirectlyInBukkit(boolean bl) {
        this.runDirectlyInBukkit = bl;
    }

    @NotNull
    public final LevelledMobs getMain() {
        return this.main;
    }

    public final void run() {
        if (this.main.getVer().isRunningFolia()) {
            if (this.runDirectlyInFolia) {
                Runnable runnable2 = this.runnable;
                Intrinsics.checkNotNull(runnable2);
                runnable2.run();
                return;
            }
            Consumer<ScheduledTask> task = arg_0 -> SchedulerWrapper.run$lambda$0(this, arg_0);
            if (this.entity != null) {
                Entity entity = this.entity;
                Intrinsics.checkNotNull(entity);
                v2 = entity.getScheduler().run((Plugin)this.main, task, null);
            } else if (this.locationForRegionScheduler != null) {
                RegionScheduler regionScheduler = Bukkit.getRegionScheduler();
                Plugin plugin = (Plugin)this.main;
                Location location = this.locationForRegionScheduler;
                Intrinsics.checkNotNull(location);
                v2 = regionScheduler.run(plugin, location, task);
            } else {
                v2 = Bukkit.getAsyncScheduler().runNow((Plugin)this.main, task);
            }
        } else {
            BukkitTask bukkitTask;
            if (this.runDirectlyInBukkit) {
                Runnable runnable3 = this.runnable;
                Intrinsics.checkNotNull(runnable3);
                runnable3.run();
                return;
            }
            if (this.entity != null) {
                BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
                Plugin plugin = (Plugin)this.main;
                Runnable runnable4 = this.runnable;
                Intrinsics.checkNotNull(runnable4);
                bukkitTask = bukkitScheduler.runTask(plugin, runnable4);
            } else {
                BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
                Plugin plugin = (Plugin)this.main;
                Runnable runnable5 = this.runnable;
                Intrinsics.checkNotNull(runnable5);
                bukkitTask = bukkitScheduler.runTaskAsynchronously(plugin, runnable5);
            }
            this.bukkitTask = bukkitTask;
            v2 = Unit.INSTANCE;
        }
    }

    @NotNull
    public final SchedulerResult runTaskTimerAsynchronously(long initialDelayMS, long repeatPeriodMS) {
        if (this.main.getVer().isRunningFolia()) {
            Consumer<ScheduledTask> task = arg_0 -> SchedulerWrapper.runTaskTimerAsynchronously$lambda$0(this, arg_0);
            ScheduledTask scheduledTask = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.main, task, initialDelayMS, repeatPeriodMS, TimeUnit.MILLISECONDS);
            Intrinsics.checkNotNullExpressionValue(scheduledTask, "runAtFixedRate(...)");
            ScheduledTask scheduledTask2 = scheduledTask;
            return new SchedulerResult(scheduledTask2);
        }
        long convertedDelay = initialDelayMS / 50L;
        long convertedPeriod = repeatPeriodMS / 50L;
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Plugin plugin = (Plugin)this.main;
        Runnable runnable2 = this.runnable;
        Intrinsics.checkNotNull(runnable2);
        BukkitTask bukkitTask = bukkitScheduler.runTaskTimerAsynchronously(plugin, runnable2, convertedDelay, convertedPeriod);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
        BukkitTask bukkitTask2 = bukkitTask;
        return new SchedulerResult(bukkitTask2);
    }

    @NotNull
    public final SchedulerResult runDelayed(long delayInTicks) {
        if (this.main.getVer().isRunningFolia()) {
            Consumer<ScheduledTask> task = arg_0 -> SchedulerWrapper.runDelayed$lambda$0(this, arg_0);
            ScheduledTask scheduledTask = null;
            if (this.entity != null) {
                Entity entity = this.entity;
                Intrinsics.checkNotNull(entity);
                scheduledTask = entity.getScheduler().runDelayed((Plugin)this.main, task, null, delayInTicks);
            } else {
                long milliseconds = delayInTicks * 50L;
                scheduledTask = Bukkit.getAsyncScheduler().runDelayed((Plugin)this.main, task, milliseconds, TimeUnit.MILLISECONDS);
            }
            return new SchedulerResult(scheduledTask);
        }
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Plugin plugin = (Plugin)this.main;
        Runnable runnable2 = this.runnable;
        Intrinsics.checkNotNull(runnable2);
        BukkitTask bukkitTask = bukkitScheduler.runTaskLater(plugin, runnable2, delayInTicks);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskLater(...)");
        BukkitTask bukkitTask2 = bukkitTask;
        return new SchedulerResult(bukkitTask2);
    }

    public final boolean getWillRunDirectly() {
        return this.main.getVer().isRunningFolia() ? this.runDirectlyInFolia : this.runDirectlyInBukkit;
    }

    private static final void run$lambda$0(SchedulerWrapper this$0, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(scheduledTask, "<unused var>");
        Runnable runnable2 = this$0.runnable;
        Intrinsics.checkNotNull(runnable2);
        runnable2.run();
    }

    private static final void runTaskTimerAsynchronously$lambda$0(SchedulerWrapper this$0, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(scheduledTask, "<unused var>");
        Runnable runnable2 = this$0.runnable;
        Intrinsics.checkNotNull(runnable2);
        runnable2.run();
    }

    private static final void runDelayed$lambda$0(SchedulerWrapper this$0, ScheduledTask scheduledTask) {
        Runnable runnable2 = this$0.runnable;
        Intrinsics.checkNotNull(runnable2);
        runnable2.run();
    }
}

