/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.projectomnipotence.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibarnstormer.projectomnipotence.config.POPlayerConfig;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class POConfig {
    private static final Gson GSON = new GsonBuilder().setLenient().disableHtmlEscaping().setPrettyPrinting().create();
    private final String _comment_version = "Config version, set to -1 to prevent config updates.";
    private int version = 6;
    private final String _comment_PlayerConfig = "Player Configurations: Various modifiers for specific players";
    public List<POPlayerConfig> playerConfigs = new ArrayList<POPlayerConfig>();
    private final String _comment_DamageReflect = "Damage Reflection Black List: Entries are in the format: 'namespace:entity_id' (e.g. minecraft:creeper) or '*' for all entities";
    public Set<String> damageReflectionBlackList = new HashSet<String>();
    private final String _comment_removeOnEnlighten = "Removal upon being enlightened: Entries are in the format: 'namespace:entity_id' (e.g. minecraft:creeper) or '*' for all entities";
    public Set<String> removeOnEnlightenList = new HashSet<String>();
    private final String _comment_EnlightenmentBlacklist = "Enlightenment blacklist: Entries are in the format: 'namespace:entity_id' (e.g. minecraft:creeper) or '*' for all entities";
    public Set<String> enlightenmentBlackList = new HashSet<String>();
    private final String _comment_ConvertUponEnlightened = "Entity to convert to upon enlightenment. Key is target entity, value is the entity to convert to. Entries are in the format: 'namespace:entity_id' (e.g. minecraft:creeper)";
    public final Map<String, String> convertUponEnlightened = new HashMap<String, String>();
    public int flightEntityGoal = 10000;
    public int invulnerabilityEntityGoal = 1000;
    public int luckLevelEntityGoal = 250;
    public int totalLuckLevels = 3;
    public boolean omnipotentPlayersGlow = false;
    public boolean omnipotentPlayerParticles = true;
    public boolean omnipotentPlayerParticlesLocal = false;
    public boolean omnipotentPlayerRenderParticlesClient = true;
    public boolean omnipotentPlayersCanBecomeInvulnerable = true;
    public boolean omnipotentPlayersCanGainFlight = false;
    public boolean omnipotentPlayersDontGriefTrees = true;
    public boolean omnipotentPlayersReflectDamage = true;
    public boolean omnipotentPlayersRemoveCurses = true;
    public boolean carryOnCompat = true;

    private POConfig() {
        this.playerConfigs.add(new POPlayerConfig("(Example Player Username Here)", "0", false, 0, 0));
        this.removeOnEnlightenList.add("blue_skies:alchemist");
        this.removeOnEnlightenList.add("blue_skies:arachnarch");
        this.removeOnEnlightenList.add("blue_skies:starlit_crusher");
        this.removeOnEnlightenList.add("blue_skies:summoner");
        this.removeOnEnlightenList.add("aether:sun_spirit");
        this.removeOnEnlightenList.add("aether:valkryie_queen");
        this.removeOnEnlightenList.add("aether:slider");
        this.removeOnEnlightenList.add("twilightforest:hydra");
        this.removeOnEnlightenList.add("twilightforest:naga");
        this.removeOnEnlightenList.add("twilightforest:knight_phantom");
        this.removeOnEnlightenList.add("mowziesmobs:ferrous_wroughtnaut");
        this.enlightenmentBlackList.add("dummmmmmy:target_dummy");
        this.enlightenmentBlackList.add("minecraft:armor_stand");
        this.convertUponEnlightened.put("minecraft:zombie_villager", "minecraft:villager");
        this.convertUponEnlightened.put("minecraft:zoglin", "minecraft:hoglin");
        this.convertUponEnlightened.put("minecraft:zombified_piglin", "minecraft:piglin");
        this.convertUponEnlightened.put("minecraft:ghast", "minecraft:happy_ghast");
        this.convertUponEnlightened.put("illageandspillage:ragno", "minecraft:villager");
        this.convertUponEnlightened.put("illageandportage:ragno", "minecraft:villager");
    }

    public static POConfig initConfig() {
        try {
            POConfig config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "ProjectOmnipotence.json");
            if (configFile.exists()) {
                String json = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
                config = (POConfig)GSON.fromJson(json, POConfig.class);
                if (config.version != 6 && config.version != -1) {
                    POConfig.updateConfig(config);
                }
            } else {
                config = new POConfig();
            }
            FileUtils.writeStringToFile((File)configFile, (String)GSON.toJson((Object)config), (Charset)StandardCharsets.UTF_8);
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new POConfig();
        }
    }

    private static void updateConfig(POConfig config) {
        POConfig freshConfig = new POConfig();
        config.version = freshConfig.version;
        config.damageReflectionBlackList.addAll(freshConfig.damageReflectionBlackList);
        config.removeOnEnlightenList.addAll(freshConfig.removeOnEnlightenList);
        config.damageReflectionBlackList.addAll(freshConfig.damageReflectionBlackList);
        config.enlightenmentBlackList.addAll(freshConfig.enlightenmentBlackList);
        config.convertUponEnlightened.putAll(freshConfig.convertUponEnlightened);
    }
}

