/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.projectomnipotence.mixin;

import com.ibarnstormer.projectomnipotence.block.entity.EnlighteningBeacon;
import com.ibarnstormer.projectomnipotence.utils.POUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4844;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2580.class})
public abstract class BeaconBlockEntityMixin
extends class_2586
implements EnlighteningBeacon {
    @Unique
    private boolean isEnlightening;
    @Unique
    private UUID omnipotentOwner;
    @Unique
    private int cachedEnlightenedAmount;

    public BeaconBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"method_11014(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    private void beaconBlockEntity$readData(class_11368 view, CallbackInfo ci) {
        try {
            this.isEnlightening = view.method_71433("isEnlightening", false);
            view.method_71426("omnipotentOwnerUUID", class_4844.field_25122);
            this.cachedEnlightenedAmount = view.method_71424("cachedEnlightenedAmount", 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"method_11007(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    private void beaconBlockEntity$writeData(class_11372 view, CallbackInfo ci) {
        try {
            view.method_71472("isEnlightening", this.isEnlightening);
            view.method_71468("omnipotentOwnerUUID", class_4844.field_25122, (Object)this.omnipotentOwner);
            view.method_71465("cachedEnlightenedAmount", this.cachedEnlightenedAmount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"method_10940(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;ILnet/minecraft/class_6880;Lnet/minecraft/class_6880;)V"}, at={@At(value="HEAD")})
    private static void beaconBlockEntity$applyPlayerEffects(class_1937 world, class_2338 pos, int beaconLevel, @Nullable class_6880<class_1291> primaryEffect, @Nullable class_6880<class_1291> secondaryEffect, CallbackInfo ci) {
        class_2580 beacon;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof class_2580 && ((EnlighteningBeacon)(beacon = (class_2580)class_25862)).isEnlightening()) {
            double d = beaconLevel * 10 + 10;
            class_238 box = new class_238(pos).method_1014(d).method_1012(0.0, (double)world.method_31605(), 0.0);
            class_1657 player = ((EnlighteningBeacon)beacon).getOmnipotentOwner();
            List entities = world.method_8390(class_1309.class, box, e -> e.method_5864() != class_1299.field_6097 && !POUtils.isInHarmony((class_1297)e));
            for (class_1309 entity : entities) {
                POUtils.harmonizeEntityByBeacon(entity, player, pos);
            }
            if (player == null) {
                ((EnlighteningBeacon)beacon).setEnlightenedCache(((EnlighteningBeacon)beacon).getEnlightenedCache() + entities.size());
            } else {
                POUtils.setEntitiesEnlightened(player, POUtils.getEntitiesEnlightened(player) + ((EnlighteningBeacon)beacon).getEnlightenedCache());
                ((EnlighteningBeacon)beacon).setEnlightenedCache(0);
            }
        }
    }

    @Override
    public int getEnlightenedCache() {
        return this.cachedEnlightenedAmount;
    }

    @Override
    @Nullable
    public class_1657 getOmnipotentOwner() {
        if (this.field_11863 != null && this.omnipotentOwner != null) {
            return this.field_11863.method_18470(this.omnipotentOwner);
        }
        return null;
    }

    @Override
    public void setEnlightenedCache(int i) {
        this.cachedEnlightenedAmount = i;
    }

    @Override
    public void setAsEnlightening(@Nullable class_1657 player) {
        this.isEnlightening = true;
        this.omnipotentOwner = player != null ? player.method_5667() : new UUID(0L, 0L);
        this.cachedEnlightenedAmount = 0;
    }

    @Override
    public boolean isEnlightening() {
        return this.isEnlightening;
    }
}

