/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.projectomnipotence.mixin;

import com.ibarnstormer.projectomnipotence.config.POPlayerConfig;
import com.ibarnstormer.projectomnipotence.utils.POUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_12090;
import net.minecraft.class_12099;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2170.class})
public abstract class CommandManagerMixin {
    @Shadow
    @Final
    private CommandDispatcher<class_2168> field_9832;
    @Unique
    private static final class_12090 PERMISSION_CHECK = new class_12090.class_12092(class_12099.field_63210);

    @Inject(at={@At(value="INVOKE", target="Lcom/mojang/brigadier/CommandDispatcher;setConsumer(Lcom/mojang/brigadier/ResultConsumer;)V")}, method={"<init>(Lnet/minecraft/class_2170$class_5364;Lnet/minecraft/class_7157;)V"})
    private void commandManager$init(class_2170.class_5364 environment, class_7157 registryAccess, CallbackInfo ci) {
        this.field_9832.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"projectOmnipotence").then(class_2170.method_9247((String)"checkEntitiesEnlightened").executes(this::getEEStatistics))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clearEnlightened").requires((Predicate)class_2170.method_71774((class_12090)PERMISSION_CHECK))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(this::clearEnlightened)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"entitiesEnlightened").requires((Predicate)class_2170.method_71774((class_12090)PERMISSION_CHECK))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(this::outputEntitiesEnlightened)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(this::setEntitiesEnlightened)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setEnlightened").requires((Predicate)class_2170.method_71774((class_12090)PERMISSION_CHECK))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(this::setEnlightened))));
    }

    @Unique
    private int getEEStatistics(CommandContext<class_2168> context) {
        int score = POUtils.getEntitiesEnlightened((class_1657)Objects.requireNonNull(((class_2168)context.getSource()).method_44023()));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("\u00a7eYou've enlightened " + score + " entities.")), false);
        return 1;
    }

    @Unique
    private int outputEntitiesEnlightened(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 target = class_2186.method_9315(context, (String)"target");
        int score = POUtils.getEntitiesEnlightened((class_1657)target);
        ((class_2168)context.getSource()).method_9226(() -> CommandManagerMixin.lambda$outputEntitiesEnlightened$1((class_1657)target, score), false);
        return 1;
    }

    @Unique
    private int setEntitiesEnlightened(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"target");
        POUtils.setEntitiesEnlightened((class_1657)player, (Integer)context.getArgument("amount", Integer.class));
        ((class_2168)context.getSource()).method_9226(() -> CommandManagerMixin.lambda$setEntitiesEnlightened$2((class_1657)player), true);
        return 1;
    }

    @Unique
    private int setEnlightened(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 target = class_2186.method_9313(context, (String)"target");
        boolean isPlayer = target instanceof class_1657;
        if (!isPlayer) {
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                if (!POUtils.isInHarmony(target)) {
                    POUtils.harmonizeEntity(livingEntity, (class_1657)((class_2168)context.getSource()).method_44023(), target.method_48923().method_48802((class_1657)((class_2168)context.getSource()).method_44023()));
                    if (POUtils.isInHarmony(target)) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is now enlightened.")), true);
                    } else {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " cannot be enlightened.")), false);
                    }
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is already enlightened.")), false);
                }
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " cannot be enlightened.")), false);
            }
        } else {
            class_1657 player = (class_1657)target;
            if (!POUtils.isOmnipotent(player)) {
                POUtils.grantOmnipotence(player, false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is now an Omnipotent.")), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is already an Omnipotent.")), false);
            }
        }
        return 1;
    }

    @Unique
    private int clearEnlightened(CommandContext<class_2168> context) throws CommandSyntaxException {
        POPlayerConfig config;
        class_1297 target = class_2186.method_9313(context, (String)"target");
        boolean isPlayer = target instanceof class_1657;
        boolean failure = false;
        boolean cannotLoseEnlightenment = false;
        if (isPlayer && (config = POUtils.getConfigForPlayer((class_1657)target)) != null) {
            cannotLoseEnlightenment = config.enlightenedOnStart();
        }
        if (cannotLoseEnlightenment) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + "'s omnipotence cannot be removed.")), false);
            return 1;
        }
        if (!isPlayer) {
            if (POUtils.isInHarmony(target) && target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                POUtils.setInHarmony(livingEntity, false);
            } else {
                failure = true;
            }
            if (!failure) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is no longer enlightened.")), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is already not enlightened.")), false);
            }
        } else {
            class_1657 player = (class_1657)target;
            if (POUtils.isOmnipotent(player)) {
                POUtils.revokeOmnipotence(player);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is no longer an Omnipotent.")), true);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)(target.method_5477().getString() + " is already not an Omnipotent.")), false);
            }
        }
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$setEntitiesEnlightened$2(class_1657 player) {
        return class_2561.method_43470((String)("Set entities enlightened for " + player.method_5820() + " to " + POUtils.getEntitiesEnlightened(player) + "."));
    }

    private static /* synthetic */ class_2561 lambda$outputEntitiesEnlightened$1(class_1657 target, int score) {
        return class_2561.method_43470((String)(target.method_5820() + " enlightened " + score + " entities."));
    }
}

