/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.projectomnipotence.mixin;

import com.ibarnstormer.projectomnipotence.Main;
import com.ibarnstormer.projectomnipotence.entity.IHarmonicEntity;
import com.ibarnstormer.projectomnipotence.mixin.EntityMixin;
import com.ibarnstormer.projectomnipotence.utils.POUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4081;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements IHarmonicEntity {
    @Unique
    boolean inHarmony;

    @Unique
    private class_1309 getLivingEntity() {
        return (class_1309)this;
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    public void livingEntity$readCustomData(class_11368 view, CallbackInfo ci) {
        class_1309 thisEntity = this.getLivingEntity();
        if (thisEntity.method_5864() != class_1299.field_6097) {
            POUtils.readNonPlayerData(thisEntity, view);
        }
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    public void livingEntity$writeCustomData(class_11372 view, CallbackInfo ci) {
        class_1309 thisEntity = this.getLivingEntity();
        if (thisEntity.method_5864() != class_1299.field_6097) {
            POUtils.writeNonPlayerData(thisEntity, view);
        }
    }

    @Inject(method={"method_18395(Lnet/minecraft/class_1309;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void livingEntity$canTarget(class_1309 target, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        if (target instanceof class_1657 && POUtils.isOmnipotent(player = (class_1657)target)) {
            cir.setReturnValue((Object)false);
        } else if (POUtils.isInHarmony((class_1297)target)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void livingEntity$damage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 thisEntity = this.getLivingEntity();
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 playerAttacker = (class_1657)class_12972;
            if (POUtils.isOmnipotent(playerAttacker) && !POUtils.enlightenedPlayerInCreative(playerAttacker) && thisEntity.method_5864() != class_1299.field_6097) {
                if (thisEntity.method_5864() == class_1299.field_6116) {
                    Object object;
                    if (playerAttacker instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)playerAttacker;
                        class_174.field_1192.method_8990(serverPlayer, (class_1297)thisEntity, source);
                    }
                    if ((object = thisEntity.method_73183()) instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)object;
                        if (serverWorld.method_29198() != null) {
                            playerAttacker.method_7255(serverWorld.method_29198().method_12530().comp_1542() ? 1000 : 24000);
                        }
                        for (class_3222 serverPlayer : serverWorld.method_18456()) {
                            serverWorld.method_14166(serverPlayer, (class_2394)class_2398.field_11207, false, true, thisEntity.method_23317(), thisEntity.method_23318() + thisEntity.method_5829().method_17940() / 2.0, thisEntity.method_23321(), 50, Math.random() * 0.5, Math.random() * 0.5, Math.random() * 0.5, 0.5);
                        }
                    }
                }
                if (!POUtils.isInHarmony((class_1297)thisEntity)) {
                    POUtils.handleEnlightenment(thisEntity, playerAttacker, source);
                }
                cir.setReturnValue((Object)false);
            }
            if (POUtils.isOmnipotent(playerAttacker) && thisEntity.method_5864() == class_1299.field_6097 && !POUtils.enlightenedPlayerInCreative(playerAttacker)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"method_6033(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void livingEntity$setHealth(float health, CallbackInfo ci) {
        class_1657 player;
        class_1309 thisEntity = this.getLivingEntity();
        if (thisEntity instanceof class_1657 && POUtils.isOmnipotent(player = (class_1657)thisEntity) && POUtils.getEntitiesEnlightened(player) >= Main.CONFIG.invulnerabilityEntityGoal && Main.CONFIG.omnipotentPlayersCanBecomeInvulnerable && health < Math.max(thisEntity.method_6063(), 20.0f)) {
            ci.cancel();
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="TAIL")})
    public void livingEntity$tick(CallbackInfo ci) {
        class_1309 thisEntity = this.getLivingEntity();
        if (POUtils.isInHarmony((class_1297)thisEntity) && thisEntity.method_5864() != class_1299.field_6097) {
            class_3218 serverWorld;
            class_1937 class_19372 = thisEntity.method_73183();
            if (class_19372 instanceof class_3218) {
                serverWorld = (class_3218)class_19372;
                if (thisEntity.field_6012 % 5 == 0) {
                    POUtils.spawnEnlightenmentParticles((class_1297)thisEntity, serverWorld);
                }
            }
            thisEntity.method_41329();
            if (thisEntity.method_5864() == class_1299.field_6116) {
                thisEntity.method_18800(thisEntity.method_18798().field_1352, 2.0, thisEntity.method_18798().field_1350);
                if (thisEntity.method_23318() > (double)thisEntity.method_73183().method_31605() && (class_19372 = thisEntity.method_73183()) instanceof class_3218) {
                    serverWorld = (class_3218)class_19372;
                    serverWorld.method_43128(null, thisEntity.method_23317(), thisEntity.method_23318(), thisEntity.method_23321(), class_3417.field_14981, class_3419.field_15250, 500.0f, 1.0f);
                    thisEntity.method_5768(serverWorld);
                }
            }
        }
    }

    @Inject(method={"method_16080(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void livingEntity$drop(class_3218 world, class_1282 damageSource, CallbackInfo ci) {
        class_1309 thisEntity = this.getLivingEntity();
        if (POUtils.isInHarmony((class_1297)thisEntity) && thisEntity.method_5864() != class_1299.field_6097) {
            ci.cancel();
        }
    }

    @Inject(method={"method_29504()Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void livingEntity$isDead(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 thisEntity = this.getLivingEntity();
        if (thisEntity instanceof class_1657 && POUtils.isOmnipotent(player = (class_1657)thisEntity) && POUtils.getEntitiesEnlightened(player) >= Main.CONFIG.invulnerabilityEntityGoal && Main.CONFIG.omnipotentPlayersCanBecomeInvulnerable) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"method_6049(Lnet/minecraft/class_1293;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void livingEntity$canHaveStatusEffect(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 thisEntity = this.getLivingEntity();
        if (thisEntity instanceof class_1657 && POUtils.isOmnipotent(player = (class_1657)thisEntity) && ((class_1291)effect.method_5579().comp_349()).method_18792() == class_4081.field_18272) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean isInHarmony() {
        return this.inHarmony;
    }

    @Override
    public void setInHarmony(boolean b) {
        this.inHarmony = b;
    }
}

