/*
 * Decompiled with CFR 0.152.
 */
package com.ibarnstormer.projectomnipotence.mixin;

import com.google.common.collect.Maps;
import com.ibarnstormer.projectomnipotence.Main;
import com.ibarnstormer.projectomnipotence.config.POPlayerConfig;
import com.ibarnstormer.projectomnipotence.entity.IPOPlayerEntity;
import com.ibarnstormer.projectomnipotence.mixin.EntityMixin;
import com.ibarnstormer.projectomnipotence.network.payload.SyncSSDHDataPayload;
import com.ibarnstormer.projectomnipotence.utils.POUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends EntityMixin
implements IPOPlayerEntity {
    @Unique
    boolean isOmnipotent;
    @Unique
    int entitiesEnlightened;
    @Unique
    private static final class_2960 OMNIPOTENT_LUCK = class_2960.method_60655((String)"projectomnipotence", (String)"omnipotent_luck");
    @Unique
    private int eeDelta;

    @Shadow
    public abstract boolean method_31747();

    @Unique
    private class_1657 getPlayer() {
        return (class_1657)this;
    }

    @Inject(method={"method_5749(Lnet/minecraft/class_11368;)V"}, at={@At(value="TAIL")})
    public void playerEntity$readCustomData(class_11368 view, CallbackInfo ci) {
        class_1657 player = this.getPlayer();
        POUtils.readPlayerData(player, view);
    }

    @Inject(method={"method_5652(Lnet/minecraft/class_11372;)V"}, at={@At(value="TAIL")})
    public void playerEntity$writeCustomData(class_11372 view, CallbackInfo ci) {
        class_1657 player = this.getPlayer();
        POUtils.writePlayerData(player, view);
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void playerEntity$damage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = this.getPlayer();
        if (POUtils.isOmnipotent(player)) {
            class_1657 playerAttacker;
            class_1297 class_12972;
            if (source.method_48789(class_8103.field_42242) && !world.method_8608() && !player.method_31549().field_7478 && player.method_23318() <= (double)world.method_31607()) {
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                POUtils.respawnPlayer((class_3222)player);
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                cir.setReturnValue((Object)false);
            }
            if (POUtils.getEntitiesEnlightened(player) >= Main.CONFIG.invulnerabilityEntityGoal && Main.CONFIG.omnipotentPlayersCanBecomeInvulnerable) {
                cir.setReturnValue((Object)false);
            }
            if (source.method_5529() != null && (!(source.method_5529() instanceof class_1657) || (class_12972 = source.method_5529()) instanceof class_1657 && !POUtils.isOmnipotent(playerAttacker = (class_1657)class_12972)) && Main.CONFIG.omnipotentPlayersReflectDamage) {
                if (Main.CONFIG.damageReflectionBlackList.contains(class_7923.field_41177.method_10221((Object)source.method_5529().method_5864()).toString()) || Main.CONFIG.damageReflectionBlackList.contains("*")) {
                    source.method_5529().method_64397(world, source.method_5529().method_48923().method_48830(), amount);
                } else {
                    source.method_5529().method_64397(world, source, amount);
                }
            }
        }
    }

    @Inject(method={"method_64397(Lnet/minecraft/class_3218;Lnet/minecraft/class_1282;F)Z"}, at={@At(value="TAIL")})
    public void playerEntity$damage_onDeath(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 attacker;
        class_1657 player = this.getPlayer();
        if (POUtils.isOmnipotent(player) && player.method_29504() && Main.CONFIG.omnipotentPlayersReflectDamage && (attacker = source.method_5529()) != null) {
            attacker.method_5768(world);
        }
    }

    @Inject(method={"method_7324(Lnet/minecraft/class_1297;)V"}, at={@At(value="HEAD")})
    public void playerEntity$attack(class_1297 target, CallbackInfo ci) {
        class_1657 player = this.getPlayer();
        if (POUtils.isOmnipotent(player) && !POUtils.enlightenedPlayerInCreative(player)) {
            List<Object> list;
            float f = (float)player.method_45325(class_5134.field_51577);
            if (f > 0.0f) {
                list = player.method_73183().method_18467(class_1309.class, target.method_5829().method_1009(1.0, 0.25, 1.0));
                class_1937 class_19372 = player.method_73183();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    double d = -class_3532.method_15374((double)(player.method_36454() * ((float)Math.PI / 180)));
                    double e = class_3532.method_15362((double)(player.method_36454() * ((float)Math.PI / 180)));
                    serverWorld.method_65096((class_2394)class_2398.field_11227, player.method_23317() + d, player.method_23323(0.5), player.method_23321() + e, 0, d, 0.0, e, 0.0);
                }
            } else if (target instanceof class_1309) {
                class_1309 le = (class_1309)target;
                list = List.of(le);
            } else {
                list = new ArrayList();
            }
            for (class_1309 le : list) {
                POUtils.handleEnlightenment(le, player, null);
            }
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="TAIL")})
    public void playerEntity$tick(CallbackInfo ci) {
        class_1657 player = this.getPlayer();
        class_1937 world = player.method_73183();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            POPlayerConfig config = POUtils.getConfigForPlayer(player);
            if (config != null) {
                if (!POUtils.isOmnipotent(player) && config.enlightenedOnStart()) {
                    POUtils.grantOmnipotence(player, false);
                }
                int score = config.eeHandicap();
                POUtils.setEntitiesEnlightened(player, Math.max(score, POUtils.getEntitiesEnlightened(player)));
            }
            class_1324 playerLuck = player.method_5996(class_5134.field_23726);
            assert (playerLuck != null);
            if (POUtils.isOmnipotent(player)) {
                if (player.field_6012 % 5 == 0 && Main.CONFIG.omnipotentPlayerParticles && !player.method_7325()) {
                    POUtils.spawnEnlightenmentParticles((class_1297)player, serverWorld);
                }
                if (Main.CONFIG.omnipotentPlayersGlow && !player.method_6059(class_1294.field_5912)) {
                    player.method_6092(new class_1293(class_1294.field_5912, -1, 0, true, false, false));
                }
                HashMap localSEICollection = Maps.newHashMap();
                for (class_1293 statusEffect : player.method_6026()) {
                    if (((class_1291)statusEffect.method_5579().comp_349()).method_18792() != class_4081.field_18272) continue;
                    localSEICollection.put((class_1291)statusEffect.method_5579().comp_349(), statusEffect);
                }
                for (class_1293 statusEffect : localSEICollection.values()) {
                    player.method_6016(statusEffect.method_5579());
                }
                int score = POUtils.getEntitiesEnlightened(player);
                class_1322 luckModifier = playerLuck.method_6199(OMNIPOTENT_LUCK);
                if (luckModifier == null && score >= Main.CONFIG.luckLevelEntityGoal) {
                    playerLuck.method_26837(new class_1322(OMNIPOTENT_LUCK, (double)POUtils.getLuckLevel(player), class_1322.class_1323.field_6328));
                } else if (luckModifier != null) {
                    double currentLevel = POUtils.getLuckLevel(player);
                    if (luckModifier.comp_2449() != currentLevel) {
                        playerLuck.method_6200(OMNIPOTENT_LUCK);
                        playerLuck.method_26837(new class_1322(OMNIPOTENT_LUCK, currentLevel, class_1322.class_1323.field_6328));
                    }
                }
                if (score > 0 && this.eeDelta == 0) {
                    this.eeDelta = score;
                }
                if (score > this.eeDelta && Math.ceil((double)score / (double)Main.CONFIG.luckLevelEntityGoal) > Math.ceil((double)this.eeDelta / (double)Main.CONFIG.luckLevelEntityGoal) && score < (Main.CONFIG.totalLuckLevels + 1) * Main.CONFIG.luckLevelEntityGoal && score > Main.CONFIG.luckLevelEntityGoal) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.projectomnipotence.attunement").method_27696(class_2583.field_24360.method_10977(class_124.field_1054)), false);
                }
                if (score > this.eeDelta && score >= Main.CONFIG.invulnerabilityEntityGoal && Main.CONFIG.omnipotentPlayersCanBecomeInvulnerable && this.eeDelta < Main.CONFIG.invulnerabilityEntityGoal) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.projectomnipotence.invulnerability").method_27696(class_2583.field_24360.method_10977(class_124.field_1054)), false);
                }
                if (score > this.eeDelta && score >= Main.CONFIG.flightEntityGoal && Main.CONFIG.omnipotentPlayersCanGainFlight && this.eeDelta < Main.CONFIG.flightEntityGoal) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.projectomnipotence.flight").method_27696(class_2583.field_24360.method_10977(class_124.field_1054)), false);
                }
                this.eeDelta = score;
                if (score >= Main.CONFIG.invulnerabilityEntityGoal && Main.CONFIG.omnipotentPlayersCanBecomeInvulnerable) {
                    player.field_6011.method_12778(class_1309.field_6247, (Object)Float.valueOf(Math.max(player.method_6063(), 20.0f)));
                    if (player.method_32312() > 0) {
                        player.method_32317(0);
                    }
                }
                if (score >= Main.CONFIG.flightEntityGoal && Main.CONFIG.omnipotentPlayersCanGainFlight && !player.method_31549().field_7478) {
                    player.method_31549().field_7478 = true;
                    player.method_7355();
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    if (serverPlayer.field_6012 % 20 == 0) {
                        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new SyncSSDHDataPayload(serverPlayer.method_7334(), POUtils.isOmnipotent((class_1657)serverPlayer), POUtils.getEntitiesEnlightened((class_1657)serverPlayer)));
                    }
                }
            } else if (playerLuck.method_6199(OMNIPOTENT_LUCK) != null) {
                playerLuck.method_6200(OMNIPOTENT_LUCK);
            }
        }
    }

    @Inject(method={"method_6078(Lnet/minecraft/class_1282;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playerEntity$onDeath(class_1282 cause, CallbackInfo ci) {
        class_1657 player = this.getPlayer();
        if (POUtils.isOmnipotent(player) && POUtils.getEntitiesEnlightened(player) >= Main.CONFIG.invulnerabilityEntityGoal && Main.CONFIG.omnipotentPlayersCanBecomeInvulnerable) {
            ci.cancel();
        }
    }

    @Inject(method={"method_68878()Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void playerEntity$isCreative(CallbackInfoReturnable<Boolean> cir) {
        StackTraceElement[] stackTrace;
        class_1657 player = this.getPlayer();
        if (POUtils.isOmnipotent(player) && Main.CONFIG.carryOnCompat) {
            for (StackTraceElement e : stackTrace = Thread.currentThread().getStackTrace()) {
                if (!e.getClassName().contains("tschipp.carryon.common.carry")) continue;
                cir.setReturnValue((Object)true);
            }
        }
        if (POUtils.isOmnipotent(player) && Main.CONFIG.omnipotentPlayersCanBecomeInvulnerable && POUtils.getEntitiesEnlightened(player) >= Main.CONFIG.invulnerabilityEntityGoal && !((Boolean)cir.getReturnValue()).booleanValue()) {
            for (StackTraceElement e : stackTrace = Thread.currentThread().getStackTrace()) {
                if (!e.getClassName().contains("com.mega.uom")) continue;
                cir.setReturnValue((Object)true);
            }
        }
        if (POUtils.isOmnipotent(player) && Main.CONFIG.omnipotentPlayersCanGainFlight && POUtils.getEntitiesEnlightened(player) >= Main.CONFIG.flightEntityGoal && !((Boolean)cir.getReturnValue()).booleanValue()) {
            for (StackTraceElement e : stackTrace = Thread.currentThread().getStackTrace()) {
                List<String> splitClass = List.of(e.getClassName().toLowerCase().split("\\."));
                if (!splitClass.contains("com") || !splitClass.contains("polarice3") || !splitClass.contains("goety") || !splitClass.contains("boss")) continue;
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Override
    public boolean isOmnipotent() {
        return this.isOmnipotent;
    }

    @Override
    public int getEntitiesEnlightened() {
        return this.entitiesEnlightened;
    }

    @Override
    public void setOmnipotent(boolean b) {
        this.isOmnipotent = b;
    }

    @Override
    public void setEntitiesEnlightened(int i) {
        this.entitiesEnlightened = i;
    }
}

