/*
 * Decompiled with CFR 0.152.
 */
package me.Lythrilla.picturelogin.libs.minedown;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.Lythrilla.picturelogin.libs.minedown.MineDown;
import me.Lythrilla.picturelogin.libs.minedown.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;

public class MineDownParser {
    private static final boolean HAS_APPEND_SUPPORT = Util.hasMethod(ComponentBuilder.class, "append", BaseComponent[].class);
    private static final boolean HAS_RGB_SUPPORT = Util.hasMethod(ChatColor.class, "of", String.class);
    private static final boolean HAS_FONT_SUPPORT = Util.hasMethod(ComponentBuilder.class, "font", String.class);
    private static final boolean HAS_HOVER_CONTENT_SUPPORT = Util.hasMethod(HoverEvent.class, "getContents", new Class[0]);
    private char colorChar = (char)38;
    private Set<Option> enabledOptions = EnumSet.of(Option.LEGACY_COLORS, Option.SIMPLE_FORMATTING, Option.ADVANCED_FORMATTING);
    private Set<Option> filteredOptions = EnumSet.noneOf(Option.class);
    private boolean lenient = false;
    private boolean backwardsCompatibility = true;
    private boolean urlDetection = true;
    private String urlHoverText = "Click to open url";
    private boolean autoAddUrlPrefix = true;
    private int hoverTextWidth = 60;
    public static final Pattern URL_PATTERN = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
    public static final String FONT_PREFIX = "font=";
    public static final String COLOR_PREFIX = "color=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String HOVER_PREFIX = "hover=";
    private ComponentBuilder builder;
    private StringBuilder value;
    private String font;
    private ChatColor color;
    private Set<ChatColor> format;
    private ClickEvent clickEvent;
    private HoverEvent hoverEvent;

    public MineDownParser() {
        this.reset();
    }

    public ComponentBuilder parse(String message) throws IllegalArgumentException {
        Matcher urlMatcher = this.urlDetection() ? URL_PATTERN.matcher(message) : null;
        boolean escaped = false;
        for (int i = 0; i < message.length(); ++i) {
            boolean isFormatting;
            int nextDefClose;
            int nextEventClose;
            char c = message.charAt(i);
            boolean isEscape = c == '\\' && i + 1 < message.length();
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < message.length() && (c == '\u00a7' || c == this.colorChar());
            boolean isEvent = false;
            if (this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[' && (nextEventClose = Util.indexOfNotEscaped(message, "](", i + 1)) != -1 && nextEventClose + 2 < message.length() && (nextDefClose = Util.indexOfNotEscaped(message, ")", i + 2)) != -1) {
                int depth = 1;
                isEvent = true;
                boolean innerEscaped = false;
                for (int j = i + 1; j < nextEventClose; ++j) {
                    if (innerEscaped) {
                        innerEscaped = false;
                    } else if (message.charAt(j) == '\\') {
                        innerEscaped = true;
                    } else if (message.charAt(j) == '[') {
                        ++depth;
                    } else if (message.charAt(j) == ']') {
                        --depth;
                    }
                    if (depth != 0) continue;
                    isEvent = false;
                    break;
                }
            }
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(message, i) && message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2) != -1;
            if (escaped) {
                escaped = false;
            } else {
                if (isEscape) {
                    escaped = true;
                    continue;
                }
                if (isColorCode) {
                    boolean isLegacyHex;
                    char code;
                    if ((code = message.charAt(++i)) >= 'A' && code <= 'Z') {
                        code = (char)(code + 32);
                    }
                    boolean bl2 = isLegacyHex = code == 'x';
                    if (isLegacyHex) {
                        i += 2;
                    }
                    ChatColor encoded = null;
                    Option filterOption = null;
                    StringBuilder colorString = new StringBuilder();
                    for (int j = i; j < message.length(); ++j) {
                        char c1 = message.charAt(j);
                        if (c1 == c) {
                            if (isLegacyHex) continue;
                            if (colorString.length() > 1) {
                                try {
                                    encoded = MineDownParser.parseColor(colorString.toString(), "", this.lenient(), this.backwardsCompatibility());
                                    filterOption = Option.SIMPLE_FORMATTING;
                                    i = j;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                                break;
                            }
                        }
                        if (!(isLegacyHex || c1 == '_' || c1 == '#' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z') && (c1 < '0' || c1 > '9')) break;
                        if (isLegacyHex && c1 == 'x') continue;
                        colorString.append(c1);
                        if (!isLegacyHex || colorString.length() != 6) continue;
                        try {
                            encoded = MineDownParser.parseColor("#" + colorString.toString(), "", this.lenient(), this.backwardsCompatibility());
                            filterOption = Option.LEGACY_COLORS;
                            i = j;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        break;
                    }
                    if (encoded == null && (encoded = ChatColor.getByChar((char)code)) != null) {
                        filterOption = Option.LEGACY_COLORS;
                    }
                    if (encoded != null) {
                        if (this.isFiltered(filterOption)) continue;
                        if (encoded == ChatColor.RESET) {
                            this.appendValue();
                            this.color = null;
                            Util.applyFormat(this.builder, this.format);
                            this.format = new HashSet<ChatColor>();
                            continue;
                        }
                        if (!Util.isFormat(encoded)) {
                            if (this.value.length() > 0) {
                                this.appendValue();
                            }
                            this.color = encoded;
                            this.format = new HashSet<ChatColor>();
                            continue;
                        }
                        if (this.value.length() > 0) {
                            this.appendValue();
                        }
                        this.format.add(encoded);
                        continue;
                    }
                    this.value.append(c).append(code);
                    continue;
                }
                if (isEvent) {
                    int index = Util.indexOfNotEscaped(message, "](", i + 1);
                    int endIndex = Util.indexOfNotEscaped(message, ")", index + 2);
                    this.appendValue();
                    if (!this.isFiltered(Option.ADVANCED_FORMATTING)) {
                        this.append(this.parseEvent(message.substring(i + 1, index), message.substring(index + 2, endIndex)));
                    } else {
                        this.append(this.copy(true).parse(message.substring(i + 1, index)));
                    }
                    i = endIndex;
                    continue;
                }
                if (isFormatting) {
                    int endIndex = message.indexOf(String.valueOf(c) + String.valueOf(c), i + 2);
                    HashSet<ChatColor> formats = new HashSet<ChatColor>(this.format);
                    if (!this.isFiltered(Option.SIMPLE_FORMATTING)) {
                        formats.add(MineDown.getFormatFromChar(c));
                    }
                    this.appendValue();
                    this.append(this.copy(true).format(formats).parse(message.substring(i + 2, endIndex)));
                    i = endIndex + 1;
                    continue;
                }
            }
            if (this.urlDetection() && urlMatcher != null) {
                int urlEnd = message.indexOf(32, i);
                if (urlEnd == -1) {
                    urlEnd = message.length();
                }
                if (urlMatcher.region(i, urlEnd).find()) {
                    this.appendValue();
                    this.value = new StringBuilder(message.substring(i, urlEnd));
                    this.appendValue();
                    i = urlEnd - 1;
                    continue;
                }
            }
            this.value.append(message.charAt(i));
        }
        if (escaped) {
            this.value.append('\\');
        }
        this.appendValue();
        if (this.builder == null) {
            this.builder = new ComponentBuilder("");
        }
        return this.builder;
    }

    private void append(ComponentBuilder builder) {
        this.append(builder.create());
    }

    private void append(BaseComponent[] components) {
        block7: {
            block8: {
                block6: {
                    if (this.builder != null) break block6;
                    if (components.length > 0) {
                        this.builder = new ComponentBuilder(components[0]);
                        for (int i = 1; i < components.length; ++i) {
                            this.builder.append(components[i]);
                        }
                    } else {
                        this.builder = new ComponentBuilder("");
                    }
                    break block7;
                }
                if (!HAS_APPEND_SUPPORT) break block8;
                this.builder.append(components);
                break block7;
            }
            if (components.length <= 0) break block7;
            try {
                Field fCurrent = this.builder.getClass().getDeclaredField("current");
                fCurrent.setAccessible(true);
                BaseComponent previous = (BaseComponent)fCurrent.get(this.builder);
                Field fParts = this.builder.getClass().getDeclaredField("parts");
                fParts.setAccessible(true);
                List parts = (List)fParts.get(this.builder);
                for (BaseComponent component : components) {
                    parts.add(previous);
                    fCurrent.set(this.builder, component.duplicate());
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void appendValue() {
        this.appendValue(ComponentBuilder.FormatRetention.NONE);
    }

    private void appendValue(ComponentBuilder.FormatRetention retention) {
        if (this.builder == null) {
            this.builder = new ComponentBuilder(this.value.toString());
        } else {
            this.builder.append(this.value.toString(), retention);
        }
        if (!this.backwardsCompatibility || HAS_FONT_SUPPORT) {
            this.builder.font(this.font);
        }
        this.builder.color(this.color);
        Util.applyFormat(this.builder, this.format);
        if (this.urlDetection() && URL_PATTERN.matcher(this.value).matches()) {
            String v = this.value.toString();
            if (!v.startsWith("http://") && !v.startsWith("https://")) {
                v = "http://" + v;
            }
            this.builder.event(new ClickEvent(ClickEvent.Action.OPEN_URL, v));
            if (this.urlHoverText() != null && !this.urlHoverText().isEmpty()) {
                this.builder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new MineDown(this.urlHoverText()).replace("url", this.value.toString()).toComponent()));
            }
        }
        if (this.clickEvent != null) {
            this.builder.event(this.clickEvent);
        }
        if (this.hoverEvent != null) {
            this.builder.event(this.hoverEvent);
        }
        this.value = new StringBuilder();
    }

    public ComponentBuilder parseEvent(String text, String definitions) {
        ArrayList<String> defParts = new ArrayList<String>();
        if (definitions.startsWith(" ")) {
            defParts.add("");
        }
        Collections.addAll(defParts, definitions.split(" "));
        if (definitions.endsWith(" ")) {
            defParts.add("");
        }
        String font = null;
        ChatColor color = null;
        HashSet<ChatColor> formats = new HashSet<ChatColor>();
        ClickEvent clickEvent = null;
        HoverEvent hoverEvent = null;
        int formatEnd = -1;
        for (int i = 0; i < defParts.size(); ++i) {
            int count;
            String id;
            String[] valueParts;
            HoverEvent.Action hoverAction;
            block45: {
                String definition = (String)defParts.get(i);
                ChatColor parsed = MineDownParser.parseColor(definition, "", true, this.backwardsCompatibility());
                if (parsed != null) {
                    if (Util.isFormat(parsed)) {
                        formats.add(parsed);
                    } else {
                        color = parsed;
                    }
                    formatEnd = i;
                    continue;
                }
                if (definition.toLowerCase(Locale.ROOT).startsWith(FONT_PREFIX)) {
                    font = definition.substring(FONT_PREFIX.length());
                }
                if (definition.toLowerCase(Locale.ROOT).startsWith(COLOR_PREFIX)) {
                    color = MineDownParser.parseColor(definition, COLOR_PREFIX, this.lenient(), this.backwardsCompatibility());
                    if (!this.lenient() && Util.isFormat(color)) {
                        throw new IllegalArgumentException(color + " is a format and not a color!");
                    }
                    formatEnd = i;
                    continue;
                }
                if (definition.toLowerCase(Locale.ROOT).startsWith(FORMAT_PREFIX)) {
                    for (String formatStr : definition.substring(FORMAT_PREFIX.length()).split(",")) {
                        ChatColor format = MineDownParser.parseColor(formatStr, "", this.lenient(), this.backwardsCompatibility());
                        if (!this.lenient() && !Util.isFormat(format)) {
                            throw new IllegalArgumentException(formats + " is a color and not a format!");
                        }
                        formats.add(format);
                    }
                    formatEnd = i;
                    continue;
                }
                if (i == formatEnd + 1 && URL_PATTERN.matcher(definition).matches()) {
                    if (!definition.startsWith("http://") && !definition.startsWith("https://")) {
                        definition = "http://" + definition;
                    }
                    clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, definition);
                    continue;
                }
                ClickEvent.Action clickAction = definition.startsWith("/") ? ClickEvent.Action.RUN_COMMAND : null;
                hoverAction = null;
                if (definition.toLowerCase(Locale.ROOT).startsWith(HOVER_PREFIX)) {
                    hoverAction = HoverEvent.Action.SHOW_TEXT;
                }
                String[] parts = definition.split("=", 2);
                try {
                    hoverAction = HoverEvent.Action.valueOf((String)parts[0].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException formatStr) {
                    // empty catch block
                }
                try {
                    clickAction = ClickEvent.Action.valueOf((String)parts[0].toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException formatStr) {
                    // empty catch block
                }
                int bracketDepth = parts.length > 1 && parts[1].startsWith("{") && (clickAction != null || hoverAction != null) ? 1 : 0;
                StringBuilder value = new StringBuilder();
                if (parts.length > 1 && clickAction != null || hoverAction != null) {
                    if (bracketDepth > 0) {
                        value.append(parts[1].substring(1));
                    } else {
                        value.append(parts[1]);
                    }
                } else {
                    value.append(definition);
                }
                ++i;
                while (i < defParts.size()) {
                    int equalsIndex;
                    String part = (String)defParts.get(i);
                    if (bracketDepth == 0 && (equalsIndex = part.indexOf(61)) > 0 && !Util.isEscaped(part, equalsIndex)) {
                        --i;
                        break;
                    }
                    value.append(" ");
                    if (bracketDepth > 0) {
                        int startBracketIndex = part.indexOf("={");
                        if (startBracketIndex > 0 && !Util.isEscaped(part, startBracketIndex) && !Util.isEscaped(part, startBracketIndex + 1)) {
                            ++bracketDepth;
                        }
                        if (part.endsWith("}") && !Util.isEscaped(part, part.length() - 1) && --bracketDepth == 0) {
                            value.append(part, 0, part.length() - 1);
                            break;
                        }
                    }
                    value.append(part);
                    ++i;
                }
                if (clickAction != null) {
                    String v = value.toString();
                    if (this.autoAddUrlPrefix() && clickAction == ClickEvent.Action.OPEN_URL && !v.startsWith("http://") && !v.startsWith("https://")) {
                        v = "http://" + v;
                    }
                    clickEvent = new ClickEvent(clickAction, v);
                } else if (hoverAction == null) {
                    hoverAction = HoverEvent.Action.SHOW_TEXT;
                }
                if (hoverAction == null) continue;
                String valueStr = value.toString();
                if (!HAS_HOVER_CONTENT_SUPPORT) {
                    hoverEvent = new HoverEvent(hoverAction, this.copy(false).urlDetection(false).parse(hoverAction == HoverEvent.Action.SHOW_TEXT ? Util.wrap(valueStr, this.hoverTextWidth()) : valueStr).create());
                    continue;
                }
                if (hoverAction == HoverEvent.Action.SHOW_TEXT) {
                    hoverEvent = new HoverEvent(hoverAction, new Content[]{new Text(this.copy(false).urlDetection(false).parse(Util.wrap(valueStr, this.hoverTextWidth())).create())});
                    continue;
                }
                if (hoverAction == HoverEvent.Action.SHOW_ENTITY) {
                    String[] valueParts2 = valueStr.split(":", 2);
                    try {
                        String[] additionalParts = valueParts2[1].split(" ", 2);
                        if (!additionalParts[0].contains(":")) {
                            additionalParts[0] = "minecraft:" + additionalParts[0];
                        }
                        hoverEvent = new HoverEvent(hoverAction, new Content[]{new Entity(additionalParts[0], valueParts2[0], additionalParts.length > 1 && additionalParts[1] != null ? new TextComponent(this.copy(false).urlDetection(false).parse(additionalParts[1]).create()) : null)});
                        continue;
                    }
                    catch (Exception e) {
                        if (this.lenient()) continue;
                        if (valueParts2.length < 2) {
                            throw new IllegalArgumentException("Invalid entity definition. Needs to be of format uuid:id or uuid:namespace:id!");
                        }
                        throw new IllegalArgumentException(e.getMessage());
                    }
                }
                if (hoverAction != HoverEvent.Action.SHOW_ITEM) continue;
                valueParts = valueStr.split(" ", 2);
                id = valueParts[0];
                if (!id.contains(":")) {
                    id = "minecraft:" + id;
                }
                count = 1;
                int countIndex = valueParts[0].indexOf(42);
                if (countIndex > 0 && countIndex + 1 < valueParts[0].length()) {
                    try {
                        count = Integer.parseInt(valueParts[0].substring(countIndex + 1));
                        id = valueParts[0].substring(0, countIndex);
                    }
                    catch (NumberFormatException e) {
                        if (this.lenient()) break block45;
                        throw new IllegalArgumentException(e.getMessage());
                    }
                }
            }
            ItemTag tag = null;
            if (valueParts.length > 1 && valueParts[1] != null) {
                tag = ItemTag.ofNbt((String)valueParts[1]);
            }
            hoverEvent = new HoverEvent(hoverAction, new Content[]{new Item(id, count, tag)});
        }
        if (clickEvent != null && hoverEvent == null) {
            hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(clickEvent.getAction().toString().toLowerCase(Locale.ROOT).replace('_', ' ')).color(ChatColor.BLUE).append(" " + clickEvent.getValue()).color(ChatColor.WHITE).create());
        }
        return this.copy().urlDetection(false).font(font).color(color).format(formats).clickEvent(clickEvent).hoverEvent(hoverEvent).parse(text);
    }

    protected ComponentBuilder builder() {
        return this.builder;
    }

    protected MineDownParser builder(ComponentBuilder builder) {
        this.builder = builder;
        return this;
    }

    protected MineDownParser value(StringBuilder value) {
        this.value = value;
        return this;
    }

    protected StringBuilder value() {
        return this.value;
    }

    private MineDownParser font(String font) {
        this.font = font;
        return this;
    }

    protected String font() {
        return this.font;
    }

    protected MineDownParser color(ChatColor color) {
        this.color = color;
        return this;
    }

    protected ChatColor color() {
        return this.color;
    }

    protected MineDownParser format(Set<ChatColor> format) {
        this.format = format;
        return this;
    }

    protected Set<ChatColor> format() {
        return this.format;
    }

    protected MineDownParser clickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
        return this;
    }

    protected ClickEvent clickEvent() {
        return this.clickEvent;
    }

    protected MineDownParser hoverEvent(HoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
        return this;
    }

    protected HoverEvent hoverEvent() {
        return this.hoverEvent;
    }

    @Deprecated
    public static ChatColor parseColor(String colorString, String prefix, boolean lenient) {
        return MineDownParser.parseColor(colorString, prefix, lenient, true);
    }

    private static ChatColor parseColor(String colorString, String prefix, boolean lenient, boolean backwardsCompatibility) {
        ChatColor color;
        block9: {
            color = null;
            if (prefix.length() + 1 == colorString.length()) {
                color = ChatColor.getByChar((char)colorString.charAt(prefix.length()));
                if (color == null && !lenient) {
                    throw new IllegalArgumentException(colorString.charAt(prefix.length()) + " is not a valid " + prefix + " char!");
                }
            } else {
                try {
                    colorString = colorString.substring(prefix.length());
                    if (colorString.charAt(0) == '#') {
                        if (colorString.length() == 4) {
                            StringBuilder sb = new StringBuilder("#");
                            for (int i = 1; i < 4; ++i) {
                                sb.append(colorString.charAt(i)).append(colorString.charAt(i));
                            }
                            colorString = sb.toString();
                        }
                        color = !backwardsCompatibility || HAS_RGB_SUPPORT ? ChatColor.of((String)colorString) : Util.getClosestLegacy(new Color(Integer.parseInt(colorString.substring(1), 16)));
                    } else {
                        color = ChatColor.valueOf((String)colorString.toUpperCase(Locale.ROOT));
                    }
                }
                catch (IllegalArgumentException e) {
                    if (lenient) break block9;
                    throw e;
                }
            }
        }
        return color;
    }

    public MineDownParser copy() {
        return this.copy(false);
    }

    public MineDownParser copy(boolean formatting) {
        return new MineDownParser().copy(this, formatting);
    }

    public MineDownParser copy(MineDownParser from) {
        return this.copy(from, false);
    }

    public MineDownParser copy(MineDownParser from, boolean formatting) {
        this.lenient(from.lenient());
        this.urlDetection(from.urlDetection());
        this.urlHoverText(from.urlHoverText());
        this.autoAddUrlPrefix(from.autoAddUrlPrefix());
        this.hoverTextWidth(from.hoverTextWidth());
        this.enabledOptions(from.enabledOptions());
        this.filteredOptions(from.filteredOptions());
        this.colorChar(from.colorChar());
        if (formatting) {
            this.format(from.format());
            this.color(from.color());
            this.font(from.font());
            this.clickEvent(from.clickEvent());
            this.hoverEvent(from.hoverEvent());
        }
        return this;
    }

    public MineDownParser reset() {
        this.builder = null;
        this.value = new StringBuilder();
        this.font = null;
        this.color = null;
        this.format = new HashSet<ChatColor>();
        this.clickEvent = null;
        this.hoverEvent = null;
        return this;
    }

    @Deprecated
    public boolean translateLegacyColors() {
        return this.isEnabled(Option.LEGACY_COLORS);
    }

    @Deprecated
    public MineDownParser translateLegacyColors(boolean enabled) {
        return enabled ? this.enable(Option.LEGACY_COLORS) : this.disable(Option.LEGACY_COLORS);
    }

    public boolean isEnabled(Option option) {
        return this.enabledOptions().contains((Object)option);
    }

    public MineDownParser enable(Option option) {
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser disable(Option option) {
        this.enabledOptions().remove((Object)option);
        return this;
    }

    public boolean isFiltered(Option option) {
        return this.filteredOptions().contains((Object)option);
    }

    public MineDownParser filter(Option option) {
        this.filteredOptions().add(option);
        this.enabledOptions().add(option);
        return this;
    }

    public MineDownParser unfilter(Option option) {
        this.filteredOptions().remove((Object)option);
        return this;
    }

    public String escape(String string) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean isFormatting;
            char c = string.charAt(i);
            boolean isEscape = c == '\\';
            boolean isColorCode = this.isEnabled(Option.LEGACY_COLORS) && i + 1 < string.length() && (c == '\u00a7' || c == this.colorChar());
            boolean isEvent = this.isEnabled(Option.ADVANCED_FORMATTING) && c == '[';
            boolean bl = isFormatting = this.isEnabled(Option.SIMPLE_FORMATTING) && (c == '_' || c == '*' || c == '~' || c == '?' || c == '#') && Util.isDouble(string, i);
            if (isEscape || isColorCode || isEvent || isFormatting) {
                value.append('\\');
            }
            value.append(c);
        }
        return value.toString();
    }

    public char colorChar() {
        return this.colorChar;
    }

    public MineDownParser colorChar(char colorChar) {
        this.colorChar = colorChar;
        return this;
    }

    public Set<Option> enabledOptions() {
        return this.enabledOptions;
    }

    public MineDownParser enabledOptions(Set<Option> enabledOptions) {
        this.enabledOptions = enabledOptions;
        return this;
    }

    public Set<Option> filteredOptions() {
        return this.filteredOptions;
    }

    public MineDownParser filteredOptions(Set<Option> filteredOptions) {
        this.filteredOptions = filteredOptions;
        return this;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public MineDownParser lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean backwardsCompatibility() {
        return this.backwardsCompatibility;
    }

    public MineDownParser backwardsCompatibility(boolean backwardsCompatibility) {
        this.backwardsCompatibility = backwardsCompatibility;
        return this;
    }

    public boolean urlDetection() {
        return this.urlDetection;
    }

    public MineDownParser urlDetection(boolean urlDetection) {
        this.urlDetection = urlDetection;
        return this;
    }

    public String urlHoverText() {
        return this.urlHoverText;
    }

    public MineDownParser urlHoverText(String urlHoverText) {
        this.urlHoverText = urlHoverText;
        return this;
    }

    public boolean autoAddUrlPrefix() {
        return this.autoAddUrlPrefix;
    }

    public MineDownParser autoAddUrlPrefix(boolean autoAddUrlPrefix) {
        this.autoAddUrlPrefix = autoAddUrlPrefix;
        return this;
    }

    public int hoverTextWidth() {
        return this.hoverTextWidth;
    }

    public MineDownParser hoverTextWidth(int hoverTextWidth) {
        this.hoverTextWidth = hoverTextWidth;
        return this;
    }

    public static enum Option {
        SIMPLE_FORMATTING,
        ADVANCED_FORMATTING,
        LEGACY_COLORS;

    }
}

