/*
 * Decompiled with CFR 0.152.
 */
package win.korowin.client;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_426;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_7842;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import win.korowin.gui.LanguageEntry;
import win.korowin.gui.LanguageListWidget;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_426.class})
public abstract class LanguageOptionsScreenMixin
extends class_4667 {
    @Unique
    private LanguageListWidget languageList;
    @Unique
    private class_342 searchBox;
    @Unique
    private final Map<String, LanguageEntry> languageEntries = new LinkedHashMap<String, LanguageEntry>();
    @Unique
    private String selectedLanguageCode = null;

    LanguageOptionsScreenMixin(class_437 parent, class_315 options, class_2561 title) {
        super(parent, options, title);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onConstructed(class_437 parent, class_315 options, class_1076 languageManager, CallbackInfo ci) {
        languageManager.method_4665().forEach((code, language) -> this.languageEntries.put((String)code, new LanguageEntry((String)code, (class_1077)language)));
        this.field_49503.method_48995(48);
        this.field_49503.method_48991(53);
    }

    @Inject(method={"initBody"}, at={@At(value="HEAD")}, cancellable=true)
    void onInitBody(CallbackInfo ci) {
        int listWidth = Math.min(this.field_22789 - 40, 300);
        this.languageList = new LanguageListWidget(this.field_22787, this.it(), listWidth, this.field_22790, (class_2561)class_2561.method_43471((String)"options.language"));
        this.languageList.method_46421((this.field_22789 - listWidth) / 2);
        this.field_49503.method_48999((class_8021)this.languageList);
        this.refresh();
        ci.cancel();
    }

    protected void method_57732() {
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, 22, 200, 20, this.searchBox, (class_2561)class_2561.method_43473());
        String currentLanguage = this.field_22787.method_1526().method_4669();
        String placeholderText = "ru_ru".equals(currentLanguage) ? "\u041f\u043e\u0438\u0441\u043a \u044f\u0437\u044b\u043a\u043e\u0432..." : "Search languages...";
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)placeholderText));
        this.searchBox.method_1863(__ -> this.refresh());
        class_8667 header = (class_8667)this.field_49503.method_48992((class_8021)class_8667.method_52741().method_52735(8));
        header.method_52740().method_46467();
        header.method_52736((class_8021)new class_7842(this.field_22785, this.field_22793));
        header.method_52736((class_8021)this.searchBox);
    }

    @Inject(method={"refreshWidgetPositions"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onRefreshWidgetPositions(CallbackInfo ci) {
        super.method_48640();
        int listWidth = Math.min(this.field_22789 - 40, 300);
        this.languageList.method_57712(listWidth, this.field_49503);
        this.languageList.method_46421((this.field_22789 - listWidth) / 2);
        this.languageList.updateScroll();
        ci.cancel();
    }

    @Unique
    private void refresh() {
        this.languageList.method_25396().clear();
        String searchText = this.searchBox != null ? this.searchBox.method_1882().toLowerCase() : "";
        for (Map.Entry<String, LanguageEntry> entry : this.languageEntries.entrySet()) {
            String languageCode = entry.getKey();
            LanguageEntry languageEntry = entry.getValue();
            if (!searchText.isEmpty() && !languageEntry.getLanguage().method_48303().getString().toLowerCase().contains(searchText) && !languageCode.toLowerCase().contains(searchText)) continue;
            this.languageList.method_25396().add(languageEntry);
            languageEntry.setParent(this.languageList);
        }
        this.languageList.updateScroll();
    }

    protected void method_56131() {
        if (this.searchBox != null) {
            this.method_48265((class_364)this.searchBox);
        } else {
            super.method_56131();
        }
    }

    @Inject(method={"onDone"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDone(CallbackInfo ci) {
        if (this.field_22787 == null) {
            return;
        }
        if (this.selectedLanguageCode != null) {
            this.field_22787.method_1526().method_4667(this.selectedLanguageCode);
            this.field_22787.field_1690.field_1883 = this.selectedLanguageCode;
            this.field_22787.field_1690.method_1640();
            this.field_22787.method_1521();
        }
        this.field_22787.method_1507(this.field_21335);
        ci.cancel();
    }

    @Unique
    public void setSelectedLanguage(String languageCode) {
        this.selectedLanguageCode = languageCode;
    }

    @Unique
    private class_426 it() {
        return (class_426)this;
    }
}

