/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.end_reborn.datagen;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.legacy.end_reborn.ERConstants;
import net.legacy.end_reborn.registry.ERBlocks;
import net.legacy.end_reborn.registry.EREquipmentAssets;
import net.legacy.end_reborn.registry.EREquipmentItems;
import net.legacy.end_reborn.registry.ERItems;
import net.legacy.end_reborn.registry.ERTrimMaterials;
import net.minecraft.class_10191;
import net.minecraft.class_10394;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ERModelProvider
extends FabricModelProvider {
    private static final List<class_4915.class_8072> TRIM_MATERIALS = List.of(new class_4915.class_8072("remnant_ingot", ERTrimMaterials.REMNANT, Map.of()), new class_4915.class_8072("featherzeal_ingot", ERTrimMaterials.FEATHERZEAL, Map.of()), new class_4915.class_8072("crystalline_shard", ERTrimMaterials.CRYSTALLINE, Map.of()));
    private static final List<class_4915.class_8072> TRIM_MATERIALS_REMNANT_ONLY = List.of(new class_4915.class_8072("remnant_ingot", ERTrimMaterials.REMNANT, Map.of()));
    private static final List<class_4915.class_8072> TRIM_MATERIALS_NOT_REMNANT = List.of(new class_4915.class_8072("featherzeal_ingot", ERTrimMaterials.FEATHERZEAL, Map.of()), new class_4915.class_8072("crystalline_shard", ERTrimMaterials.CRYSTALLINE, Map.of()));
    private static final List<class_4915.class_8072> TRIM_MATERIALS_FEATHERZEAL_ONLY = List.of(new class_4915.class_8072("featherzeal_ingot", ERTrimMaterials.FEATHERZEAL, Map.of()));
    private static final List<class_4915.class_8072> TRIM_MATERIALS_NOT_FEATHERZEAL = List.of(new class_4915.class_8072("remnant_ingot", ERTrimMaterials.FEATHERZEAL, Map.of()), new class_4915.class_8072("crystalline_shard", ERTrimMaterials.CRYSTALLINE, Map.of()));
    public static final List<Pair<class_2746, Function<class_2960, class_4935>>> MULTIFACE_GENERATOR_NO_UV_LOCK = List.of(Pair.of((Object)class_2741.field_12489, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model)), Pair.of((Object)class_2741.field_12487, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)), Pair.of((Object)class_2741.field_12540, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)), Pair.of((Object)class_2741.field_12527, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)), Pair.of((Object)class_2741.field_12519, model -> class_4935.method_25824().method_25828(class_4936.field_22887, model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893)), Pair.of((Object)class_2741.field_12546, resourceLocation -> class_4935.method_25824().method_25828(class_4936.field_22887, resourceLocation).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)));

    public ERModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(@NotNull class_4910 generator) {
        generator.method_25641(ERBlocks.REMNANT_BLOCK);
        generator.method_25641(ERBlocks.FORGOTTEN_REMAINS);
        generator.method_25641(ERBlocks.FEATHERZEAL_BLOCK);
        generator.method_25641(ERBlocks.TIMELOST_FRAGMENTS);
        generator.method_25641(ERBlocks.CRYSTALLINE_LAMP);
        generator.method_25641(ERBlocks.CRYSTALLINE_BLOCK);
        generator.method_25641(ERBlocks.END_IRON_ORE);
        generator.method_25641(ERBlocks.MIRESTONE_IRON_ORE);
        generator.method_25641(ERBlocks.RAW_CRYSTALLINE_BLOCK);
        generator.method_25658(ERBlocks.CHORUS_DOOR);
        generator.method_25671(ERBlocks.CHORUS_TRAPDOOR);
        generator.method_25706(ERBlocks.CRYSTALLINE_LANTERN);
        generator.method_25641(ERBlocks.PURPUR);
        generator.method_25641(ERBlocks.AMETRUR);
        generator.method_25554(ERBlocks.CUT_AMETRUR_PILLAR, class_4946.field_23055, class_4946.field_23056);
        class_4910.class_4912 ametrurFamily = generator.method_25650(ERBlocks.CUT_AMETRUR);
        ametrurFamily.method_33522(ERBlocks.FAMILY_AMETRUR);
        class_4910.class_4912 chorusFamily = generator.method_25650(ERBlocks.CHORUS_PLANKS);
        chorusFamily.field_47134.add(ERBlocks.CHORUS_DOOR);
        chorusFamily.field_47134.add(ERBlocks.CHORUS_TRAPDOOR);
        chorusFamily.method_33522(ERBlocks.FAMILY_CHORUS);
        generator.method_25676(ERBlocks.CHORUS_BLOCK).method_25730(ERBlocks.CHORUS_BLOCK);
        generator.method_25676(ERBlocks.STRIPPED_CHORUS_BLOCK).method_25730(ERBlocks.STRIPPED_CHORUS_BLOCK);
        generator.method_46190(ERBlocks.STRIPPED_CHORUS_BLOCK, (class_2248)ERBlocks.CHORUS_HANGING_SIGN, (class_2248)ERBlocks.CHORUS_WALL_HANGING_SIGN);
        class_4910.class_4912 chorusMosaicFamily = generator.method_25650(ERBlocks.CHORUS_MOSAIC);
        chorusMosaicFamily.method_33522(ERBlocks.FAMILY_CHORUS_MOSAIC);
    }

    public void generateItemModels(@NotNull class_4915 generator) {
        generator.method_65429(ERItems.REMNANT_HELMET, EREquipmentAssets.REMNANT, "helmet", false);
        generator.method_65429(ERItems.REMNANT_CHESTPLATE, EREquipmentAssets.REMNANT, "chestplate", false);
        generator.method_65429(ERItems.REMNANT_LEGGINGS, EREquipmentAssets.REMNANT, "leggings", false);
        generator.method_65429(ERItems.REMNANT_BOOTS, EREquipmentAssets.REMNANT, "boots", false);
        generator.method_65429(ERItems.FEATHERZEAL_HELMET, EREquipmentAssets.FEATHERZEAL, "helmet", false);
        generator.method_65429(ERItems.FEATHERZEAL_CHESTPLATE, EREquipmentAssets.FEATHERZEAL, "chestplate", false);
        generator.method_65429(ERItems.FEATHERZEAL_LEGGINGS, EREquipmentAssets.FEATHERZEAL, "leggings", false);
        generator.method_65429(ERItems.FEATHERZEAL_BOOTS, EREquipmentAssets.FEATHERZEAL, "boots", false);
        generator.method_65442((class_1792)ERItems.CHORUS_RAFT, class_4943.field_22938);
        generator.method_65442((class_1792)ERItems.CHORUS_CHEST_RAFT, class_4943.field_22938);
        generator.method_65442(ERItems.CHORUS_SPINE, class_4943.field_22938);
        generator.method_65442(ERItems.CRYSTALLINE_SHARD, class_4943.field_22938);
        generator.method_65442(ERItems.REMNANT_INGOT, class_4943.field_22938);
        generator.method_65442(ERItems.REMNANT_SCRAP, class_4943.field_22938);
        generator.method_65442((class_1792)ERItems.REMNANT_UPGRADE_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_65442(ERItems.FEATHERZEAL_INGOT, class_4943.field_22938);
        generator.method_65442(ERItems.FEATHERZEAL_SCRAP, class_4943.field_22938);
        generator.method_65442((class_1792)ERItems.FEATHERZEAL_UPGRADE_SMITHING_TEMPLATE, class_4943.field_22938);
        generator.method_65442((class_1792)EREquipmentItems.REMNANT_SWORD, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.REMNANT_AXE, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.REMNANT_PICKAXE, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.REMNANT_SHOVEL, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.REMNANT_HOE, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.FEATHERZEAL_SWORD, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.FEATHERZEAL_AXE, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.FEATHERZEAL_PICKAXE, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.FEATHERZEAL_SHOVEL, class_4943.field_22939);
        generator.method_65442((class_1792)EREquipmentItems.FEATHERZEAL_HOE, class_4943.field_22939);
        generator.method_65442(ERItems.REMNANT_HORSE_ARMOR, class_4943.field_22938);
        generator.method_65442(ERItems.FEATHERZEAL_HORSE_ARMOR, class_4943.field_22938);
        this.registerArmorTrims(generator, class_1802.field_8090, (class_5321<class_10394>)class_10191.field_54139, "helmet", false);
        this.registerArmorTrims(generator, class_1802.field_8267, (class_5321<class_10394>)class_10191.field_54134, "helmet", true);
        this.registerArmorTrims(generator, class_1802.field_8577, (class_5321<class_10394>)class_10191.field_54134, "chestplate", true);
        this.registerArmorTrims(generator, class_1802.field_8570, (class_5321<class_10394>)class_10191.field_54134, "leggings", true);
        this.registerArmorTrims(generator, class_1802.field_8370, (class_5321<class_10394>)class_10191.field_54134, "boots", true);
        this.registerArmorTrims(generator, class_1802.field_8283, (class_5321<class_10394>)class_10191.field_54135, "helmet", false);
        this.registerArmorTrims(generator, class_1802.field_8873, (class_5321<class_10394>)class_10191.field_54135, "chestplate", false);
        this.registerArmorTrims(generator, class_1802.field_8218, (class_5321<class_10394>)class_10191.field_54135, "leggings", false);
        this.registerArmorTrims(generator, class_1802.field_8313, (class_5321<class_10394>)class_10191.field_54135, "boots", false);
        this.registerArmorTrims(generator, class_1802.field_8743, (class_5321<class_10394>)class_10191.field_54136, "helmet", false);
        this.registerArmorTrims(generator, class_1802.field_8523, (class_5321<class_10394>)class_10191.field_54136, "chestplate", false);
        this.registerArmorTrims(generator, class_1802.field_8396, (class_5321<class_10394>)class_10191.field_54136, "leggings", false);
        this.registerArmorTrims(generator, class_1802.field_8660, (class_5321<class_10394>)class_10191.field_54136, "boots", false);
        this.registerArmorTrims(generator, class_1802.field_8805, (class_5321<class_10394>)class_10191.field_54138, "helmet", false);
        this.registerArmorTrims(generator, class_1802.field_8058, (class_5321<class_10394>)class_10191.field_54138, "chestplate", false);
        this.registerArmorTrims(generator, class_1802.field_8348, (class_5321<class_10394>)class_10191.field_54138, "leggings", false);
        this.registerArmorTrims(generator, class_1802.field_8285, (class_5321<class_10394>)class_10191.field_54138, "boots", false);
        this.registerArmorTrims(generator, class_1802.field_8862, (class_5321<class_10394>)class_10191.field_54137, "helmet", false);
        this.registerArmorTrims(generator, class_1802.field_8678, (class_5321<class_10394>)class_10191.field_54137, "chestplate", false);
        this.registerArmorTrims(generator, class_1802.field_8416, (class_5321<class_10394>)class_10191.field_54137, "leggings", false);
        this.registerArmorTrims(generator, class_1802.field_8753, (class_5321<class_10394>)class_10191.field_54137, "boots", false);
        this.registerArmorTrims(generator, class_1802.field_22027, (class_5321<class_10394>)class_10191.field_54140, "helmet", false);
        this.registerArmorTrims(generator, class_1802.field_22028, (class_5321<class_10394>)class_10191.field_54140, "chestplate", false);
        this.registerArmorTrims(generator, class_1802.field_22029, (class_5321<class_10394>)class_10191.field_54140, "leggings", false);
        this.registerArmorTrims(generator, class_1802.field_22030, (class_5321<class_10394>)class_10191.field_54140, "boots", false);
        this.registerArmorTrimsRemnantDarker(generator, ERItems.REMNANT_HELMET, EREquipmentAssets.REMNANT, "helmet", false);
        this.registerArmorTrimsRemnantDarker(generator, ERItems.REMNANT_CHESTPLATE, EREquipmentAssets.REMNANT, "chestplate", false);
        this.registerArmorTrimsRemnantDarker(generator, ERItems.REMNANT_LEGGINGS, EREquipmentAssets.REMNANT, "leggings", false);
        this.registerArmorTrimsRemnantDarker(generator, ERItems.REMNANT_BOOTS, EREquipmentAssets.REMNANT, "boots", false);
        this.registerArmorTrimsNotRemnant(generator, ERItems.REMNANT_HELMET, EREquipmentAssets.REMNANT, "helmet", false);
        this.registerArmorTrimsNotRemnant(generator, ERItems.REMNANT_CHESTPLATE, EREquipmentAssets.REMNANT, "chestplate", false);
        this.registerArmorTrimsNotRemnant(generator, ERItems.REMNANT_LEGGINGS, EREquipmentAssets.REMNANT, "leggings", false);
        this.registerArmorTrimsNotRemnant(generator, ERItems.REMNANT_BOOTS, EREquipmentAssets.REMNANT, "boots", false);
        this.registerArmorTrimsFeatherzealDarker(generator, ERItems.FEATHERZEAL_HELMET, EREquipmentAssets.FEATHERZEAL, "helmet", false);
        this.registerArmorTrimsFeatherzealDarker(generator, ERItems.FEATHERZEAL_CHESTPLATE, EREquipmentAssets.FEATHERZEAL, "chestplate", false);
        this.registerArmorTrimsFeatherzealDarker(generator, ERItems.FEATHERZEAL_LEGGINGS, EREquipmentAssets.FEATHERZEAL, "leggings", false);
        this.registerArmorTrimsFeatherzealDarker(generator, ERItems.FEATHERZEAL_BOOTS, EREquipmentAssets.FEATHERZEAL, "boots", false);
        this.registerArmorTrimsNotFeatherzeal(generator, ERItems.FEATHERZEAL_HELMET, EREquipmentAssets.FEATHERZEAL, "helmet", false);
        this.registerArmorTrimsNotFeatherzeal(generator, ERItems.FEATHERZEAL_CHESTPLATE, EREquipmentAssets.FEATHERZEAL, "chestplate", false);
        this.registerArmorTrimsNotFeatherzeal(generator, ERItems.FEATHERZEAL_LEGGINGS, EREquipmentAssets.FEATHERZEAL, "leggings", false);
        this.registerArmorTrimsNotFeatherzeal(generator, ERItems.FEATHERZEAL_BOOTS, EREquipmentAssets.FEATHERZEAL, "boots", false);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    private static class_4942 createItem(String string, class_4945 ... textureSlots) {
        return new class_4942(Optional.of(ERConstants.id("item/" + string)), Optional.empty(), textureSlots);
    }

    private void uploadArmor2(class_4915 generator, class_2960 id, class_2960 layer0, class_2960 layer1) {
        class_4943.field_42232.method_25852(id, class_4944.method_48529((class_2960)layer0, (class_2960)layer1), generator.field_55246);
    }

    private void uploadArmor3(class_4915 generator, class_2960 id, class_2960 layer0, class_2960 layer1, class_2960 layer2) {
        class_4943.field_42233.method_25852(id, class_4944.method_48745((class_2960)layer0, (class_2960)layer1, (class_2960)layer2), generator.field_55246);
    }

    private void registerArmorTrims(class_4915 generator, class_1792 armor, class_5321<class_10394> equipmentKey, String armorType, boolean dyeable) {
        class_2960 armorModelId = class_4944.method_25876((class_1792)armor);
        class_2960 armorTextures = class_4944.method_25876((class_1792)armor);
        class_2960 armorOverlayTextures = class_4944.method_25863((class_1792)armor, (String)"_overlay");
        for (class_4915.class_8072 trimMaterial : TRIM_MATERIALS) {
            class_2960 trimmedModelId = class_2960.method_60655((String)"end_reborn", (String)armorModelId.method_12832()).method_48331("_" + trimMaterial.comp_1219() + "_trim");
            class_2960 trimTextureId = class_2960.method_60656((String)("trims/items/" + armorType + "_trim_" + trimMaterial.method_65458(equipmentKey)));
            if (dyeable) {
                this.uploadArmor3(generator, trimmedModelId, armorTextures, armorOverlayTextures, trimTextureId);
                continue;
            }
            this.uploadArmor2(generator, trimmedModelId, armorTextures, trimTextureId);
        }
    }

    private void registerArmorTrimsRemnantDarker(class_4915 generator, class_1792 armor, class_5321<class_10394> equipmentKey, String armorType, boolean dyeable) {
        class_2960 armorModelId = class_4944.method_25876((class_1792)armor);
        class_2960 armorTextures = class_4944.method_25876((class_1792)armor);
        class_2960 armorOverlayTextures = class_4944.method_25863((class_1792)armor, (String)"_overlay");
        for (class_4915.class_8072 trimMaterial : TRIM_MATERIALS_REMNANT_ONLY) {
            class_2960 trimmedModelId = class_2960.method_60655((String)"end_reborn", (String)armorModelId.method_12832()).method_48331("_" + trimMaterial.comp_1219() + "_trim");
            class_2960 trimTextureId = class_2960.method_60656((String)("trims/items/" + armorType + "_trim_" + trimMaterial.method_65458(equipmentKey) + "_darker"));
            if (dyeable) {
                this.uploadArmor3(generator, trimmedModelId, armorTextures, armorOverlayTextures, trimTextureId);
                continue;
            }
            this.uploadArmor2(generator, trimmedModelId, armorTextures, trimTextureId);
        }
    }

    private void registerArmorTrimsNotRemnant(class_4915 generator, class_1792 armor, class_5321<class_10394> equipmentKey, String armorType, boolean dyeable) {
        class_2960 armorModelId = class_4944.method_25876((class_1792)armor);
        class_2960 armorTextures = class_4944.method_25876((class_1792)armor);
        class_2960 armorOverlayTextures = class_4944.method_25863((class_1792)armor, (String)"_overlay");
        for (class_4915.class_8072 trimMaterial : TRIM_MATERIALS_NOT_REMNANT) {
            class_2960 trimmedModelId = class_2960.method_60655((String)"end_reborn", (String)armorModelId.method_12832()).method_48331("_" + trimMaterial.comp_1219() + "_trim");
            class_2960 trimTextureId = class_2960.method_60656((String)("trims/items/" + armorType + "_trim_" + trimMaterial.method_65458(equipmentKey)));
            if (dyeable) {
                this.uploadArmor3(generator, trimmedModelId, armorTextures, armorOverlayTextures, trimTextureId);
                continue;
            }
            this.uploadArmor2(generator, trimmedModelId, armorTextures, trimTextureId);
        }
    }

    private void registerArmorTrimsFeatherzealDarker(class_4915 generator, class_1792 armor, class_5321<class_10394> equipmentKey, String armorType, boolean dyeable) {
        class_2960 armorModelId = class_4944.method_25876((class_1792)armor);
        class_2960 armorTextures = class_4944.method_25876((class_1792)armor);
        class_2960 armorOverlayTextures = class_4944.method_25863((class_1792)armor, (String)"_overlay");
        for (class_4915.class_8072 trimMaterial : TRIM_MATERIALS_FEATHERZEAL_ONLY) {
            class_2960 trimmedModelId = class_2960.method_60655((String)"end_reborn", (String)armorModelId.method_12832()).method_48331("_" + trimMaterial.comp_1219() + "_trim");
            class_2960 trimTextureId = class_2960.method_60656((String)("trims/items/" + armorType + "_trim_" + trimMaterial.method_65458(equipmentKey) + "_darker"));
            if (dyeable) {
                this.uploadArmor3(generator, trimmedModelId, armorTextures, armorOverlayTextures, trimTextureId);
                continue;
            }
            this.uploadArmor2(generator, trimmedModelId, armorTextures, trimTextureId);
        }
    }

    private void registerArmorTrimsNotFeatherzeal(class_4915 generator, class_1792 armor, class_5321<class_10394> equipmentKey, String armorType, boolean dyeable) {
        class_2960 armorModelId = class_4944.method_25876((class_1792)armor);
        class_2960 armorTextures = class_4944.method_25876((class_1792)armor);
        class_2960 armorOverlayTextures = class_4944.method_25863((class_1792)armor, (String)"_overlay");
        for (class_4915.class_8072 trimMaterial : TRIM_MATERIALS_NOT_FEATHERZEAL) {
            class_2960 trimmedModelId = class_2960.method_60655((String)"end_reborn", (String)armorModelId.method_12832()).method_48331("_" + trimMaterial.comp_1219() + "_trim");
            class_2960 trimTextureId = class_2960.method_60656((String)("trims/items/" + armorType + "_trim_" + trimMaterial.method_65458(equipmentKey)));
            if (dyeable) {
                this.uploadArmor3(generator, trimmedModelId, armorTextures, armorOverlayTextures, trimTextureId);
                continue;
            }
            this.uploadArmor2(generator, trimmedModelId, armorTextures, trimTextureId);
        }
    }
}

