/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.end_reborn.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.legacy.end_reborn.ERConstants;
import net.legacy.end_reborn.registry.ERTrimMaterials;
import net.minecraft.class_2960;
import net.ramixin.mixson.inline.EventContext;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.MixsonEvent;
import net.ramixin.mixson.inline.ResourceReference;

public final class ERTrimItemModels {
    private static final List<String> ARMORS = List.of("helmet", "chestplate", "leggings", "boots");
    private static final List<String> ARMOR_MATERIALS = List.of("leather", "chainmail", "iron", "golden", "diamond", "netherite");

    private ERTrimItemModels() {
    }

    public static void init() {
        ARMORS.forEach(armor -> ARMOR_MATERIALS.forEach(armorMaterial -> ERTrimItemModels.registerAddTrimsToArmor(armor, armorMaterial)));
        ERTrimItemModels.registerAddTrimsToArmor("helmet", "turtle");
        ERTrimItemModels.registerAddTrimsToAtlas("armor_trims");
        ERTrimItemModels.registerAddTrimsToAtlas("blocks");
    }

    private static void registerAddTrimsToArmor(final String armor, final String armorMaterial) {
        Mixson.registerEvent((int)1000, (String)("minecraft:items/" + armorMaterial + "_" + armor), (String)("end_reborn:add_trims_to_" + armorMaterial + "_" + armor), (MixsonEvent)new MixsonEvent<JsonElement>(){

            public void runEvent(EventContext<JsonElement> context) {
                JsonElement elem = (JsonElement)context.getFile();
                JsonObject root = elem.getAsJsonObject();
                JsonObject model = root.getAsJsonObject("model");
                JsonArray cases = model.getAsJsonArray("cases");
                JsonObject case0 = cases.get(0).getAsJsonObject();
                ERTrimMaterials.TRIM_MATERIALS.forEach(trim -> {
                    JsonObject newCase = case0.deepCopy();
                    newCase.addProperty("when", ERTrimItemModels.trimMaterialId(trim).toString());
                    newCase.getAsJsonObject("model").addProperty("model", ERTrimItemModels.itemModelId(armor, armorMaterial, trim).toString());
                    cases.add((JsonElement)newCase);
                });
            }

            public int ordinal() {
                return 0;
            }
        }, (boolean)false, (ResourceReference[])new ResourceReference[0]);
    }

    private static void registerAddTrimsToAtlas(String name) {
        Mixson.registerEvent((int)1000, (String)("minecraft:atlases/" + name), (String)("end_reborn:add_trims_to_" + name + "_atlas"), (MixsonEvent)new MixsonEvent<JsonElement>(){

            public void runEvent(EventContext<JsonElement> context) {
                JsonElement elem = (JsonElement)context.getFile();
                JsonObject root = elem.getAsJsonObject();
                JsonArray sources = root.getAsJsonArray("sources");
                for (int i = 0; i < sources.size(); ++i) {
                    JsonObject source = sources.get(i).getAsJsonObject();
                    if (!"minecraft:paletted_permutations".equals(source.getAsJsonPrimitive("type").getAsString())) continue;
                    JsonObject permutations = source.getAsJsonObject("permutations");
                    ERTrimMaterials.TRIM_MATERIALS.forEach(trim -> permutations.addProperty(trim, ERTrimItemModels.paletteId(trim).toString()));
                    break;
                }
            }

            public int ordinal() {
                return 0;
            }
        }, (boolean)false, (ResourceReference[])new ResourceReference[0]);
    }

    private static class_2960 trimMaterialId(String trim) {
        return ERConstants.id(trim);
    }

    private static class_2960 itemModelId(String armor, String armorMaterial, String trim) {
        return ERConstants.id("item/" + armorMaterial + "_" + armor + "_" + trim + "_trim");
    }

    private static class_2960 paletteId(String trim) {
        return ERConstants.id("trims/color_palettes/" + trim);
    }
}

