/*
 * Decompiled with CFR 0.152.
 */
package de.nightium.status.playerstate;

import de.nightium.status.playerstate.Availability;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;

public class PlayerState {
    private UUID player;
    private Availability availability;
    private String state;
    private boolean noSleep;

    public PlayerState(UUID player) {
        this(player, Availability.NONE, "", false);
    }

    public PlayerState(UUID player, Availability availability, String state, boolean noSleep) {
        this.player = player;
        this.availability = availability;
        this.state = state;
        this.noSleep = noSleep;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public void setPlayer(UUID player) {
        this.player = player;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isNoSleep() {
        return this.noSleep;
    }

    public void setNoSleep(boolean noSleep) {
        this.noSleep = noSleep;
    }

    public static PlayerState fromBytes(PacketDataSerializer buf) {
        PlayerState state = new PlayerState(buf.n());
        state.availability = Availability.byName(buf.d(128));
        state.state = buf.d(128);
        state.noSleep = buf.readBoolean();
        return state;
    }

    public void toBytes(PacketDataSerializer buf) {
        buf.a(this.player);
        buf.a(this.availability.getName(), 128);
        buf.a(this.state, 128);
        buf.a(this.noSleep);
    }
}

