/*
 * Decompiled with CFR 0.152.
 */
package net.nightium.statusplugin;

import de.maxhenkel.configbuilder.ConfigBuilder;
import de.nightium.status.config.ServerConfig;
import de.nightium.status.playerstate.PlayerState;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class Status
extends JavaPlugin
implements Listener,
PluginMessageListener {
    private final ConcurrentHashMap<UUID, PlayerState> states = new ConcurrentHashMap();
    public static Logger log;
    public static Status PLUGIN;
    public static ServerConfig SERVER_CONFIG;

    public void onEnable() {
        PLUGIN = this;
        log = PLUGIN.getLogger();
        SERVER_CONFIG = ConfigBuilder.builder(ServerConfig::new).path(PLUGIN.getServer().getPluginsFolder().toPath().resolve("status-plugin").resolve("status-server.properties")).build();
        Messenger msg = Bukkit.getMessenger();
        msg.registerOutgoingPluginChannel((Plugin)this, "status:state");
        msg.registerIncomingPluginChannel((Plugin)this, "status:state", (PluginMessageListener)this);
        msg.registerOutgoingPluginChannel((Plugin)this, "status:states");
        super.onEnable();
    }

    @EventHandler
    public void onSleep(PlayerBedEnterEvent event) {
        EntityPlayer player = MinecraftServer.getServer().ah().a(event.getPlayer().getUniqueId());
        assert (player != null);
        List<EntityPlayer> noSleepPlayers = this.getNoSleepPlayers(player.d);
        if (noSleepPlayers.isEmpty()) {
            return;
        }
        player.c.b((Packet)new ClientboundSetTitleTextPacket((IChatBaseComponent)IChatBaseComponent.b((String)Status.SERVER_CONFIG.noSleepTitle.get())));
        if (noSleepPlayers.size() > 1) {
            player.c.b((Packet)new ClientboundSetSubtitleTextPacket((IChatBaseComponent)IChatBaseComponent.b((String)Status.SERVER_CONFIG.noSleepMultipleSubtitle.get())));
        } else {
            player.c.b((Packet)new ClientboundSetSubtitleTextPacket((IChatBaseComponent)IChatBaseComponent.b((String)String.format(Status.SERVER_CONFIG.noSleepPlayerSubtitle.get(), noSleepPlayers.get(0).S_().getString()))));
        }
    }

    @EventHandler
    private void notifyPlayer(PlayerJoinEvent event) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        this.playerStatesToBytes(this.states, buf);
        byte[] dataBytes = new byte[buf.writerIndex()];
        buf.a(0, dataBytes);
        event.getPlayer().sendPluginMessage((Plugin)this, "status:states", dataBytes);
        this.broadcastState(this, new PlayerState(event.getPlayer().getUniqueId()));
    }

    @EventHandler
    private void removePlayer(PlayerQuitEvent event) {
        this.states.remove(event.getPlayer().getUniqueId());
        this.broadcastState(this, new PlayerState(event.getPlayer().getUniqueId()));
    }

    private void broadcastState(JavaPlugin plugin, PlayerState state) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        state.toBytes(buf);
        byte[] dataBytes = new byte[buf.writerIndex()];
        buf.a(0, dataBytes);
        plugin.getServer().getOnlinePlayers().forEach(player -> player.sendPluginMessage((Plugin)PLUGIN, "status:state", dataBytes));
    }

    private List<EntityPlayer> getNoSleepPlayers(MinecraftServer server) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (Map.Entry<UUID, PlayerState> entry : this.states.entrySet()) {
            EntityPlayer player;
            if (!entry.getValue().isNoSleep() || (player = server.ah().a(entry.getKey())) == null) continue;
            players.add(player);
        }
        return players;
    }

    private void playerStatesToBytes(ConcurrentHashMap<UUID, PlayerState> playerStates, PacketDataSerializer buf) {
        buf.p(playerStates.size());
        for (Map.Entry<UUID, PlayerState> entry : playerStates.entrySet()) {
            entry.getValue().toBytes(buf);
        }
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
        if (channel.equals("status:state")) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.copiedBuffer((byte[])message));
            PlayerState state = PlayerState.fromBytes(buf);
            state.setPlayer(player.getUniqueId());
            this.states.put(player.getUniqueId(), state);
            this.broadcastState(this, state);
        }
    }
}

