/*
 * Decompiled with CFR 0.152.
 */
package de.nightium.status.playerstate;

import de.nightium.status.playerstate.Availability;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;

public class PlayerState {
    private UUID player;
    private Availability availability;
    private String state;

    public PlayerState(UUID player) {
        this(player, Availability.NEUTRAL, "");
    }

    public PlayerState(UUID player, Availability availability, String state) {
        this.player = player;
        this.availability = availability;
        this.state = state;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public byte[] toByteArray() {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(this.player);
        buf.a(this.availability.getName(), 128);
        buf.a(this.state, 128);
        byte[] data = new byte[buf.writerIndex()];
        buf.a(0, data);
        return data;
    }

    public static PlayerState fromByteArray(byte[] data) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])data));
        UUID player = buf.n();
        Availability availability = Availability.byName(buf.d(128));
        String state = buf.d(128);
        return new PlayerState(player, availability, state);
    }
}

