/*
 * Decompiled with CFR 0.152.
 */
package net.nightium.statusplugin;

import de.nightium.status.playerstate.PlayerState;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class Status
extends JavaPlugin
implements Listener,
PluginMessageListener {
    private final ConcurrentHashMap<UUID, PlayerState> states = new ConcurrentHashMap();
    private int updateTaskId;

    public void onEnable() {
        Messenger msg = Bukkit.getMessenger();
        msg.registerOutgoingPluginChannel((Plugin)this, "status:state");
        msg.registerIncomingPluginChannel((Plugin)this, "status:state", (PluginMessageListener)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.updateTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::updateAllPlayerStates, 0L, 1200L);
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTask(this.updateTaskId);
    }

    private void updateAllPlayerStates() {
        this.states.forEach((uuid, state) -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player != null) {
                this.updatePlayerTabName(player, (PlayerState)state);
            }
        });
    }

    private void updatePlayerTabName(Player player, PlayerState state) {
        String statusDisplay = state.getAvailability().getName().toUpperCase();
        player.setPlayerListName(player.getName() + " [" + statusDisplay + "]");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        PlayerState state = new PlayerState(player.getUniqueId());
        this.states.put(player.getUniqueId(), state);
        this.broadcastState(state);
        this.updatePlayerTabName(player, state);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.states.remove(event.getPlayer().getUniqueId());
    }

    private void broadcastState(PlayerState state) {
        byte[] data = state.toByteArray();
        Bukkit.getOnlinePlayers().forEach(p -> p.sendPluginMessage((Plugin)this, "status:state", data));
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
        if (channel.equals("status:state")) {
            PlayerState state = PlayerState.fromByteArray(message);
            this.states.put(player.getUniqueId(), state);
            this.updatePlayerTabName(player, state);
            this.broadcastState(state);
        }
    }
}

