/*
 * Decompiled with CFR 0.152.
 */
package nicusha.ruby.registry;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ArmourMaterialRegistry {
    public static final DeferredRegister<ArmorMaterial> ARMOR_MATERIALS = DeferredRegister.create((ResourceKey)Registries.ARMOR_MATERIAL, (String)"ruby");
    public static final Holder<ArmorMaterial> RUBY = ArmourMaterialRegistry.register("ruby", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), armourType -> {
        armourType.put(ArmorItem.Type.BOOTS, 5);
        armourType.put(ArmorItem.Type.LEGGINGS, 9);
        armourType.put(ArmorItem.Type.CHESTPLATE, 12);
        armourType.put(ArmorItem.Type.HELMET, 5);
        armourType.put(ArmorItem.Type.BODY, 12);
    }), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 0.0f, 0.0f, () -> Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"ruby_repair"))), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"ruby"))));
    public static final Holder<ArmorMaterial> AMETHYST = ArmourMaterialRegistry.register("amethyst", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), armourType -> {
        armourType.put(ArmorItem.Type.BOOTS, 6);
        armourType.put(ArmorItem.Type.LEGGINGS, 10);
        armourType.put(ArmorItem.Type.CHESTPLATE, 13);
        armourType.put(ArmorItem.Type.HELMET, 6);
        armourType.put(ArmorItem.Type.BODY, 13);
    }), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 0.0f, 0.0f, () -> Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"amethyst_repair"))), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"amethyst"))));
    public static final Holder<ArmorMaterial> BRAUNITE = ArmourMaterialRegistry.register("braunite", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), armourType -> {
        armourType.put(ArmorItem.Type.BOOTS, 5);
        armourType.put(ArmorItem.Type.LEGGINGS, 8);
        armourType.put(ArmorItem.Type.CHESTPLATE, 10);
        armourType.put(ArmorItem.Type.HELMET, 4);
        armourType.put(ArmorItem.Type.BODY, 10);
    }), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, 0.0f, 0.0f, () -> Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"braunite_repair"))), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"braunite"))));
    public static final Holder<ArmorMaterial> OPAL = ArmourMaterialRegistry.register("opal", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), armourType -> {
        armourType.put(ArmorItem.Type.BOOTS, 2);
        armourType.put(ArmorItem.Type.LEGGINGS, 3);
        armourType.put(ArmorItem.Type.CHESTPLATE, 2);
        armourType.put(ArmorItem.Type.HELMET, 1);
        armourType.put(ArmorItem.Type.BODY, 2);
    }), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 0.0f, 0.0f, () -> Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"opal_repair"))), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"opal"))));
    public static final Holder<ArmorMaterial> METEORITE = ArmourMaterialRegistry.register("meteorite", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), armourType -> {
        armourType.put(ArmorItem.Type.BOOTS, 5);
        armourType.put(ArmorItem.Type.LEGGINGS, 8);
        armourType.put(ArmorItem.Type.CHESTPLATE, 7);
        armourType.put(ArmorItem.Type.HELMET, 4);
        armourType.put(ArmorItem.Type.BODY, 7);
    }), 9, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 0.0f, 0.0f, () -> Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"meteorite_repair"))), List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"meteorite"))));

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> armourType, int enchantability, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repair, List<ArmorMaterial.Layer> pLayers) {
        EnumMap<ArmorItem.Type, Integer> enummap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type armoritem$type : ArmorItem.Type.values()) {
            enummap.put(armoritem$type, armourType.get(armoritem$type));
        }
        return ARMOR_MATERIALS.register(name, () -> new ArmorMaterial((Map)enummap, enchantability, equipSound, repair, pLayers, toughness, knockbackResistance));
    }
}

