/*
 * Decompiled with CFR 0.152.
 */
package nicusha.ruby.registry;

import javax.annotation.Nonnull;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import nicusha.ruby.blocks.Amethyst;
import nicusha.ruby.blocks.Meteorite;
import nicusha.ruby.registry.ItemRegistry;

public class BlockRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"ruby");
    public static final DeferredBlock<Block> RUBY_ORE = BlockRegistry.createOreBlock("ruby_ore", MapColor.COLOR_RED, 2.0f, 4.0f, NoteBlockInstrument.XYLOPHONE, true);
    public static final DeferredBlock<Block> RUBY_ORE_DEEPSLATE = BlockRegistry.createOreBlock("ruby_ore_deepslate", MapColor.COLOR_RED, 2.0f, 4.0f, NoteBlockInstrument.XYLOPHONE, true);
    public static final DeferredBlock<Block> BRAUNITE_ORE = BlockRegistry.createOreBlock("braunite_ore", MapColor.COLOR_GRAY, 2.0f, 4.0f, NoteBlockInstrument.IRON_XYLOPHONE, true);
    public static final DeferredBlock<Block> BRAUNITE_ORE_DEEPSLATE = BlockRegistry.createOreBlock("braunite_ore_deepslate", MapColor.COLOR_GRAY, 2.0f, 4.0f, NoteBlockInstrument.IRON_XYLOPHONE, true);
    public static final DeferredBlock<Block> OPAL_ORE = BlockRegistry.createOreBlock("opal_ore", MapColor.COLOR_LIGHT_BLUE, 2.0f, 4.0f, NoteBlockInstrument.CHIME, true);
    public static final DeferredBlock<Block> OPAL_ORE_DEEPSLATE = BlockRegistry.createOreBlock("opal_ore_deepslate", MapColor.COLOR_LIGHT_BLUE, 2.0f, 4.0f, NoteBlockInstrument.CHIME, true);
    public static final DeferredBlock<Block> AMETHYST = BlockRegistry.createOreBlock("amethyst", MapColor.COLOR_PURPLE, 2.0f, 4.0f, NoteBlockInstrument.XYLOPHONE, false);
    public static final DeferredBlock<Block> METEORITE_ORE = BlockRegistry.createOreBlock("meteorite_ore", MapColor.COLOR_ORANGE, 5.0f, 8.0f, NoteBlockInstrument.IRON_XYLOPHONE, false);
    public static final DeferredBlock<Block> BRAUNITE_BLOCK = BlockRegistry.createBlock("braunite_block", MapColor.COLOR_GRAY, 2.0f, 4.0f, NoteBlockInstrument.IRON_XYLOPHONE);
    public static final DeferredBlock<Block> OPAL_BLOCK = BlockRegistry.createBlock("opal_block", MapColor.COLOR_LIGHT_BLUE, 2.0f, 4.0f, NoteBlockInstrument.CHIME);
    public static final DeferredBlock<Block> RUBY_BLOCK = BlockRegistry.createBlock("ruby_block", MapColor.COLOR_RED, 2.0f, 4.0f, NoteBlockInstrument.XYLOPHONE);

    private static DeferredBlock<Block> createOreBlock(@Nonnull String id, MapColor color, float hardness, float resistance, NoteBlockInstrument sound, boolean fullBlock) {
        if (fullBlock) {
            DeferredBlock block = BLOCKS.register(id, () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)5), BlockBehaviour.Properties.of().mapColor(color).instrument(sound).requiresCorrectToolForDrops().strength(hardness, resistance)));
            ItemRegistry.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().fireResistant()));
            return block;
        }
        if (id == "amethyst") {
            DeferredBlock block = BLOCKS.register(id, () -> new Amethyst(BlockBehaviour.Properties.of().mapColor(color).requiresCorrectToolForDrops().strength(hardness, resistance).instrument(sound).noOcclusion()));
            ItemRegistry.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().fireResistant()));
            return block;
        }
        if (id == "meteorite_ore") {
            DeferredBlock block = BLOCKS.register(id, () -> new Meteorite(BlockBehaviour.Properties.of().mapColor(color).requiresCorrectToolForDrops().strength(hardness, resistance).instrument(sound).noOcclusion()));
            ItemRegistry.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().fireResistant()));
            return block;
        }
        DeferredBlock block = BLOCKS.register(id, () -> new Block(BlockBehaviour.Properties.of().mapColor(color).requiresCorrectToolForDrops().strength(hardness, resistance).instrument(sound).noOcclusion()));
        ItemRegistry.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().fireResistant()));
        return block;
    }

    private static DeferredBlock<Block> createBlock(@Nonnull String id, MapColor color, float hardness, float resistance, NoteBlockInstrument instrument) {
        DeferredBlock block = BLOCKS.register(id, () -> new Block(BlockBehaviour.Properties.of().mapColor(color).requiresCorrectToolForDrops().strength(hardness, resistance).noOcclusion().instrument(instrument)));
        ItemRegistry.ITEMS.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().fireResistant()));
        return block;
    }
}

