/*
 * Decompiled with CFR 0.152.
 */
package nicusha.ruby.registry;

import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import nicusha.ruby.enums.RubyToolMaterials;
import nicusha.ruby.registry.ArmourMaterialRegistry;

public class ItemRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ruby");
    public static final DeferredItem<Item> BRAUNITE_GEM = ItemRegistry.item("braunite_gem");
    public static final DeferredItem<Item> METEORITE_GEM = ItemRegistry.fireItem("meteorite_gem");
    public static final DeferredItem<Item> OPAL_GEM = ItemRegistry.item("opal_gem");
    public static final DeferredItem<Item> RUBY_GEM = ItemRegistry.item("ruby_gem");
    public static final DeferredItem<Item> AMETHYST_SWORD = ItemRegistry.sword("amethyst_sword", RubyToolMaterials.AMETHYST);
    public static final DeferredItem<Item> BRAUNITE_SWORD = ItemRegistry.sword("braunite_sword", RubyToolMaterials.BRAUNITE);
    public static final DeferredItem<Item> METEORITE_SWORD = ItemRegistry.fireSword("meteorite_sword", RubyToolMaterials.METEORITE);
    public static final DeferredItem<Item> OPAL_SWORD = ItemRegistry.sword("opal_sword", RubyToolMaterials.OPAL);
    public static final DeferredItem<Item> RUBY_SWORD = ItemRegistry.sword("ruby_sword", RubyToolMaterials.RUBY);
    public static final DeferredItem<Item> AMETHYST_PICKAXE = ItemRegistry.pickaxe("amethyst_pickaxe", RubyToolMaterials.AMETHYST);
    public static final DeferredItem<Item> BRAUNITE_PICKAXE = ItemRegistry.pickaxe("braunite_pickaxe", RubyToolMaterials.BRAUNITE);
    public static final DeferredItem<Item> METEORITE_PICKAXE = ItemRegistry.firePickaxe("meteorite_pickaxe", RubyToolMaterials.METEORITE);
    public static final DeferredItem<Item> OPAL_PICKAXE = ItemRegistry.pickaxe("opal_pickaxe", RubyToolMaterials.OPAL);
    public static final DeferredItem<Item> RUBY_PICKAXE = ItemRegistry.pickaxe("ruby_pickaxe", RubyToolMaterials.RUBY);
    public static final DeferredItem<Item> AMETHYST_AXE = ItemRegistry.axe("amethyst_axe", RubyToolMaterials.AMETHYST);
    public static final DeferredItem<Item> BRAUNITE_AXE = ItemRegistry.axe("braunite_axe", RubyToolMaterials.BRAUNITE);
    public static final DeferredItem<Item> METEORITE_AXE = ItemRegistry.fireAxe("meteorite_axe", RubyToolMaterials.METEORITE);
    public static final DeferredItem<Item> OPAL_AXE = ItemRegistry.axe("opal_axe", RubyToolMaterials.OPAL);
    public static final DeferredItem<Item> RUBY_AXE = ItemRegistry.axe("ruby_axe", RubyToolMaterials.RUBY);
    public static final DeferredItem<Item> AMETHYST_SHOVEL = ItemRegistry.shovel("amethyst_shovel", RubyToolMaterials.AMETHYST);
    public static final DeferredItem<Item> BRAUNITE_SHOVEL = ItemRegistry.shovel("braunite_shovel", RubyToolMaterials.BRAUNITE);
    public static final DeferredItem<Item> METEORITE_SHOVEL = ItemRegistry.fireShovel("meteorite_shovel", RubyToolMaterials.METEORITE);
    public static final DeferredItem<Item> OPAL_SHOVEL = ItemRegistry.shovel("opal_shovel", RubyToolMaterials.OPAL);
    public static final DeferredItem<Item> RUBY_SHOVEL = ItemRegistry.shovel("ruby_shovel", RubyToolMaterials.RUBY);
    public static final DeferredItem<Item> AMETHYST_HOE = ItemRegistry.hoe("amethyst_hoe", RubyToolMaterials.AMETHYST);
    public static final DeferredItem<Item> BRAUNITE_HOE = ItemRegistry.hoe("braunite_hoe", RubyToolMaterials.BRAUNITE);
    public static final DeferredItem<Item> METEORITE_HOE = ItemRegistry.fireHoe("meteorite_hoe", RubyToolMaterials.METEORITE);
    public static final DeferredItem<Item> OPAL_HOE = ItemRegistry.hoe("opal_hoe", RubyToolMaterials.OPAL);
    public static final DeferredItem<Item> RUBY_HOE = ItemRegistry.hoe("ruby_hoe", RubyToolMaterials.RUBY);
    public static final DeferredItem<Item> AMETHYST_HELMET = ItemRegistry.armor("amethyst_helmet", ArmourMaterialRegistry.AMETHYST, ArmorItem.Type.HELMET, 350);
    public static final DeferredItem<Item> AMETHYST_CHESTPLATE = ItemRegistry.armor("amethyst_chestplate", ArmourMaterialRegistry.AMETHYST, ArmorItem.Type.CHESTPLATE, 500);
    public static final DeferredItem<Item> AMETHYST_LEGGINGS = ItemRegistry.armor("amethyst_leggings", ArmourMaterialRegistry.AMETHYST, ArmorItem.Type.LEGGINGS, 455);
    public static final DeferredItem<Item> AMETHYST_BOOTS = ItemRegistry.armor("amethyst_boots", ArmourMaterialRegistry.AMETHYST, ArmorItem.Type.BOOTS, 325);
    public static final DeferredItem<Item> BRAUNITE_HELMET = ItemRegistry.armor("braunite_helmet", ArmourMaterialRegistry.BRAUNITE, ArmorItem.Type.HELMET, 555);
    public static final DeferredItem<Item> BRAUNITE_CHESTPLATE = ItemRegistry.armor("braunite_chestplate", ArmourMaterialRegistry.BRAUNITE, ArmorItem.Type.CHESTPLATE, 750);
    public static final DeferredItem<Item> BRAUNITE_LEGGINGS = ItemRegistry.armor("braunite_leggings", ArmourMaterialRegistry.BRAUNITE, ArmorItem.Type.LEGGINGS, 700);
    public static final DeferredItem<Item> BRAUNITE_BOOTS = ItemRegistry.armor("braunite_boots", ArmourMaterialRegistry.BRAUNITE, ArmorItem.Type.BOOTS, 525);
    public static final DeferredItem<Item> METEORITE_HELMET = ItemRegistry.armor("meteorite_helmet", ArmourMaterialRegistry.METEORITE, ArmorItem.Type.HELMET, 4050);
    public static final DeferredItem<Item> METEORITE_CHESTPLATE = ItemRegistry.armor("meteorite_chestplate", ArmourMaterialRegistry.METEORITE, ArmorItem.Type.CHESTPLATE, 6250);
    public static final DeferredItem<Item> METEORITE_LEGGINGS = ItemRegistry.armor("meteorite_leggings", ArmourMaterialRegistry.METEORITE, ArmorItem.Type.LEGGINGS, 5800);
    public static final DeferredItem<Item> METEORITE_BOOTS = ItemRegistry.armor("meteorite_boots", ArmourMaterialRegistry.METEORITE, ArmorItem.Type.BOOTS, 3750);
    public static final DeferredItem<Item> OPAL_HELMET = ItemRegistry.armor("opal_helmet", ArmourMaterialRegistry.OPAL, ArmorItem.Type.HELMET, 350);
    public static final DeferredItem<Item> OPAL_CHESTPLATE = ItemRegistry.armor("opal_chestplate", ArmourMaterialRegistry.OPAL, ArmorItem.Type.CHESTPLATE, 500);
    public static final DeferredItem<Item> OPAL_LEGGINGS = ItemRegistry.armor("opal_leggings", ArmourMaterialRegistry.OPAL, ArmorItem.Type.LEGGINGS, 455);
    public static final DeferredItem<Item> OPAL_BOOTS = ItemRegistry.armor("opal_boots", ArmourMaterialRegistry.OPAL, ArmorItem.Type.BOOTS, 325);
    public static final DeferredItem<Item> RUBY_HELMET = ItemRegistry.armor("ruby_helmet", ArmourMaterialRegistry.RUBY, ArmorItem.Type.HELMET, 1020);
    public static final DeferredItem<Item> RUBY_CHESTPLATE = ItemRegistry.armor("ruby_chestplate", ArmourMaterialRegistry.RUBY, ArmorItem.Type.CHESTPLATE, 1550);
    public static final DeferredItem<Item> RUBY_LEGGINGS = ItemRegistry.armor("ruby_leggings", ArmourMaterialRegistry.RUBY, ArmorItem.Type.LEGGINGS, 1300);
    public static final DeferredItem<Item> RUBY_BOOTS = ItemRegistry.armor("ruby_boots", ArmourMaterialRegistry.RUBY, ArmorItem.Type.BOOTS, 980);

    private static DeferredItem<Item> item(String id) {
        return ITEMS.register(id, () -> new Item(new Item.Properties()));
    }

    private static DeferredItem<Item> fireItem(String id) {
        return ITEMS.register(id, () -> new Item(new Item.Properties().fireResistant()));
    }

    private static DeferredItem<Item> sword(String id, Tier tier) {
        return ITEMS.register(id, () -> new SwordItem(tier, new Item.Properties().attributes(SwordItem.createAttributes((Tier)tier, (int)3, (float)-2.4f))));
    }

    private static DeferredItem<Item> pickaxe(String id, Tier tier) {
        return ITEMS.register(id, () -> new PickaxeItem(tier, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)tier, (float)1.0f, (float)-2.8f))));
    }

    private static DeferredItem<Item> axe(String id, Tier tier) {
        return ITEMS.register(id, () -> new AxeItem(tier, new Item.Properties().attributes(AxeItem.createAttributes((Tier)tier, (float)5.0f, (float)-3.0f))));
    }

    private static DeferredItem<Item> shovel(String id, Tier tier) {
        return ITEMS.register(id, () -> new ShovelItem(tier, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)tier, (float)1.5f, (float)-3.0f))));
    }

    private static DeferredItem<Item> hoe(String id, Tier tier) {
        return ITEMS.register(id, () -> new HoeItem(tier, new Item.Properties().attributes(HoeItem.createAttributes((Tier)tier, (float)-1.0f, (float)-2.0f))));
    }

    private static DeferredItem<Item> fireSword(String id, Tier tier) {
        return ITEMS.register(id, () -> new SwordItem(tier, new Item.Properties().fireResistant().attributes(SwordItem.createAttributes((Tier)tier, (int)3, (float)-2.4f))));
    }

    private static DeferredItem<Item> firePickaxe(String id, Tier tier) {
        return ITEMS.register(id, () -> new PickaxeItem(tier, new Item.Properties().fireResistant().attributes(PickaxeItem.createAttributes((Tier)tier, (float)1.0f, (float)-2.8f))));
    }

    private static DeferredItem<Item> fireAxe(String id, Tier tier) {
        return ITEMS.register(id, () -> new AxeItem(tier, new Item.Properties().fireResistant().attributes(AxeItem.createAttributes((Tier)tier, (float)5.0f, (float)-3.0f))));
    }

    private static DeferredItem<Item> fireShovel(String id, Tier tier) {
        return ITEMS.register(id, () -> new ShovelItem(tier, new Item.Properties().fireResistant().attributes(ShovelItem.createAttributes((Tier)tier, (float)1.5f, (float)-3.0f))));
    }

    private static DeferredItem<Item> fireHoe(String id, Tier tier) {
        return ITEMS.register(id, () -> new HoeItem(tier, new Item.Properties().fireResistant().attributes(HoeItem.createAttributes((Tier)tier, (float)-1.0f, (float)-2.0f))));
    }

    private static DeferredItem<Item> armor(String id, Holder<ArmorMaterial> material, ArmorItem.Type slot, int durability) {
        return ITEMS.register(id, () -> new ArmorItem(material, slot, new Item.Properties().stacksTo(1).durability(durability)));
    }
}

