/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.chatjs.api;

import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.aika.chatjs.api.OpenAIProvider;
import dev.aika.chatjs.api.resources.ErrorResponse;
import dev.aika.chatjs.api.resources.ModelObject;
import dev.aika.chatjs.api.resources.ModelsResponse;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.http.client.HttpResponseException;

public final class OpenAIClient {
    private OpenAIProvider provider = OpenAIProvider.OpenAI;
    private String model = this.provider.getDefaultModel();
    private String apiKey;
    private Double timeout = 10000.0;
    private HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    public ChatAPI chat = new ChatAPI();
    private RateLimiter rl = RateLimiter.create((double)1000.0);

    public OpenAIClient setProvider(OpenAIProvider provider) {
        this.provider = provider;
        this.model = provider.getDefaultModel();
        return this;
    }

    public OpenAIClient setRPS(Double rps) {
        this.rl.setRate(rps.doubleValue());
        return this;
    }

    public HttpRequest.Builder getRequest() {
        return HttpRequest.newBuilder().timeout(Duration.ofMillis((long)(this.timeout * 1000.0))).header("Authorization", "Bearer " + this.apiKey);
    }

    public HttpResponse<String> send(HttpRequest req) {
        this.rl.acquire();
        return this.httpClient.send(req, HttpResponse.BodyHandlers.ofString());
    }

    private <T> void checkError(HttpResponse<T> resp, String body) throws HttpResponseException {
        if (resp.statusCode() != 200) {
            String err;
            try {
                err = ((ErrorResponse)this.gson.fromJson(body, ErrorResponse.class)).error().message();
            }
            catch (Exception e) {
                err = body;
            }
            throw new HttpResponseException(resp.statusCode(), err);
        }
    }

    private <T> void checkError(HttpResponse<T> resp) throws HttpResponseException {
        if (resp.statusCode() != 200) {
            throw new HttpResponseException(resp.statusCode(), "Failed to request");
        }
    }

    public List<ModelObject> models() {
        URI uri = new URI(this.provider.getBaseURL() + this.provider.getModelsPath());
        HttpResponse<String> response = this.httpClient.send(this.getRequest().uri(uri).GET().build(), HttpResponse.BodyHandlers.ofString());
        String body = response.body();
        this.checkError(response, body);
        ModelsResponse result = (ModelsResponse)this.gson.fromJson(body, ModelsResponse.class);
        return result.data();
    }

    @Generated
    public OpenAIClient setModel(String model) {
        this.model = model;
        return this;
    }

    @Generated
    public OpenAIClient setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Generated
    public OpenAIClient setTimeout(Double timeout) {
        this.timeout = timeout;
        return this;
    }

    @Generated
    public OpenAIClient setChat(ChatAPI chat2) {
        this.chat = chat2;
        return this;
    }

    @Generated
    public OpenAIProvider getProvider() {
        return this.provider;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public Double getTimeout() {
        return this.timeout;
    }

    @Generated
    public ChatAPI getChat() {
        return this.chat;
    }

    public class ChatAPI {
        private ChatAPI() {
        }

        public JsonElement createCompletion(Object body) {
            JsonObject obj = (JsonObject)OpenAIClient.this.gson.toJsonTree(body);
            return this.createCompletion(obj);
        }

        public JsonElement createCompletion(String body) {
            JsonObject obj = (JsonObject)JsonIO.parseRaw((String)body);
            return this.createCompletion(obj);
        }

        public JsonElement createCompletion(JsonObject body) {
            if (body.has("model")) {
                body.remove("model");
            }
            body.addProperty("model", OpenAIClient.this.model);
            if (body.has("stream")) {
                body.remove("stream");
            }
            body.addProperty("stream", Boolean.valueOf(false));
            String json = OpenAIClient.this.gson.toJson((JsonElement)body);
            URI uri = new URI(OpenAIClient.this.provider.getBaseURL() + OpenAIClient.this.provider.getChatCompletionPath());
            HttpResponse<String> response = OpenAIClient.this.httpClient.send(OpenAIClient.this.getRequest().header("Accept", "application/json").header("Content-Type", "application/json; charset=utf-8").uri(uri).POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.ofString());
            String _body = response.body();
            OpenAIClient.this.checkError(response, _body);
            return JsonIO.parseRaw((String)_body);
        }

        public void createStreamCompletion(Object body, Consumer<Object> onDataReceived, Consumer<Throwable> onError) {
            JsonObject obj = (JsonObject)OpenAIClient.this.gson.toJsonTree(body);
            if (obj.has("model")) {
                obj.remove("model");
            }
            obj.addProperty("model", OpenAIClient.this.model);
            if (obj.has("stream")) {
                obj.remove("stream");
            }
            obj.addProperty("stream", Boolean.valueOf(true));
            String json = OpenAIClient.this.gson.toJson((JsonElement)obj);
            URI uri = new URI(OpenAIClient.this.provider.getBaseURL() + OpenAIClient.this.provider.getChatCompletionPath());
            HttpResponse<Void> response = OpenAIClient.this.httpClient.send(OpenAIClient.this.getRequest().header("Content-Type", "application/json; charset=utf-8").uri(uri).POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build(), HttpResponse.BodyHandlers.fromLineSubscriber(new CompletionResponseSubscriber(onDataReceived, onError)));
            OpenAIClient.this.checkError(response);
        }

        public static class CompletionResponseSubscriber
        implements Flow.Subscriber<String> {
            private final Consumer<Object> onDataReceived;
            private final Consumer<Throwable> onError;
            private Flow.Subscription subscription;

            public CompletionResponseSubscriber(Consumer<Object> onDataReceived, Consumer<Throwable> onError) {
                this.onDataReceived = onDataReceived;
                this.onError = onError;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                subscription.request(1L);
            }

            @Override
            public void onNext(String item) {
                try {
                    String data;
                    if (item.startsWith("data: ") && !item.contains("[DONE]") && !(data = item.substring(6).trim()).isEmpty()) {
                        this.onDataReceived.accept(UtilsJS.wrap((Object)JsonIO.parseRaw((String)data), (JSObjectType)JSObjectType.MAP));
                    }
                    this.subscription.request(1L);
                }
                catch (Exception e) {
                    this.onError.accept(e);
                    this.subscription.cancel();
                }
            }

            @Override
            public void onError(Throwable throwable) {
                this.onError.accept(throwable);
            }

            @Override
            public void onComplete() {
            }
        }
    }
}

